/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.packet.packets.stargate;

import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolInterface;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.AbstractSymbolType;
import dev.tauri.jsg.blockentity.dialhomedevice.DHDAbstractBE;
import dev.tauri.jsg.packet.PositionedPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class DHDButtonClickedToServer
extends PositionedPacket {
    public SymbolInterface symbol;
    public AbstractSymbolType<?> symbolType;
    public boolean force;

    public DHDButtonClickedToServer() {
    }

    public DHDButtonClickedToServer(BlockPos pos, SymbolInterface symbol) {
        super(pos);
        this.symbol = symbol;
        this.symbolType = symbol.getSymbolType();
    }

    public DHDButtonClickedToServer(BlockPos pos, SymbolInterface symbol, boolean force) {
        this(pos, symbol);
        this.force = force;
    }

    public DHDButtonClickedToServer(FriendlyByteBuf buf) {
        super(buf);
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(AbstractSymbolType.getId(this.symbolType));
        buf.writeInt(this.symbol.getId());
        buf.writeBoolean(this.force);
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        super.fromBytes(buf);
        this.symbolType = AbstractSymbolType.byId(buf.readInt());
        this.symbol = this.symbolType.valueOf(buf.readInt());
        this.force = buf.readBoolean();
    }

    @Override
    public void handle(NetworkEvent.Context ctx) {
        if (ctx.getDirection() != NetworkDirection.PLAY_TO_SERVER) {
            return;
        }
        ctx.setPacketHandled(true);
        ServerPlayer player = ctx.getSender();
        if (player == null) {
            return;
        }
        Level world = player.m_9236_();
        ctx.enqueueWork(() -> {
            if (!this.symbol.canBePressed()) {
                player.m_240418_((Component)Component.m_237115_((String)"block.jsg.dhd_pegasus.unknown_buttons"), true);
                return;
            }
            DHDAbstractBE dhdTile = (DHDAbstractBE)world.m_7702_(this.pos);
            if (dhdTile == null) {
                return;
            }
            player.m_6674_(InteractionHand.MAIN_HAND);
            dhdTile.pushSymbolButton(this.symbol, player, this.force);
        });
    }
}

