/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.recipes;

import dev.tauri.jsg.api.item.NotebookPageSerialization;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolTypeRegistry;
import dev.tauri.jsg.item.linkable.dialer.modes.UniverseDialerModes;
import dev.tauri.jsg.item.notebook.PageNotebookItemFilled;
import dev.tauri.jsg.recipes.NotebookRecipe;
import dev.tauri.jsg.registry.ItemRegistry;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class PageAndUniverseDialerRecipe
extends ShapelessRecipe {
    public PageAndUniverseDialerRecipe() {
        super(new ResourceLocation("jsg", "dialer_page_combination"), "JSG", CraftingBookCategory.MISC, new ItemStack((ItemLike)ItemRegistry.UNIVERSE_DIALER.get(), 1), NonNullList.m_122779_());
    }

    @ParametersAreNonnullByDefault
    public boolean m_5818_(CraftingContainer inv, Level pLevel) {
        int dialerCount = 0;
        int pagesCount = 0;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            Item item = stack.m_41720_();
            if (item == ItemRegistry.UNIVERSE_DIALER.get()) {
                ++dialerCount;
                continue;
            }
            if (item == ItemRegistry.NOTEBOOK_PAGE_FILLED.get()) {
                CompoundTag tag = stack.m_41784_();
                if (PageNotebookItemFilled.getPageAddressType(tag).equals((Object)NotebookPageSerialization.STARGATES) && PageNotebookItemFilled.getSymbolType(tag) == SymbolTypeRegistry.UNIVERSE) {
                    ++pagesCount;
                    continue;
                }
                return false;
            }
            if (stack.m_41619_()) continue;
            return false;
        }
        return dialerCount == 1 && pagesCount >= 1;
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public ItemStack m_5874_(CraftingContainer inv, RegistryAccess pRegistryAccess) {
        ListTag addressTagList = new ListTag();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            Item item = stack.m_41720_();
            CompoundTag compound = stack.m_41783_();
            if (item == ItemRegistry.UNIVERSE_DIALER.get()) {
                if (compound == null) {
                    return ItemStack.f_41583_;
                }
                CompoundTag modeTag = UniverseDialerModes.MEMORY.getTag(compound);
                ListTag addressTags = modeTag.m_128437_("entries", 10);
                for (Tag tag : addressTags) {
                    if (NotebookRecipe.tagListContains(addressTagList, (CompoundTag)tag)) continue;
                    addressTagList.add((Object)tag);
                }
            }
            if (item != ItemRegistry.NOTEBOOK_PAGE_FILLED.get()) continue;
            if (compound == null) {
                return ItemStack.f_41583_;
            }
            CompoundTag newTag = compound.m_128469_("address").m_6426_();
            newTag.m_128385_("symbolsToDisplay", compound.m_128465_("symbolsToDisplay"));
            addressTagList.add((Object)newTag);
        }
        ItemStack output = new ItemStack((ItemLike)ItemRegistry.UNIVERSE_DIALER.get(), 1);
        CompoundTag compound = new CompoundTag();
        CompoundTag modeTag = UniverseDialerModes.MEMORY.getTag(compound);
        modeTag.m_128365_("entries", (Tag)addressTagList);
        compound.m_128365_(String.valueOf(UniverseDialerModes.MEMORY.id) + "_tag", (Tag)modeTag);
        output.m_41751_(compound);
        return output;
    }

    @ParametersAreNonnullByDefault
    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return RecipeSerializer.f_44077_;
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return RecipeType.f_44107_;
    }
}

