/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.registry;

import com.google.common.collect.ImmutableSet;
import dev.tauri.jsg.JSG;
import dev.tauri.jsg.block.cauldron.JSGFluidCauldron;
import dev.tauri.jsg.entity.VillagerTradesBuilder;
import dev.tauri.jsg.helpers.ItemHelper;
import dev.tauri.jsg.registry.BlockRegistry;
import dev.tauri.jsg.registry.DimensionRegistry;
import dev.tauri.jsg.registry.FluidRegistry;
import dev.tauri.jsg.registry.ItemRegistry;
import dev.tauri.jsg.registry.tags.JSGBiomeTags;
import dev.tauri.jsg.registry.tags.JSGStructureTags;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class VillagerRegistry {
    public static final DeferredRegister<VillagerProfession> PROFESSION_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.VILLAGER_PROFESSIONS, (String)"jsg");
    public static final DeferredRegister<VillagerType> TYPE_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_257019_, (String)"jsg");
    public static final DeferredRegister<PoiType> POI_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256805_, (String)"jsg");
    public static final RegistryObject<PoiType> NAQUADAH_CAULDRON_POI = POI_REGISTER.register("naquadah_cauldron", () -> new PoiType((Set)ImmutableSet.copyOf((Collection)((JSGFluidCauldron)((Object)((Object)FluidRegistry.MOLTEN_NAQUADAH_RAW.cauldron.get()))).m_49965_().m_61056_()), 4, 1));
    public static final RegistryObject<VillagerProfession> PRIEST_DESERT = PROFESSION_REGISTER.register("priest_desert", () -> new VillagerProfession("priest_desert", holder -> false, holder -> false, ImmutableSet.of(), ImmutableSet.of(), null));
    public static final RegistryObject<VillagerProfession> PRIEST_JUNGLE = PROFESSION_REGISTER.register("priest_jungle", () -> new VillagerProfession("priest_jungle", holder -> false, holder -> false, ImmutableSet.of(), ImmutableSet.of(), null));
    public static final RegistryObject<VillagerProfession> PRIEST_PLAINS = PROFESSION_REGISTER.register("priest_plains", () -> new VillagerProfession("priest_plains", holder -> false, holder -> false, ImmutableSet.of(), ImmutableSet.of(), null));
    public static final RegistryObject<VillagerProfession> PRIEST_SAVANNA = PROFESSION_REGISTER.register("priest_savanna", () -> new VillagerProfession("priest_savanna", holder -> false, holder -> false, ImmutableSet.of(), ImmutableSet.of(), null));
    public static final RegistryObject<VillagerProfession> PRIEST_SNOW = PROFESSION_REGISTER.register("priest_snow", () -> new VillagerProfession("priest_snow", holder -> false, holder -> false, ImmutableSet.of(), ImmutableSet.of(), null));
    public static final RegistryObject<VillagerProfession> PRIEST_SWAMP = PROFESSION_REGISTER.register("priest_swamp", () -> new VillagerProfession("priest_swamp", holder -> false, holder -> false, ImmutableSet.of(), ImmutableSet.of(), null));
    public static final RegistryObject<VillagerProfession> PRIEST_TAIGA = PROFESSION_REGISTER.register("priest_taiga", () -> new VillagerProfession("priest_taiga", holder -> false, holder -> false, ImmutableSet.of(), ImmutableSet.of(), null));
    public static final RegistryObject<VillagerProfession> SLAVE_MINER = PROFESSION_REGISTER.register("slave_miner", () -> new VillagerProfession("slave_miner", holder -> holder.m_203565_(Objects.requireNonNull(NAQUADAH_CAULDRON_POI.getKey())), holder -> holder.m_203565_(Objects.requireNonNull(NAQUADAH_CAULDRON_POI.getKey())), ImmutableSet.of((Object)Items.f_42385_, (Object)((Item)ItemRegistry.NAQUADAH_ORE_RAW.get())), ImmutableSet.copyOf((Collection)BlockRegistry.ORE_NAQUADAH.values().stream().map(RegistryObject::get).collect(Collectors.toSet())), null));
    public static final RegistryObject<VillagerType> ABYDOS_TYPE = TYPE_REGISTER.register("abydonian", () -> new VillagerType("abydonian"));

    public static void register(IEventBus bus) {
        PROFESSION_REGISTER.register(bus);
        TYPE_REGISTER.register(bus);
        POI_REGISTER.register(bus);
        if (VillagerTrades.f_35627_.isEmpty()) {
            JSG.logger.info("Trades of villagers is empty map!");
        }
    }

    @NotNull
    public static Optional<VillagerType> checkAndGetCustomType(Villager villager) {
        Holder biome = villager.m_9236_().m_204166_(villager.m_20183_());
        if (biome.m_203656_(JSGBiomeTags.IS_ABYDOS)) {
            return Optional.of((VillagerType)ABYDOS_TYPE.get());
        }
        return Optional.empty();
    }

    public static boolean isPriest(VillagerProfession profession) {
        return profession == PRIEST_DESERT.get() || profession == PRIEST_JUNGLE.get() || profession == PRIEST_PLAINS.get() || profession == PRIEST_SAVANNA.get() || profession == PRIEST_SNOW.get() || profession == PRIEST_SWAMP.get() || profession == PRIEST_TAIGA.get();
    }

    public static void registerTrades(VillagerTradesEvent event) {
        VillagerTradesBuilder.create(event).setForLevels(5).setForProfessions(VillagerProfession.f_35588_).register((trader, random) -> {
            ItemStack map;
            Level patt6331$temp = trader.m_9236_();
            if (!(patt6331$temp instanceof ServerLevel)) {
                return null;
            }
            ServerLevel serverLevel = (ServerLevel)patt6331$temp;
            if (serverLevel.m_46472_() == DimensionRegistry.ABYDOS) {
                map = ItemHelper.getMapForTarget(JSGStructureTags.ABYDOS_MARKED_ON_MAP, (Component)Component.m_237115_((String)"filled_map.abydos_treasure"), MapDecoration.Type.RED_X, serverLevel, trader.m_20183_());
                if (map == null) {
                    return null;
                }
                return new MerchantOffer(new ItemStack((ItemLike)Items.f_42409_), new ItemStack((ItemLike)ItemRegistry.FOOD_CHOCOLATE_BAR.get(), 24), map, 3, 2, 0.1f);
            }
            if (serverLevel.m_46472_() == Level.f_46428_) {
                map = ItemHelper.getMapForTarget(JSGStructureTags.OVERWORLD_MARKED_ON_MAP, (Component)Component.m_237115_((String)"filled_map.burried_stargate"), MapDecoration.Type.RED_X, serverLevel, trader.m_20183_());
                if (map == null) {
                    return null;
                }
                return new MerchantOffer(new ItemStack((ItemLike)Items.f_41997_, 16), new ItemStack((ItemLike)Items.f_42436_, 8), map, 3, 2, 0.1f);
            }
            return null;
        }).setInput1(new ItemStack((ItemLike)ItemRegistry.TITANIUM_INGOT.get(), 20)).setOutput(new ItemStack((ItemLike)Items.f_42616_, 1)).setMaxUses(12).setXpPerTrade(1).setPriceMul(0.02f).setForLevels(1).setPriestOnly().register().setInput1(new ItemStack((ItemLike)Items.f_42616_, 1)).setInput2(new ItemStack((ItemLike)Items.f_42533_, 3)).setOutput(new ItemStack((ItemLike)ItemRegistry.FOOD_CHOCOLATE_BAR.get(), 6)).setMaxUses(12).setXpPerTrade(1).setPriceMul(0.02f).setForLevels(1).setPriestOnly().register().setInput1(new ItemStack((ItemLike)ItemRegistry.NAQUADAH_ORE_RAW.get(), 24)).setOutput(new ItemStack((ItemLike)Items.f_42616_, 1)).setMaxUses(12).setXpPerTrade(1).setPriceMul(0.02f).setForLevels(1).setPriestOnly().register().setInput1(new ItemStack((ItemLike)Items.f_42616_, 1)).setInput2(new ItemStack((ItemLike)Items.f_42516_, 4)).setOutput(new ItemStack((ItemLike)ItemRegistry.NOTEBOOK_PAGE_EMPTY.get(), 8)).setMaxUses(12).setXpPerTrade(1).setPriceMul(0.02f).setForLevels(1).setPriestOnly().register().setInput1(new ItemStack((ItemLike)Items.f_42616_, 2)).setOutput(new ItemStack((ItemLike)Items.f_151047_, 12)).setMaxUses(12).setXpPerTrade(1).setPriceMul(0.02f).setForLevels(1).setPriestOnly().register().setInput1(new ItemStack((ItemLike)Items.f_42616_, 1)).setOutput(new ItemStack((ItemLike)Items.f_42410_, 4)).setMaxUses(12).setXpPerTrade(1).setPriceMul(0.02f).setForLevels(1).setPriestOnly().register().setInput1(new ItemStack((ItemLike)Items.f_42616_, 1)).setInput2(new ItemStack((ItemLike)ItemRegistry.FOOD_LEMON.get(), 6)).setOutput(new ItemStack((ItemLike)Items.f_42400_, 1)).setMaxUses(5).setXpPerTrade(15).setPriceMul(0.05f).setForLevels(2).setPriestOnly().register().setInput1(new ItemStack((ItemLike)Items.f_151047_, 4)).setInput2(new ItemStack((ItemLike)Items.f_42616_, 1)).setOutput(new ItemStack((ItemLike)ItemRegistry.BLACK_CHALK.get(), 1)).setMaxUses(12).setXpPerTrade(10).setPriceMul(0.02f).setForLevels(3).setPriestOnly().register().setInput1(new ItemStack((ItemLike)Items.f_42616_, 6)).setInput2(new ItemStack((ItemLike)ItemRegistry.CRYSTAL_PEGASUS.get(), 4)).setOutput(new ItemStack((ItemLike)ItemRegistry.CRYSTAL_CONTROL_PEGASUS_DHD.get(), 1)).setMaxUses(6).setXpPerTrade(20).setPriceMul(0.02f).setForLevels(3).setPriestOnly().register().setInput1(new ItemStack((ItemLike)Items.f_42616_, 1)).setOutput(new ItemStack((ItemLike)Items.f_42406_, 6)).setMaxUses(12).setXpPerTrade(10).setPriceMul(0.02f).setForLevels(3).setPriestOnly().register().setInput1(new ItemStack((ItemLike)Items.f_42416_, 8)).setInput2(new ItemStack((ItemLike)Items.f_42616_, 1)).setOutput(new ItemStack((ItemLike)Items.f_42544_, 1)).setMaxUses(12).setXpPerTrade(15).setPriceMul(0.02f).setForLevels(4).setPriestOnly().register().setInput1(new ItemStack((ItemLike)Items.f_42616_, 4)).setInput2(new ItemStack((ItemLike)ItemRegistry.TRINIUM_INGOT.get(), 2)).setOutput(new ItemStack((ItemLike)ItemRegistry.CIRCUIT_CONTROL_CRYSTAL.get(), 1)).setMaxUses(12).setXpPerTrade(15).setPriceMul(0.02f).setForLevels(4).setPriestOnly().register().setInput1(new ItemStack((ItemLike)Items.f_42616_, 4)).setInput2(new ItemStack((ItemLike)ItemRegistry.NAQUADAH_ALLOY.get(), 3)).setOutput(new ItemStack((ItemLike)ItemRegistry.CIRCUIT_CONTROL_NAQUADAH.get(), 1)).setMaxUses(12).setXpPerTrade(15).setPriceMul(0.02f).setForLevels(4).setPriestOnly().register().setInput1(new ItemStack((ItemLike)Items.f_42616_, 4)).setOutput(new ItemStack((ItemLike)ItemRegistry.NAQUADAH_ALLOY.get(), 3)).setMaxUses(10).setXpPerTrade(10).setPriceMul(0.02f).setForLevels(4).setPriestOnly().register().setInput1(new ItemStack((ItemLike)Items.f_42616_, 4)).setOutput(new ItemStack((ItemLike)ItemRegistry.CRYSTAL_RED.get(), 1)).setMaxUses(10).setXpPerTrade(30).setPriceMul(0.02f).setForLevels(5).setPriestOnly().register().setInput1(new ItemStack((ItemLike)Items.f_42616_, 2)).setInput2(new ItemStack((ItemLike)ItemRegistry.CRYSTAL_RED.get(), 1)).setOutput(new ItemStack((ItemLike)ItemRegistry.CRYSTAL_RED_SMALL.get(), 2)).setMaxUses(12).setXpPerTrade(30).setPriceMul(0.02f).setForLevels(5).setPriestOnly().register().setInput1(new ItemStack((ItemLike)Items.f_42616_, 3)).setOutput(new ItemStack((ItemLike)ItemRegistry.CRYSTAL_PEGASUS.get(), 2)).setMaxUses(4).setXpPerTrade(30).setPriceMul(0.02f).setForLevels(5).setPriestOnly().register().setInput1(new ItemStack((ItemLike)Items.f_42616_, 2)).setInput2(new ItemStack((ItemLike)ItemRegistry.CRYSTAL_PEGASUS.get(), 1)).setOutput(new ItemStack((ItemLike)ItemRegistry.CRYSTAL_PEGASUS_SMALL.get(), 1)).setMaxUses(8).setXpPerTrade(30).setPriceMul(0.02f).setForLevels(5).setPriestOnly().register().setInput1(new ItemStack((ItemLike)Items.f_42616_, 1)).setOutput(new ItemStack((ItemLike)ItemRegistry.CRYSTAL_ENDER.get(), 2)).setMaxUses(5).setXpPerTrade(12).setPriceMul(0.02f).setForLevels(2).setForProfessions((VillagerProfession)PRIEST_PLAINS.get()).register().setInput1(new ItemStack((ItemLike)Items.f_42616_, 1)).setOutput(new ItemStack((ItemLike)ItemRegistry.TRINIUM_NUGGET.get(), 8)).setMaxUses(5).setXpPerTrade(12).setPriceMul(0.02f).setForLevels(2).setForProfessions((VillagerProfession)PRIEST_PLAINS.get()).register().setInput1(new ItemStack((ItemLike)Items.f_42616_, 3)).setInput2(new ItemStack((ItemLike)ItemRegistry.CRYSTAL_ENDER.get(), 1)).setOutput(new ItemStack((ItemLike)ItemRegistry.CRYSTAL_ENDER_SMALL.get(), 2)).setMaxUses(5).setXpPerTrade(12).setPriceMul(0.2f).setForLevels(2).setForProfessions((VillagerProfession)PRIEST_PLAINS.get()).register().setInput1(new ItemStack((ItemLike)Items.f_42616_, 1)).setOutput(new ItemStack((ItemLike)ItemRegistry.CRYSTAL_YELLOW.get(), 3)).setMaxUses(5).setXpPerTrade(12).setPriceMul(0.02f).setForLevels(2).setForProfessions((VillagerProfession)PRIEST_DESERT.get()).register().setInput1(new ItemStack((ItemLike)Items.f_42616_, 1)).setInput2(new ItemStack((ItemLike)ItemRegistry.CRYSTAL_YELLOW.get(), 1)).setOutput(new ItemStack((ItemLike)ItemRegistry.CRYSTAL_YELLOW_SMALL.get(), 2)).setMaxUses(5).setXpPerTrade(12).setPriceMul(0.02f).setForLevels(2).setForProfessions((VillagerProfession)PRIEST_DESERT.get()).register().setInput1(new ItemStack((ItemLike)Items.f_42416_, 6)).setInput2(new ItemStack((ItemLike)ItemRegistry.TITANIUM_NUGGET.get(), 1)).setOutput(new ItemStack((ItemLike)ItemRegistry.JSG_WRENCH.get(), 1)).setMaxUses(5).setXpPerTrade(12).setPriceMul(0.02f).setForLevels(2).setForProfessions((VillagerProfession)PRIEST_DESERT.get()).register().setInput1(new ItemStack((ItemLike)Items.f_42616_, 2)).setOutput(new ItemStack((ItemLike)ItemRegistry.CRYSTAL_WHITE.get(), 3)).setMaxUses(5).setXpPerTrade(12).setPriceMul(0.02f).setForLevels(2).setForProfessions((VillagerProfession)PRIEST_SAVANNA.get()).register().setInput1(new ItemStack((ItemLike)Items.f_42616_, 2)).setInput2(new ItemStack((ItemLike)ItemRegistry.CRYSTAL_WHITE.get(), 1)).setOutput(new ItemStack((ItemLike)ItemRegistry.CRYSTAL_WHITE_SMALL.get(), 3)).setMaxUses(5).setXpPerTrade(12).setPriceMul(0.02f).setForLevels(2).setForProfessions((VillagerProfession)PRIEST_SAVANNA.get()).register().setInput1(new ItemStack((ItemLike)Items.f_42616_, 1)).setInput2(new ItemStack((ItemLike)Items.f_42405_, 48)).setOutput(new ItemStack((ItemLike)ItemRegistry.FOOD_LEMON.get(), 1)).setMaxUses(5).setXpPerTrade(12).setPriceMul(0.02f).setForLevels(2).setForProfessions((VillagerProfession)PRIEST_SAVANNA.get()).register().setInput1(new ItemStack((ItemLike)Items.f_42616_, 1)).setOutput(new ItemStack((ItemLike)ItemRegistry.CRYSTAL_BLUE.get(), 4)).setMaxUses(5).setXpPerTrade(12).setPriceMul(0.02f).setForLevels(2).setForProfessions((VillagerProfession)PRIEST_TAIGA.get()).register().setInput1(new ItemStack((ItemLike)Items.f_42616_, 1)).setInput2(new ItemStack((ItemLike)ItemRegistry.CRYSTAL_BLUE.get(), 1)).setOutput(new ItemStack((ItemLike)ItemRegistry.CRYSTAL_BLUE_SMALL.get(), 2)).setMaxUses(5).setXpPerTrade(12).setPriceMul(0.02f).setForLevels(2).setForProfessions((VillagerProfession)PRIEST_TAIGA.get()).register().setInput1(new ItemStack((ItemLike)Items.f_42616_, 1)).setInput2(new ItemStack((ItemLike)Items.f_151052_, 16)).setOutput(new ItemStack((ItemLike)ItemRegistry.COPPER_INGOT_WEATHERED.get(), 8)).setMaxUses(5).setXpPerTrade(12).setPriceMul(0.02f).setForLevels(2).setForProfessions((VillagerProfession)PRIEST_TAIGA.get()).register().setInput1(new ItemStack((ItemLike)Items.f_42616_, 2)).setOutput(new ItemStack((ItemLike)ItemRegistry.CRYSTAL_BLUE.get(), 3)).setMaxUses(5).setXpPerTrade(12).setPriceMul(0.02f).setForLevels(2).setForProfessions((VillagerProfession)PRIEST_SNOW.get()).register().setInput1(new ItemStack((ItemLike)Items.f_42616_, 1)).setInput2(new ItemStack((ItemLike)ItemRegistry.CRYSTAL_BLUE.get(), 1)).setOutput(new ItemStack((ItemLike)ItemRegistry.CRYSTAL_BLUE_SMALL.get(), 2)).setMaxUses(5).setXpPerTrade(12).setPriceMul(0.02f).setForLevels(2).setForProfessions((VillagerProfession)PRIEST_SNOW.get()).register().setInput1(new ItemStack((ItemLike)Items.f_151052_, 16)).setInput2(new ItemStack((ItemLike)Items.f_42616_, 1)).setOutput(new ItemStack((ItemLike)ItemRegistry.COPPER_INGOT_OXIDIZED.get(), 12)).setMaxUses(5).setXpPerTrade(12).setPriceMul(0.02f).setForLevels(2).setForProfessions((VillagerProfession)PRIEST_SNOW.get()).register().setInput1(new ItemStack((ItemLike)Items.f_42616_, 2)).setOutput(new ItemStack((ItemLike)ItemRegistry.CRYSTAL_ENDER.get(), 4)).setMaxUses(5).setXpPerTrade(12).setPriceMul(0.02f).setForLevels(2).setForProfessions((VillagerProfession)PRIEST_JUNGLE.get()).register().setInput1(new ItemStack((ItemLike)Items.f_42616_, 1)).setInput2(new ItemStack((ItemLike)ItemRegistry.CRYSTAL_ENDER.get(), 2)).setOutput(new ItemStack((ItemLike)ItemRegistry.CRYSTAL_ENDER_SMALL.get(), 4)).setMaxUses(5).setXpPerTrade(12).setPriceMul(0.02f).setForLevels(2).setForProfessions((VillagerProfession)PRIEST_JUNGLE.get()).register().setInput1(new ItemStack((ItemLike)Items.f_42416_, 32)).setOutput(new ItemStack((ItemLike)ItemRegistry.MORTAR_AND_PESTLE.get(), 1)).setMaxUses(5).setXpPerTrade(12).setPriceMul(0.02f).setForLevels(2).setForProfessions((VillagerProfession)PRIEST_JUNGLE.get()).register().setInput1(new ItemStack((ItemLike)Items.f_42616_, 1)).setInput2(new ItemStack((ItemLike)Items.f_42405_, 8)).setOutput(new ItemStack((ItemLike)Items.f_42533_, 2)).setMaxUses(5).setXpPerTrade(12).setPriceMul(0.02f).setForLevels(2).setForProfessions((VillagerProfession)PRIEST_JUNGLE.get()).register().setInput1(new ItemStack((ItemLike)Items.f_42616_, 1)).setInput2(new ItemStack((ItemLike)Items.f_151052_, 4)).setOutput(new ItemStack((ItemLike)ItemRegistry.COPPER_INGOT_OXIDIZED.get(), 8)).setMaxUses(5).setXpPerTrade(12).setPriceMul(0.02f).setForLevels(2).setForProfessions((VillagerProfession)PRIEST_SWAMP.get()).register().setInput1(new ItemStack((ItemLike)Items.f_42616_, 1)).setOutput(new ItemStack((ItemLike)ItemRegistry.JSG_HAMMER.get(), 1)).setMaxUses(5).setXpPerTrade(12).setPriceMul(0.02f).setForLevels(2).setForProfessions((VillagerProfession)PRIEST_SWAMP.get()).register().setInput1(new ItemStack((ItemLike)ItemRegistry.CRYSTAL_RED.get(), 4)).setInput2(new ItemStack((ItemLike)Items.f_42616_, 3)).setOutput(new ItemStack((ItemLike)ItemRegistry.CRYSTAL_CONTROL_MILKYWAY_DHD.get(), 1)).setMaxUses(5).setXpPerTrade(12).setPriceMul(0.02f).setForLevels(2).setForProfessions((VillagerProfession)PRIEST_SWAMP.get()).register().setInput1(new ItemStack((ItemLike)Items.f_42619_, 4)).setOutput(new ItemStack((ItemLike)ItemRegistry.NAQUADAH_RAW_NUGGET.get(), 1)).setMaxUses(8).setXpPerTrade(1).setPriceMul(0.02f).setForLevels(1).setForProfessions((VillagerProfession)SLAVE_MINER.get()).register().setInput1(new ItemStack((ItemLike)Items.f_42780_, 6)).setOutput(new ItemStack((ItemLike)ItemRegistry.NAQUADAH_RAW_DUST.get(), 2)).setMaxUses(6).setXpPerTrade(1).setPriceMul(0.02f).setForLevels(1).setForProfessions((VillagerProfession)SLAVE_MINER.get()).register().setInput1(new ItemStack((ItemLike)Items.f_42410_, 8)).setOutput(new ItemStack((ItemLike)ItemRegistry.NAQUADAH_ORE_RAW.get(), 3)).setMaxUses(10).setXpPerTrade(1).setPriceMul(0.02f).setForLevels(1).setForProfessions((VillagerProfession)SLAVE_MINER.get()).register().setInput1(new ItemStack((ItemLike)Items.f_42572_, 3)).setOutput(new ItemStack((ItemLike)Items.f_42426_, 1)).setMaxUses(5).setXpPerTrade(15).setPriceMul(0.05f).setForLevels(2).setForProfessions((VillagerProfession)SLAVE_MINER.get()).register().setInput1(new ItemStack((ItemLike)Items.f_42732_, 20)).setOutput(new ItemStack((ItemLike)ItemRegistry.NAQUADAH_RAW_DUST.get(), 2)).setMaxUses(5).setXpPerTrade(12).setPriceMul(0.02f).setForLevels(2).setForProfessions((VillagerProfession)SLAVE_MINER.get()).register().setInput1(new ItemStack((ItemLike)Items.f_42620_, 16)).setOutput(new ItemStack((ItemLike)ItemRegistry.NAQUADAH_RAW_NUGGET.get(), 2)).setMaxUses(6).setXpPerTrade(8).setPriceMul(0.02f).setForLevels(2).setForProfessions((VillagerProfession)SLAVE_MINER.get()).register().setInput1(new ItemStack((ItemLike)Items.f_42406_, 3)).setOutput(new ItemStack((ItemLike)Items.f_42427_, 1)).setMaxUses(12).setXpPerTrade(10).setPriceMul(0.02f).setForLevels(3).setForProfessions((VillagerProfession)SLAVE_MINER.get()).register().setInput1(new ItemStack((ItemLike)Items.f_42582_, 4)).setOutput(new ItemStack((ItemLike)ItemRegistry.NAQUADAH_ORE_RAW.get(), 2)).setMaxUses(6).setXpPerTrade(20).setPriceMul(0.02f).setForLevels(3).setForProfessions((VillagerProfession)SLAVE_MINER.get()).register().setInput1(new ItemStack((ItemLike)Items.f_42698_, 6)).setOutput(new ItemStack((ItemLike)ItemRegistry.NAQUADAH_RAW_NUGGET.get(), 27)).setMaxUses(12).setXpPerTrade(10).setPriceMul(0.02f).setForLevels(3).setForProfessions((VillagerProfession)SLAVE_MINER.get()).register().setInput1(new ItemStack((ItemLike)Items.f_42659_, 12)).setOutput(new ItemStack((ItemLike)ItemRegistry.NAQUADAH_RAW_DUST.get(), 4)).setMaxUses(12).setXpPerTrade(15).setPriceMul(0.02f).setForLevels(4).setForProfessions((VillagerProfession)SLAVE_MINER.get()).register().setInput1(new ItemStack((ItemLike)Items.f_42580_, 6)).setOutput(new ItemStack((ItemLike)Items.f_42384_, 1)).setMaxUses(8).setXpPerTrade(15).setPriceMul(0.02f).setForLevels(4).setForProfessions((VillagerProfession)SLAVE_MINER.get()).register().setInput1(new ItemStack((ItemLike)Items.f_42486_, 8)).setOutput(new ItemStack((ItemLike)ItemRegistry.NAQUADAH_RAW_DUST.get(), 3)).setMaxUses(10).setXpPerTrade(10).setPriceMul(0.02f).setForLevels(4).setForProfessions((VillagerProfession)SLAVE_MINER.get()).register().setInput1(new ItemStack((ItemLike)Items.f_42502_, 1)).setOutput(new ItemStack((ItemLike)BlockRegistry.NAQUADAH_RAW_BLOCK.get(), 1)).setMaxUses(10).setXpPerTrade(20).setPriceMul(0.02f).setForLevels(5).setForProfessions((VillagerProfession)SLAVE_MINER.get()).register().setInput1(new ItemStack((ItemLike)Items.f_42687_, 16)).setOutput(new ItemStack((ItemLike)Items.f_42385_, 1)).setMaxUses(4).setXpPerTrade(32).setPriceMul(0.02f).setForLevels(5).setForProfessions((VillagerProfession)SLAVE_MINER.get()).register().setInput1(new ItemStack((ItemLike)ItemRegistry.FOOD_CHOCOLATE_BAR.get(), 4)).setOutput(new ItemStack((ItemLike)ItemRegistry.NAQUADAH_ALLOY_RAW.get(), 2)).setMaxUses(8).setXpPerTrade(30).setPriceMul(0.02f).setForLevels(5).setForProfessions((VillagerProfession)SLAVE_MINER.get()).register();
    }
}

