/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.renderer.activation;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.util.INBTSerializable;

public abstract class Activation<K>
implements INBTSerializable<CompoundTag> {
    protected final K textureKey;
    public long stateChange;
    protected boolean dim;
    private final ActivationState state;
    private boolean active;

    public Activation(K textureKey, long stateChange, boolean dim) {
        this.textureKey = textureKey;
        this.stateChange = stateChange;
        this.dim = dim;
        this.state = new ActivationState(dim ? this.getMaxStage() : 0.0f);
        this.active = true;
    }

    public Activation(K textureKey, CompoundTag compoundTag) {
        this.textureKey = textureKey;
        this.deserializeNBT(compoundTag);
        this.state = new ActivationState(this.dim ? this.getMaxStage() : 0.0f);
    }

    public Activation(K textureKey, ByteBuf buf) {
        this.textureKey = textureKey;
        this.fromBytes(buf);
        this.state = new ActivationState(this.dim ? this.getMaxStage() : 0.0f);
    }

    protected abstract float getMaxStage();

    protected abstract float getTickMultiplier();

    public Activation<K> inactive() {
        this.active = false;
        return this;
    }

    public Activation<K> active() {
        this.active = true;
        return this;
    }

    public boolean isActive() {
        return this.active;
    }

    public float getFinalState() {
        if (this.dim) {
            return 0.0f;
        }
        return this.getMaxStage();
    }

    public ActivationState activate(long worldTicks, double partialTicks) {
        double stage = ((double)(worldTicks - this.stateChange) + partialTicks) * (double)this.getTickMultiplier();
        if (stage >= 0.0) {
            if (stage <= (double)this.getMaxStage()) {
                if (this.dim) {
                    stage = (double)this.getMaxStage() - stage;
                }
                this.state.stage = (float)stage;
            } else {
                this.onActivated();
                this.state.stage = this.dim ? 0.0f : this.getMaxStage();
                this.state.remove = true;
            }
        }
        return this.state;
    }

    protected void onActivated() {
    }

    public static <K> void iterate(List<Activation<K>> activationList, long ticks, double partialTicks, IActivationCallback<K> callback) {
        int i = 0;
        while (i < activationList.size()) {
            Activation<K> activation = activationList.get(i);
            if (activation.isActive()) {
                ActivationState activationState = activation.activate(ticks, partialTicks);
                callback.run(activation.textureKey, activationState.stage);
                if (activationState.remove) {
                    activationList.remove(activation);
                    continue;
                }
                ++i;
                continue;
            }
            ++i;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.textureKey.hashCode();
        result = 31 * result + (this.dim ? 1231 : 1237);
        result = 31 * result + (int)(this.stateChange ^ this.stateChange >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Activation other = (Activation)obj;
        if (!this.textureKey.equals(other.textureKey)) {
            return false;
        }
        if (this.dim != other.dim) {
            return false;
        }
        return this.stateChange == other.stateChange;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.stateChange);
        buf.writeBoolean(this.dim);
        buf.writeBoolean(this.active);
    }

    public void fromBytes(ByteBuf buf) {
        this.stateChange = buf.readLong();
        this.dim = buf.readBoolean();
        this.active = buf.readBoolean();
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128356_("stateChanged", this.stateChange);
        compound.m_128379_("dim", this.dim);
        compound.m_128379_("active", this.active);
        return compound;
    }

    public void deserializeNBT(CompoundTag compound) {
        this.stateChange = compound.m_128454_("stateChange");
        this.dim = compound.m_128471_("dim");
        this.active = compound.m_128471_("active");
    }

    public static class ActivationState {
        public float stage;
        public boolean remove;

        public ActivationState(float stage) {
            this.stage = stage;
            this.remove = false;
        }
    }

    public static interface IActivationCallback<K> {
        public void run(K var1, float var2);
    }
}

