/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.renderer.dialhomedevice;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.tauri.jsg.api.blockstates.JSGProperties;
import dev.tauri.jsg.api.client.renderer.BlockRenderer;
import dev.tauri.jsg.api.client.renderer.IRaycasterButtonsRenderer;
import dev.tauri.jsg.api.client.renderer.LinkableRenderer;
import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.api.config.values.JSGConfigValue;
import dev.tauri.jsg.api.item.NotebookPageSerialization;
import dev.tauri.jsg.api.stargate.network.address.IAddress;
import dev.tauri.jsg.api.stargate.network.address.StargateAddress;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolInterface;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.AbstractSymbolType;
import dev.tauri.jsg.api.util.vectors.Vector3f;
import dev.tauri.jsg.blockentity.dialhomedevice.DHDAbstractBE;
import dev.tauri.jsg.item.notebook.NotebookItem;
import dev.tauri.jsg.renderer.dialhomedevice.DHDAbstractRendererState;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class DHDAbstractRenderer<S extends DHDAbstractRendererState>
implements LinkableRenderer,
BlockEntityRenderer<DHDAbstractBE>,
IRaycasterButtonsRenderer {
    public DHDAbstractBE tileEntity;
    public Level level;
    public float partialTicks;
    public S rendererState;

    public DHDAbstractRenderer(BlockEntityRendererProvider.Context ignored) {
    }

    @ParametersAreNonnullByDefault
    public void render(DHDAbstractBE te, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        this.tileEntity = te;
        this.rendererState = te.getRendererStateClient();
        this.partialTicks = partialTicks;
        if (this.rendererState != null && te.m_58904_() != null) {
            this.level = te.m_58904_();
            this.level.m_46465_();
            BlockState state = te.m_58904_().m_8055_(te.m_58899_());
            if (state.m_60734_() != this.getDHDBlock()) {
                return;
            }
            this.renderLink(te.m_58899_(), te, poseStack, bufferSource);
            this.renderRaycasterButtons(te, poseStack, bufferSource);
            poseStack.m_85836_();
            if (((Boolean)state.m_61143_((Property)JSGProperties.SNOWY)).booleanValue()) {
                BlockRenderer.renderBlock(this.level, te.m_58899_(), Blocks.f_50125_.m_49966_(), new BlockPos(0, 0, 0), poseStack, bufferSource, combinedLight, combinedOverlay);
            }
            poseStack.m_85837_(0.5, 0.0, 0.5);
            poseStack.m_252781_(Axis.f_252436_.m_252977_((float)((Integer)Objects.requireNonNull(this.level).m_8055_(this.tileEntity.m_58899_()).m_61143_((Property)JSGProperties.ROTATION_PROPERTY)).intValue() * -22.5f));
            this.renderDHD(poseStack, bufferSource, combinedLight, combinedOverlay);
            this.renderSymbols(poseStack, bufferSource, combinedLight, combinedOverlay);
            poseStack.m_85849_();
            ((DHDAbstractRendererState)this.rendererState).iterate(this.level, partialTicks);
        }
    }

    public abstract void renderSymbols(PoseStack var1, MultiBufferSource var2, int var3, int var4);

    public abstract void renderDHD(PoseStack var1, MultiBufferSource var2, int var3, int var4);

    public abstract Block getDHDBlock();

    protected Vector3f getColorByAddress(DHDAbstractRendererState rendererState, CompoundTag compound, AbstractSymbolType<?> symbolType, SymbolInterface symbol) {
        if (rendererState == null) {
            return new Vector3f(1.0f, 1.0f, 1.0f);
        }
        if (compound != null && JSGConfig.DialHomeDevice.enablePageHint.get()) {
            if (compound.m_128441_("addressList")) {
                compound = NotebookItem.getSelectedPageFromCompound(compound);
            }
            if (compound == null) {
                return new Vector3f(1.0f, 1.0f, 1.0f);
            }
            if (!compound.m_128441_("symbolType")) {
                return new Vector3f(1.0f, 1.0f, 1.0f);
            }
            if (!compound.m_128441_("address")) {
                return new Vector3f(1.0f, 1.0f, 1.0f);
            }
            IAddress address = NotebookPageSerialization.getDeserializedAddress(compound);
            if (!(address instanceof StargateAddress)) {
                return new Vector3f(1.0f, 1.0f, 1.0f);
            }
            StargateAddress stargateAddress = (StargateAddress)address;
            AbstractSymbolType<?> st = stargateAddress.getSymbolType();
            int[] symbolsToDisplay = compound.m_128465_("symbolsToDisplay");
            List<Integer> symbolsToDisplayList = Arrays.stream(symbolsToDisplay).boxed().toList();
            if (st == symbolType && !rendererState.isButtonActive(symbol) && !rendererState.isButtonActive((SymbolInterface)st.getOrigin())) {
                int activatedButtons = rendererState.getActivatedButtons();
                Object displayedSymbol = st.getOrigin();
                if (symbolsToDisplayList.contains(activatedButtons + 1) && activatedButtons <= 7 && !rendererState.stargateIsConnected) {
                    displayedSymbol = stargateAddress.get(activatedButtons);
                } else if (!symbolsToDisplayList.contains(activatedButtons + 1)) {
                    for (int i = activatedButtons + 2; i <= 7; ++i) {
                        if (!symbolsToDisplayList.contains(i)) continue;
                        return new Vector3f(1.0f, 1.0f, 1.0f);
                    }
                }
                if ((stargateAddress.contains(symbol) || symbol.origin()) && displayedSymbol == symbol) {
                    JSGConfigValue.RGBAValue color = symbol.origin() ? JSGConfig.DialHomeDevice.pageHintColorOrigin : (activatedButtons < 6 ? JSGConfig.DialHomeDevice.pageHintColorNormal : JSGConfig.DialHomeDevice.pageHintColorExtra);
                    return new Vector3f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
                }
            }
        }
        return new Vector3f(1.0f, 1.0f, 1.0f);
    }

    public CompoundTag getNoteBookPage() {
        LocalPlayer p = Minecraft.m_91087_().f_91074_;
        if (p == null) {
            return null;
        }
        CompoundTag compound = null;
        ItemStack item = p.m_21120_(InteractionHand.MAIN_HAND);
        if (item.m_41782_()) {
            compound = item.m_41783_();
        } else {
            item = p.m_21120_(InteractionHand.OFF_HAND);
            if (item.m_41782_()) {
                compound = item.m_41783_();
            }
        }
        return compound;
    }
}

