/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.renderer.dialhomedevice;

import dev.tauri.jsg.api.config.ingame.BEConfig;
import dev.tauri.jsg.api.registry.BiomeOverlayRegistry;
import dev.tauri.jsg.api.stargate.network.address.StargateAddressDynamic;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolInterface;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.AbstractSymbolType;
import dev.tauri.jsg.api.state.State;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;

public abstract class DHDAbstractRendererState
extends State {
    public BlockPos pos;
    protected BiomeOverlayRegistry.BiomeOverlayInstance biomeOverlay;
    public boolean stargateIsConnected;
    public StargateAddressDynamic addressDialed;
    public boolean brbActive;
    public BiomeOverlayRegistry.BiomeOverlayInstance biomeOverride;

    public DHDAbstractRendererState() {
    }

    public DHDAbstractRendererState(StargateAddressDynamic addressDialed, boolean brbActive, BiomeOverlayRegistry.BiomeOverlayInstance biomeOverride, boolean stargateIsConnected, BEConfig gateConfig) {
        this.addressDialed = addressDialed;
        this.brbActive = brbActive;
        this.biomeOverride = biomeOverride;
        this.stargateIsConnected = stargateIsConnected;
    }

    public DHDAbstractRendererState initClient(BlockPos pos, BiomeOverlayRegistry.BiomeOverlayInstance biomeOverlay, boolean stargateIsConnected) {
        this.pos = pos;
        this.biomeOverlay = biomeOverlay;
        this.stargateIsConnected = stargateIsConnected;
        return this;
    }

    public void setIsConnected(boolean connected) {
        this.stargateIsConnected = connected;
    }

    public BiomeOverlayRegistry.BiomeOverlayInstance getBiomeOverlay() {
        if (this.biomeOverride != null) {
            return this.biomeOverride;
        }
        return this.biomeOverlay;
    }

    public void setBiomeOverlay(BiomeOverlayRegistry.BiomeOverlayInstance biomeOverlay) {
        this.biomeOverlay = biomeOverlay;
    }

    public abstract void iterate(Level var1, double var2);

    public abstract boolean isButtonActive(SymbolInterface var1);

    public abstract int getActivatedButtons();

    public abstract AbstractSymbolType<?> getSymbolType();

    @Override
    public void toBytes(ByteBuf buf) {
        this.addressDialed.toBytes(buf);
        buf.writeBoolean(this.brbActive);
        if (this.biomeOverride != null) {
            buf.writeBoolean(true);
            new FriendlyByteBuf(buf).m_130085_(this.biomeOverride.id);
        } else {
            buf.writeBoolean(false);
        }
        buf.writeBoolean(this.stargateIsConnected);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.addressDialed = new StargateAddressDynamic(this.getSymbolType());
        this.addressDialed.fromBytes(buf);
        this.brbActive = buf.readBoolean();
        if (buf.readBoolean()) {
            this.biomeOverride = BiomeOverlayRegistry.byId(new FriendlyByteBuf(buf).m_130281_());
        }
        this.stargateIsConnected = buf.readBoolean();
    }
}

