/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.renderer.dimension;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import dev.tauri.jsg.api.integration.Integrations;
import dev.tauri.jsg.integration.stellarview.StellarViewCompatibility;
import dev.tauri.jsg.renderer.dimension.util.CustomSkyObjectRenderer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Camera;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public abstract class AbstractSkyEffects
extends DimensionSpecialEffects.OverworldEffects {
    protected final List<CustomSkyObjectRenderer> CUSTOM_SKY_OBJECTS = new ArrayList<CustomSkyObjectRenderer>();
    protected VertexBuffer starBuffer;
    protected VertexBuffer skyBuffer;
    protected VertexBuffer darkBuffer;
    protected int prevCloudX = Integer.MIN_VALUE;
    protected int prevCloudY = Integer.MIN_VALUE;
    protected int prevCloudZ = Integer.MIN_VALUE;
    protected Vec3 prevCloudColor = Vec3.f_82478_;
    @Nullable
    protected CloudStatus prevCloudsType;
    protected boolean generateClouds = true;
    @Nullable
    private VertexBuffer cloudBuffer;

    public AbstractSkyEffects() {
        this.createDarkSky();
        this.createLightSky();
        this.createStars();
    }

    public void addCustomSkyObjects(CustomSkyObjectRenderer ... customSkyObjectRenderer) {
        this.CUSTOM_SKY_OBJECTS.addAll(List.of(customSkyObjectRenderer));
    }

    public boolean drawStars() {
        return true;
    }

    public boolean drawDefaultSun() {
        return true;
    }

    public boolean drawDefaultMoon() {
        return true;
    }

    protected void createDarkSky() {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        if (this.darkBuffer != null) {
            this.darkBuffer.close();
        }
        this.darkBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        BufferBuilder.RenderedBuffer bufferbuilder$renderedbuffer = AbstractSkyEffects.buildSkyDisc(bufferbuilder, -16.0f);
        this.darkBuffer.m_85921_();
        this.darkBuffer.m_231221_(bufferbuilder$renderedbuffer);
        VertexBuffer.m_85931_();
    }

    protected void createLightSky() {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        if (this.skyBuffer != null) {
            this.skyBuffer.close();
        }
        this.skyBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        BufferBuilder.RenderedBuffer bufferbuilder$renderedbuffer = AbstractSkyEffects.buildSkyDisc(bufferbuilder, 16.0f);
        this.skyBuffer.m_85921_();
        this.skyBuffer.m_231221_(bufferbuilder$renderedbuffer);
        VertexBuffer.m_85931_();
    }

    public long getStarsGenerationSeed() {
        return 10842L;
    }

    public int getStarsCount() {
        return 1500;
    }

    protected void createStars() {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172808_);
        if (this.starBuffer != null) {
            this.starBuffer.close();
        }
        this.starBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        BufferBuilder.RenderedBuffer renderedBuffer = this.drawStars(bufferbuilder, RandomSource.m_216335_((long)this.getStarsGenerationSeed()), this.getStarsCount());
        this.starBuffer.m_85921_();
        this.starBuffer.m_231221_(renderedBuffer);
        VertexBuffer.m_85931_();
    }

    public Color getStarColor(RandomSource random) {
        return new Color(190, 160, 0, 170);
    }

    protected BufferBuilder.RenderedBuffer drawStars(BufferBuilder builder, RandomSource randomsource, int numberOfStars) {
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        for (int i = 0; i < numberOfStars; ++i) {
            double x = randomsource.m_188501_() * 2.0f - 1.0f;
            double y = randomsource.m_188501_() * 2.0f - 1.0f;
            double z = randomsource.m_188501_() * 2.0f - 1.0f;
            double starSize = 0.05f + randomsource.m_188501_() * 0.08f;
            double distance = x * x + y * y + z * z;
            if (!(distance < 1.0) || !(distance > 0.01)) continue;
            distance = 1.0 / Math.sqrt(distance);
            double starX = (x *= distance) * 100.0;
            double starY = (y *= distance) * 100.0;
            double starZ = (z *= distance) * 100.0;
            double sphericalTheta = Math.atan2(x, z);
            double sinTheta = Math.sin(sphericalTheta);
            double cosTheta = Math.cos(sphericalTheta);
            double xzLength = Math.sqrt(x * x + z * z);
            double sphericalPhi = Math.atan2(xzLength, y);
            double sinPhi = Math.sin(sphericalPhi);
            double cosPhi = Math.cos(sphericalPhi);
            double random = randomsource.m_188500_() * Math.PI * 2.0;
            double sinRandom = Math.sin(random);
            double cosRandom = Math.cos(random);
            Color starColor = this.getStarColor(randomsource);
            float alpha = 1.0f;
            for (int k = 0; k < 3; ++k) {
                if (k >= 1) {
                    starSize *= (double)(1.0f + (float)k * 0.3f);
                    alpha -= 0.1f + 0.2f * (float)k;
                }
                for (int j = 0; j < 4; ++j) {
                    double aLocation = (double)((j & 2) - 1) * starSize;
                    double bLocation = (double)((j + 1 & 2) - 1) * starSize;
                    double height = aLocation * cosRandom - bLocation * sinRandom;
                    double width = bLocation * cosRandom + aLocation * sinRandom;
                    double heightProjectionY = height * sinPhi;
                    double heightProjectionXZ = -height * cosPhi;
                    double projectedX = heightProjectionXZ * sinTheta - width * cosTheta;
                    double projectedZ = width * sinTheta + heightProjectionXZ * cosTheta;
                    builder.m_5483_(starX + projectedX, starY + heightProjectionY, starZ + projectedZ).m_6122_(starColor.getRed(), starColor.getGreen(), starColor.getBlue(), (int)((float)starColor.getAlpha() * alpha)).m_5752_();
                }
            }
        }
        return builder.m_231175_();
    }

    protected static BufferBuilder.RenderedBuffer buildSkyDisc(BufferBuilder pBuilder, float pY) {
        float f1 = 512.0f;
        float f = Math.signum(pY) * f1;
        RenderSystem.setShader(GameRenderer::m_172808_);
        pBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85814_);
        pBuilder.m_5483_(0.0, (double)pY, 0.0).m_5752_();
        for (int i = -180; i <= 180; i += 45) {
            pBuilder.m_5483_((double)(f * Mth.m_14089_((float)((float)i * ((float)Math.PI / 180)))), (double)pY, (double)(f1 * Mth.m_14031_((float)((float)i * ((float)Math.PI / 180))))).m_5752_();
        }
        return pBuilder.m_231175_();
    }

    public void renderSunAndMoon(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, FogType fogType, Runnable setupFog) {
        float f11 = 1.0f - this.getRainLevel(level, partialTick);
        RenderSystem.setShaderColor((float)f11, (float)f11, (float)f11, (float)1.0f);
        RenderSystem.defaultBlendFunc();
        if (this.drawDefaultSun()) {
            CustomSkyObjectRenderer.OVERWORLD_SUN.render(level, ticks, partialTick, poseStack, camera, projectionMatrix, isFoggy, fogType, setupFog);
        }
        if (this.drawDefaultMoon()) {
            CustomSkyObjectRenderer.OVERWORLD_MOON.render(level, ticks, partialTick, poseStack, camera, projectionMatrix, isFoggy, fogType, setupFog);
        }
        for (CustomSkyObjectRenderer r : this.CUSTOM_SKY_OBJECTS) {
            r.render(level, ticks, partialTick, poseStack, camera, projectionMatrix, isFoggy, fogType, setupFog);
        }
    }

    public void renderSunAndMoonSunrise(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, FogType fogType, Runnable setupFog) {
        if (this.drawDefaultSun()) {
            CustomSkyObjectRenderer.OVERWORLD_SUN.renderSkySunrise(level, ticks, partialTick, poseStack, camera, projectionMatrix, setupFog);
        }
        if (this.drawDefaultMoon()) {
            CustomSkyObjectRenderer.OVERWORLD_MOON.renderSkySunrise(level, ticks, partialTick, poseStack, camera, projectionMatrix, setupFog);
        }
        for (CustomSkyObjectRenderer r : this.CUSTOM_SKY_OBJECTS) {
            r.renderSkySunrise(level, ticks, partialTick, poseStack, camera, projectionMatrix, setupFog);
        }
    }

    public void renderSkyObjects(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, FogType fogType, Runnable setupFog) {
        if (isFoggy) {
            return;
        }
        if (fogType == FogType.POWDER_SNOW || fogType == FogType.LAVA || AbstractSkyEffects.doesMobEffectBlockSky(camera)) {
            return;
        }
        this.renderSkyBackground(level, ticks, partialTick, poseStack, camera, projectionMatrix, setupFog);
        this.renderSunAndMoonSunrise(level, ticks, partialTick, poseStack, camera, projectionMatrix, isFoggy, fogType, setupFog);
        this.applyRainColor(level, ticks, partialTick, poseStack, camera, projectionMatrix, setupFog);
        if (this.drawStars()) {
            this.renderStars(level, ticks, partialTick, poseStack, camera, projectionMatrix, setupFog);
        }
        this.renderSunAndMoon(level, ticks, partialTick, poseStack, camera, projectionMatrix, isFoggy, fogType, setupFog);
    }

    @ParametersAreNonnullByDefault
    public void adjustLightmapColors(ClientLevel level, float partialTicks, float skyDarken, float blockLightRedFlicker, float skyLight, int pixelX, int pixelY, Vector3f colors) {
        if (Integrations.STELLAR_VIEW.isLoaded()) {
            StellarViewCompatibility.adjustLightmapColors(level, partialTicks, skyDarken, blockLightRedFlicker, skyLight, pixelX, pixelY, colors);
        }
    }

    @ParametersAreNonnullByDefault
    public boolean renderSky(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        if (Integrations.STELLAR_VIEW.isLoaded()) {
            return StellarViewCompatibility.renderSky(level, ticks, partialTick, poseStack, camera, projectionMatrix, isFoggy, setupFog);
        }
        setupFog.run();
        poseStack.m_85836_();
        this.renderSkyObjects(level, ticks, partialTick, poseStack, camera, projectionMatrix, isFoggy, camera.m_167685_(), setupFog);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        double d0 = Minecraft.m_91087_().f_91074_.m_20299_((float)partialTick).f_82480_ - level.m_6106_().m_171687_((LevelHeightAccessor)level);
        if (d0 < 0.0) {
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 12.0f, 0.0f);
            this.darkBuffer.m_85921_();
            this.darkBuffer.m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, RenderSystem.getShader());
            VertexBuffer.m_85931_();
            poseStack.m_85849_();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)true);
        poseStack.m_85849_();
        return true;
    }

    protected void renderSkyBackground(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, Runnable setupFog) {
        Vec3 vec3 = level.m_171660_(Minecraft.m_91087_().f_91063_.m_109153_().m_90583_(), partialTick);
        float f = (float)vec3.f_82479_;
        float f1 = (float)vec3.f_82480_;
        float f2 = (float)vec3.f_82481_;
        FogRenderer.m_109036_();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShaderColor((float)f, (float)f1, (float)f2, (float)1.0f);
        ShaderInstance shaderinstance = RenderSystem.getShader();
        this.skyBuffer.m_85921_();
        this.skyBuffer.m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, shaderinstance);
        VertexBuffer.m_85931_();
        RenderSystem.enableBlend();
    }

    protected void applyRainColor(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, Runnable setupFog) {
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        float f11 = 1.0f - this.getRainLevel(level, partialTick);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)f11);
    }

    protected void renderStars(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, Runnable setupFog) {
        poseStack.m_85836_();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(level.m_46942_(partialTick) * 360.0f));
        float f11 = 1.0f - this.getRainLevel(level, partialTick);
        float f10 = level.m_104811_(partialTick) * f11;
        if (f10 > 0.0f) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)f10);
            FogRenderer.m_109017_();
            this.starBuffer.m_85921_();
            this.starBuffer.m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, GameRenderer.m_172811_());
            VertexBuffer.m_85931_();
            setupFog.run();
        }
        poseStack.m_85849_();
    }

    public float getRainLevel(ClientLevel level, float pDelta) {
        return level.m_46722_(pDelta);
    }

    protected static boolean doesMobEffectBlockSky(Camera camera) {
        Entity entity = camera.m_90592_();
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity livingentity = (LivingEntity)entity;
        return livingentity.m_21023_(MobEffects.f_19610_) || livingentity.m_21023_(MobEffects.f_216964_);
    }

    @Nullable
    public ResourceLocation getCustomCloudsTexture() {
        return null;
    }

    public float getCloudsSpeed() {
        return 1.0f;
    }

    @ParametersAreNonnullByDefault
    public boolean renderClouds(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, double camX, double camY, double camZ, Matrix4f projectionMatrix) {
        ResourceLocation tex = this.getCustomCloudsTexture();
        if (tex == null) {
            return false;
        }
        float f = level.m_104583_().m_108871_();
        if (!Float.isNaN(f)) {
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.depthMask((boolean)true);
            double d1 = ((float)ticks + partialTick) * 0.03f * this.getCloudsSpeed();
            double d2 = (camX + d1) / 12.0;
            double d3 = f - (float)camY + 0.33f;
            double d4 = camZ / 12.0 + (double)0.33f;
            d2 -= (double)(Mth.m_14107_((double)(d2 / 2048.0)) * 2048);
            d4 -= (double)(Mth.m_14107_((double)(d4 / 2048.0)) * 2048);
            float f3 = (float)(d2 - (double)Mth.m_14107_((double)d2));
            float f4 = (float)(d3 / 4.0 - (double)Mth.m_14107_((double)(d3 / 4.0))) * 4.0f;
            float f5 = (float)(d4 - (double)Mth.m_14107_((double)d4));
            Vec3 vec3 = level.m_104808_(partialTick);
            int i = (int)Math.floor(d2);
            int j = (int)Math.floor(d3 / 4.0);
            int k = (int)Math.floor(d4);
            if (i != this.prevCloudX || j != this.prevCloudY || k != this.prevCloudZ || Minecraft.m_91087_().f_91066_.m_92174_() != this.prevCloudsType || this.prevCloudColor.m_82557_(vec3) > 2.0E-4) {
                this.prevCloudX = i;
                this.prevCloudY = j;
                this.prevCloudZ = k;
                this.prevCloudColor = vec3;
                this.prevCloudsType = Minecraft.m_91087_().f_91066_.m_92174_();
                this.generateClouds = true;
            }
            if (this.generateClouds) {
                this.generateClouds = false;
                BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
                if (this.cloudBuffer != null) {
                    this.cloudBuffer.close();
                }
                this.cloudBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
                BufferBuilder.RenderedBuffer bufferbuilder$renderedbuffer = this.buildClouds(bufferbuilder, d2, d3, d4, vec3);
                this.cloudBuffer.m_85921_();
                this.cloudBuffer.m_231221_(bufferbuilder$renderedbuffer);
                VertexBuffer.m_85931_();
            }
            RenderSystem.setShader(GameRenderer::m_172838_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)tex);
            FogRenderer.m_109036_();
            poseStack.m_85836_();
            poseStack.m_85841_(12.0f, 1.0f, 12.0f);
            poseStack.m_252880_(-f3, f4, -f5);
            if (this.cloudBuffer != null) {
                int l;
                this.cloudBuffer.m_85921_();
                for (int i1 = l = this.prevCloudsType == CloudStatus.FANCY ? 0 : 1; i1 < 2; ++i1) {
                    if (i1 == 0) {
                        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                    } else {
                        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                    }
                    ShaderInstance shaderinstance = RenderSystem.getShader();
                    this.cloudBuffer.m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, shaderinstance);
                }
                VertexBuffer.m_85931_();
            }
            poseStack.m_85849_();
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        }
        return true;
    }

    private BufferBuilder.RenderedBuffer buildClouds(BufferBuilder pBuilder, double pX, double pY, double pZ, Vec3 pCloudColor) {
        float f = 4.0f;
        float f1 = 0.00390625f;
        int i = 8;
        int j = 4;
        float f2 = 9.765625E-4f;
        float f3 = (float)Mth.m_14107_((double)pX) * 0.00390625f;
        float f4 = (float)Mth.m_14107_((double)pZ) * 0.00390625f;
        float f5 = (float)pCloudColor.f_82479_;
        float f6 = (float)pCloudColor.f_82480_;
        float f7 = (float)pCloudColor.f_82481_;
        float f8 = f5 * 0.9f;
        float f9 = f6 * 0.9f;
        float f10 = f7 * 0.9f;
        float f11 = f5 * 0.7f;
        float f12 = f6 * 0.7f;
        float f13 = f7 * 0.7f;
        float f14 = f5 * 0.8f;
        float f15 = f6 * 0.8f;
        float f16 = f7 * 0.8f;
        RenderSystem.setShader(GameRenderer::m_172838_);
        pBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85822_);
        float f17 = (float)Math.floor(pY / 4.0) * 4.0f;
        if (this.prevCloudsType == CloudStatus.FANCY) {
            for (int k = -3; k <= 4; ++k) {
                for (int l = -3; l <= 4; ++l) {
                    float f18 = k * 8;
                    float f19 = l * 8;
                    if (f17 > -5.0f) {
                        pBuilder.m_5483_((double)(f18 + 0.0f), (double)(f17 + 0.0f), (double)(f19 + 8.0f)).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f11, f12, f13, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                        pBuilder.m_5483_((double)(f18 + 8.0f), (double)(f17 + 0.0f), (double)(f19 + 8.0f)).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f11, f12, f13, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                        pBuilder.m_5483_((double)(f18 + 8.0f), (double)(f17 + 0.0f), (double)(f19 + 0.0f)).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f11, f12, f13, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                        pBuilder.m_5483_((double)(f18 + 0.0f), (double)(f17 + 0.0f), (double)(f19 + 0.0f)).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f11, f12, f13, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                    }
                    if (f17 <= 5.0f) {
                        pBuilder.m_5483_((double)(f18 + 0.0f), (double)(f17 + 4.0f - 9.765625E-4f), (double)(f19 + 8.0f)).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                        pBuilder.m_5483_((double)(f18 + 8.0f), (double)(f17 + 4.0f - 9.765625E-4f), (double)(f19 + 8.0f)).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                        pBuilder.m_5483_((double)(f18 + 8.0f), (double)(f17 + 4.0f - 9.765625E-4f), (double)(f19 + 0.0f)).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                        pBuilder.m_5483_((double)(f18 + 0.0f), (double)(f17 + 4.0f - 9.765625E-4f), (double)(f19 + 0.0f)).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                    }
                    if (k > -1) {
                        for (int i1 = 0; i1 < 8; ++i1) {
                            pBuilder.m_5483_((double)(f18 + (float)i1 + 0.0f), (double)(f17 + 0.0f), (double)(f19 + 8.0f)).m_7421_((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                            pBuilder.m_5483_((double)(f18 + (float)i1 + 0.0f), (double)(f17 + 4.0f), (double)(f19 + 8.0f)).m_7421_((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                            pBuilder.m_5483_((double)(f18 + (float)i1 + 0.0f), (double)(f17 + 4.0f), (double)(f19 + 0.0f)).m_7421_((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                            pBuilder.m_5483_((double)(f18 + (float)i1 + 0.0f), (double)(f17 + 0.0f), (double)(f19 + 0.0f)).m_7421_((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                        }
                    }
                    if (k <= 1) {
                        for (int j2 = 0; j2 < 8; ++j2) {
                            pBuilder.m_5483_((double)(f18 + (float)j2 + 1.0f - 9.765625E-4f), (double)(f17 + 0.0f), (double)(f19 + 8.0f)).m_7421_((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                            pBuilder.m_5483_((double)(f18 + (float)j2 + 1.0f - 9.765625E-4f), (double)(f17 + 4.0f), (double)(f19 + 8.0f)).m_7421_((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                            pBuilder.m_5483_((double)(f18 + (float)j2 + 1.0f - 9.765625E-4f), (double)(f17 + 4.0f), (double)(f19 + 0.0f)).m_7421_((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                            pBuilder.m_5483_((double)(f18 + (float)j2 + 1.0f - 9.765625E-4f), (double)(f17 + 0.0f), (double)(f19 + 0.0f)).m_7421_((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                        }
                    }
                    if (l > -1) {
                        for (int k2 = 0; k2 < 8; ++k2) {
                            pBuilder.m_5483_((double)(f18 + 0.0f), (double)(f17 + 4.0f), (double)(f19 + (float)k2 + 0.0f)).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                            pBuilder.m_5483_((double)(f18 + 8.0f), (double)(f17 + 4.0f), (double)(f19 + (float)k2 + 0.0f)).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                            pBuilder.m_5483_((double)(f18 + 8.0f), (double)(f17 + 0.0f), (double)(f19 + (float)k2 + 0.0f)).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                            pBuilder.m_5483_((double)(f18 + 0.0f), (double)(f17 + 0.0f), (double)(f19 + (float)k2 + 0.0f)).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                        }
                    }
                    if (l > 1) continue;
                    for (int l2 = 0; l2 < 8; ++l2) {
                        pBuilder.m_5483_((double)(f18 + 0.0f), (double)(f17 + 4.0f), (double)(f19 + (float)l2 + 1.0f - 9.765625E-4f)).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                        pBuilder.m_5483_((double)(f18 + 8.0f), (double)(f17 + 4.0f), (double)(f19 + (float)l2 + 1.0f - 9.765625E-4f)).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                        pBuilder.m_5483_((double)(f18 + 8.0f), (double)(f17 + 0.0f), (double)(f19 + (float)l2 + 1.0f - 9.765625E-4f)).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                        pBuilder.m_5483_((double)(f18 + 0.0f), (double)(f17 + 0.0f), (double)(f19 + (float)l2 + 1.0f - 9.765625E-4f)).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                    }
                }
            }
        } else {
            boolean j1 = true;
            int k1 = 32;
            for (int l1 = -32; l1 < 32; l1 += 32) {
                for (int i2 = -32; i2 < 32; i2 += 32) {
                    pBuilder.m_5483_((double)(l1 + 0), (double)f17, (double)(i2 + 32)).m_7421_((float)(l1 + 0) * 0.00390625f + f3, (float)(i2 + 32) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                    pBuilder.m_5483_((double)(l1 + 32), (double)f17, (double)(i2 + 32)).m_7421_((float)(l1 + 32) * 0.00390625f + f3, (float)(i2 + 32) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                    pBuilder.m_5483_((double)(l1 + 32), (double)f17, (double)(i2 + 0)).m_7421_((float)(l1 + 32) * 0.00390625f + f3, (float)(i2 + 0) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                    pBuilder.m_5483_((double)(l1 + 0), (double)f17, (double)(i2 + 0)).m_7421_((float)(l1 + 0) * 0.00390625f + f3, (float)(i2 + 0) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                }
            }
        }
        return pBuilder.m_231175_();
    }
}

