/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.renderer.dimension;

import dev.tauri.jsg.api.util.math.MathHelper;
import dev.tauri.jsg.renderer.dimension.AbstractSkyEffects;
import dev.tauri.jsg.renderer.dimension.util.CustomSkyObjectRenderer;
import it.unimi.dsi.fastutil.Pair;
import java.awt.Color;
import java.util.function.Function;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.Nullable;

public class AbydosSkyEffects
extends AbstractSkyEffects {
    public static final Function<CustomSkyObjectRenderer, CustomSkyObjectRenderer.UVGetter> ADVANCED_MOON_PHASER = sun -> (moon1, corner, level, ticks, partialTicks, poseStack, camera, projectionMatrix, isFoggy, fogType, setupFog) -> {
        float t = level.m_46942_(partialTicks);
        float sunCelestialAngle = sun.getObjectCelestialAngle(t, false);
        float sunHorizontalAngle = sun.getObjectHorizontalAngle(t, false);
        float moonCelestialAngle = moon1.getObjectCelestialAngle(t, false);
        float moonHorizontalAngle = moon1.getObjectHorizontalAngle(t, false);
        int verticalDif = MathHelper.wrapDegrees((int)(moonCelestialAngle - sunCelestialAngle));
        int horizontalDif = MathHelper.wrapDegrees((int)(moonHorizontalAngle - sunHorizontalAngle));
        boolean sunAbove = verticalDif > 0;
        boolean sunOnLeft = horizontalDif > 0;
        verticalDif = Math.abs(verticalDif);
        horizontalDif = Math.abs(horizontalDif);
        int cols = 16;
        int rows = 16;
        if (verticalDif < 10) {
            if (horizontalDif < 10) {
                return AbydosSkyEffects.getUV(cols, rows, 4, 0).apply(corner);
            }
            if (horizontalDif < 30) {
                return AbydosSkyEffects.getUV(cols, rows, sunOnLeft ? 3 : 5, 0).apply(corner);
            }
            if (horizontalDif < 50) {
                return AbydosSkyEffects.getUV(cols, rows, sunOnLeft ? 2 : 6, 0).apply(corner);
            }
            if (horizontalDif < 90) {
                return AbydosSkyEffects.getUV(cols, rows, sunOnLeft ? 1 : 7, 0).apply(corner);
            }
            return AbydosSkyEffects.getUV(cols, rows, 0, 0).apply(corner);
        }
        if (verticalDif < 30) {
            if (horizontalDif < 10) {
                return AbydosSkyEffects.getUV(cols, rows, sunAbove ? 3 : 5, 2).apply(corner);
            }
            if (horizontalDif < 50) {
                return AbydosSkyEffects.getUV(cols, rows, sunAbove ? 2 : 6, sunOnLeft == sunAbove ? 4 : 5).apply(corner);
            }
            if (horizontalDif < 90) {
                return AbydosSkyEffects.getUV(cols, rows, sunAbove ? 1 : 7, sunOnLeft == sunAbove ? 4 : 5).apply(corner);
            }
            return AbydosSkyEffects.getUV(cols, rows, 0, 0).apply(corner);
        }
        if (verticalDif < 120) {
            if (verticalDif < 50 && horizontalDif < 10) {
                return AbydosSkyEffects.getUV(cols, rows, sunAbove ? 2 : 6, 2).apply(corner);
            }
            if (horizontalDif < 50) {
                return AbydosSkyEffects.getUV(cols, rows, sunAbove ? 1 : 7, 2).apply(corner);
            }
        }
        return AbydosSkyEffects.getUV(cols, rows, 0, 0).apply(corner);
    };
    public static final CustomSkyObjectRenderer SUN = new CustomSkyObjectRenderer(false, true, new ResourceLocation("jsg", "textures/environment/abydos/sun.png"), 1.0f, 15.0f, 0.0f, 0.0f);
    public static final CustomSkyObjectRenderer MOON1 = new CustomSkyObjectRenderer(true, false, new ResourceLocation("jsg", "textures/environment/abydos/moon_1.png"), 1.0f, 3.0f, -15.0f, -100.0f, () -> {}, ADVANCED_MOON_PHASER.apply(SUN));
    public static final CustomSkyObjectRenderer MOON2 = new CustomSkyObjectRenderer(true, false, new ResourceLocation("jsg", "textures/environment/abydos/moon_2.png"), 2.0f, 2.0f, 8.0f, -105.0f, () -> {}, ADVANCED_MOON_PHASER.apply(SUN));
    public static final CustomSkyObjectRenderer MOON3 = new CustomSkyObjectRenderer(true, false, new ResourceLocation("jsg", "textures/environment/abydos/moon_3.png"), 3.0f, 5.0f, 15.0f, -135.0f, () -> {}, ADVANCED_MOON_PHASER.apply(SUN));

    public static Function<Integer, Pair<Float, Float>> getUV(int cols, int rows, int col, int row) {
        float pieceW = 1.0f / (float)cols;
        float pieceH = 1.0f / (float)rows;
        return corner -> switch (corner) {
            case 1 -> Pair.of((Object)Float.valueOf(pieceW * (float)(col + 1)), (Object)Float.valueOf(pieceH * (float)row));
            case 2 -> Pair.of((Object)Float.valueOf(pieceW * (float)(col + 1)), (Object)Float.valueOf(pieceH * (float)(row + 1)));
            case 3 -> Pair.of((Object)Float.valueOf(pieceW * (float)col), (Object)Float.valueOf(pieceH * (float)(row + 1)));
            default -> Pair.of((Object)Float.valueOf(pieceW * (float)col), (Object)Float.valueOf(pieceH * (float)row));
        };
    }

    public AbydosSkyEffects() {
        this.addCustomSkyObjects(SUN, MOON1, MOON2, MOON3);
    }

    @Override
    public int getStarsCount() {
        return 5000;
    }

    @Override
    public long getStarsGenerationSeed() {
        return 42L;
    }

    @Override
    public boolean drawDefaultSun() {
        return false;
    }

    @Override
    public boolean drawDefaultMoon() {
        return false;
    }

    @Override
    public Color getStarColor(RandomSource random) {
        int i = random.m_188503_(50);
        return switch (i) {
            case 0 -> new Color(-476521, true);
            case 1 -> new Color(-5328904, true);
            case 2 -> new Color(-1402, true);
            case 3 -> new Color(-8675073, true);
            case 4 -> new Color(-2693125, true);
            case 5 -> new Color(-500634, true);
            default -> new Color(-337247, true);
        };
    }

    @Override
    public float getRainLevel(ClientLevel level, float pDelta) {
        return 0.0f;
    }

    @Override
    @Nullable
    public ResourceLocation getCustomCloudsTexture() {
        return new ResourceLocation("jsg", "textures/environment/abydos/clouds.png");
    }

    @Override
    public float getCloudsSpeed() {
        return 5.0f;
    }
}

