/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.renderer.dimension.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.Pair;
import java.awt.Color;
import java.util.function.Function;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.material.FogType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class CustomSkyObjectRenderer {
    public static final Function<Float, Color> DEFAULT_SUNRISE_COLOR = coef -> {
        float alpha = 1.0f - (1.0f - Mth.m_14031_((float)(coef.floatValue() * (float)Math.PI))) * 0.99f;
        alpha *= alpha;
        float red = coef.floatValue() * 0.3f + 0.7f;
        float green = coef.floatValue() * coef.floatValue() * 0.7f + 0.2f;
        float blue = coef.floatValue() * coef.floatValue() * 0.0f + 0.2f;
        return new Color(red, green, blue, alpha);
    };
    public final ResourceLocation texture;
    public final UVGetter uvGetter;
    public final Runnable finalTransformation;
    public final float celestialRotationSpeed;
    public final float size;
    public final float offsetCelestial;
    public final float offsetHorizontal;
    public final boolean fadeOutWithSun;
    public final Function<Float, Color> sunRiseColorFunction;
    public static final ResourceLocation OVERWORLD_MOON_LOCATION = new ResourceLocation("textures/environment/moon_phases.png");
    public static final ResourceLocation OVERWORLD_SUN_LOCATION = new ResourceLocation("textures/environment/sun.png");
    public static final CustomSkyObjectRenderer OVERWORLD_SUN = new CustomSkyObjectRenderer(false, true, OVERWORLD_SUN_LOCATION, 1.0f, 30.0f, 0.0f, 0.0f);
    public static final CustomSkyObjectRenderer OVERWORLD_MOON = new CustomSkyObjectRenderer(true, false, OVERWORLD_MOON_LOCATION, 1.0f, 20.0f, 0.0f, 180.0f, () -> {}, (o, corner, level, ticks, partialTicks, poseStack, camera, projectionMatrix, isFoggy, fogType, setupFog) -> {
        int k = level.m_46941_();
        int l = k % 4;
        int i1 = k / 4 % 2;
        float minX = (float)l / 4.0f;
        float minY = (float)i1 / 2.0f;
        float maxX = (float)(l + 1) / 4.0f;
        float maxY = (float)(i1 + 1) / 2.0f;
        return switch (corner) {
            case 0 -> Pair.of((Object)Float.valueOf(maxX), (Object)Float.valueOf(minY));
            case 1 -> Pair.of((Object)Float.valueOf(minX), (Object)Float.valueOf(minY));
            case 2 -> Pair.of((Object)Float.valueOf(minX), (Object)Float.valueOf(maxY));
            default -> Pair.of((Object)Float.valueOf(maxX), (Object)Float.valueOf(maxY));
        };
    });

    public CustomSkyObjectRenderer(boolean fadeOutWithSun, boolean isSun, ResourceLocation texture, float celestialRotationSpeed, float size, float offsetHorizontal, float offsetCelestial) {
        this(fadeOutWithSun, isSun ? DEFAULT_SUNRISE_COLOR : null, texture, celestialRotationSpeed, size, offsetHorizontal, offsetCelestial);
    }

    public CustomSkyObjectRenderer(boolean fadeOutWithSun, Function<Float, Color> sunRiseColor, ResourceLocation texture, float celestialRotationSpeed, float size, float offsetHorizontal, float offsetCelestial) {
        this(fadeOutWithSun, sunRiseColor, texture, celestialRotationSpeed, size, offsetHorizontal, offsetCelestial, () -> {}, (CustomSkyObjectRenderer o, int corner, ClientLevel level, int ticks, float partialTicks, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, FogType fogType, Runnable setupFog) -> Pair.of((Object)Float.valueOf(corner == 1 || corner == 2 ? 1.0f : 0.0f), (Object)Float.valueOf(corner > 1 ? 1.0f : 0.0f)));
    }

    public CustomSkyObjectRenderer(boolean fadeOutWithSun, boolean isSun, ResourceLocation texture, float celestialRotationSpeed, float size, float offsetHorizontal, float offsetCelestial, Runnable finalTransformation, UVGetter uvGetter) {
        this(fadeOutWithSun, isSun ? DEFAULT_SUNRISE_COLOR : null, texture, celestialRotationSpeed, size, offsetHorizontal, offsetCelestial, finalTransformation, uvGetter);
    }

    public CustomSkyObjectRenderer(boolean fadeOutWithSun, Function<Float, Color> sunRiseColor, ResourceLocation texture, float celestialRotationSpeed, float size, float offsetHorizontal, float offsetCelestial, Runnable finalTransformation, UVGetter uvGetter) {
        this.texture = texture;
        this.sunRiseColorFunction = sunRiseColor;
        this.celestialRotationSpeed = celestialRotationSpeed;
        this.size = size * 4.0f;
        this.offsetCelestial = offsetCelestial;
        this.offsetHorizontal = offsetHorizontal;
        this.uvGetter = uvGetter;
        this.finalTransformation = finalTransformation;
        this.fadeOutWithSun = fadeOutWithSun;
    }

    public void render(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, FogType fogType, Runnable setupFog) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        float celestialAngle = this.getObjectCelestialAngle(level.m_46942_(partialTick), false);
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(this.getObjectHorizontalAngle(level.m_46942_(partialTick), false)));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(celestialAngle));
        this.finalTransformation.run();
        if (this.fadeOutWithSun) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(Math.min(0.8f, level.m_104811_(partialTick) * 4.0f) + 0.2f));
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_252986_(poseStack.m_85850_().m_252922_(), -this.size, 100.0f, -this.size).m_7421_(((Float)this.uvGetter.getUV(this, 0, level, ticks, partialTick, poseStack, camera, projectionMatrix, isFoggy, fogType, setupFog).first()).floatValue(), ((Float)this.uvGetter.getUV(this, 0, level, ticks, partialTick, poseStack, camera, projectionMatrix, isFoggy, fogType, setupFog).second()).floatValue()).m_5752_();
        bufferBuilder.m_252986_(poseStack.m_85850_().m_252922_(), this.size, 100.0f, -this.size).m_7421_(((Float)this.uvGetter.getUV(this, 1, level, ticks, partialTick, poseStack, camera, projectionMatrix, isFoggy, fogType, setupFog).first()).floatValue(), ((Float)this.uvGetter.getUV(this, 1, level, ticks, partialTick, poseStack, camera, projectionMatrix, isFoggy, fogType, setupFog).second()).floatValue()).m_5752_();
        bufferBuilder.m_252986_(poseStack.m_85850_().m_252922_(), this.size, 100.0f, this.size).m_7421_(((Float)this.uvGetter.getUV(this, 2, level, ticks, partialTick, poseStack, camera, projectionMatrix, isFoggy, fogType, setupFog).first()).floatValue(), ((Float)this.uvGetter.getUV(this, 2, level, ticks, partialTick, poseStack, camera, projectionMatrix, isFoggy, fogType, setupFog).second()).floatValue()).m_5752_();
        bufferBuilder.m_252986_(poseStack.m_85850_().m_252922_(), -this.size, 100.0f, this.size).m_7421_(((Float)this.uvGetter.getUV(this, 3, level, ticks, partialTick, poseStack, camera, projectionMatrix, isFoggy, fogType, setupFog).first()).floatValue(), ((Float)this.uvGetter.getUV(this, 3, level, ticks, partialTick, poseStack, camera, projectionMatrix, isFoggy, fogType, setupFog).second()).floatValue()).m_5752_();
        tessellator.m_85914_();
        poseStack.m_85849_();
    }

    public float getObjectCelestialAngle(float dayTime, boolean radians) {
        return dayTime * (radians ? (float)Math.PI * 2 : 360.0f) * this.celestialRotationSpeed + this.offsetCelestial;
    }

    public float getObjectHorizontalAngle(float dayTime, boolean radians) {
        return -(radians ? (float)Math.PI : 90.0f) + this.offsetHorizontal;
    }

    public void renderSkySunrise(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, Runnable setupFog) {
        float timeOfDay = level.m_46942_(partialTick);
        float angle = this.getObjectCelestialAngle(timeOfDay, true);
        Color sunRiseColor = null;
        float radius = 0.4f;
        float cosAngle = Mth.m_14089_((float)angle);
        if (this.sunRiseColorFunction != null && cosAngle >= -radius && cosAngle <= radius) {
            float coef = cosAngle / radius * 0.5f + 0.5f;
            sunRiseColor = this.sunRiseColorFunction.apply(Float.valueOf(coef));
        }
        if (sunRiseColor != null) {
            poseStack.m_85836_();
            float f3 = Mth.m_14031_((float)angle) < 0.0f ? 0.0f : 180.0f;
            BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
            RenderSystem.setShader(GameRenderer::m_172811_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(f3 + this.getObjectHorizontalAngle(timeOfDay, false)));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
            this.finalTransformation.run();
            float r = (float)sunRiseColor.getRed() / 255.0f;
            float g = (float)sunRiseColor.getGreen() / 255.0f;
            float b = (float)sunRiseColor.getBlue() / 255.0f;
            float a = (float)sunRiseColor.getAlpha() / 255.0f;
            Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
            bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
            bufferbuilder.m_252986_(matrix4f, 0.0f, 100.0f, 0.0f).m_85950_(r, g, b, a).m_5752_();
            for (int j = 0; j <= 16; ++j) {
                float f7 = (float)j * ((float)Math.PI * 2) / 16.0f;
                float f8 = Mth.m_14031_((float)f7);
                float f9 = Mth.m_14089_((float)f7);
                bufferbuilder.m_252986_(matrix4f, f8 * 120.0f, f9 * 120.0f, -f9 * 40.0f * a).m_85950_(r, g, b, 0.0f).m_5752_();
            }
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            poseStack.m_85849_();
        }
    }

    public static interface UVGetter {
        public Pair<Float, Float> getUV(CustomSkyObjectRenderer var1, int var2, ClientLevel var3, int var4, float var5, PoseStack var6, Camera var7, Matrix4f var8, boolean var9, FogType var10, Runnable var11);
    }
}

