/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.renderer.machine;

import dev.tauri.jsg.api.pointoforigins.PointOfOrigin;
import dev.tauri.jsg.api.stargate.network.address.StargateAddressDynamic;
import dev.tauri.jsg.api.state.State;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;

public class PrinterRendererState
extends State {
    public ItemStack input;
    public LinkedList<ItemStack> output;
    public StargateAddressDynamic addressDynamic;
    public int pos;
    public PointOfOrigin origin;
    public long printStarted;
    public final List<Integer> symbolsToPrint = new ArrayList<Integer>();
    public List<ItemStack> cartridges = new ArrayList<ItemStack>();

    @Override
    public void toBytes(ByteBuf buf) {
        FriendlyByteBuf b = new FriendlyByteBuf(buf);
        if (this.input == null) {
            this.input = ItemStack.f_41583_;
        }
        b.writeItemStack(this.input, false);
        if (this.output == null) {
            this.output = new LinkedList();
        }
        b.writeInt(this.output.size());
        for (ItemStack o : this.output) {
            b.writeItemStack(o, false);
        }
        if (this.addressDynamic == null) {
            b.writeBoolean(false);
        } else {
            b.writeBoolean(true);
            this.addressDynamic.toBytes((ByteBuf)b);
        }
        b.writeInt(this.pos);
        b.writeLong(this.printStarted);
        b.writeInt(this.symbolsToPrint.size());
        for (Integer s : this.symbolsToPrint) {
            b.writeInt(s.intValue());
        }
        if (this.origin != null) {
            b.writeBoolean(true);
            this.origin.toBytes(b);
        } else {
            b.writeBoolean(false);
        }
        b.writeInt(this.cartridges.size());
        for (ItemStack c : this.cartridges) {
            b.writeItemStack(c, false);
        }
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        int i;
        this.cartridges = new ArrayList<ItemStack>();
        FriendlyByteBuf b = new FriendlyByteBuf(buf);
        this.input = b.m_130267_();
        this.output = new LinkedList();
        int size = b.readInt();
        for (i = 0; i < size; ++i) {
            this.output.addLast(b.m_130267_());
        }
        if (b.readBoolean()) {
            this.addressDynamic = new StargateAddressDynamic((ByteBuf)b);
        }
        this.pos = b.readInt();
        this.printStarted = b.readLong();
        size = b.readInt();
        this.symbolsToPrint.clear();
        for (i = 0; i < size; ++i) {
            this.symbolsToPrint.add(b.readInt());
        }
        if (b.readBoolean()) {
            this.origin = PointOfOrigin.fromBytes(b, null);
        }
        size = b.readInt();
        for (i = 0; i < size; ++i) {
            this.cartridges.add(b.m_130267_());
        }
    }
}

