/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.renderer.obj;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.tauri.jsg.api.client.model.IOBJModelRenderer;
import dev.tauri.jsg.api.util.vectors.Vector2f;
import dev.tauri.jsg.loader.model.OBJModel;
import dev.tauri.jsg.renderer.EmissiveRenderer;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL46C;

@ParametersAreNonnullByDefault
public class GUIOBJModelRenderer
extends IOBJModelRenderer<OBJModel> {
    public GUIOBJModelRenderer(OBJModel model) {
        super(model);
    }

    @Override
    @Nullable
    protected VertexBuffer initModel(PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay, boolean emissiveRendering, @Nullable TextureAtlasSprite textureAtlasSprite, @Nullable ResourceLocation usedTexture) {
        VertexBuffer modelBuffer = this.modelBufferNoAtlas;
        if (textureAtlasSprite != null) {
            modelBuffer = (VertexBuffer)this.modelBuffers.get(textureAtlasSprite);
        }
        if (modelBuffer == null) {
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            modelBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
            if (!bufferbuilder.m_85732_()) {
                bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85817_);
            }
            int vertexCount = ((OBJModel)this.model).vertices.length;
            for (int i = 0; i < vertexCount; i += 3) {
                Vector2f uv1 = new Vector2f(((OBJModel)this.model).textureCoords[i / 3 * 2], ((OBJModel)this.model).textureCoords[i / 3 * 2 + 1]);
                uv1 = GUIOBJModelRenderer.getCorrectUVWithSprite(uv1.getX(), uv1.getY(), textureAtlasSprite);
                bufferbuilder.m_5483_((double)((OBJModel)this.model).vertices[i], (double)((OBJModel)this.model).vertices[i + 1], (double)((OBJModel)this.model).vertices[i + 2]).m_7421_(uv1.x, uv1.y).m_5752_();
            }
            BufferBuilder.RenderedBuffer rb = bufferbuilder.m_231175_();
            modelBuffer.m_85921_();
            modelBuffer.m_231221_(rb);
            VertexBuffer.m_85931_();
            if (textureAtlasSprite != null) {
                this.modelBuffers.put(textureAtlasSprite, modelBuffer);
            } else {
                this.modelBufferNoAtlas = modelBuffer;
            }
        }
        return modelBuffer;
    }

    @Override
    protected void renderModel(@Nullable VertexBuffer modelBuffer, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay, boolean emissiveRendering, float r, float g, float b, float a, boolean noCulling, @Nullable TextureAtlasSprite textureAtlasSprite, @Nullable ResourceLocation usedTexture) {
        if (modelBuffer == null) {
            return;
        }
        EmissiveRenderer.renderWithLightOverlay(poseStack, light, false, () -> {
            if (noCulling) {
                RenderSystem.disableCull();
            }
            GL46C.glEnable((int)34383);
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
            modelBuffer.m_85921_();
        }, () -> {
            Matrix4f projectionMatrix = new Matrix4f().setOrtho(0.0f, (float)((double)Minecraft.m_91087_().m_91268_().m_85441_() / Minecraft.m_91087_().m_91268_().m_85449_()), (float)((double)Minecraft.m_91087_().m_91268_().m_85442_() / Minecraft.m_91087_().m_91268_().m_85449_()), 0.0f, -1000.0f, ForgeHooksClient.getGuiFarPlane());
            modelBuffer.m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, Objects.requireNonNull(RenderSystem.getShader()));
            VertexBuffer.m_85931_();
            GL46C.glDisable((int)34383);
        }, GameRenderer::m_172817_);
    }
}

