/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.renderer.stargate;

import dev.tauri.jsg.api.client.texture.ITextureLoader;
import dev.tauri.jsg.api.registry.BiomeOverlayRegistry;
import dev.tauri.jsg.api.stargate.ChevronEnum;
import dev.tauri.jsg.renderer.activation.Activation;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class ChevronTextureList {
    private final List<ChevronEnum> activeChevrons = new ArrayList<ChevronEnum>(9);
    public Map<ChevronEnum, Integer> CHEVRON_STATE_MAP = new HashMap<ChevronEnum, Integer>(9);
    private final List<Activation<ChevronEnum>> activationList = new ArrayList<Activation<ChevronEnum>>();
    private final Map<BiomeOverlayRegistry.BiomeOverlayInstance, ResourceLocation> CHEVRON_RESOURCE_MAP = new HashMap<BiomeOverlayRegistry.BiomeOverlayInstance, ResourceLocation>();
    private final Map<BiomeOverlayRegistry.BiomeOverlayInstance, ResourceLocation> CHEVRON_LIGHT_RESOURCE_MAP = new HashMap<BiomeOverlayRegistry.BiomeOverlayInstance, ResourceLocation>();
    private final Map<BiomeOverlayRegistry.BiomeOverlayInstance, ResourceLocation> CHEVRON_LIGHT_RESOURCE_MAP_OFF = new HashMap<BiomeOverlayRegistry.BiomeOverlayInstance, ResourceLocation>();

    public ChevronTextureList(ITextureLoader textureLoader, String chevronTextureBase) {
        for (BiomeOverlayRegistry.BiomeOverlayInstance biomeOverlay : BiomeOverlayRegistry.values()) {
            this.CHEVRON_LIGHT_RESOURCE_MAP.put(biomeOverlay, textureLoader.getTextureResource(chevronTextureBase + "_light" + biomeOverlay.getSuffix() + ".png"));
            this.CHEVRON_LIGHT_RESOURCE_MAP_OFF.put(biomeOverlay, textureLoader.getTextureResource(chevronTextureBase + "_light_off" + biomeOverlay.getSuffix() + ".png"));
            this.CHEVRON_RESOURCE_MAP.put(biomeOverlay, textureLoader.getTextureResource(chevronTextureBase + biomeOverlay.getSuffix() + ".png"));
        }
    }

    public ChevronTextureList(ITextureLoader textureLoader, String chevronTextureBase, int activeChevrons, boolean isFinalActive) {
        this(textureLoader, chevronTextureBase);
        if (isFinalActive) {
            --activeChevrons;
        }
        for (int i = 0; i < activeChevrons; ++i) {
            this.activeChevrons.add(ChevronEnum.valueOf(i));
        }
        if (isFinalActive) {
            this.activeChevrons.add(ChevronEnum.getFinal());
        }
    }

    public void initClient() {
        for (ChevronEnum chevron : ChevronEnum.values()) {
            this.CHEVRON_STATE_MAP.put(chevron, this.activeChevrons.contains(chevron) ? 10 : 0);
        }
    }

    public void iterate(Level world, double partialTicks) {
        Activation.iterate(this.activationList, world.m_46467_(), partialTicks, (index, stage) -> this.CHEVRON_STATE_MAP.put((ChevronEnum)index, Math.round(stage)));
    }

    public ResourceLocation get(BiomeOverlayRegistry.BiomeOverlayInstance overlayEnum, ChevronEnum chevron, boolean onlyLight) {
        if (onlyLight) {
            if (this.getState(chevron) < 1) {
                return this.CHEVRON_LIGHT_RESOURCE_MAP_OFF.get(overlayEnum);
            }
            return this.CHEVRON_LIGHT_RESOURCE_MAP.get(overlayEnum);
        }
        return this.CHEVRON_RESOURCE_MAP.get(overlayEnum);
    }

    public int getState(ChevronEnum chevron) {
        return this.CHEVRON_STATE_MAP.get(chevron);
    }

    public float getColor(ChevronEnum chevron) {
        return (float)this.getState(chevron) / 10.0f;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.activeChevrons.size());
        for (ChevronEnum chevron : this.activeChevrons) {
            buf.writeInt(chevron.index);
        }
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        this.activeChevrons.clear();
        for (int i = 0; i < size; ++i) {
            this.activeChevrons.add(ChevronEnum.valueOf(buf.readInt()));
        }
    }
}

