/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.renderer.stargate;

import com.mojang.math.Axis;
import dev.tauri.jsg.api.stargate.ChevronEnum;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolTypeRegistry;
import dev.tauri.jsg.loader.ElementEnum;
import dev.tauri.jsg.renderer.stargate.StargateClassicRenderer;
import dev.tauri.jsg.renderer.stargate.StargateMilkyWayRendererState;
import dev.tauri.jsg.stargate.animation.chevron.StargateChevronsState;
import dev.tauri.jsg.stargate.manager.dialing.StargateAbstractDialingManager;
import dev.tauri.jsg.stargate.manager.state.StargateAbstractStateManager;
import it.unimi.dsi.fastutil.Pair;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.phys.Vec3;

public class StargateMilkyWayRenderer
extends StargateClassicRenderer<StargateMilkyWayRendererState> {
    public static final Vec3 RING_LOC = new Vec3(0.0, -0.122333, -5.97E-4);
    public static final float GATE_DIAMETER = 10.1815f;

    public StargateMilkyWayRenderer(BlockEntityRendererProvider.Context ignored) {
        super(ignored);
    }

    @Override
    public float getGateDiameter() {
        return 10.1815f;
    }

    @Override
    public double getScaleMultiplier() {
        return 1.0;
    }

    @Override
    protected void renderGate() {
        this.stack.m_85836_();
        ElementEnum.MILKYWAY_GATE.bindTexture(((StargateMilkyWayRendererState)this.rendererState).getBiomeOverlay()).render(this.stack, this.source, this.combinedLight);
        this.stack.m_85849_();
        this.renderRing();
        this.renderChevrons();
    }

    protected void renderRing() {
        this.stack.m_85836_();
        float angularRotation = (float)((StargateAbstractDialingManager)this.tileEntity.getDialingManager()).getSpinHelper().apply((float)this.level.m_46467_() + this.partialTicks, true);
        this.stack.m_85837_(StargateMilkyWayRenderer.RING_LOC.f_82479_, StargateMilkyWayRenderer.RING_LOC.f_82481_, StargateMilkyWayRenderer.RING_LOC.f_82480_);
        this.stack.m_252781_(Axis.f_252403_.m_252977_(-angularRotation));
        this.stack.m_85837_(-StargateMilkyWayRenderer.RING_LOC.f_82479_, -StargateMilkyWayRenderer.RING_LOC.f_82481_, -StargateMilkyWayRenderer.RING_LOC.f_82480_);
        ElementEnum.MILKYWAY_RING.bindTexture(((StargateMilkyWayRendererState)this.rendererState).getBiomeOverlay()).render(this.stack, this.source, this.combinedLight);
        SymbolTypeRegistry.MILKYWAY.getOrigin().getModel(this.tileEntity.getStargateType(), this.tileEntity.getPointOfOrigin(), "stargate.obj").render(this.stack, this.source, this.combinedLight);
        this.stack.m_85849_();
    }

    @Override
    protected void renderChevron(ChevronEnum chevron, StargateChevronsState.ChevronState state, float color, boolean onlyLight) {
        this.stack.m_85836_();
        this.stack.m_252781_(Axis.f_252403_.m_252977_((float)chevron.rotation));
        StargateChevronsState.ChevronState chevronState = ((StargateAbstractStateManager)this.tileEntity.getStateManager()).getChevronsState().get(chevron);
        boolean renderEmissive = onlyLight && chevronState.isLocked();
        float chevronOffset = chevronState.getOffset(this.partialTicks, 1.5f);
        this.getTextureLoader().getTexture(chevronState.getTexture(((StargateMilkyWayRendererState)this.rendererState).getBiomeOverlay(), onlyLight)).bindTexture();
        this.stack.m_85836_();
        this.stack.m_252880_(0.0f, chevronOffset, 0.0f);
        ElementEnum.MILKYWAY_CHEVRON_LIGHT.render(this.stack, this.source, this.combinedLight, renderEmissive, color);
        this.stack.m_252880_(0.0f, -2.0f * chevronOffset, 0.0f);
        ElementEnum.MILKYWAY_CHEVRON_MOVING.render(this.stack, this.source, this.combinedLight, renderEmissive, color);
        this.stack.m_85849_();
        if (!onlyLight) {
            ElementEnum.MILKYWAY_CHEVRON_FRAME.bindTexture(((StargateMilkyWayRendererState)this.rendererState).getBiomeOverlay()).render(this.stack, this.source, this.combinedLight);
            ElementEnum.MILKYWAY_CHEVRON_BACK.render(this.stack, this.source, this.combinedLight);
        }
        this.stack.m_85849_();
    }

    @Override
    @Nonnull
    public Pair<Integer, Integer> getEventHorizonColor() {
        return Pair.of((Object)-15854778, (Object)-1);
    }
}

