/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.renderer.stargate;

import com.mojang.math.Axis;
import dev.tauri.jsg.api.config.ingame.option.StargateConfigOptions;
import dev.tauri.jsg.api.stargate.ChevronEnum;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.SymbolUniverseEnum;
import dev.tauri.jsg.api.stargate.type.StargateTypes;
import dev.tauri.jsg.api.util.vectors.Vector3f;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.loader.ElementEnum;
import dev.tauri.jsg.renderer.stargate.StargateClassicRenderer;
import dev.tauri.jsg.renderer.stargate.StargateUniverseRendererState;
import dev.tauri.jsg.stargate.animation.chevron.StargateChevronsState;
import dev.tauri.jsg.stargate.animation.chevron.StargateUniverseChevronsState;
import dev.tauri.jsg.stargate.manager.dialing.StargateAbstractDialingManager;
import dev.tauri.jsg.stargate.manager.state.StargateAbstractStateManager;
import it.unimi.dsi.fastutil.Pair;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.phys.Vec3;

public class StargateUniverseRenderer
extends StargateClassicRenderer<StargateUniverseRendererState> {
    private static final float GATE_DIAMETER = 8.67415f;
    private static final float IRIS_DARK_COLOR = 0.6f;

    public StargateUniverseRenderer(BlockEntityRendererProvider.Context ignored) {
        super(ignored);
    }

    @Override
    public float getGateDiameter() {
        return 8.67415f;
    }

    @Override
    public double getScaleMultiplier() {
        return 1.14;
    }

    @Override
    protected void renderGate() {
        float angularRotation = (float)((StargateAbstractDialingManager)this.tileEntity.getDialingManager()).getSpinHelper().apply((float)this.level.m_46467_() + this.partialTicks, true);
        this.stack.m_252781_(Axis.f_252393_.m_252977_(angularRotation));
        this.stack.m_85836_();
        ElementEnum.UNIVERSE_GATE.bindTexture(((StargateUniverseRendererState)this.rendererState).getBiomeOverlay()).render(this.stack, this.source, this.combinedLight);
        this.stack.m_85849_();
        this.renderChevrons();
        ElementEnum.UNIVERSE_SYMBOL.bindTexture(((StargateUniverseRendererState)this.rendererState).getBiomeOverlay());
        for (SymbolUniverseEnum symbol : SymbolUniverseEnum.values()) {
            if (symbol == SymbolUniverseEnum.TOP_CHEVRON) continue;
            this.stack.m_85836_();
            int symbolLight = (int)((double)((StargateUniverseChevronsState)((StargateAbstractStateManager)this.tileEntity.getStateManager()).getChevronsState()).getSymbol(symbol).getLightStage() * 15.0);
            float maxLight = Math.max(2359332.0f, (float)Math.max(this.combinedLight / 2, LightTexture.m_109885_((int)symbolLight, (int)symbolLight)));
            symbol.getModel(StargateTypes.UNIVERSE, this.tileEntity.getPointOfOrigin(), "stargate.obj").render(this.stack, this.source, this.combinedLight, symbolLight > 2, maxLight / 1.572888E7f);
            this.stack.m_85849_();
        }
    }

    @Override
    protected void renderKawoosh() {
        this.stack.m_252880_(0.0f, -0.05f, 0.0f);
        this.stack.m_85841_(0.9f, 0.9f, 1.0f);
        super.renderKawoosh();
    }

    @Override
    public void scaleVortex() {
        this.stack.m_85841_(1.2f, 1.2f, 1.0f);
    }

    @Override
    public void renderIris(boolean backOnly) {
        this.stack.m_85836_();
        this.stack.m_85837_(0.0, 0.0, 0.06);
        float scale = this.getGateDiameter() / 10.1815f * 1.037f;
        this.stack.m_85841_(scale, scale, 1.0f);
        super.renderIris(backOnly);
        this.stack.m_85849_();
    }

    @Override
    protected Vec3 getIrisPivot() {
        return super.getIrisPivot().m_82520_(-0.1, 0.0, 0.0);
    }

    @Override
    protected int getIrisBladesCount() {
        return 20;
    }

    @Override
    protected void translateIrisBlade() {
    }

    @Override
    protected void renderChevron(ChevronEnum chevron, StargateChevronsState.ChevronState state, float color, boolean onlyLight) {
        this.stack.m_85836_();
        this.stack.m_252781_(Axis.f_252403_.m_252977_((float)chevron.rotation));
        this.getTextureLoader().getTexture(state.getTexture(((StargateUniverseRendererState)this.rendererState).getBiomeOverlay(), onlyLight)).bindTexture();
        ElementEnum.UNIVERSE_CHEVRON.render(this.stack, this.source, this.combinedLight, onlyLight && state.isLocked(), color);
        this.stack.m_85849_();
    }

    @Override
    public Vector3f getIrisHeatColor(float red) {
        return new Vector3f(0.6f + red * 3.0f, 0.6f, 0.6f);
    }

    @Override
    public int getShieldColor() {
        if (this.tileEntity instanceof StargateClassicBaseBE && ((StargateClassicBaseBE)this.tileEntity).getConfig().getValueOrDefault(StargateConfigOptions.Universe.ORANGE_SHIELD).booleanValue()) {
            return -22951;
        }
        return super.getShieldColor();
    }

    @Override
    @Nonnull
    public Pair<Integer, Integer> getEventHorizonColor() {
        return Pair.of((Object)-12237499, (Object)-1);
    }
}

