/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.screen.element.tabs;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.tauri.jsg.api.client.screen.ITabAddress;
import dev.tauri.jsg.api.client.screen.util.GuiHelper;
import dev.tauri.jsg.api.client.texture.ITexture;
import dev.tauri.jsg.api.pointoforigins.PointOfOrigin;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolInterface;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.AbstractSymbolType;
import dev.tauri.jsg.blockentity.IAddressProvider;
import dev.tauri.jsg.loader.texture.Texture;
import dev.tauri.jsg.screen.element.tabs.Tab;
import dev.tauri.jsg.screen.element.tabs.TabWithSlot;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class TabAddress
extends TabWithSlot
implements ITabAddress {
    private final IAddressProvider addressProvider;
    private final AbstractSymbolType<?> symbolType;
    private final int progressColor;
    private int maxSymbols;

    protected TabAddress(TabAddressBuilder builder) {
        super(builder);
        this.addressProvider = builder.addressProvider;
        this.symbolType = builder.symbolType;
        this.progressColor = builder.progressColor;
        this.maxSymbols = 6;
    }

    public static TabAddressBuilder builder() {
        return new TabAddressBuilder();
    }

    public void setMaxSymbols(int maxSymbols) {
        this.maxSymbols = maxSymbols;
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY) {
        super.render(graphics, mouseX, mouseY);
        if (this.isVisible() && this.addressProvider.getAddress(this.symbolType) != null) {
            ITexture.bindTextureWithMc(this.bgTexLocation);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiHelper.drawModalRectWithCustomSizedTexture(this.guiLeft + this.currentOffsetX + 105, this.guiTop + this.defaultY + 86, 6.0f, 179.0f, 18, 18, this.textureSize, this.textureSize);
            int shadow = 2;
            PointOfOrigin origin = this.addressProvider.getPointOfOrigin(this.symbolType);
            for (int i = 0; i < this.maxSymbols; ++i) {
                SymbolInterface symbol = Objects.requireNonNull(this.addressProvider.getAddress(this.symbolType)).get(i);
                symbol.bindIconTexture(origin);
                ITabAddress.SymbolCoords symbolCoords = this.getSymbolCoords(i);
                GuiHelper.drawTexturedRectWithShadow(symbolCoords.x(), symbolCoords.y(), shadow, shadow, this.symbolType.getIconWidth(), this.symbolType.getIconHeight(), 0.0f);
            }
            RenderSystem.enableBlend();
            Texture.bindTextureWithMc(this.bgTexLocation);
            int progress = this.addressProvider.getPageProgress();
            Color c = new Color(this.progressColor);
            float red = c.getRed();
            float green = c.getGreen();
            float blue = c.getBlue();
            RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)1.0f);
            GuiHelper.drawModalRectWithCustomSizedTexture(this.guiLeft + this.currentOffsetX + 97, this.guiTop + this.defaultY + 86 + (18 - progress), 0.0f, 179 + (18 - progress), 6, progress, this.textureSize, this.textureSize);
            RenderSystem.disableBlend();
        }
    }

    @Override
    public void renderFg(GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderFg(graphics, mouseX, mouseY);
        if (this.isVisible() && this.isOpen() && this.addressProvider.getAddress(this.symbolType) != null) {
            for (int i = 0; i < this.maxSymbols; ++i) {
                ITabAddress.SymbolCoords symbolCoords = this.getSymbolCoords(i);
                if (!GuiHelper.isPointInRegion(symbolCoords.x(), symbolCoords.y(), this.symbolType.getIconWidth(), this.symbolType.getIconHeight(), mouseX, mouseY)) continue;
                graphics.m_280677_(Minecraft.m_91087_().f_91062_, List.of(Component.m_237113_((String)Objects.requireNonNull(this.addressProvider.getAddress(this.symbolType)).get(i).localize())), Optional.empty(), mouseX - this.guiLeft, mouseY - this.guiTop);
            }
        }
    }

    public ITabAddress.SymbolCoords getSymbolCoords(int symbol) {
        ITabAddress.SymbolCoords got = this.symbolType.getSymbolCoords(symbol);
        return new ITabAddress.SymbolCoords(got.x() + this.guiLeft + this.currentOffsetX, got.y() + this.guiTop + this.defaultY);
    }

    public static class TabAddressBuilder
    extends Tab.TabBuilder {
        private IAddressProvider addressProvider;
        private AbstractSymbolType<?> symbolType;
        private int progressColor;

        public TabAddressBuilder setAddressProvider(IAddressProvider addressProvider) {
            this.addressProvider = addressProvider;
            return this;
        }

        public TabAddressBuilder setSymbolType(AbstractSymbolType<?> symbolType) {
            this.symbolType = symbolType;
            return this;
        }

        public TabAddressBuilder setProgressColor(int color) {
            this.progressColor = color;
            return this;
        }

        @Override
        public TabAddress build() {
            return new TabAddress(this);
        }
    }
}

