/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.screen.element.tabs;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.tauri.jsg.api.client.screen.util.GuiHelper;
import dev.tauri.jsg.api.registry.BiomeOverlayRegistry;
import dev.tauri.jsg.forgeutil.SlotHandler;
import dev.tauri.jsg.loader.texture.Texture;
import dev.tauri.jsg.screen.element.tabs.Tab;
import dev.tauri.jsg.screen.element.tabs.TabWithSlot;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class TabBiomeOverlay
extends TabWithSlot {
    private final List<BiomeOverlayRegistry.BiomeOverlayInstance> supportedOverlays;
    private final int slotTexX;
    private final int slotTexY;

    protected TabBiomeOverlay(TabBiomeOverlayBuilder builder) {
        super(builder);
        this.supportedOverlays = builder.supportedOverlays;
        this.slotTexX = builder.slotTexX;
        this.slotTexY = builder.slotTexY;
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY) {
        super.render(graphics, mouseX, mouseY);
        Texture.bindTextureWithMc(this.bgTexLocation);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiHelper.drawModalRectWithCustomSizedTexture(this.guiLeft + this.currentOffsetX + 5, this.guiTop + this.defaultY + 24, this.slotTexX, this.slotTexY, 18, 18, this.textureSize, this.textureSize);
    }

    @Override
    public void renderFg(GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderFg(graphics, mouseX, mouseY);
        if (this.isVisible() && this.isOpen() && GuiHelper.isPointInRegion(this.guiLeft + this.currentOffsetX + 6, this.guiTop + this.defaultY + 25, 16, 16, mouseX, mouseY) && !this.slot.m_6657_()) {
            ArrayList<MutableComponent> text = new ArrayList<MutableComponent>();
            text.add(Component.m_237115_((String)"gui.biome_overlay.help"));
            for (BiomeOverlayRegistry.BiomeOverlayInstance biomeOverlay : BiomeOverlayRegistry.values()) {
                if (!this.supportedOverlays.contains(biomeOverlay)) continue;
                StringBuilder line = new StringBuilder(biomeOverlay.getLocalizedColorizedName() + ": ");
                String blocksLine = String.join((CharSequence)", ", biomeOverlay.getOverlayItems().stream().map(ItemStack::new).map(i -> i.m_41720_().m_7626_(i).getString()).toList());
                line.append(blocksLine);
                text.add(Component.m_237113_((String)line.toString()));
            }
            graphics.m_280677_(Minecraft.m_91087_().f_91062_, text, Optional.empty(), mouseX - this.guiLeft, mouseY - this.guiTop);
        }
    }

    @Override
    public Tab.SlotTab createAndSaveSlot(SlotHandler slot) {
        this.slot = new Tab.SlotTab(slot, slotTab -> {
            int x = this.currentOffsetX + 6;
            int y = this.defaultY + 25;
            return slotTab.setXY(x, y);
        });
        return this.slot;
    }

    public static TabBiomeOverlayBuilder builder() {
        return new TabBiomeOverlayBuilder();
    }

    public static class TabBiomeOverlayBuilder
    extends Tab.TabBuilder {
        private List<BiomeOverlayRegistry.BiomeOverlayInstance> supportedOverlays;
        private int slotTexX;
        private int slotTexY;

        public TabBiomeOverlayBuilder setSupportedOverlays(List<BiomeOverlayRegistry.BiomeOverlayInstance> supportedOverlays) {
            this.supportedOverlays = supportedOverlays;
            return this;
        }

        public TabBiomeOverlayBuilder setSlotTexture(int x, int y) {
            this.slotTexX = x;
            this.slotTexY = y;
            return this;
        }

        @Override
        public TabBiomeOverlay build() {
            return new TabBiomeOverlay(this);
        }
    }
}

