/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.screen.gui.admincontroller;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.api.client.screen.util.GuiHelper;
import dev.tauri.jsg.api.client.screen.widget.ModeButton;
import dev.tauri.jsg.api.client.screen.widget.base.JSGButton;
import dev.tauri.jsg.api.client.screen.widget.base.JSGButtonClassic;
import dev.tauri.jsg.api.client.screen.widget.base.JSGTextField;
import dev.tauri.jsg.api.client.screen.widget.base.JSGTextFieldClassic;
import dev.tauri.jsg.api.helper.BlockHelper;
import dev.tauri.jsg.api.stargate.animation.EnumDialingType;
import dev.tauri.jsg.api.stargate.iris.EnumIrisState;
import dev.tauri.jsg.api.stargate.network.StargatePos;
import dev.tauri.jsg.api.stargate.network.address.StargateAddress;
import dev.tauri.jsg.api.stargate.network.address.StargateAddressDynamic;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.AbstractSymbolType;
import dev.tauri.jsg.packet.JSGPacketHandler;
import dev.tauri.jsg.packet.packets.entry.ACEntryActionToServer;
import dev.tauri.jsg.packet.packets.entry.EntryActionEnum;
import dev.tauri.jsg.screen.gui.admincontroller.GuiAdminController;
import dev.tauri.jsg.screen.gui.admincontroller.Notifier;
import dev.tauri.jsg.screen.gui.admincontroller.StargateEntry;
import dev.tauri.jsg.stargate.manager.dialing.StargateAbstractDialingManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;

public class AddressesSection {
    public static final int OFFSET = 15;
    protected static final int SCROLL_AMOUNT = 5;
    public ArrayList<StargateEntry> entries = new ArrayList();
    public int guiTop;
    public int height;
    public int guiLeft;
    public int width;
    public int scrolled = 0;
    public int totalSectionHeight = 0;
    public GuiAdminController guiBase;
    public int thisGateEntryIndex = -1;
    public ArrayList<ModeButton> dialButtons = new ArrayList();
    public ArrayList<JSGButtonClassic> optionButtons = new ArrayList();
    public ArrayList<JSGTextFieldClassic> entriesTextFields = new ArrayList();
    public JSGTextField searchField;
    public Font font;
    public GuiGraphics graphics;

    public AddressesSection(GuiAdminController baseGui) {
        this.guiBase = baseGui;
        this.font = Minecraft.m_91087_().f_91062_;
        this.graphics = baseGui.graphics;
        this.searchField = new JSGTextField(500, 0, 0, 120, 20, (Component)Component.m_237119_());
    }

    public boolean canAddThisEntry(StargatePos pos) {
        String searchString = this.searchField.m_94155_().toLowerCase();
        if (!searchString.equalsIgnoreCase("")) {
            String[] params;
            String entryString = BlockHelper.blockPosToBetterString(pos.gatePos) + " " + String.valueOf(pos.getStargateType()) + " " + String.valueOf(pos.dimension.m_135782_()) + " " + pos.getName().toLowerCase();
            if (entryString.contains(searchString)) {
                return true;
            }
            for (String s : params = searchString.split(" ")) {
                try {
                    if (s.toLowerCase().startsWith("dim=")) {
                        if (!pos.dimension.m_135782_().m_135815_().toLowerCase().startsWith(s.toLowerCase().replaceFirst("dim=", "")) && !pos.dimension.m_135782_().toString().toLowerCase().startsWith(s.toLowerCase().replaceFirst("dim=", ""))) continue;
                        return true;
                    }
                    if (s.toLowerCase().startsWith("pos=")) {
                        String ss = s.toLowerCase().replaceFirst("pos=", "");
                        int i = Integer.parseInt(ss.split(",")[0]);
                        if (pos.gatePos.m_123341_() == i) {
                            return true;
                        }
                        i = Integer.parseInt(ss.split(",")[1]);
                        if (pos.gatePos.m_123342_() == i) {
                            return true;
                        }
                        i = Integer.parseInt(ss.split(",")[2]);
                        if (pos.gatePos.m_123343_() != i) continue;
                        return true;
                    }
                    if (!(s.startsWith("name=") ? pos.getName().toLowerCase().startsWith(s.toLowerCase().replaceFirst("name=", "")) : s.startsWith("type=") && pos.getStargateType().toString().toLowerCase().startsWith(s.toLowerCase().replaceFirst("type=", "")))) continue;
                    return true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
        return true;
    }

    public void generateAddressEntries() {
        this.generateAddressEntries(false);
    }

    public void generateAddressEntries(boolean reset) {
        if (this.guiBase.stargateNetwork == null) {
            this.entries.clear();
            return;
        }
        if (!reset && !this.entries.isEmpty()) {
            return;
        }
        this.entries.clear();
        Map<StargatePos, Map<AbstractSymbolType<?>, StargateAddress>> m = this.guiBase.stargateNetwork.getAll();
        for (Map.Entry<StargatePos, Map<AbstractSymbolType<?>, StargateAddress>> entry : m.entrySet()) {
            if (!this.canAddThisEntry(entry.getKey())) continue;
            StargateEntry e = new StargateEntry();
            e.pos = entry.getKey();
            e.address = entry.getValue().get(Objects.requireNonNull(this.guiBase.gateTile).getSymbolType());
            this.entries.add(e);
        }
        this.sortEntries();
        this.init(reset);
    }

    public void init(boolean reset) {
        int index = -1;
        if (!reset && !this.dialButtons.isEmpty()) {
            return;
        }
        if (!reset && !this.entriesTextFields.isEmpty()) {
            return;
        }
        this.dialButtons.clear();
        this.entriesTextFields.clear();
        boolean focused = this.searchField.m_93696_();
        int cursor = this.searchField.m_94207_();
        this.searchField.m_252865_(this.guiBase.center[0] - 45);
        this.searchField.m_253211_(this.guiTop + this.height - 21);
        this.searchField.m_93674_(90);
        this.searchField.setHeight(20);
        this.searchField.setActionCallback(() -> this.generateAddressEntries(true));
        this.searchField.performActionOnKeyUp = true;
        this.searchField.m_93692_(focused);
        this.searchField.m_94196_(cursor);
        this.thisGateEntryIndex = -1;
        for (StargateEntry e : this.entries) {
            StargatePos p = e.pos;
            String name = p.getName() != null && !p.getName().equalsIgnoreCase("") ? p.getName() : BlockHelper.blockPosToBetterString(p.gatePos);
            int finalIndex = ++index;
            JSGTextField field = new JSGTextField(index, this.guiLeft, 0, 120, 20, e.defaultName + name);
            field.m_94144_(e.defaultName + name);
            field.setActionCallback(() -> this.renameEntry(finalIndex));
            ModeButton btn = new ModeButton(index, this.guiLeft + 125, 0, 20, new ResourceLocation("jsg", "textures/gui/controller_mode.png"), 100, 40, 5);
            btn.setActionCallback(() -> this.mainButtonPerformAction(finalIndex));
            if (e.pos.gatePos.equals((Object)Objects.requireNonNull(this.guiBase.gateTile).m_58899_()) && e.pos.dimension == Objects.requireNonNull(this.guiBase.gateTile.m_58904_()).m_46472_()) {
                this.thisGateEntryIndex = index;
                btn.setEnabled(0, false);
                btn.setEnabled(1, false);
            }
            this.entriesTextFields.add(field);
            this.dialButtons.add(btn);
        }
        this.totalSectionHeight = Math.max(0, index) * 23;
        this.optionButtons.clear();
        String text = "Abort dialing";
        int width = 10 + this.font.m_92895_(text);
        int y = this.guiTop + this.height - 21;
        int x = this.guiBase.guiRight - 15 - 40 - width;
        this.optionButtons.add(new JSGButton(100, x, y, width, 20, text).setActionCallback(() -> {
            if (this.guiBase.imaginaryGateTile != null && ((StargateAbstractDialingManager)this.guiBase.imaginaryGateTile.getDialingManager()).getStargateState().dialing()) {
                if (((StargateAbstractDialingManager)this.guiBase.imaginaryGateTile.getDialingManager()).canAbortDialing()) {
                    this.guiBase.notifier.setText("Dialing aborted.", Notifier.EnumAlertType.INFO, 5);
                    this.sendPacket(EntryActionEnum.ABORT);
                } else {
                    this.guiBase.notifier.setText("Gate is busy!", Notifier.EnumAlertType.WARNING, 5);
                }
            } else if (this.guiBase.imaginaryGateTile != null) {
                this.guiBase.notifier.setText("Gate is not dialing", Notifier.EnumAlertType.WARNING, 5);
            } else {
                this.guiBase.notifier.setText("Gate is NULL!", Notifier.EnumAlertType.ERROR, 5);
            }
        }));
        text = "Toggle iris";
        width = 10 + this.font.m_92895_(text);
        this.optionButtons.add(new JSGButton(101, x -= width + 3, y, width, 20, text).setActionCallback(() -> {
            if (this.guiBase.imaginaryGateTile != null && this.guiBase.imaginaryGateTile.getIrisManager().hasIris()) {
                if (this.guiBase.imaginaryGateTile.getIrisManager().getIrisState() == EnumIrisState.OPENED || this.guiBase.imaginaryGateTile.getIrisManager().getIrisState() == EnumIrisState.CLOSED) {
                    this.guiBase.notifier.setText("Toggling iris.", Notifier.EnumAlertType.INFO, 5);
                    this.sendPacket(EntryActionEnum.TOGGLE_IRIS);
                } else {
                    this.guiBase.notifier.setText("Gate's iris is busy!", Notifier.EnumAlertType.WARNING, 5);
                }
            } else if (this.guiBase.imaginaryGateTile != null) {
                this.guiBase.notifier.setText("Gate has no iris!", Notifier.EnumAlertType.WARNING, 5);
            } else {
                this.guiBase.notifier.setText("Gate is NULL!", Notifier.EnumAlertType.ERROR, 5);
            }
        }));
    }

    public void sortEntries() {
        ArrayList<StargateEntry> namedList = new ArrayList<StargateEntry>();
        ArrayList<StargateEntry> unnamedList = new ArrayList<StargateEntry>();
        for (StargateEntry e : this.entries) {
            if (!e.pos.getName().isEmpty()) {
                namedList.add(e);
                continue;
            }
            unnamedList.add(e);
        }
        namedList.addAll(unnamedList);
        this.entries = namedList;
    }

    public void sendPacket(EntryActionEnum action) {
        try {
            JSGPacketHandler.sendToServer(new ACEntryActionToServer(action, this.guiBase.pos));
        }
        catch (Exception e) {
            JSG.logger.error("Error", e);
        }
    }

    public void mainButtonPerformAction(int index) {
        ModeButton btn = this.dialButtons.get(index);
        if (!btn.isEnabledCurrent()) {
            return;
        }
        StargateEntry entry = this.entries.get(index);
        StargatePos pos = entry.pos;
        switch (btn.getCurrentState()) {
            case 0: 
            case 1: 
            case 2: {
                this.dialGate(index, EnumDialingType.values()[btn.getCurrentState()]);
                break;
            }
            case 3: {
                JSGPacketHandler.sendToServer(new ACEntryActionToServer(EntryActionEnum.GIVE_NOTEBOOK, pos, entry.addresses));
                break;
            }
            case 4: {
                JSGPacketHandler.sendToServer(new ACEntryActionToServer(EntryActionEnum.TELEPORT_TO_POS, pos, this.guiBase.gateTile.m_58899_()));
                break;
            }
        }
    }

    public void dialGate(int index, EnumDialingType dialType) {
        try {
            InteractionHand hand = this.guiBase.getHand();
            StargateEntry entry = this.entries.get(index);
            StargatePos pos = entry.pos;
            if (this.guiBase.gateTile == null || this.guiBase.imaginaryGateTile == null) {
                this.guiBase.notifier.setText("Linked gate is NULL!", Notifier.EnumAlertType.ERROR, 5);
                return;
            }
            if (!((StargateAbstractDialingManager)this.guiBase.imaginaryGateTile.getDialingManager()).getStargateState().idle() && !((StargateAbstractDialingManager)this.guiBase.imaginaryGateTile.getDialingManager()).getStargateState().engaged()) {
                this.guiBase.notifier.setText("Stargate is busy!", Notifier.EnumAlertType.WARNING, 5);
                return;
            }
            if (!((StargateAbstractDialingManager)this.guiBase.imaginaryGateTile.getDialingManager()).getStargateState().engaged()) {
                this.guiBase.notifier.setText("Dialing gate " + (pos.getName().isEmpty() ? pos.dimension.m_135782_().m_135815_() : pos.getName()), Notifier.EnumAlertType.INFO, 5);
            } else {
                this.guiBase.notifier.setText("Closing gate...", Notifier.EnumAlertType.INFO, 5);
            }
            JSGPacketHandler.sendToServer(new ACEntryActionToServer(hand, new StargateAddressDynamic(entry.address), pos, this.guiBase.gateTile.m_58899_(), dialType));
        }
        catch (Exception e) {
            JSG.logger.error("Error ", e);
            this.guiBase.notifier.setText("Unknown error! (" + e.getMessage() + ")", Notifier.EnumAlertType.ERROR, 5);
        }
    }

    public void renameEntry(int index) {
        try {
            InteractionHand hand = this.guiBase.getHand();
            JSGTextFieldClassic field = this.entriesTextFields.get(index);
            JSGPacketHandler.sendToServer(new ACEntryActionToServer(hand, field.m_94155_(), this.entries.get((int)index).pos));
            this.guiBase.notifier.setText("Gate renamed to " + field.m_94155_(), Notifier.EnumAlertType.INFO, 5);
        }
        catch (Exception e) {
            JSG.logger.error("", e);
            this.guiBase.notifier.setText("Unknown error! (" + e.getMessage() + ")", Notifier.EnumAlertType.ERROR, 5);
        }
    }

    public void updateY() {
        for (JSGTextFieldClassic jSGTextFieldClassic : this.entriesTextFields) {
            jSGTextFieldClassic.m_253211_(this.scrolled + jSGTextFieldClassic.getId() * 23 + 15 + this.guiTop);
        }
        for (ModeButton modeButton : this.dialButtons) {
            modeButton.m_253211_(this.scrolled + modeButton.id * 23 + 15 + this.guiTop);
        }
    }

    public void renderEntries() {
        this.updateY();
        for (JSGTextFieldClassic f : this.entriesTextFields) {
            if (this.canNotRenderEntry(f.m_252907_())) continue;
            f.m_88315_(this.graphics, this.guiBase.mouseX, this.guiBase.mouseY, this.guiBase.partialTicks);
        }
        boolean shouldBeEnabled = this.guiBase.imaginaryGateTile != null && (((StargateAbstractDialingManager)this.guiBase.imaginaryGateTile.getDialingManager()).getStargateState().idle() || ((StargateAbstractDialingManager)this.guiBase.imaginaryGateTile.getDialingManager()).getStargateState().engaged());
        for (ModeButton modeButton : this.dialButtons) {
            if (this.canNotRenderEntry(modeButton.m_252907_())) continue;
            boolean enabled = shouldBeEnabled && modeButton.id != this.thisGateEntryIndex;
            modeButton.setEnabled(0, enabled);
            modeButton.setEnabled(1, enabled);
            modeButton.setEnabled(2, enabled);
            modeButton.drawButton(this.graphics, this.guiBase.mouseX, this.guiBase.mouseY);
        }
        for (JSGButtonClassic jSGButtonClassic : this.optionButtons) {
            jSGButtonClassic.m_88315_(this.graphics, this.guiBase.mouseX, this.guiBase.mouseY, this.guiBase.partialTicks);
        }
        this.searchField.m_88315_(this.graphics, this.guiBase.mouseX, this.guiBase.mouseY, this.guiBase.partialTicks);
    }

    public void renderFg() {
        for (JSGTextFieldClassic jSGTextFieldClassic : this.entriesTextFields) {
            StargateEntry e = this.entries.get(jSGTextFieldClassic.getId());
            if (this.canNotRenderEntry(jSGTextFieldClassic.m_252907_()) || !GuiHelper.isPointInRegion(jSGTextFieldClassic.m_252754_(), jSGTextFieldClassic.m_252907_(), jSGTextFieldClassic.m_5711_(), jSGTextFieldClassic.m_93694_(), this.guiBase.mouseX, this.guiBase.mouseY)) continue;
            this.graphics.m_280677_(this.font, Arrays.asList(Component.m_237113_((String)("\u00a7lType: \u00a77" + e.pos.getStargateType().toString())), Component.m_237113_((String)("\u00a7lPos: \u00a77" + BlockHelper.blockPosToBetterString(e.pos.gatePos))), Component.m_237113_((String)("\u00a7lDim: \u00a77" + e.pos.dimension.m_135782_().m_135815_()))), Optional.empty(), this.guiBase.mouseX, this.guiBase.mouseY);
        }
        if (GuiHelper.isPointInRegion(this.searchField.m_252754_(), this.searchField.m_252907_(), this.searchField.m_5711_(), this.searchField.m_93694_(), this.guiBase.mouseX, this.guiBase.mouseY)) {
            this.graphics.m_280677_(this.font, Arrays.asList(Component.m_237113_((String)"Search entry by DimID, Name, Position or Gate type"), Component.m_237113_((String)""), Component.m_237113_((String)"\u00a7lYou can use:"), Component.m_237113_((String)"\u00a77\u00a7o dim=<dim>"), Component.m_237113_((String)"\u00a77\u00a7o name=<name>"), Component.m_237113_((String)"\u00a77\u00a7o pos=<x,y,z>"), Component.m_237113_((String)"\u00a77\u00a7o type=<MILKYWAY|PEGASUS|UNIVERSE>")), Optional.empty(), this.guiBase.mouseX, this.guiBase.mouseY);
        }
        for (ModeButton modeButton : this.dialButtons) {
            if (this.canNotRenderEntry(modeButton.m_252907_()) || !modeButton.isEnabledCurrent() || !GuiHelper.isPointInRegion(modeButton.m_252754_(), modeButton.m_252907_(), modeButton.m_5711_(), modeButton.m_93694_(), this.guiBase.mouseX, this.guiBase.mouseY)) continue;
            String lines = null;
            switch (modeButton.getCurrentState()) {
                default: {
                    break;
                }
                case 0: {
                    lines = "Dial this address (slow)";
                    break;
                }
                case 1: {
                    lines = "Dial this address (fast)";
                    break;
                }
                case 2: {
                    lines = "Dial this address (nox)";
                    break;
                }
                case 3: {
                    lines = "Get gate's addresses";
                    break;
                }
                case 4: {
                    lines = "Teleport to gate's location";
                }
            }
            if (lines == null) continue;
            this.graphics.m_280557_(this.font, (Component)Component.m_237113_((String)lines), this.guiBase.mouseX, this.guiBase.mouseY);
        }
    }

    public void scroll(int k) {
        if (k == 0) {
            return;
        }
        if (k < 0) {
            k = -1;
        }
        if (k > 0) {
            k = 1;
        }
        if (this.canContinueScrolling(k)) {
            this.scrolled += 5 * k;
        }
    }

    public boolean canContinueScrolling(int k) {
        int top = this.guiTop;
        int bottom = this.guiTop + this.height;
        if (this.entriesTextFields.isEmpty() && this.dialButtons.isEmpty()) {
            return false;
        }
        boolean isTop = !this.entriesTextFields.isEmpty() && this.entriesTextFields.get(0).getId() < this.dialButtons.get((int)0).id ? this.entriesTextFields.get(0).m_252907_() > top : this.dialButtons.get(0).m_252907_() > top;
        boolean isBottom = this.getSectionHeight() < bottom;
        return !isTop && k == 1 || !isBottom && k == -1;
    }

    public int getSectionHeight() {
        return !this.entriesTextFields.isEmpty() && this.entriesTextFields.get(this.entriesTextFields.size() - 1).getId() >= this.dialButtons.get((int)(this.dialButtons.size() - 1)).id ? this.entriesTextFields.get(this.entriesTextFields.size() - 1).m_252907_() + this.entriesTextFields.get(this.entriesTextFields.size() - 1).m_93694_() : (this.dialButtons.isEmpty() ? 0 : this.dialButtons.get(this.dialButtons.size() - 1).m_252907_() + this.dialButtons.get(this.dialButtons.size() - 1).m_93694_());
    }

    public boolean canNotRenderEntry(int y) {
        int top = this.guiTop;
        int bottom = this.guiTop + this.height;
        int height = 23;
        return y < top || y + height > bottom;
    }
}

