/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.screen.gui.config;

import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.api.config.screen.entry.AbstractConfigEntry;
import dev.tauri.jsg.api.config.screen.entry.IDescriptionEntry;
import dev.tauri.jsg.api.config.screen.entry.SectionSeparatorConfigEntry;
import dev.tauri.jsg.api.config.values.JSGConfigValue;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class ConfigList
extends ObjectSelectionList<AbstractConfigEntry> {
    protected final Map<String, LinkedList<AbstractConfigEntry>> entriesSorted = new HashMap<String, LinkedList<AbstractConfigEntry>>();

    public ConfigList(Minecraft minecraft, int screenWidth, int screenHeight, int yStart, int yEnd, int itemHeight) {
        super(minecraft, screenWidth, screenHeight, yStart, yEnd, itemHeight);
    }

    public ConfigList(JSGConfig.JSGConfigChild jsgConfigChild, Minecraft minecraft, int screenWidth, int screenHeight, int yStart, int yEnd, int itemHeight) {
        this(minecraft, screenWidth, screenHeight, yStart, yEnd, itemHeight);
        this.loadSection(jsgConfigChild);
    }

    public void add(AbstractConfigEntry entry) {
        this.m_7085_((AbstractSelectionList.Entry)entry);
    }

    public int m_5759_() {
        return 265;
    }

    protected int m_5756_() {
        return (this.f_93388_ + super.m_5759_()) / 2 + 35;
    }

    @Nullable
    protected AbstractConfigEntry nextEntry(@NotNull ScreenDirection dir) {
        return (AbstractConfigEntry)this.m_264620_(dir, e -> !(e instanceof IDescriptionEntry));
    }

    public void loadSection(JSGConfig.JSGConfigChild configChild) {
        this.entriesSorted.clear();
        this.entriesSorted.put("", new LinkedList());
        for (JSGConfigValue jSGConfigValue : configChild.entries) {
            AbstractConfigEntry r = jSGConfigValue.getGuiEntry(this.f_93388_);
            if (r == null) continue;
            String[] splitPath = jSGConfigValue.getPath().split("\\.");
            if (splitPath.length > 1) {
                String category = jSGConfigValue.getPath().replace("." + splitPath[splitPath.length - 1], "");
                LinkedList<AbstractConfigEntry> l = this.entriesSorted.getOrDefault(category, new LinkedList());
                l.add(r);
                this.entriesSorted.put(category, l);
                continue;
            }
            LinkedList<AbstractConfigEntry> l = this.entriesSorted.getOrDefault("", new LinkedList());
            l.add(r);
            this.entriesSorted.put("", l);
        }
        for (Map.Entry entry : this.entriesSorted.entrySet()) {
            if (!((String)entry.getKey()).equalsIgnoreCase("")) {
                this.add(new SectionSeparatorConfigEntry((Component)Component.m_237113_((String)((String)entry.getKey()))));
            }
            for (AbstractConfigEntry entry2 : (LinkedList)entry.getValue()) {
                this.add(entry2);
            }
        }
    }

    public void tick() {
        for (AbstractConfigEntry e : this.m_6702_()) {
            e.tick();
        }
    }
}

