/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.screen.gui.mainmenu;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.tauri.jsg.JSG;
import dev.tauri.jsg.api.client.screen.EnumMainMenuGateType;
import dev.tauri.jsg.api.client.screen.util.GuiHelper;
import dev.tauri.jsg.api.client.screen.widget.IconButton;
import dev.tauri.jsg.api.client.screen.widget.base.JSGButtonClassic;
import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.api.helper.JSGMinecraftHelper;
import dev.tauri.jsg.api.sound.client.FlybySoundInstance;
import dev.tauri.jsg.api.sound.client.JSGSoundHelperClient;
import dev.tauri.jsg.api.util.TimeUtils;
import dev.tauri.jsg.config.data.ProgressJSON;
import dev.tauri.jsg.loader.texture.Texture;
import dev.tauri.jsg.screen.element.MainMenuMusicSlider;
import dev.tauri.jsg.screen.gui.mainmenu.EnumMainMenuTips;
import dev.tauri.jsg.screen.gui.mainmenu.MainMenuGateRenderer;
import dev.tauri.jsg.screen.gui.mainmenu.MainMenuNotifications;
import dev.tauri.jsg.screen.gui.mainmenu.MainMenuTheme;
import dev.tauri.jsg.sound.PositionedSound;
import dev.tauri.jsg.util.updater.GetUpdate;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.OptionsScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.ModListScreen;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2i;

@OnlyIn(value=Dist.CLIENT)
public class GuiCustomMainMenu
extends Screen {
    public static GuiGraphics graphics;
    public static PoseStack poseStack;
    public static final String WEBSITE = "https://justsgmod.eu/";
    public static final String WIKI_RAM_ALLOCATION_URL = "https://justsgmod.eu/wiki/?type=1.20category=general&topic=start#Allocating%20more%20RAM";
    public static final String GITHUB = "https://github.com/Tau-ri-Dev";
    public static final String JSG_RUNNING_TEXT;
    public static final ResourceLocation LOGO_TAURI;
    public static final boolean IS_WINTER;
    public static final ResourceLocation LOGO_JSG;
    public static final Vector2i JSG_LOGO_SIZE;
    public static final long FIRST_TRANSITION_LENGTH = 300L;
    public static final int PADDING = 10;
    public static final MainMenuNotifications NOTIFIER;
    private static final int BACKGROUND_CHANGE_ANIMATION_LENGTH = 60;
    private static final int BACKGROUND_STAY_TIME = 200;
    public static GetUpdate.UpdateResult UPDATER_RESULT;
    public static long menuDisplayed;
    public static boolean menuWasDisplayed;
    public static double firstTransitionStart;
    private static int currentButton;
    private static boolean menuWasDisplayedIgnoredFPS;
    private static int updaterNotification;
    public double tick;
    public boolean isMusicPlaying = false;
    public final EnumMainMenuGateType gateType;
    private long lastTipChange = 0L;
    public List<JSGButtonClassic> buttonList = new ArrayList<JSGButtonClassic>();
    public MainMenuMusicSlider musicSlider;
    private double backgroundScale = 1.0;
    private int currentBackground = 0;
    private float backgroundTransition = 0.0f;
    private EnumMainMenuTips tipEnum = EnumMainMenuTips.random(null);
    @NotNull
    public final MainMenuTheme theme;
    public int lastMouseX;
    public int lastMouseY;
    public double lastMouseMove = -1.0;
    public boolean isZoomedOut = false;
    public double zoomInStart;
    public double zoomOutCoef = 0.0;
    public static Float musicVolume;
    public static boolean soundIntroPlayed;
    public int kinoXStart = -1;
    public int kinoYStart = -1;
    public int kinoXEnd = -1;
    public int kinoYEnd = -1;
    public double kinoAngle = 0.0;
    public boolean renderKino = false;
    public double kinoRenderStart = 0.0;
    public static final double KINO_ANIMATION_LENGTH = 80.0;
    public static FlybySoundInstance kinoSound;

    public GuiCustomMainMenu() {
        super((Component)Component.m_237115_((String)"narrator.screen.title"));
        this.m_86600_();
        this.theme = this.getTheme();
        EnumMainMenuGateType gateType = JSGConfig.General.mainMenuGateType.get();
        this.gateType = gateType == null || gateType == EnumMainMenuGateType.BY_ACT ? EnumMainMenuGateType.byGateType(this.theme.gateType) : gateType;
    }

    protected MainMenuTheme getTheme() {
        MainMenuTheme.load();
        List<Map.Entry> t = MainMenuTheme.THEMES.entrySet().stream().sorted(Comparator.comparingInt(e -> ((MainMenuTheme)e.getValue()).getPriority())).toList();
        for (Map.Entry e2 : t) {
            if (!((MainMenuTheme)e2.getValue()).canBeChosen()) continue;
            return (MainMenuTheme)e2.getValue();
        }
        return MainMenuTheme.ACT_1;
    }

    public static float getMusicVolume() {
        if (musicVolume == null) {
            musicVolume = Float.valueOf((float)JSGConfig.General.mainMenuMusicVolume.get());
        }
        return musicVolume.floatValue();
    }

    public void playMusic(boolean play) {
        JSGSoundHelperClient.playMainMenuTheme(GuiCustomMainMenu::getMusicVolume, this.theme.getSoundTheme(), play);
    }

    public static int[] getCenterPos(int rectWidth, int rectHeight, int winWidth, int winHeight) {
        return new int[]{(winWidth - rectWidth) / 2, (winHeight - rectHeight) / 2};
    }

    public boolean m_6913_() {
        return false;
    }

    public void m_86600_() {
        this.tick = JSGMinecraftHelper.getClientTickPrecise();
    }

    public void updateMusic() {
        if (this.tick - (double)menuDisplayed <= 300.0) {
            return;
        }
        if (this.tick - (double)menuDisplayed > 600.0) {
            this.isMusicPlaying = JSGSoundHelperClient.getRecordMainMenu(GuiCustomMainMenu::getMusicVolume, this.theme.getSoundTheme()).isPlaying();
        }
        if (!this.isMusicPlaying && JSGConfig.General.playMusic.get()) {
            this.isMusicPlaying = true;
            this.playMusic(true);
        }
        if (!JSGConfig.General.playMusic.get() && this.isMusicPlaying) {
            this.playMusic(false);
        }
    }

    public int[] getCenterPos(int rectWidth, int rectHeight) {
        return GuiCustomMainMenu.getCenterPos(rectWidth, rectHeight, this.f_96543_, this.f_96544_);
    }

    public void m_7856_() {
        this.musicSlider = new MainMenuMusicSlider(this.f_96543_ - 10 - 20, this.f_96544_ - 10 - 20, 20, 20, (Component)Component.m_237115_((String)"menu.music.volume"), GuiCustomMainMenu.getMusicVolume(), () -> {
            musicVolume = Float.valueOf((float)this.musicSlider.getValue());
        });
        this.buttonList.clear();
        int id = -1;
        int texSize = 128;
        this.buttonList.add(new IconButton(++id, 0, 0, MainMenuGateRenderer.getIconsTexture(this.gateType), 128, 32, 32, 32, 32, false, Component.m_237115_((String)"menu.singleplayer").getString()));
        this.buttonList.add(new IconButton(++id, 0, 0, MainMenuGateRenderer.getIconsTexture(this.gateType), 128, 64, 32, 32, 32, false, Component.m_237115_((String)"menu.multiplayer").getString()));
        this.buttonList.add(new IconButton(++id, 0, 0, MainMenuGateRenderer.getIconsTexture(this.gateType), 128, 32, 0, 32, 32, false, Component.m_237115_((String)"menu.options").getString()));
        this.buttonList.add(new IconButton(++id, 0, 0, MainMenuGateRenderer.getIconsTexture(this.gateType), 128, 0, 32, 32, 32, false, Component.m_237115_((String)"menu.quit").getString()));
        this.buttonList.add(new IconButton(++id, 0, 0, MainMenuGateRenderer.getIconsTexture(this.gateType), 128, 0, 0, 32, 32, false, Component.m_237115_((String)"menu.about").getString()));
        this.buttonList.add(new IconButton(++id, 0, 0, MainMenuGateRenderer.getIconsTexture(this.gateType), 128, 64, 0, 32, 32, false, Component.m_237115_((String)"fml.menu.mods").getString()));
        this.initUpdaterNotifier();
    }

    public int getButtonForDisplay(int offset) {
        if (offset > 0) {
            return this.getNextButton(offset);
        }
        if (offset < 0) {
            return this.getPreviousButton(offset * -1);
        }
        return currentButton;
    }

    private int getNextButton(int offset) {
        return (currentButton + offset) % this.buttonList.size();
    }

    private int getPreviousButton(int offset) {
        int id = currentButton;
        for (int i = 0; i < offset; ++i) {
            if (--id >= 0) continue;
            id = this.buttonList.size() - 1;
        }
        return id;
    }

    public void updateTip() {
        if (this.tick - (double)this.lastTipChange < 600.0) {
            return;
        }
        this.lastTipChange = (long)this.tick;
        this.tipEnum = EnumMainMenuTips.random(this.tipEnum);
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        double s;
        GuiCustomMainMenu.graphics = graphics;
        GuiHelper.currentStack = GuiCustomMainMenu.graphics.m_280168_();
        poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        Lighting.m_166384_();
        RenderSystem.enableDepthTest();
        this.f_96547_ = Minecraft.m_91087_().f_91062_;
        this.m_86600_();
        if (menuDisplayed == -1L) {
            menuDisplayed = (long)this.tick;
        }
        this.updateMusic();
        this.updateTip();
        if (GuiCustomMainMenu.NOTIFIER.currentDisplayed == null && this.tick - firstTransitionStart > 300.0) {
            if (this.lastMouseY != mouseY || this.lastMouseX != mouseX || this.lastMouseMove <= 0.0) {
                this.lastMouseX = mouseX;
                this.lastMouseY = mouseY;
                this.lastMouseMove = this.tick;
            }
            if (this.tick - this.lastMouseMove > 400.0) {
                this.isZoomedOut = true;
                s = (this.tick - this.lastMouseMove - 400.0) / 20.0;
                if (s > 1.0) {
                    s = 1.0;
                }
                this.zoomOutCoef = Math.pow(Math.sin(s * 1.5707963267948966), 6.0);
            } else if (this.isZoomedOut || this.zoomInStart > 0.0) {
                if (this.zoomInStart < 1.0) {
                    this.zoomInStart = this.tick;
                }
                this.isZoomedOut = false;
                s = 1.0 - (this.tick - this.zoomInStart) / 20.0;
                if (s > 1.0) {
                    s = 1.0;
                }
                if (s < 0.0) {
                    s = 0.0;
                    this.zoomInStart = 0.0;
                }
                this.zoomOutCoef = Math.pow(Math.sin(s * 1.5707963267948966), 6.0);
            }
        } else {
            this.zoomOutCoef = 0.0;
        }
        if (JSGConfig.General.enableLogo.get() && this.tick - firstTransitionStart <= 320.0) {
            s = (this.tick - (firstTransitionStart + 300.0)) / 20.0;
            if (s > 1.0) {
                s = 1.0;
            }
            if (s < 0.0) {
                s = 0.0;
            }
            s = 1.0 - s;
            this.zoomOutCoef = Math.pow(Math.sin(s * 1.5707963267948966), 6.0);
        }
        this.drawBackground();
        this.drawButtons(mouseX, mouseY);
        this.drawTitles();
        this.drawFg(mouseX, mouseY);
        if (!menuWasDisplayed) {
            firstTransitionStart = this.tick;
            if (Minecraft.m_91087_().m_260875_() >= 25) {
                menuWasDisplayed = true;
            }
        }
        this.drawFirstAnimation();
        if (!menuWasDisplayedIgnoredFPS) {
            this.firstInit();
            menuWasDisplayedIgnoredFPS = true;
        }
        poseStack.m_85849_();
    }

    public void drawFirstAnimation() {
        if (!JSGConfig.General.enableLogo.get()) {
            return;
        }
        double current = this.tick - firstTransitionStart;
        if (current > 300.0) {
            return;
        }
        double step = 60.0;
        double alpha = 1.0 - Math.min(1.0, Math.max(0.0, current - 4.5 * step) / (step / 2.0));
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, 52.0f);
        poseStack.m_85836_();
        RenderSystem.enableBlend();
        int introFrameInt = (int)current - 60;
        if (introFrameInt >= 0) {
            GuiHelper.drawRect(0, 0, this.f_96543_, this.f_96544_, new Color(255, 255, 255, (int)(255.0 * alpha)).getRGB());
        } else {
            GuiHelper.drawRect(0, 0, this.f_96543_, this.f_96544_, new Color(0, 0, 0, 255).getRGB());
        }
        if (!soundIntroPlayed && introFrameInt >= 0) {
            JSGSoundHelperClient.playMainMenuTheme(GuiCustomMainMenu::getMusicVolume, PositionedSound.MAINMENU_INTRO, true);
            soundIntroPlayed = true;
        }
        Object introFrame = "";
        introFrame = introFrameInt < 10 ? "00" + introFrameInt : (introFrameInt < 100 ? "0" + introFrameInt : "" + introFrameInt);
        if (introFrameInt < 1) {
            introFrame = "001";
        }
        if (introFrameInt <= 175 && introFrameInt > -1) {
            Texture.bindTextureWithMc(new ResourceLocation("jsg", "textures/gui/wormhole/milkyway/ezgif-frame-" + (String)introFrame + ".jpg"));
            GuiHelper.drawScaledCustomSizeModalRect(0, 0, 0.0f, 0.0f, 1920, 1080, this.f_96543_, this.f_96544_, 1920.0f, 1080.0f);
        }
        poseStack.m_85849_();
        poseStack.m_85836_();
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        int[] center = this.getCenterPos(0, 0);
        if (alpha > 0.75) {
            this.drawCenteredString(this.f_96547_, "We are not associated with Mojang.", center[0], this.f_96544_ - 10 - 10, 0xFFFFFF, true);
        }
        RenderSystem.disableBlend();
        poseStack.m_85849_();
        poseStack.m_85849_();
        poseStack.m_85849_();
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        return this.musicSlider.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        return this.musicSlider.m_6348_(pMouseX, pMouseY, pButton);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        boolean result = NOTIFIER.mouseClicked(mouseX, mouseY, mouseButton);
        if (mouseButton == 0 && GuiCustomMainMenu.NOTIFIER.currentDisplayed == null) {
            if (this.musicSlider.m_6375_(mouseX, mouseY, mouseButton)) {
                return true;
            }
            for (JSGButtonClassic guiButton : this.buttonList) {
                if (!guiButton.m_6375_(mouseX, mouseY, mouseButton)) continue;
                guiButton.m_7435_(this.getMinecraft().m_91106_());
                this.actionPerformed(guiButton);
                result = true;
            }
            int sizeXTauri = this.f_96543_ / 10;
            int sizeYTauri = 230 * sizeXTauri / 411;
            if (GuiHelper.isPointInRegion(10, this.f_96544_ - 10 - sizeYTauri, sizeXTauri, sizeYTauri, (int)mouseX, (int)mouseY)) {
                GetUpdate.openWebsiteToClient(GITHUB);
                result = true;
            }
            int jsgSizeX = this.f_96547_.m_92895_(JSG_RUNNING_TEXT);
            int jsgSizeY = 10;
            int sizeXJSG = (int)((double)this.f_96543_ / 2.33);
            int sizeYJSG = JSG_LOGO_SIZE.y() * sizeXJSG / JSG_LOGO_SIZE.y();
            int[] center = this.getCenterPos(sizeXJSG, sizeYJSG);
            int x = (int)((double)center[0] * 0.25);
            int y = (int)((double)center[1] * 0.5);
            if (GuiHelper.isPointInRegion(10, 10, jsgSizeX, jsgSizeY, (int)mouseX, (int)mouseY) || GuiHelper.isPointInRegion(x, y, sizeXJSG, sizeYJSG, (int)mouseX, (int)mouseY)) {
                GetUpdate.openWebsiteToClient(WEBSITE);
                result = true;
            }
        }
        return result;
    }

    public boolean m_6050_(double x, double y, double amount) {
        super.m_6050_(x, y, amount);
        if (amount == 0.0) {
            return false;
        }
        int topY = Integer.MAX_VALUE;
        int leftX = Integer.MAX_VALUE;
        int bottomY = 0;
        int width = 0;
        for (JSGButtonClassic btn : this.buttonList) {
            if (!btn.f_93624_) continue;
            if (btn.m_252907_() < topY) {
                topY = btn.m_252907_();
            }
            if (btn.m_252754_() < leftX) {
                leftX = btn.m_252754_();
            }
            if (btn.m_5711_() > width) {
                width = btn.m_5711_();
            }
            if (btn.m_252907_() + btn.m_93694_() <= bottomY) continue;
            bottomY = btn.m_252907_() + btn.m_93694_();
        }
        if (GuiHelper.isPointInRegion(leftX, topY, width, bottomY - topY, (int)x, (int)y)) {
            if ((currentButton += amount < 0.0 ? 1 : -1) < 0) {
                currentButton = this.buttonList.size() - 1;
            }
            if (currentButton >= this.buttonList.size()) {
                currentButton = 0;
            }
            return true;
        }
        return false;
    }

    protected void actionPerformed(@Nonnull JSGButtonClassic button) {
        if (this.f_96541_ == null) {
            return;
        }
        if (button.id < this.buttonList.size()) {
            switch (button.id) {
                case 0: {
                    this.f_96541_.m_91152_((Screen)new SelectWorldScreen((Screen)this));
                    break;
                }
                case 1: {
                    this.f_96541_.m_91152_((Screen)new JoinMultiplayerScreen((Screen)this));
                    break;
                }
                case 2: {
                    this.f_96541_.m_91152_((Screen)new OptionsScreen((Screen)this, this.f_96541_.f_91066_));
                    break;
                }
                case 3: {
                    this.f_96541_.m_91395_();
                    break;
                }
                case 4: {
                    GetUpdate.openWebsiteToClient(WEBSITE);
                    break;
                }
                case 5: {
                    this.f_96541_.m_91152_((Screen)new ModListScreen((Screen)this));
                }
            }
        }
    }

    public void drawButtons(int mouseX, int mouseY) {
        poseStack.m_85836_();
        poseStack.m_85837_(this.zoomOutCoef * (double)this.f_96543_, this.zoomOutCoef * (double)this.f_96543_, 50.0);
        this.musicSlider.m_87963_(graphics, mouseX, mouseY, 0.0f);
        poseStack.m_85849_();
        for (JSGButtonClassic button : this.buttonList) {
            button.f_93624_ = false;
            boolean bl = button.f_93623_ = GuiCustomMainMenu.NOTIFIER.currentDisplayed == null;
            if (!(button instanceof IconButton)) continue;
            ((IconButton)button).texture = MainMenuGateRenderer.getIconsTexture(this.gateType);
        }
        for (int i = -2; i <= 2; ++i) {
            RenderSystem.enableBlend();
            int btn = this.getButtonForDisplay(i);
            IconButton button = (IconButton)this.buttonList.get(btn);
            int x = (int)((double)(this.f_96543_ - (button.width + 20)) + this.zoomOutCoef * (double)this.f_96543_);
            int y = this.getCenterPos(button.width, button.height)[1] + i * (button.height + 10);
            button.m_252865_(x);
            button.m_253211_(y);
            button.f_93624_ = true;
            button.drawButton(graphics, mouseX, mouseY);
            if (i == 0) {
                button.drawButton(graphics, mouseX, mouseY);
                button.drawButton(graphics, mouseX, mouseY);
                button.drawButton(graphics, mouseX, mouseY);
                String[] label = button.label;
                int labelHigh = label.length * 10;
                int syDefault = button.m_252907_() + button.height / 2;
                int syStart = syDefault - labelHigh / 2;
                int color = 0xFFFFFF;
                for (int ii = 0; ii < label.length; ++ii) {
                    graphics.m_280488_(this.f_96547_, label[ii], button.m_252754_() - 5 - this.f_96547_.m_92895_(label[ii]), syStart + ii * 10, color);
                    color = 0x404040;
                }
            }
            if (i == -1 || i == 1) {
                button.drawButton(graphics, mouseX, mouseY);
            }
            RenderSystem.disableBlend();
        }
    }

    public void drawBackground() {
        double startTick = this.tick;
        if (JSGConfig.General.enableLogo.get()) {
            startTick = Math.max(0.0, this.tick - firstTransitionStart - 300.0);
        }
        RenderSystem.enableBlend();
        double currentImgCoef = startTick % 200.0 / 200.0;
        double backgroundProgress = startTick % (200.0 * (double)this.theme.getBackgrounds().size()) / (200.0 * (double)this.theme.getBackgrounds().size());
        float scale = 1.0f + (float)((Math.sin(startTick / 400.0 * Math.PI) / 2.0 + 0.5) * (double)0.2f);
        this.currentBackground = (int)(Math.floor(startTick / 200.0) % (double)this.theme.getBackgrounds().size());
        int nextBackground = (this.currentBackground + 1) % this.theme.getBackgrounds().size();
        double backChangeTime = 0.3;
        this.backgroundTransition = (float)(currentImgCoef > 1.0 - backChangeTime ? (currentImgCoef - (1.0 - backChangeTime)) / backChangeTime : 0.0);
        if (this.backgroundTransition > 0.98f) {
            this.currentBackground = nextBackground;
        }
        poseStack.m_85836_();
        int[] center = this.getCenterPos(0, 0);
        poseStack.m_252880_((float)center[0], (float)center[1], 0.0f);
        poseStack.m_85841_(scale, scale, 1.0f);
        this.backgroundScale = scale;
        int w = this.f_96543_;
        int h = this.f_96544_;
        if ((double)h / (double)w < 0.5294424179260031) {
            h = (int)(1016.0 * (double)w / 1919.0);
        } else {
            w = (int)(1919.0 * (double)h / 1016.0);
        }
        Texture.bindTextureWithMc(this.theme.getBackground(this.currentBackground));
        GuiHelper.drawScaledCustomSizeModalRect(-(this.f_96543_ / 2), -(this.f_96544_ / 2), 0.0f, 0.0f, 1919, 1016, w, h, 1920.0f, 1017.0f);
        if (this.backgroundTransition > 0.0f) {
            Texture.bindTextureWithMc(this.theme.getBackground(nextBackground));
            GuiHelper.drawScaledCustomSizeModalRectColor(-(this.f_96543_ / 2), -(this.f_96544_ / 2), 0.0f, 0.0f, 1919, 1016, w, h, 1920.0f, 1017.0f, 1.0f, 1.0f, 1.0f, this.backgroundTransition);
        }
        poseStack.m_85849_();
        GuiHelper.drawRect(0, this.f_96544_ - 2, this.f_96543_, this.f_96544_, -9539986);
        GuiHelper.drawRect(0, this.f_96544_ - 2, (int)((double)this.f_96543_ * backgroundProgress), this.f_96544_, -1315861);
        RenderSystem.disableBlend();
        MainMenuGateRenderer.renderGate(this.gateType, (int)((double)(this.f_96543_ + 20) + this.zoomOutCoef * (double)this.f_96543_), this.getCenterPos(0, 0)[1], 45.0f, this.tick);
    }

    public void drawTitles() {
        if (JSGConfig.General.mainMenuDebugMode.get()) {
            int[] center = this.getCenterPos(0, 0);
            center[1] = center[1] - 30;
            int i = 0;
            graphics.m_280488_(this.f_96547_, "FPS: " + Minecraft.m_91087_().m_260875_(), 10, center[1] + 10 * ++i, 0xFFFFFF);
            graphics.m_280488_(this.f_96547_, "width: " + this.f_96543_, 10, center[1] + 10 * ++i, 0xFFFFFF);
            graphics.m_280488_(this.f_96547_, "height: " + this.f_96544_, 10, center[1] + 10 * ++i, 0xFFFFFF);
            graphics.m_280488_(this.f_96547_, "time: " + String.format("%.4f", this.tick), 10, center[1] + 10 * ++i, 0xFFFFFF);
            graphics.m_280488_(this.f_96547_, "timeHere: " + String.format("%.4f", this.tick % 200.0), 10, center[1] + 10 * ++i, 0xFFFFFF);
            graphics.m_280488_(this.f_96547_, "backgroundScale: " + String.format("%.4f", this.backgroundScale), 10, center[1] + 10 * ++i, 0xFFFFFF);
            graphics.m_280488_(this.f_96547_, "backgroundTransition: " + String.format("%.4f", Float.valueOf(this.backgroundTransition)), 10, center[1] + 10 * ++i, 0xFFFFFF);
            graphics.m_280488_(this.f_96547_, "currentBackground: " + this.currentBackground, 10, center[1] + 10 * ++i, 0xFFFFFF);
            graphics.m_280488_(this.f_96547_, "gateType: " + this.gateType.toString(), 10, center[1] + 10 * ++i, 0xFFFFFF);
            graphics.m_280488_(this.f_96547_, "currentButton: " + currentButton, 10, center[1] + 10 * ++i, 0xFFFFFF);
            graphics.m_280488_(this.f_96547_, "updater: (Status: " + GuiCustomMainMenu.UPDATER_RESULT.result.toString() + "; Got: " + GuiCustomMainMenu.UPDATER_RESULT.response + ")", 10, center[1] + 10 * ++i, 0xFFFFFF);
            graphics.m_280488_(this.f_96547_, "currentAct: " + ProgressJSON.get().currentActId, 10, center[1] + 10 * ++i, 0xFFFFFF);
        }
        poseStack.m_85836_();
        poseStack.m_85837_(-this.zoomOutCoef * (double)this.f_96543_, 0.0, 0.0);
        graphics.m_280488_(this.f_96547_, JSG_RUNNING_TEXT, 10, 10, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "Running on Minecraft Java 1.20.1", 10, 20, 0xFFFFFF);
        poseStack.m_85849_();
        int sizeXTauri = this.f_96543_ / 10;
        int sizeYTauri = 230 * sizeXTauri / 411;
        int sizeXJSG = (int)((double)this.f_96543_ / 2.33);
        int sizeYJSG = JSG_LOGO_SIZE.y() * sizeXJSG / JSG_LOGO_SIZE.x();
        int[] center = this.getCenterPos(sizeXJSG, sizeYJSG);
        int x = (int)((double)center[0] * 0.25);
        int y = (int)((double)center[1] * 0.5);
        RenderSystem.enableBlend();
        Texture.bindTextureWithMc(LOGO_TAURI);
        GuiHelper.drawScaledCustomSizeModalRect(10, this.f_96544_ - 10 - sizeYTauri, 0.0f, 0.0f, 411, 230, sizeXTauri, sizeYTauri, 410.0f, 229.0f);
        poseStack.m_85836_();
        poseStack.m_85837_(-this.zoomOutCoef * (double)this.f_96543_, 0.0, 0.0);
        Texture.bindTextureWithMc(LOGO_JSG);
        GuiHelper.drawScaledCustomSizeModalRect(x, y, 0.0f, 0.0f, JSG_LOGO_SIZE.x(), JSG_LOGO_SIZE.y(), sizeXJSG, sizeYJSG, JSG_LOGO_SIZE.x(), JSG_LOGO_SIZE.y());
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, this.zoomOutCoef * (double)this.f_96544_, 0.0);
        poseStack.m_252880_(0.0f, 0.0f, 51.0f);
        String[] tip = this.tipEnum.text;
        int startY = -(tip.length * 10);
        int i = 0;
        center = this.getCenterPos(0, 0);
        for (String s : tip) {
            this.drawCenteredString(this.f_96547_, Component.m_237115_((String)s).getString(), center[0], this.f_96544_ - 10 + startY + i * 10, 13544744, true);
            ++i;
        }
        poseStack.m_85849_();
        RenderSystem.disableBlend();
    }

    public void drawFg(int mouseX, int mouseY) {
        NOTIFIER.update();
        if (GuiCustomMainMenu.NOTIFIER.currentDisplayed == null) {
            for (JSGButtonClassic b : this.buttonList) {
                if (!(b instanceof IconButton) || !b.f_93624_ || b.id == currentButton) continue;
                ((IconButton)b).drawFg(mouseX, mouseY);
            }
            int sizeXTauri = this.f_96543_ / 10;
            int sizeYTauri = 230 * sizeXTauri / 411;
            if (GuiHelper.isPointInRegion(10, this.f_96544_ - 10 - sizeYTauri, sizeXTauri, sizeYTauri, mouseX, mouseY)) {
                List<MutableComponent> authors = List.of(Component.m_237113_((String)"Click to open Tau'ri Dev github").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(true))));
                graphics.m_280677_(this.f_96547_, authors, Optional.empty(), mouseX, mouseY);
            }
        } else {
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.0f, 50.0f);
            GuiHelper.drawGradientRect(poseStack.m_85850_().m_252922_(), 0, 0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
            NOTIFIER.render(mouseX, mouseY, this.f_96543_, this.f_96544_, this);
            poseStack.m_85849_();
        }
    }

    public void drawCenteredString(Font fontRendererIn, @Nonnull String text, int x, int y, int color, boolean shadow) {
        if (shadow) {
            graphics.m_280137_(fontRendererIn, text, x, y, color);
            return;
        }
        graphics.m_280056_(fontRendererIn, text, x - fontRendererIn.m_92895_(text) / 2, y, color, false);
    }

    public void drawKinoAnimation() {
        double anim = this.tick - this.kinoRenderStart;
        if (!this.renderKino) {
            if (kinoSound != null) {
                GuiCustomMainMenu.kinoSound.currentPosition = null;
                kinoSound.m_7788_();
            }
            kinoSound = null;
            if (anim > 400.0 && Math.random() < (double)0.003f) {
                this.renderKino = true;
                this.kinoRenderStart = this.tick;
                double angle = Math.pow(Math.random(), 2.0) * 2.0 * Math.PI;
                this.kinoXStart = (int)(Math.cos(angle) * 2.5 + 1.0) * (this.f_96543_ / 2);
                this.kinoYStart = (int)(Math.sin(angle) * 2.5 + 1.0) * (this.f_96544_ / 2);
                this.kinoAngle = angle += Math.PI * Math.random() * 1.5;
                this.kinoXEnd = (int)(Math.cos(angle) * 2.5 + 1.0) * (this.f_96543_ / 2);
                this.kinoYEnd = (int)(Math.sin(angle) * 2.5 + 1.0) * (this.f_96544_ / 2);
            }
            return;
        }
        if (anim > 80.0) {
            this.renderKino = false;
            return;
        }
        int kinoX = (int)((double)this.kinoXStart + (double)(this.kinoXEnd - this.kinoXStart) * (anim / 80.0));
        int kinoY = (int)((double)this.kinoYStart + (double)(this.kinoYEnd - this.kinoYStart) * (anim / 80.0));
        BlockPos pos = JSG.lastPlayerPosInWorld.m_121955_((Vec3i)new BlockPos(kinoX, kinoY, 0));
        if (kinoSound == null) {
            kinoSound = JSGSoundHelperClient.playPositionedFlyBySound(pos, PositionedSound.KINO_FLYBY, 1.0f, 1.3f);
            GuiCustomMainMenu.kinoSound.centerPos = JSG.lastPlayerPosInWorld;
        } else {
            GuiCustomMainMenu.kinoSound.currentPosition = pos;
            kinoSound.m_7788_();
        }
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252403_.m_252977_((float)this.kinoAngle));
        RenderSystem.enableBlend();
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        Texture.bindTextureWithMc(LOGO_TAURI);
        GuiHelper.drawScaledCustomSizeModalRect(kinoX, kinoY, 0.0f, 0.0f, 410, 229, 100, 50, 411.0f, 230.0f);
        RenderSystem.disableBlend();
        poseStack.m_85849_();
    }

    public void initUpdaterNotifier() {
        if (GuiCustomMainMenu.UPDATER_RESULT.result == GetUpdate.EnumUpdateResult.NEWER_AVAILABLE || GuiCustomMainMenu.UPDATER_RESULT.result == GetUpdate.EnumUpdateResult.ERROR) {
            boolean error;
            boolean bl = error = GuiCustomMainMenu.UPDATER_RESULT.result == GetUpdate.EnumUpdateResult.ERROR;
            if (updaterNotification == -1 || NOTIFIER.get(updaterNotification) == null) {
                updaterNotification = !error ? NOTIFIER.add(new MainMenuNotifications.Notification(new ArrayList<JSGButtonClassic>(){
                    {
                        String update = Component.m_237115_((String)"menu.updater.download").getString();
                        int width = GuiCustomMainMenu.this.f_96547_.m_92895_(update) + 20;
                        this.add(new JSGButtonClassic(40, -width - 5, 0, width, 20, update));
                        update = Component.m_237115_((String)"menu.updater.close").getString();
                        width = GuiCustomMainMenu.this.f_96547_.m_92895_(update) + 20;
                        this.add(new JSGButtonClassic(41, 5, 0, width, 20, update));
                    }
                }, new String[]{"New update is available!", "", "", "You can update to version " + GuiCustomMainMenu.UPDATER_RESULT.response, "It is highly recommended to update to this version!", "Some dangerous bugs should be fixed in this version."}){

                    @Override
                    public void render(int mouseX, int mouseY, int width, int height, int rectX, int rectY, Screen parentScreen) {
                        super.renderText(mouseX, mouseY, width, height, rectX, rectY, parentScreen);
                        int xCenter = GuiCustomMainMenu.this.getCenterPos(0, 0)[0];
                        ((JSGButtonClassic)((Object)this.buttons.get(0))).m_253211_(rectY + 140 - 30);
                        ((JSGButtonClassic)((Object)this.buttons.get(0))).m_252865_(xCenter - ((JSGButtonClassic)((Object)this.buttons.get(0))).m_5711_() - 5);
                        ((JSGButtonClassic)((Object)this.buttons.get(0))).m_88315_(graphics, mouseX, mouseY, 0.0f);
                        ((JSGButtonClassic)((Object)this.buttons.get(1))).m_252865_(xCenter + 5);
                        ((JSGButtonClassic)((Object)this.buttons.get(1))).m_253211_(((JSGButtonClassic)((Object)this.buttons.get(0))).m_252907_());
                        ((JSGButtonClassic)((Object)this.buttons.get(1))).m_88315_(graphics, mouseX, mouseY, 0.0f);
                    }

                    @Override
                    public void actionPerformed(@Nonnull JSGButtonClassic button) {
                        switch (button.id) {
                            case 40: {
                                GetUpdate.openWebsiteToClient(GetUpdate.DOWNLOAD_URL_USER);
                                break;
                            }
                            case 41: {
                                this.dismiss();
                                break;
                            }
                        }
                    }
                }) : NOTIFIER.add(new MainMenuNotifications.Notification(new ArrayList<JSGButtonClassic>(){
                    {
                        String close = Component.m_237115_((String)"menu.updater.close").getString();
                        int width = GuiCustomMainMenu.this.f_96547_.m_92895_(close) + 20;
                        this.add(new JSGButtonClassic(41, -width / 2, 0, width, 20, close));
                    }
                }, new String[]{"Error while checking update!", GuiCustomMainMenu.UPDATER_RESULT.response, "", "Can not get response from the server!", "Please check your internet connection.", "Problem can also be on our side."}){

                    @Override
                    public void render(int mouseX, int mouseY, int width, int height, int rectX, int rectY, Screen parentScreen) {
                        super.renderText(mouseX, mouseY, width, height, rectX, rectY, parentScreen);
                        int xCenter = GuiCustomMainMenu.this.getCenterPos(0, 0)[0];
                        ((JSGButtonClassic)((Object)this.buttons.get(0))).m_253211_(rectY + 140 - 30);
                        ((JSGButtonClassic)((Object)this.buttons.get(0))).m_252865_(xCenter - ((JSGButtonClassic)((Object)this.buttons.get(0))).m_5711_() / 2);
                        ((JSGButtonClassic)((Object)this.buttons.get(0))).m_88315_(graphics, mouseX, mouseY, 0.0f);
                    }

                    @Override
                    public void actionPerformed(@Nonnull JSGButtonClassic button) {
                        if (button.id == 41) {
                            this.dismiss();
                        }
                    }
                });
            }
        }
    }

    public void firstInit() {
        if (JSG.memoryTotal < 0x80000000L) {
            NOTIFIER.add(new MainMenuNotifications.Notification(new ArrayList<JSGButtonClassic>(){
                {
                    String update = Component.m_237115_((String)"menu.ram.help").getString();
                    int width = GuiCustomMainMenu.this.f_96547_.m_92895_(update) + 20;
                    this.add(new JSGButtonClassic(50, -width - 5, 0, width, 20, update));
                    update = Component.m_237115_((String)"menu.updater.close").getString();
                    width = GuiCustomMainMenu.this.f_96547_.m_92895_(update) + 20;
                    this.add(new JSGButtonClassic(51, 5, 0, width, 20, update));
                }
            }, new String[]{"Allocate more RAM!", "", "Recommended minimum RAM for JSG mod is 2GB!", "By ignoring this fact, you can", "run into troubles with this mod."}){

                @Override
                public void render(int mouseX, int mouseY, int width, int height, int rectX, int rectY, Screen parentScreen) {
                    super.renderText(mouseX, mouseY, width, height, rectX, rectY, parentScreen);
                    int xCenter = GuiCustomMainMenu.this.getCenterPos(0, 0)[0];
                    ((JSGButtonClassic)((Object)this.buttons.get(0))).m_253211_(rectY + 140 - 30);
                    ((JSGButtonClassic)((Object)this.buttons.get(0))).m_252865_(xCenter - ((JSGButtonClassic)((Object)this.buttons.get(0))).m_5711_() - 5);
                    ((JSGButtonClassic)((Object)this.buttons.get(0))).m_88315_(graphics, mouseX, mouseY, 0.0f);
                    ((JSGButtonClassic)((Object)this.buttons.get(1))).m_252865_(xCenter + 5);
                    ((JSGButtonClassic)((Object)this.buttons.get(1))).m_253211_(((JSGButtonClassic)((Object)this.buttons.get(0))).m_252907_());
                    ((JSGButtonClassic)((Object)this.buttons.get(1))).m_88315_(graphics, mouseX, mouseY, 0.0f);
                }

                @Override
                public void actionPerformed(@Nonnull JSGButtonClassic button) {
                    switch (button.id) {
                        case 50: {
                            GetUpdate.openWebsiteToClient(GuiCustomMainMenu.WIKI_RAM_ALLOCATION_URL);
                            break;
                        }
                        case 51: {
                            this.dismiss();
                            break;
                        }
                    }
                }
            });
            NOTIFIER.update();
        }
    }

    static {
        JSG_RUNNING_TEXT = "Just Stargate Mod v" + JSG.MOD_VERSION.replaceAll("1.20.1-", "");
        LOGO_TAURI = new ResourceLocation("jsg", "textures/gui/mainmenu/tauri_dev_logo.png");
        IS_WINTER = TimeUtils.isWinter();
        LOGO_JSG = IS_WINTER ? new ResourceLocation("jsg", "textures/gui/mainmenu/jsg_logo_winter.png") : new ResourceLocation("jsg", "textures/gui/mainmenu/jsg_logo.png");
        JSG_LOGO_SIZE = IS_WINTER ? new Vector2i(1581, 844) : new Vector2i(1586, 603);
        NOTIFIER = MainMenuNotifications.getManager();
        UPDATER_RESULT = GetUpdate.LAST_UPDATE_RESULT;
        menuDisplayed = -1L;
        menuWasDisplayed = false;
        firstTransitionStart = 0.0;
        currentButton = 0;
        menuWasDisplayedIgnoredFPS = false;
        updaterNotification = -1;
        if (JSGConfig.General.mainMenuDebugMode.get()) {
            NOTIFIER.add(new MainMenuNotifications.Notification(new ArrayList<JSGButtonClassic>(){
                {
                    String close = Component.m_237115_((String)"menu.updater.close").getString();
                    int width = Minecraft.m_91087_().f_91062_.m_92895_(close) + 20;
                    this.add(new JSGButtonClassic(41, -width / 2, 0, width, 20, close));
                }
            }, new String[]{"Report from startup:", "", "Total textures loaded/not: " + JSG.ClientModEvents.LoadingStats.loadedTextures + "/" + JSG.ClientModEvents.LoadingStats.notLoadedTextures, "Total models loaded/not: " + JSG.ClientModEvents.LoadingStats.loadedModels + "/" + JSG.ClientModEvents.LoadingStats.notLoadedModels}){

                @Override
                public void render(int mouseX, int mouseY, int width, int height, int rectX, int rectY, Screen parentScreen) {
                    super.renderText(mouseX, mouseY, width, height, rectX, rectY, parentScreen);
                    int xCenter = GuiCustomMainMenu.getCenterPos(0, 0, width, height)[0];
                    ((JSGButtonClassic)((Object)this.buttons.get(0))).m_253211_(rectY + 140 - 30);
                    ((JSGButtonClassic)((Object)this.buttons.get(0))).m_252865_(xCenter - ((JSGButtonClassic)((Object)this.buttons.get(0))).m_5711_() / 2);
                    ((JSGButtonClassic)((Object)this.buttons.get(0))).m_88315_(graphics, mouseX, mouseY, 0.0f);
                }

                @Override
                public void actionPerformed(@Nonnull JSGButtonClassic button) {
                    if (button.id == 41) {
                        this.dismiss();
                    }
                }
            });
        }
        musicVolume = null;
        soundIntroPlayed = false;
    }
}

