/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.screen.gui.sggenerator;

import dev.tauri.jsg.api.client.screen.util.GuiHelper;
import dev.tauri.jsg.api.util.JSGColorUtil;
import dev.tauri.jsg.screen.gui.sggenerator.AbstractStargateGeneratorScreen;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.Util;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.progress.StoringChunkProgressListener;
import net.minecraft.util.Mth;
import net.minecraft.world.level.chunk.ChunkStatus;
import org.jetbrains.annotations.NotNull;

public class LevelGenerationScreen
extends AbstractStargateGeneratorScreen {
    protected final StoringChunkProgressListener progressListener = Minecraft.m_91087_().m_167983_();
    private static final Object2IntMap<ChunkStatus> COLORS = (Object2IntMap)Util.m_137469_((Object)new Object2IntOpenHashMap(), map -> {
        map.defaultReturnValue(0);
        map.put((Object)ChunkStatus.f_62314_, 0x545454);
        map.put((Object)ChunkStatus.f_62315_, 0x999999);
        map.put((Object)ChunkStatus.f_62316_, 6250897);
        map.put((Object)ChunkStatus.f_62317_, 8434258);
        map.put((Object)ChunkStatus.f_62318_, 0xD1D1D1);
        map.put((Object)ChunkStatus.f_62319_, 7497737);
        map.put((Object)ChunkStatus.f_62320_, 3159410);
        map.put((Object)ChunkStatus.f_62322_, 2213376);
        map.put((Object)ChunkStatus.f_279614_, 0xCCCCCC);
        map.put((Object)ChunkStatus.f_62323_, 16769184);
        map.put((Object)ChunkStatus.f_62324_, 15884384);
        map.put((Object)ChunkStatus.f_62326_, 0xFFFFFF);
    });

    public LevelGenerationScreen() {
        super(GameNarrator.f_93310_, () -> "menu.preparingSpawn", () -> 1, ConcurrentHashMap::new, Component::m_237119_);
    }

    protected boolean m_264396_() {
        return false;
    }

    @Override
    public float getProgress() {
        if (this.progressListener == null) {
            return 1.0f;
        }
        return Mth.m_14036_((float)this.progressListener.m_9674_(), (float)0.0f, (float)100.0f) / 100.0f;
    }

    @Override
    protected void renderGateAssembly(@NotNull GuiGraphics graphics, int mouseX, int mouseY, double ticks) {
        int x = this.f_96543_ / 2;
        int y = this.f_96544_ / 2;
        this.renderChunks(graphics, this.progressListener, x, y - 20, 4, 0, mouseX, mouseY, true);
    }

    @Override
    protected void renderProgress(@NotNull GuiGraphics graphics, int x, int y, int progressSize, int mouseX, int mouseY, double ticks) {
        graphics.m_280637_(x, y, progressSize, 10, -1);
        double loaderCoef = ticks % 100.0 / 100.0;
        double loaderX = Math.max(0.0, -10.0 + loaderCoef * (double)progressSize);
        double loaderXRight = Math.min((double)(progressSize - 4), loaderCoef * (double)progressSize);
        graphics.m_280509_((int)((double)(x + 2) + loaderX), y + 2, (int)((double)(x + 2) + loaderXRight), y + 8, -1);
        graphics.m_280509_(x + 2, y + 2, x + 2 + (int)(this.getProgress() * (float)(progressSize - 4)), y + 8, -2960686);
    }

    public void renderChunks(GuiGraphics graphics, StoringChunkProgressListener pProgressListener, int pX, int pY, int tileSize, int offset, int mouseX, int mouseY, boolean renderTooltip) {
        int i = tileSize + offset;
        int j = pProgressListener.m_9672_();
        int k = j * i - offset;
        int l = pProgressListener.m_9673_();
        int i1 = l * i - offset;
        int j1 = pX - i1 / 2;
        int k1 = pY - i1 / 2;
        int l1 = k / 2 + 1;
        int i2 = -16772609;
        graphics.m_286007_(() -> {
            if (offset != 0) {
                graphics.m_280509_(pX - l1, pY - l1, pX - l1 + 1, pY + l1, i2);
                graphics.m_280509_(pX + l1 - 1, pY - l1, pX + l1, pY + l1, i2);
                graphics.m_280509_(pX - l1, pY - l1, pX + l1, pY - l1 + 1, i2);
                graphics.m_280509_(pX - l1, pY + l1 - 1, pX + l1, pY + l1, i2);
            }
            for (int j2 = 0; j2 < l; ++j2) {
                for (int k2 = 0; k2 < l; ++k2) {
                    ChunkStatus chunkstatus = pProgressListener.m_9663_(j2, k2);
                    int l2 = j1 + j2 * i;
                    int i3 = k1 + k2 * i;
                    int color = COLORS.getInt((Object)chunkstatus) | 0xFF000000;
                    boolean hover = false;
                    if (GuiHelper.isPointInRegion(l2, i3, tileSize, tileSize, mouseX, mouseY)) {
                        color = JSGColorUtil.blendColors(color, -1, 0.5f);
                        hover = true;
                    }
                    graphics.m_280509_(l2, i3, l2 + tileSize, i3 + tileSize, color);
                    if (!hover) continue;
                    if (chunkstatus == null) {
                        chunkstatus = ChunkStatus.f_62314_;
                    }
                    graphics.m_280677_(this.f_96547_, List.of(Component.m_237113_((String)chunkstatus.toString())), Optional.empty(), mouseX, mouseY);
                }
            }
        });
    }
}

