/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.screen.inventory;

import dev.tauri.jsg.api.client.screen.TabSideEnum;
import dev.tauri.jsg.api.config.ingame.BEConfig;
import dev.tauri.jsg.api.registry.BiomeOverlayRegistry;
import dev.tauri.jsg.api.util.I18n;
import dev.tauri.jsg.screen.element.tabs.Tab;
import dev.tauri.jsg.screen.element.tabs.TabBiomeOverlay;
import dev.tauri.jsg.screen.element.tabs.TabConfig;
import dev.tauri.jsg.screen.element.tabs.TabScrollAble;
import dev.tauri.jsg.screen.element.tabs.TabbedContainerInterface;
import dev.tauri.jsg.screen.inventory.OpenTabHolderInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public abstract class TabbedContainerScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T>
implements TabbedContainerInterface {
    public static final ResourceLocation CONFIG_TAB_BG = new ResourceLocation("jsg", "textures/gui/container_stargate.png");
    public static final ResourceLocation OVERLAY_TAB_BG = new ResourceLocation("jsg", "textures/gui/container_stargate.png");
    protected final List<Tab> tabs = new ArrayList<Tab>();

    public TabbedContainerScreen(T container, Inventory playerInventory, Component title, int width, int height) {
        super(container, playerInventory, title);
        this.f_97726_ = width;
        this.f_97727_ = height;
        this.f_96543_ = width;
        this.f_96544_ = height;
    }

    public void m_7856_() {
        super.m_7856_();
        this.tabs.clear();
        this.initTabs(this.tabs);
    }

    protected abstract void initTabs(List<Tab> var1);

    public void renderTabsBg(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        Tab.updatePositions(this.tabs);
        graphics.m_280168_().m_85836_();
        for (Tab tab : this.tabs) {
            tab.render(graphics, mouseX, mouseY);
        }
        graphics.m_280168_().m_85849_();
    }

    public void renderTabsFg(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        for (Tab tab : this.tabs) {
            tab.renderFg(graphics, mouseX, mouseY);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        super.m_6375_(mouseX, mouseY, mouseButton);
        for (int i = 0; i < this.tabs.size(); ++i) {
            Tab tab = this.tabs.get(i);
            if (!tab.isCursorOnTab((int)mouseX, (int)mouseY)) continue;
            Tab.tabsInteract(this.tabs, i);
            ((OpenTabHolderInterface)this.f_97732_).updateTabSlots();
            break;
        }
        for (Tab tab : this.tabs) {
            if (!tab.isOpen() || !tab.isVisible()) continue;
            tab.mouseClicked((int)mouseX, (int)mouseY, mouseButton);
        }
        return true;
    }

    public boolean m_6050_(double v, double v1, double v2) {
        super.m_6050_(v, v1, v2);
        int wheel = (int)v2;
        if (wheel != 0) {
            for (Tab tab : this.tabs) {
                if (!(tab instanceof TabScrollAble) || !tab.isVisible() || !tab.isOpen() || !tab.isCursorOnTabBody((int)v, (int)v1)) continue;
                ((TabScrollAble)tab).mouseScrolled(v, v1, v2);
                return true;
            }
        }
        return false;
    }

    public boolean m_7933_(int typedChar, int keyCode, int t) {
        for (Tab tab : this.tabs) {
            if (!tab.isOpen() || !tab.isVisible() || !tab.keyTyped((char)typedChar, keyCode)) continue;
            return true;
        }
        return super.m_7933_(typedChar, keyCode, t);
    }

    public boolean m_5534_(char typedChar, int keyCode) {
        for (Tab tab : this.tabs) {
            if (!tab.isOpen() || !tab.isVisible() || !tab.charTyped(typedChar, keyCode)) continue;
            return true;
        }
        return super.m_5534_(typedChar, keyCode);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        for (Tab tab : this.tabs) {
            if (!tab.isOpen() || !tab.isVisible() || !tab.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY)) continue;
            return true;
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        for (Tab tab : this.tabs) {
            if (!tab.isOpen() || !tab.isVisible() || !tab.mouseReleased(pMouseX, pMouseY, pButton)) continue;
            return true;
        }
        return super.m_6348_(pMouseX, pMouseY, pButton);
    }

    @Override
    public List<Rect2i> getGuiExtraAreas() {
        return this.tabs.stream().map(Tab::getArea).collect(Collectors.toList());
    }

    public static TabConfig createConfigTab(BEConfig config, int guiwidth, int guiheight, int leftPos, int topPos) {
        return (TabConfig)TabConfig.builder().setConfig(config).setGuiSize(guiwidth, guiheight).setGuiPosition(leftPos, topPos).setTabPosition(-21, 77).setOpenX(-(guiwidth - 3)).setHiddenX(-6).setTabSize(guiwidth - 3, 96).setTabTitle(I18n.format("gui.configuration")).setTabSide(TabSideEnum.LEFT).setTexture(CONFIG_TAB_BG, 512).setBackgroundTextureLocation(176, 165).setIconRenderPos(0, 6).setIconSize(22, 22).setIconTextureLocation(326, 66).build();
    }

    public static TabBiomeOverlay createOverlayTab(List<BiomeOverlayRegistry.BiomeOverlayInstance> supportedOverlay, int guiwidth, int guiheight, int leftPos, int topPos) {
        return (TabBiomeOverlay)TabBiomeOverlay.builder().setSupportedOverlays(supportedOverlay).setSlotTexture(6, 179).setGuiSize(guiwidth, guiheight).setGuiPosition(leftPos, topPos).setTabPosition(69, 2).setOpenX(176).setHiddenX(54).setTabSize(128, 51).setTabTitle(I18n.format("gui.biome_overlay")).setTabSide(TabSideEnum.RIGHT).setTexture(OVERLAY_TAB_BG, 512).setBackgroundTextureLocation(200, 113).setIconRenderPos(107, 6).setIconSize(22, 22).setIconTextureLocation(304, 66).build();
    }
}

