/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.screen.inventory.dialhomedevice;

import dev.tauri.jsg.api.client.screen.util.ContainerHelper;
import dev.tauri.jsg.api.stargate.dialhomedevice.DHDReactorStateEnum;
import dev.tauri.jsg.api.state.StateType;
import dev.tauri.jsg.api.util.FluidTank;
import dev.tauri.jsg.blockentity.dialhomedevice.DHDAbstractBE;
import dev.tauri.jsg.forgeutil.SlotHandler;
import dev.tauri.jsg.packet.JSGPacketHandler;
import dev.tauri.jsg.packet.packets.StateUpdatePacketToClient;
import dev.tauri.jsg.registry.FluidRegistry;
import dev.tauri.jsg.registry.MenuTypeRegistry;
import dev.tauri.jsg.screen.inventory.JSGContainer;
import dev.tauri.jsg.screen.inventory.OpenTabHolderInterface;
import dev.tauri.jsg.screen.inventory.dialhomedevice.DHDContainerGuiUpdate;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class DHDContainer
extends JSGContainer
implements OpenTabHolderInterface {
    public Slot slotCrystal;
    public FluidTank tankNaquadah;
    public DHDAbstractBE dhdTile;
    protected BlockPos pos;
    protected int tankLastAmount;
    protected DHDReactorStateEnum lastReactorState;
    protected boolean lastLinked;
    protected final List<Integer> openedTabsSlotsIds = new ArrayList<Integer>();
    public final Inventory playerInventory;

    @Override
    public List<Integer> getOpenTabsSlotsIds() {
        return this.openedTabsSlotsIds;
    }

    @Override
    public void modifyOpenTabSlotId(int slotId, boolean add) {
        if (add) {
            this.openedTabsSlotsIds.add(slotId);
        } else {
            this.openedTabsSlotsIds.removeIf(v -> v == slotId);
        }
    }

    public DHDContainer(int containerID, Inventory playerInventory, BlockEntity tile) {
        super((MenuType)MenuTypeRegistry.DHD_MENU_TYPE.get(), containerID);
        this.playerInventory = playerInventory;
        if (tile == null) {
            throw new NullPointerException("Gate tile is null inside the container! Can not continue!");
        }
        this.dhdTile = (DHDAbstractBE)tile;
        this.pos = this.dhdTile.m_58899_();
        IItemHandler itemHandler = (IItemHandler)this.dhdTile.getCapability(ForgeCapabilities.ITEM_HANDLER, null).resolve().orElseThrow();
        this.slotCrystal = new SlotHandler(itemHandler, 0, 81, 40);
        this.m_38897_(this.slotCrystal);
        this.tankNaquadah = (FluidTank)((Object)this.dhdTile.getCapability(ForgeCapabilities.FLUID_HANDLER, null).resolve().orElseThrow());
        for (int col = 0; col < 3; ++col) {
            this.m_38897_(new SlotHandler(itemHandler, col + 1, 9 + 18 * col, 40));
        }
        this.m_38897_(new SlotHandler(itemHandler, 4, 116, 23));
        this.m_38897_(new SlotHandler(itemHandler, 5, 0, 0));
        for (Slot slot : ContainerHelper.generatePlayerSlots((Container)playerInventory, 91)) {
            this.m_38897_(slot);
        }
    }

    public DHDContainer(int containerID, Inventory playerInventory, FriendlyByteBuf buf) {
        this(containerID, playerInventory, playerInventory.f_35978_.m_9236_().m_7702_(buf.m_130135_()));
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        ItemStack stack = this.m_38853_(index).m_7993_();
        if (index < 6) {
            if (!this.m_38903_(stack, 6, this.f_38839_.size(), false)) {
                return ItemStack.f_41583_;
            }
        } else {
            if (stack.m_41720_() == this.getControlCrystal()) {
                if (!this.slotCrystal.m_6657_()) {
                    ItemStack stack1 = stack.m_41777_();
                    stack1.m_41764_(1);
                    this.slotCrystal.m_5852_(stack1);
                    stack.m_41774_(1);
                    return ItemStack.f_41583_;
                }
            } else if (DHDAbstractBE.SUPPORTED_UPGRADES.contains(stack.m_41720_()) && !this.dhdTile.hasUpgrade(stack.m_41720_())) {
                for (int i = 1; i < 4; ++i) {
                    if (this.m_38853_(i).m_6657_()) continue;
                    ItemStack stack1 = stack.m_41777_();
                    stack1.m_41764_(1);
                    this.m_38853_(i).m_5852_(stack1);
                    this.m_150404_(i, stack1);
                    stack.m_41774_(1);
                    return stack;
                }
            } else if (stack.m_41720_() instanceof BucketItem) {
                Fluid fluid = ((BucketItem)stack.m_41720_()).getFluid();
                if (fluid == FluidRegistry.MOLTEN_NAQUADAH_REFINED.get() && !this.m_38853_(4).m_6657_()) {
                    ItemStack stack1 = stack.m_41777_();
                    stack1.m_41764_(1);
                    this.m_38853_(4).m_5852_(stack1);
                    this.m_150404_(4, stack1);
                    stack.m_41774_(1);
                    return stack;
                }
            } else if (this.openedTabsSlotsIds.contains(5) && this.m_38853_(5).m_5857_(stack) && !this.m_38853_(5).m_6657_()) {
                ItemStack stack1 = stack.m_41777_();
                stack1.m_41764_(1);
                this.m_38853_(5).m_5852_(stack1);
                this.m_150404_(5, stack1);
                stack.m_41774_(1);
                return ItemStack.f_41583_;
            }
            return ItemStack.f_41583_;
        }
        this.m_38853_(index).m_5852_(ItemStack.f_41583_);
        this.m_150404_(index, ItemStack.f_41583_);
        return stack;
    }

    public void m_38946_() {
        super.m_38946_();
        if (this.tankLastAmount != this.tankNaquadah.getFluidAmount() || this.lastReactorState != this.dhdTile.getReactorState() || this.lastLinked != this.dhdTile.isLinked()) {
            Player player = this.playerInventory.f_35978_;
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                JSGPacketHandler.sendTo(new StateUpdatePacketToClient(this.pos, StateType.GUI_UPDATE, new DHDContainerGuiUpdate(this.tankNaquadah.getFluidAmount(), this.tankNaquadah.getCapacity(), this.dhdTile.getReactorState(), this.dhdTile.isLinked())), sp);
            }
            this.tankLastAmount = this.tankNaquadah.getFluidAmount();
            this.lastReactorState = this.dhdTile.getReactorState();
            this.lastLinked = this.dhdTile.isLinked();
        }
    }

    public Item getControlCrystal() {
        return this.dhdTile.getControlCrystal();
    }
}

