/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.screen.inventory.energy.capacitor;

import dev.tauri.jsg.api.client.screen.util.ContainerHelper;
import dev.tauri.jsg.api.power.general.SmallEnergyStorage;
import dev.tauri.jsg.api.state.StateType;
import dev.tauri.jsg.blockentity.capacitor.CapacitorBE;
import dev.tauri.jsg.packet.JSGPacketHandler;
import dev.tauri.jsg.packet.packets.StateUpdatePacketToClient;
import dev.tauri.jsg.registry.MenuTypeRegistry;
import dev.tauri.jsg.screen.inventory.JSGContainer;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class CapacitorContainer
extends JSGContainer {
    public CapacitorBE capTile;
    public Slot slot;
    private final BlockPos pos;
    private int lastEnergyStored;
    private int energyTransferedLastTick;
    public final Inventory playerInventory;

    public CapacitorContainer(int containerId, Inventory playerInventory, @Nullable BlockEntity capTile) {
        super((MenuType)MenuTypeRegistry.CAPACITOR_MENU_TYPE.get(), containerId);
        this.playerInventory = playerInventory;
        if (capTile == null) {
            throw new NullPointerException("capTile is null!");
        }
        this.pos = capTile.m_58899_();
        this.capTile = (CapacitorBE)capTile;
        IItemHandler itemHandler = (IItemHandler)Objects.requireNonNull(capTile).getCapability(ForgeCapabilities.ITEM_HANDLER, null).resolve().get();
        this.slot = new SlotItemHandler(itemHandler, 0, 80, 35);
        this.m_38897_(this.slot);
        for (Slot slot : ContainerHelper.generatePlayerSlots((Container)playerInventory, 81)) {
            this.m_38897_(slot);
        }
    }

    public CapacitorContainer(int containerID, Inventory playerInventory, FriendlyByteBuf buf) {
        this(containerID, playerInventory, playerInventory.f_35978_.m_9236_().m_7702_(buf.m_130135_()));
    }

    @Nonnull
    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        ItemStack stack = this.m_38853_(index).m_7993_();
        if (index < 1) {
            if (!this.m_38903_(stack, 1, this.f_38839_.size(), false)) {
                return ItemStack.f_41583_;
            }
        } else {
            if (stack.getCapability(ForgeCapabilities.ENERGY, null).isPresent() && !this.slot.m_6657_()) {
                ItemStack stack1 = stack.m_41777_();
                stack1.m_41764_(1);
                this.slot.m_5852_(stack1);
                stack.m_41774_(1);
                return ItemStack.f_41583_;
            }
            return ItemStack.f_41583_;
        }
        this.m_150404_(index, ItemStack.f_41583_);
        return stack;
    }

    public void m_38946_() {
        super.m_38946_();
        SmallEnergyStorage energyStorage = (SmallEnergyStorage)((Object)this.capTile.getCapability(ForgeCapabilities.ENERGY, null).resolve().get());
        if (this.lastEnergyStored != Objects.requireNonNull(energyStorage).getEnergyStored() || this.energyTransferedLastTick != this.capTile.getEnergyTransferedLastTick()) {
            Player player = this.playerInventory.f_35978_;
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                JSGPacketHandler.sendTo(new StateUpdatePacketToClient(this.pos, StateType.GUI_UPDATE, this.capTile.getState(StateType.GUI_UPDATE)), sp);
            }
            this.lastEnergyStored = energyStorage.getEnergyStored();
            this.energyTransferedLastTick = this.capTile.getEnergyTransferedLastTick();
        }
    }
}

