/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.screen.inventory.energy.capacitor;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.tauri.jsg.api.client.screen.util.GuiHelper;
import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.api.power.general.SmallEnergyStorage;
import dev.tauri.jsg.api.util.I18n;
import dev.tauri.jsg.loader.texture.Texture;
import dev.tauri.jsg.screen.inventory.energy.capacitor.CapacitorContainer;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.jetbrains.annotations.NotNull;

public class CapacitorContainerGui
extends AbstractContainerScreen<CapacitorContainer> {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("jsg", "textures/gui/container_capacitor.png");
    private final CapacitorContainer container;

    public CapacitorContainerGui(CapacitorContainer container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, title);
        this.container = container;
        this.f_97726_ = 176;
        this.f_97727_ = 163;
        this.f_96543_ = this.f_97726_;
        this.f_96544_ = this.f_97727_;
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.disableDepthTest();
        this.m_280273_(graphics);
        GuiHelper.currentStack = graphics.m_280168_();
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_7286_(@NotNull GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.disableDepthTest();
        GuiHelper.currentStack = graphics.m_280168_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Texture.bindTextureWithMc(BACKGROUND_TEXTURE);
        GuiHelper.drawTexturedModalRect(this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        SmallEnergyStorage energyStorage = (SmallEnergyStorage)((Object)this.container.capTile.getCapability(ForgeCapabilities.ENERGY, null).resolve().get());
        int width = Math.round((float)Objects.requireNonNull(energyStorage).getEnergyStored() / ((float)JSGConfig.Stargate.stargateEnergyStorage.get() / 4.0f) * 156.0f);
        GuiHelper.drawGradientRect(this.f_97735_ + 10, this.f_97736_ + 59, this.f_97735_ + 10 + width, this.f_97736_ + 59 + 6, -3397592, -9234922);
    }

    protected void m_280003_(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        RenderSystem.disableDepthTest();
        graphics.m_280056_(this.f_96547_, I18n.format("gui.capacitor.name"), 8, 16, 0x404040, false);
        graphics.m_280056_(this.f_96547_, I18n.format("container.inventory"), 8, this.f_97727_ - 96 + 2, 0x404040, false);
        SmallEnergyStorage energyStorage = (SmallEnergyStorage)((Object)this.container.capTile.getCapability(ForgeCapabilities.ENERGY, null).resolve().get());
        int energyStored = Objects.requireNonNull(energyStorage).getEnergyStored();
        int maxEnergyStored = energyStorage.getMaxEnergyStored();
        String energyPercent = String.format("%.2f", Float.valueOf((float)energyStored / (float)maxEnergyStored * 100.0f)) + " %";
        graphics.m_280056_(this.f_96547_, energyPercent, this.f_97726_ - 8 - this.f_96547_.m_92895_(energyPercent), 69, 0x404040, false);
        int transferred = this.container.capTile.getEnergyTransferedLastTick();
        ChatFormatting transferredFormatting = ChatFormatting.GRAY;
        String transferredSign = "";
        if (transferred > 0) {
            transferredFormatting = ChatFormatting.GREEN;
            transferredSign = "+";
        } else if (transferred < 0) {
            transferredFormatting = ChatFormatting.RED;
        }
        if (GuiHelper.isPointInRegion(10, 59, 156, 6, mouseX - this.getGuiLeft(), mouseY - this.getGuiTop())) {
            List<String> power = Arrays.asList(I18n.format("gui.stargate.energyBuffer"), String.valueOf(ChatFormatting.GRAY) + String.format("%,d / %,d FE", energyStorage.getEnergyStored(), energyStorage.getMaxEnergyStored()), String.valueOf(transferredFormatting) + transferredSign + String.format("%,d FE/t", transferred));
            GuiHelper.drawHoveringText(graphics, this.f_96547_, power, mouseX - this.getGuiLeft(), mouseY - this.getGuiTop());
        }
    }
}

