/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.screen.inventory.stargate;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.tauri.jsg.api.client.screen.TabSideEnum;
import dev.tauri.jsg.api.client.screen.util.GuiHelper;
import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.api.config.ingame.option.StargateConfigOptions;
import dev.tauri.jsg.api.helper.TemperatureHelper;
import dev.tauri.jsg.api.power.general.LargeEnergyStorage;
import dev.tauri.jsg.api.stargate.StargateUpgrade;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolTypeRegistry;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolUsage;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.AbstractSymbolType;
import dev.tauri.jsg.api.util.I18n;
import dev.tauri.jsg.api.util.IUpgradeItem;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.forgeutil.SlotHandler;
import dev.tauri.jsg.loader.texture.Texture;
import dev.tauri.jsg.packet.JSGPacketHandler;
import dev.tauri.jsg.packet.packets.stargate.SaveConfigToServer;
import dev.tauri.jsg.packet.packets.stargate.SaveIrisCodeToServer;
import dev.tauri.jsg.registry.ItemRegistry;
import dev.tauri.jsg.screen.element.tabs.Tab;
import dev.tauri.jsg.screen.element.tabs.TabAddress;
import dev.tauri.jsg.screen.element.tabs.TabBiomeOverlay;
import dev.tauri.jsg.screen.element.tabs.TabConfig;
import dev.tauri.jsg.screen.element.tabs.TabInfo;
import dev.tauri.jsg.screen.element.tabs.TabIris;
import dev.tauri.jsg.screen.inventory.OpenTabHolderInterface;
import dev.tauri.jsg.screen.inventory.TabbedContainerScreen;
import dev.tauri.jsg.screen.inventory.stargate.StargateContainer;
import dev.tauri.jsg.stargate.manager.StargateEnergyManager;
import dev.tauri.jsg.stargate.manager.dialing.StargateAbstractDialingManager;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class StargateContainerGui
extends TabbedContainerScreen<StargateContainer> {
    public static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("jsg", "textures/gui/container_stargate.png");
    private final Map<AbstractSymbolType<?>, TabAddress> addressTabs = new LinkedHashMap();
    private TabIris irisTab;
    private TabConfig configTab;
    private TabInfo infoTab;
    private TabBiomeOverlay overlayTab;
    private int energyStored;
    private int maxEnergyStored;
    private final BlockPos pos;

    public StargateContainerGui(StargateContainer container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title, 176, 173);
        this.pos = container.gateTile.m_58899_();
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        int ii = 0;
        for (TabAddress tab : this.addressTabs.values()) {
            if (ii + 7 == 10) {
                ++ii;
            }
            ((StargateContainer)this.f_97732_).f_38839_.set(ii + 7, (Object)tab.createAndSaveSlot((SlotHandler)((StargateContainer)this.f_97732_).m_38853_(ii + 7)));
            ++ii;
        }
        ((StargateContainer)this.f_97732_).f_38839_.set(10, (Object)this.overlayTab.createAndSaveSlot((SlotHandler)((StargateContainer)this.f_97732_).m_38853_(10)));
    }

    @Override
    protected void initTabs(List<Tab> tabs) {
        int i = 0;
        for (AbstractSymbolType<?> type : AbstractSymbolType.values(SymbolUsage.STARGATES)) {
            Tab.TabBuilder tab = TabAddress.builder().setAddressProvider(((StargateContainer)this.f_97732_).gateTile).setSymbolType(type).setProgressColor(10009849).setGuiSize(this.f_97726_, this.f_97727_).setGuiPosition(this.f_97735_, this.f_97736_).setTabPosition(-21, 11 + 22 * i).setOpenX(-128).setHiddenX(-6).setTabSize(128, 113).setTabTitle(I18n.format("gui.stargate." + type.getId() + "_address")).setTabSide(TabSideEnum.LEFT);
            tab = (Tab.TabBuilder)type.finalizeAddressTab(tab);
            this.addressTabs.put(type, (TabAddress)((TabAddress)tab.build()).setMenu((OpenTabHolderInterface)this.f_97732_));
            ++i;
        }
        this.configTab = StargateContainerGui.createConfigTab(((StargateContainer)this.f_97732_).gateTile.getConfig(), this.f_97726_, this.f_97727_, this.f_97735_, this.f_97736_);
        this.overlayTab = StargateContainerGui.createOverlayTab(((StargateContainer)this.f_97732_).gateTile.getSupportedOverlays(), this.f_97726_, this.f_97727_, this.f_97735_, this.f_97736_);
        this.overlayTab.setMenu((OpenTabHolderInterface)this.f_97732_);
        this.irisTab = (TabIris)TabIris.builder().setCode(((StargateContainer)this.f_97732_).gateTile.getIrisManager().getIrisCode()).setIsUniverse(((StargateContainer)this.f_97732_).gateTile.getSymbolType() == SymbolTypeRegistry.UNIVERSE).setIrisMode(((StargateContainer)this.f_97732_).gateTile.getIrisManager().getIrisMode()).setGuiSize(this.f_97726_, this.f_97727_).setGuiPosition(this.f_97735_, this.f_97736_).setTabPosition(69, 24).setOpenX(176).setHiddenX(54).setTabSize(128, 51).setTabTitle(I18n.format("gui.stargate.iris_code")).setTabSide(TabSideEnum.RIGHT).setTexture(BACKGROUND_TEXTURE, 512).setBackgroundTextureLocation(200, 113).setIconRenderPos(107, 6).setIconSize(22, 22).setIconTextureLocation(304, 88).build();
        this.infoTab = (TabInfo)TabInfo.builder().setGuiSize(this.f_97726_, this.f_97727_).setGuiPosition(this.f_97735_, this.f_97736_).setTabPosition(45, 46).setOpenX(176).setHiddenX(30).setTabSize(152, 51).setTabTitle(I18n.format("gui.stargate.info")).setTabSide(TabSideEnum.RIGHT).setTexture(BACKGROUND_TEXTURE, 512).setBackgroundTextureLocation(176, 113).setIconRenderPos(131, 6).setIconSize(22, 22).setIconTextureLocation(326, 88).build();
        this.irisTab.setOnTabClose(this::saveIrisCode);
        this.configTab.setOnTabClose(this::saveConfig);
        tabs.addAll(this.addressTabs.values());
        tabs.add(this.configTab);
        tabs.add(this.overlayTab);
        tabs.add(this.irisTab);
        tabs.add(this.infoTab);
    }

    protected void m_7286_(@NotNull GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        int i;
        RenderSystem.disableDepthTest();
        GuiHelper.currentStack = graphics.m_280168_();
        if (this.irisTab.isVisible() && !this.irisTab.isOpen()) {
            if (this.irisTab.getIrisMode() != ((StargateContainer)this.f_97732_).gateTile.getIrisManager().getIrisMode()) {
                this.irisTab.updateValue(((StargateContainer)this.f_97732_).gateTile.getIrisManager().getIrisMode());
            }
            if (!Objects.equals(this.irisTab.getCode(), ((StargateContainer)this.f_97732_).gateTile.getIrisManager().getIrisCode())) {
                this.irisTab.updateValue(((StargateContainer)this.f_97732_).gateTile.getIrisManager().getIrisCode());
            }
        }
        if (((StargateContainer)this.f_97732_).gateTile.getConfig().getOptions().size() != this.configTab.getConfig().getOptions().size()) {
            this.configTab.updateConfig(((StargateContainer)this.f_97732_).gateTile.getConfig(), true);
        }
        this.renderTabsBg(graphics, mouseX, mouseY);
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 0.2f);
        Texture.bindTextureWithMc(BACKGROUND_TEXTURE);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiHelper.drawModalRectWithCustomSizedTexture(this.f_97735_, this.f_97736_, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 512.0f, 512.0f);
        for (i = 0; i < 3 - ((StargateContainer)this.f_97732_).gateTile.getSupportedCapacitors(); ++i) {
            GuiHelper.drawModalRectWithCustomSizedTexture(this.f_97735_ + 151 - 18 * i, this.f_97736_ + 27, 24.0f, 180.0f, 16, 16, 512.0f, 512.0f);
        }
        for (i = ((StargateContainer)this.f_97732_).gateTile.getPowerTier(); i < 4; ++i) {
            GuiHelper.drawModalRectWithCustomSizedTexture(this.f_97735_ + 10 + 39 * i, this.f_97736_ + 69, 0.0f, 173.0f, 39, 6, 512.0f, 512.0f);
        }
        int width = Math.round((float)this.energyStored / (float)JSGConfig.Stargate.stargateEnergyStorage.get() * 156.0f);
        GuiHelper.drawGradientRect(graphics.m_280168_(), this.f_97735_ + 10, this.f_97736_ + 69, this.f_97735_ + 10 + width, this.f_97736_ + 69 + 6, -3397592, -9234922);
        int[] pos = ((StargateContainer)this.f_97732_).gateTile.getSymbolType().getAncientTitlePos();
        GuiHelper.drawModalRectWithCustomSizedTexture(this.f_97735_ + 137, this.f_97736_ + 4, pos[0], pos[1], 35, 8, 512.0f, 512.0f);
        boolean drawICFirstCable = false;
        boolean drawICSecondCable = false;
        block11: for (int i2 = 0; i2 < 7; ++i2) {
            if (!((StargateContainer)this.f_97732_).m_38853_(i2).m_6657_()) continue;
            if (i2 < 4) {
                drawICFirstCable = true;
            }
            switch (i2) {
                case 0: {
                    GuiHelper.drawModalRectWithCustomSizedTexture(this.f_97735_ + 16, this.f_97736_ + 44, 18.0f, 239.0f, 31, 15, 512.0f, 512.0f);
                    continue block11;
                }
                case 1: {
                    GuiHelper.drawModalRectWithCustomSizedTexture(this.f_97735_ + 34, this.f_97736_ + 44, 3.0f, 239.0f, 13, 11, 512.0f, 512.0f);
                    continue block11;
                }
                case 2: {
                    GuiHelper.drawModalRectWithCustomSizedTexture(this.f_97735_ + 52, this.f_97736_ + 44, 0.0f, 239.0f, 2, 6, 512.0f, 512.0f);
                    continue block11;
                }
                case 3: {
                    GuiHelper.drawModalRectWithCustomSizedTexture(this.f_97735_ + 59, this.f_97736_ + 44, 33.0f, 254.0f, 13, 11, 512.0f, 512.0f);
                    continue block11;
                }
                case 4: {
                    GuiHelper.drawModalRectWithCustomSizedTexture(this.f_97735_ + 121, this.f_97736_ + 44, 0.0f, 225.0f, 14, 12, 512.0f, 512.0f);
                    continue block11;
                }
                case 5: {
                    GuiHelper.drawModalRectWithCustomSizedTexture(this.f_97735_ + 139, this.f_97736_ + 44, 14.0f, 225.0f, 4, 6, 512.0f, 512.0f);
                    continue block11;
                }
                case 6: {
                    GuiHelper.drawModalRectWithCustomSizedTexture(this.f_97735_ + 147, this.f_97736_ + 44, 18.0f, 225.0f, 14, 14, 512.0f, 512.0f);
                    continue block11;
                }
            }
        }
        if (((StargateContainer)this.f_97732_).m_38853_(11).m_6657_()) {
            drawICSecondCable = true;
            ItemStack stack = ((StargateContainer)this.f_97732_).m_38853_(11).m_7993_();
            if (stack.m_41720_() == ItemRegistry.UPGRADE_SHIELD.get()) {
                GuiHelper.drawModalRectWithCustomSizedTexture(this.f_97735_ + 98, this.f_97736_ + 33, 0.0f, 197.0f, 37, 28, 512.0f, 512.0f);
            }
            GuiHelper.drawModalRectWithCustomSizedTexture(this.f_97735_ + 59, this.f_97736_ + 44, 0.0f, 254.0f, 31, 15, 512.0f, 512.0f);
        }
        if (drawICFirstCable) {
            GuiHelper.drawModalRectWithCustomSizedTexture(this.f_97735_ + 50, this.f_97736_ + 62, 0.0f, 239.0f, 2, 6, 512.0f, 512.0f);
        }
        if (drawICSecondCable) {
            GuiHelper.drawModalRectWithCustomSizedTexture(this.f_97735_ + 54, this.f_97736_ + 62, 0.0f, 239.0f, 2, 6, 512.0f, 512.0f);
        }
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int i;
        RenderSystem.disableDepthTest();
        if (this.infoTab != null) {
            this.infoTab.clearStrings();
            int y = 22;
            long openedSince = ((StargateAbstractDialingManager)((StargateContainer)this.f_97732_).gateTile.getDialingManager()).getConnection().getSince();
            if (openedSince > 0L) {
                long openedSeconds = ((StargateAbstractDialingManager)((StargateContainer)this.f_97732_).gateTile.getDialingManager()).getConnection().getSecondsOpen();
                String format = ChatFormatting.DARK_GREEN.toString();
                int maxTime = ((StargateContainer)this.f_97732_).gateTile.getConfig().getValueOrDefault(StargateConfigOptions.Common.TIME_LIMIT_TIME);
                if ((double)openedSeconds >= (double)maxTime * 0.75) {
                    format = ChatFormatting.YELLOW.toString();
                }
                if (openedSeconds >= (long)maxTime) {
                    format = ChatFormatting.RED.toString();
                }
                String openedTime = I18n.format("gui.stargate.state.opened") + " " + format + ((StargateContainer)this.f_97732_).gateTile.getOpenedSecondsToDisplayAsMinutes();
                this.infoTab.addString(new TabInfo.InfoString(openedTime, 4, y));
                y += 9;
            }
            double gateTemperature = ((StargateContainer)this.f_97732_).gateTile.gateHeat;
            double irisTemperature = ((StargateContainer)this.f_97732_).gateTile.irisHeat;
            String format = ChatFormatting.DARK_GREEN.toString();
            if (gateTemperature >= StargateClassicBaseBE.GATE_MAX_HEAT * 0.5) {
                format = ChatFormatting.YELLOW.toString();
            }
            if (gateTemperature >= StargateClassicBaseBE.GATE_MAX_HEAT * 0.75) {
                format = ChatFormatting.RED.toString();
            }
            this.infoTab.addString(new TabInfo.InfoString(I18n.format("gui.stargate.state.gate_temp") + " " + format + JSGConfig.General.temperatureUnit.get().getTemperatureToDisplay(TemperatureHelper.asKelvins(TemperatureHelper.asCelsius(gateTemperature).toKelvins()), 0), 4, y));
            y += 9;
            ((StargateContainer)this.f_97732_).gateTile.getIrisManager().updateIrisType();
            if (((StargateContainer)this.f_97732_).gateTile.getIrisManager().hasPhysicalIris()) {
                double maxHeat = ((StargateContainer)this.f_97732_).gateTile.getMaxIrisHeat();
                format = ChatFormatting.DARK_GREEN.toString();
                if (irisTemperature > maxHeat * 0.5) {
                    format = ChatFormatting.YELLOW.toString();
                }
                if (irisTemperature > maxHeat * 0.75) {
                    format = ChatFormatting.RED.toString();
                }
                this.infoTab.addString(new TabInfo.InfoString(I18n.format("gui.stargate.state.iris_temp") + " " + format + JSGConfig.General.temperatureUnit.get().getTemperatureToDisplay(TemperatureHelper.asKelvins(TemperatureHelper.asCelsius(irisTemperature).toKelvins()), 0), 4, y));
            }
        }
        this.m_280273_(graphics);
        boolean hasAddressUpgrade = false;
        boolean hasIrisUpgrade = !((StargateContainer)this.f_97732_).m_38853_(11).m_7993_().m_41619_();
        for (Map.Entry<AbstractSymbolType<?>, TabAddress> entry : this.addressTabs.entrySet()) {
            entry.getValue().setVisible(false);
        }
        for (int i2 = 0; i2 < 4; ++i2) {
            IUpgradeItem upgradeItem;
            ItemStack itemStack = ((StargateContainer)this.f_97732_).m_38853_(i2).m_7993_();
            if (itemStack.m_41619_()) continue;
            for (Map.Entry<AbstractSymbolType<?>, TabAddress> entry : this.addressTabs.entrySet()) {
                if (itemStack.m_41720_() != entry.getKey().getGlyphUpgrade()) continue;
                entry.getValue().setVisible(true);
            }
            Item item = itemStack.m_41720_();
            if (!(item instanceof IUpgradeItem) || (upgradeItem = (IUpgradeItem)item).getUpgrade() != StargateUpgrade.CHEVRON_UPGRADE) continue;
            hasAddressUpgrade = true;
        }
        for (Map.Entry<AbstractSymbolType<?>, TabAddress> entry : this.addressTabs.entrySet()) {
            entry.getValue().setMaxSymbols(entry.getKey().getMaxSymbolsDisplay(hasAddressUpgrade));
        }
        this.irisTab.setVisible(hasIrisUpgrade);
        this.configTab.setVisible(((StargateContainer)this.f_97732_).hasCreative);
        LargeEnergyStorage energyStorageInternal = (LargeEnergyStorage)((Object)((StargateContainer)this.f_97732_).gateTile.getStargateCapability(ForgeCapabilities.ENERGY, null).resolve().orElseThrow());
        this.energyStored = energyStorageInternal.getEnergyStoredInternally();
        this.maxEnergyStored = energyStorageInternal.getMaxEnergyStoredInternally();
        for (i = 4; i < 7; ++i) {
            Optional energyStorage = ((StargateContainer)this.f_97732_).m_38853_(i).m_7993_().getCapability(ForgeCapabilities.ENERGY, null).resolve();
            if (energyStorage.isEmpty()) continue;
            this.energyStored += ((IEnergyStorage)energyStorage.get()).getEnergyStored();
            this.maxEnergyStored += ((IEnergyStorage)energyStorage.get()).getMaxEnergyStored();
        }
        for (i = 7; i < 11; ++i) {
            Tab.SlotTab slot = ((Tab.SlotTab)((StargateContainer)this.f_97732_).m_38853_(i)).updatePos();
            slot.setSlotIndex(i);
            ((StargateContainer)this.f_97732_).f_38839_.set(i, (Object)slot);
        }
        graphics.m_280168_().m_85836_();
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
        graphics.m_280168_().m_85849_();
    }

    protected void m_280003_(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        RenderSystem.disableDepthTest();
        String caps = I18n.format("gui.stargate.capacitors");
        graphics.m_280056_(this.f_96547_, caps, this.f_97726_ - 8 - this.f_96547_.m_92895_(caps), 16, 0x404040, false);
        String energyPercent = String.format("%.2f", Float.valueOf((float)this.energyStored / (float)this.maxEnergyStored * 100.0f)) + " %";
        graphics.m_280056_(this.f_96547_, energyPercent, this.f_97726_ - 8 - this.f_96547_.m_92895_(energyPercent), 79, 0x404040, false);
        graphics.m_280056_(this.f_96547_, I18n.format("gui.upgrades"), 8, 16, 0x404040, false);
        graphics.m_280056_(this.f_96547_, I18n.format("container.inventory"), 8, this.f_97727_ - 96 + 2, 0x404040, false);
        this.renderTabsFg(graphics, mouseX, mouseY);
        int transferred = ((StargateEnergyManager)((StargateContainer)this.f_97732_).gateTile.getEnergyManager()).getTransferredLastTick();
        ChatFormatting transferredFormatting = ChatFormatting.GRAY;
        String transferredSign = "";
        if (transferred > 0) {
            transferredFormatting = ChatFormatting.GREEN;
            transferredSign = "+";
        } else if (transferred < 0) {
            transferredFormatting = ChatFormatting.RED;
        }
        double toClose = ((StargateEnergyManager)((StargateContainer)this.f_97732_).gateTile.getEnergyManager()).getSecondsToClose();
        ChatFormatting toCloseFormatting = ChatFormatting.GRAY;
        if (toClose > 0.0) {
            toCloseFormatting = toClose < (double)JSGConfig.Stargate.instabilitySeconds.get() ? ChatFormatting.DARK_RED : ChatFormatting.GREEN;
        }
        if (GuiHelper.isPointInRegion(10, 69, 156, 6, mouseX - this.getGuiLeft(), mouseY - this.getGuiTop())) {
            ArrayList<String> power = new ArrayList<String>();
            power.add(I18n.format("gui.stargate.energyBuffer"));
            power.add(String.valueOf(ChatFormatting.GRAY) + String.format("%,d / %,d FE", this.energyStored, this.maxEnergyStored));
            power.add(String.valueOf(transferredFormatting) + transferredSign + String.format("%,d FE/t", transferred));
            if (toClose >= 0.0) {
                power.add(String.valueOf(toCloseFormatting) + String.format("%.2f s", toClose));
            }
            GuiHelper.drawHoveringText(graphics, this.f_96547_, power, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
    }

    public void m_7379_() {
        this.saveConfig();
        this.saveIrisCode();
        super.m_7379_();
    }

    private void saveConfig() {
        JSGPacketHandler.sendToServer(new SaveConfigToServer(this.pos, this.configTab.config));
        ((StargateContainer)this.f_97732_).gateTile.setConfig(this.configTab.getConfig());
    }

    private void saveIrisCode() {
        JSGPacketHandler.sendToServer(new SaveIrisCodeToServer(this.pos, this.irisTab.getCode(), this.irisTab.getIrisMode()));
        ((StargateContainer)this.f_97732_).gateTile.getIrisManager().setIrisCode(this.irisTab.getCode());
        ((StargateContainer)this.f_97732_).gateTile.getIrisManager().setIrisMode(this.irisTab.getIrisMode());
    }
}

