/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.sound;

import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.api.sound.IPositionedSound;
import dev.tauri.jsg.api.sound.ISoundEvent;
import dev.tauri.jsg.api.sound.client.JSGSoundHelperClient;
import dev.tauri.jsg.packet.JSGPacketHandler;
import dev.tauri.jsg.packet.packets.SoundPositionedPlayToClient;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.network.PacketDistributor;

public class JSGSoundHelper {
    public static void playPositionedSound(@Nullable Level world, BlockPos pos, IPositionedSound soundEnum, boolean play) {
        if (world == null) {
            return;
        }
        if (world.f_46443_) {
            JSGSoundHelperClient.playPositionedSoundClientSide(pos, soundEnum, play);
            return;
        }
        if (play) {
            world.m_220407_(GameEvent.f_223702_, pos, GameEvent.Context.m_223722_((BlockState)world.m_8055_(pos)));
        }
        JSGPacketHandler.sendToClient(new SoundPositionedPlayToClient(pos, soundEnum, play), new PacketDistributor.TargetPoint((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 512.0, world.m_46472_()));
    }

    public static void playSoundEventClientSide(Level world, BlockPos pos, ISoundEvent soundEventEnum, float pitch) {
        world.m_220407_(GameEvent.f_223702_, pos, GameEvent.Context.m_223722_((BlockState)world.m_8055_(pos)));
        world.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (SoundEvent)soundEventEnum.getInstance().get(), SoundSource.BLOCKS, (float)((double)soundEventEnum.getVolume() * JSGConfig.General.volume.get()), pitch);
    }

    public static void playSoundEvent(Level world, BlockPos pos, ISoundEvent soundEventEnum) {
        JSGSoundHelper.playSoundEvent(world, pos, soundEventEnum, 1.0f);
    }

    public static void playSoundEvent(Level world, BlockPos pos, ISoundEvent soundEventEnum, float pitch) {
        JSGSoundHelper.playSoundEventClientSide(world, pos, soundEventEnum, pitch);
    }

    public static void playSoundToPlayer(ServerPlayer player, ISoundEvent soundEventEnum, BlockPos pos) {
        player.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(BuiltInRegistries.f_256894_.m_263177_((Object)((SoundEvent)soundEventEnum.getInstance().get())), SoundSource.BLOCKS, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (float)((double)soundEventEnum.getVolume() * JSGConfig.General.volume.get()), 1.0f, player.m_217043_().m_188505_()));
    }
}

