/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.sound;

import dev.tauri.jsg.api.sound.IPositionedSound;
import dev.tauri.jsg.api.sound.client.JSGMainMenuSound;
import dev.tauri.jsg.api.sound.client.JSGPositionedSound;
import dev.tauri.jsg.registry.SoundRegistry;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class PositionedSound
implements IPositionedSound {
    private static int currentOrdinal = 0;
    private static final Map<Integer, PositionedSound> REGISTRY = new HashMap<Integer, PositionedSound>();
    public static final PositionedSound WORMHOLE_TRAVEL = new PositionedSound("misc.stargate.wormhole.travel", true, 1.0f).register(() -> SoundRegistry.REGISTER);
    public static final PositionedSound MILKYWAY_RING_ROLL = new PositionedSound("block.stargate.milkyway.ring_roll.loop", true, 1.0f).register(() -> SoundRegistry.REGISTER);
    public static final PositionedSound MILKYWAY_RING_ROLL_START = new PositionedSound("block.stargate.milkyway.ring_roll.start", false, 1.0f).register(() -> SoundRegistry.REGISTER);
    public static final PositionedSound UNIVERSE_RING_ROLL = new PositionedSound("block.stargate.universe.ring_roll.loop", true, 1.0f).register(() -> SoundRegistry.REGISTER);
    public static final PositionedSound UNIVERSE_RING_ROLL_START = new PositionedSound("block.stargate.universe.ring_roll.start", false, 1.0f).register(() -> SoundRegistry.REGISTER);
    public static final PositionedSound PEGASUS_RING_ROLL = new PositionedSound("block.stargate.pegasus.ring_roll.loop", true, 1.0f).register(() -> SoundRegistry.REGISTER);
    public static final PositionedSound PEGASUS_RING_ROLL_START = new PositionedSound("block.stargate.pegasus.ring_roll.start", false, 1.0f).register(() -> SoundRegistry.REGISTER);
    public static final PositionedSound MOVIE_RING_ROLL = new PositionedSound("block.stargate.movie.ring_roll.loop", true, 1.0f).register(() -> SoundRegistry.REGISTER);
    public static final PositionedSound MOVIE_RING_ROLL_START = new PositionedSound("block.stargate.movie.ring_roll.start", false, 1.0f).register(() -> SoundRegistry.REGISTER);
    public static final PositionedSound WORMHOLE_LOOP = new PositionedSound("misc.stargate.wormhole.loop", true, 1.0f).register(() -> SoundRegistry.REGISTER);
    public static final PositionedSound SHIELD_HUMMING = new PositionedSound("misc.stargate.shield.humming", true, 1.0f).register(() -> SoundRegistry.REGISTER);
    public static final PositionedSound MAINMENU_INTRO = new PositionedSound("music.menu.intro", false, 1.0f).register(() -> SoundRegistry.REGISTER);
    public static final PositionedSound KINO_FLYBY = new PositionedSound("misc.kino.flyby", true, 1.0f).register(() -> SoundRegistry.REGISTER);
    public static final PositionedSound MAINMENU_ACT1 = new PositionedSound("music.menu.act1", true, 1.0f).register(() -> SoundRegistry.REGISTER);
    public static final PositionedSound MAINMENU_ACT2 = new PositionedSound("music.menu.act2", true, 1.0f).register(() -> SoundRegistry.REGISTER);
    public static final PositionedSound MAINMENU_ACT3 = new PositionedSound("music.menu.act3", true, 1.0f).register(() -> SoundRegistry.REGISTER);
    public static final PositionedSound MAINMENU_ACT6 = new PositionedSound("music.menu.act6", true, 1.0f).register(() -> SoundRegistry.REGISTER);
    public static final PositionedSound PRINTER_PRINTING = new PositionedSound("misc.printer.printing", false, 1.0f).register(() -> SoundRegistry.REGISTER);
    public final String id;
    public final int ordinal = currentOrdinal++;
    public final ResourceLocation resourceLocation;
    public final boolean loop;
    public final float volume;
    public RegistryObject<SoundEvent> event;

    public PositionedSound(String id, boolean loop, float volume) {
        this("jsg", id, loop, volume);
    }

    public PositionedSound(String modId, String id, boolean loop, float volume) {
        this.id = id;
        this.resourceLocation = new ResourceLocation(modId, id);
        this.loop = loop;
        this.volume = volume * 3.0f;
        REGISTRY.put(this.ordinal, this);
    }

    public PositionedSound register(Supplier<DeferredRegister<SoundEvent>> soundRegistry) {
        this.event = soundRegistry.get().register(this.id, () -> SoundEvent.m_262856_((ResourceLocation)this.resourceLocation, (float)64.0f));
        return this;
    }

    public static PositionedSound get(int id) {
        return REGISTRY.get(id);
    }

    public static Collection<PositionedSound> values() {
        return REGISTRY.values();
    }

    public static void load() {
    }

    @Override
    public JSGPositionedSound getInstance(BlockPos pos) {
        return new JSGPositionedSound(pos, (SoundEvent)this.event.get(), SoundSource.BLOCKS, SoundInstance.m_235150_(), this.loop, this.volume);
    }

    @Override
    public JSGMainMenuSound getInstanceAbsolute(Supplier<Float> volumeSupplier) {
        return new JSGMainMenuSound((SoundEvent)this.event.get(), SoundSource.BLOCKS, SoundInstance.m_235150_(), this.loop, volumeSupplier);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public ResourceLocation getLocation() {
        return this.resourceLocation;
    }

    @Override
    public boolean isLoopSound() {
        return this.loop;
    }

    @Override
    public float getVolume() {
        return this.volume;
    }

    @Override
    public RegistryObject<SoundEvent> getInstance() {
        return this.event;
    }
}

