/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate;

import dev.tauri.jsg.api.stargate.animation.EnumDialingType;
import dev.tauri.jsg.api.stargate.animation.IAddressDialSequence;
import dev.tauri.jsg.api.stargate.network.address.StargateAddressDynamic;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class StargateAddressDialSequence
implements IAddressDialSequence {
    protected final IAddressDialSequence.DialNextConsumer consumeSymbol;
    protected StargateAddressDynamic originalAddress;
    protected StargateAddressDynamic address;
    protected EnumDialingType dialingType;
    protected boolean noEnergy;
    protected boolean ignoreMaxChevrons;

    protected StargateAddressDialSequence(IAddressDialSequence.DialNextConsumer consumeSymbol) {
        this.consumeSymbol = consumeSymbol;
    }

    public StargateAddressDialSequence(IAddressDialSequence.DialNextConsumer consumeSymbol, CompoundTag tag) {
        this(consumeSymbol);
        this.deserializeNBT(tag);
    }

    public StargateAddressDialSequence(IAddressDialSequence.DialNextConsumer consumeSymbol, StargateAddressDynamic address, boolean noEnergy, boolean ignoreMaxChevrons, EnumDialingType dialingType) {
        this(consumeSymbol);
        this.originalAddress = new StargateAddressDynamic(address);
        this.address = new StargateAddressDynamic(address);
        this.noEnergy = noEnergy;
        this.dialingType = dialingType;
        this.ignoreMaxChevrons = ignoreMaxChevrons;
    }

    @Override
    public StargateAddressDynamic getOriginalAddress() {
        return new StargateAddressDynamic(this.originalAddress);
    }

    public void dialNext() {
        this.consumeSymbol.accept(this.address.popFirst(), this.noEnergy, this.ignoreMaxChevrons, this.dialingType);
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_("originalAddress", (Tag)this.originalAddress.serializeNBT());
        compound.m_128365_("address", (Tag)this.address.serializeNBT());
        compound.m_128405_("dialingType", this.dialingType.ordinal());
        compound.m_128379_("noEnergy", this.noEnergy);
        compound.m_128379_("ignoreMaxChevrons", this.ignoreMaxChevrons);
        return compound;
    }

    public void deserializeNBT(CompoundTag compound) {
        this.originalAddress = new StargateAddressDynamic(compound.m_128469_("originalAddress"));
        this.address = new StargateAddressDynamic(compound.m_128469_("address"));
        this.dialingType = EnumDialingType.values()[compound.m_128451_("dialingType")];
        this.noEnergy = compound.m_128471_("noEnergy");
        this.ignoreMaxChevrons = compound.m_128471_("ignoreMaxChevrons");
    }
}

