/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.animation;

import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.api.stargate.Stargate;
import dev.tauri.jsg.api.stargate.StargateWithIris;
import dev.tauri.jsg.api.stargate.animation.AbstractBlackHoleAnimationState;
import dev.tauri.jsg.api.state.StateType;
import dev.tauri.jsg.api.util.JSGAxisAlignedBB;
import dev.tauri.jsg.api.util.math.MathHelper;
import dev.tauri.jsg.config.JSGConfigUtil;
import dev.tauri.jsg.packet.JSGPacketHandler;
import dev.tauri.jsg.packet.packets.stargate.StargateMotionAndRotationToClient;
import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BlackHoleAnimationState
extends AbstractBlackHoleAnimationState {
    public static final int TIME_BEFORE_DEPTH_CHANGE = 400;
    public static final int MAX_GRAVITY_FIELD_RADIUS = 75;
    public static final int BACK_VORTEX_FORMING_ANIMATION_TIME = 12000;

    public BlackHoleAnimationState(@Nonnull Stargate<?> stargate) {
        super(stargate);
    }

    @Override
    public void setConnectedToBlackHole(boolean connected, boolean isSource) {
        if (connected && !this.isConnectedToBlackHole) {
            this.isConnectedToBlackHoleFrom = this.stargate.getDialingManager().getConnection().getSince();
        }
        this.isConnectedToBlackHole = connected;
        this.isSource = isSource;
        this.stargate.setStargateChanged();
        this.sendUpdateToClient();
    }

    @Override
    public void sendUpdateToClient() {
        this.stargate.getAndSendState(StateType.BLACK_HOLE_ANIMATION_UPDATE);
    }

    @Override
    public void tick(@NotNull Level level) {
        if (!this.isConnectedToBlackHole) {
            return;
        }
        if (level.f_46443_) {
            return;
        }
        if (!this.stargate.getDialingManager().getStargateState().engaged() && !this.stargate.getDialingManager().getStargateState().unstable()) {
            this.setConnectedToBlackHole(false, false);
            return;
        }
        if (this.stargate.getDialingManager().getStargateState().unstable()) {
            return;
        }
        if (this.getGravitationalFieldStrength() > 0.0f) {
            this.suckEntities((ServerLevel)level);
        }
        if (this.getBackVortexDepth() != 0.0f && JSGConfig.Stargate.blackHoleCanDestroyBlocks.get()) {
            this.destroyBlocksInBackVortex((ServerLevel)level);
        }
    }

    protected void destroyBlocksInBackVortex(ServerLevel level) {
        float depth = this.getBackVortexDepth();
        BlockPos center = this.stargate.getGateCenterPos().m_121955_((Vec3i)this.stargate.blockPosition().m_142393_(-1));
        if ((double)(depth * 5.0f) <= 0.5) {
            return;
        }
        int i = 0;
        while ((float)i < Math.abs(depth * 5.0f)) {
            int z = (i + 1) * (depth > 0.0f ? -1 : 1);
            double minXY = Math.ceil((depth * 5.0f - (float)i) / 2.0f);
            double maxXY = -Math.ceil((depth * 5.0f - (float)i) / 2.0f);
            JSGAxisAlignedBB partBox = new JSGAxisAlignedBB(minXY, minXY, z, maxXY, maxXY, z + 1).offset(center);
            partBox = this.stargate.relative(partBox, new Vec3(0.0, 0.0, 0.0));
            BlockPos.m_121921_((AABB)partBox).forEach(blockPos -> {
                if (!JSGConfigUtil.canBlackHoleDestroyBlock(level.m_8055_(blockPos))) {
                    return;
                }
                level.m_46961_(blockPos, false);
            });
            ++i;
        }
    }

    protected void suckEntities(@NotNull ServerLevel level) {
        int currentRadius;
        StargateWithIris irisCapable;
        BlockPos gateCenter = this.stargate.getGateCenterPos();
        float strength = this.getGravitationalFieldStrength();
        Stargate stargate = this.stargate;
        if (stargate instanceof StargateWithIris && (irisCapable = (StargateWithIris)stargate).getIrisManager().isIrisClosed()) {
            if (irisCapable.getIrisManager().hasPhysicalIris() && strength >= 0.5f && level.f_46441_.m_188501_() < strength - 0.5f) {
                irisCapable.getIrisManager().hitIris();
            }
            strength /= 2.0f;
        }
        if ((currentRadius = (int)(75.0f * (strength / 2.0f))) <= 0) {
            return;
        }
        JSGAxisAlignedBB box = new JSGAxisAlignedBB((float)(-currentRadius) / 4.0f, (float)(-currentRadius) / 4.0f, 0.0, (float)currentRadius / 4.0f, (float)currentRadius / 4.0f, (float)currentRadius * 2.0f);
        box = this.stargate.relative(box, new Vec3(0.0, 0.0, 0.0)).move(this.stargate.getGateCenterPos().m_121996_((Vec3i)this.stargate.blockPosition()));
        List entities = level.m_45933_(null, (AABB)box);
        for (Entity entity : entities) {
            Vec3 ePos = entity.m_20182_();
            double distanceToGateCenter = Math.sqrt(gateCenter.m_203193_((Position)ePos));
            double motionFactor = ((double)(currentRadius * 2) - distanceToGateCenter) / (double)(currentRadius * 10);
            if (motionFactor <= 0.0) continue;
            Vec3 vectorToGate = new Vec3((double)gateCenter.m_123341_() - ePos.m_7096_(), (double)gateCenter.m_123342_() - ePos.m_7098_(), (double)gateCenter.m_123343_() - ePos.m_7094_()).m_82541_();
            vectorToGate = vectorToGate.m_82542_(motionFactor, motionFactor, motionFactor);
            Vec3 newMotion = entity.m_20184_().m_82549_(vectorToGate);
            if (this.isSource) {
                newMotion = newMotion.m_82548_();
            }
            entity.m_20256_(newMotion);
            if (!(entity instanceof ServerPlayer)) continue;
            ServerPlayer sp = (ServerPlayer)entity;
            JSGPacketHandler.sendTo(new StargateMotionAndRotationToClient(newMotion, entity.m_146909_(), entity.m_146908_(), false, true), sp);
        }
        if (this.isSource || !JSGConfig.Stargate.blackHoleCanSuckBlocks.get()) {
            return;
        }
        BlockPos.m_121921_((AABB)box).forEach(blockPos -> {
            BlockPos pos = blockPos.m_7949_();
            double distanceToGateCenter = Math.sqrt(gateCenter.m_203193_((Position)pos.m_252807_())) * 1.5;
            double motionFactor = ((double)(currentRadius * 2) - distanceToGateCenter) / (double)(currentRadius * 10);
            if (motionFactor <= 0.0) {
                return;
            }
            Vec3 vectorToGate = new Vec3((double)(gateCenter.m_123341_() - pos.m_123341_()), (double)(gateCenter.m_123342_() - pos.m_123342_()), (double)(gateCenter.m_123343_() - pos.m_123343_())).m_82541_();
            vectorToGate = vectorToGate.m_82542_(motionFactor, motionFactor, motionFactor);
            this.suckBlock(level, (BlockPos)blockPos, vectorToGate);
        });
    }

    @ParametersAreNonnullByDefault
    protected void suckBlock(ServerLevel level, BlockPos pos, Vec3 forceVector) {
        if ((double)(level.f_46441_.m_188501_() * 3.0f) > forceVector.m_82553_()) {
            return;
        }
        double forceScalar = Math.abs(forceVector.m_82553_() * 10.0 + (double)((level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 2.0f));
        BlockState blockstate = level.m_8055_(pos);
        if (blockstate.m_60795_()) {
            return;
        }
        if (!JSGConfigUtil.canBlackHoleDestroyBlock(blockstate)) {
            return;
        }
        float strength = blockstate.m_60800_((BlockGetter)level, pos);
        if ((double)(strength * Math.min(1.0f, level.f_46441_.m_188501_() * 1.5f)) > forceScalar) {
            return;
        }
        level.m_46961_(pos, true);
    }

    @Override
    public float getBackVortexDepth() {
        if (!this.isConnectedToBlackHole) {
            return 0.0f;
        }
        float f = (float)(this.stargate.getTime() - this.isConnectedToBlackHoleFrom - 400L) / 12000.0f;
        return (float)(this.isSource ? -1 : 1) * MathHelper.clamp(f, 0.0f, 1.0f);
    }

    @Override
    public double getBackVortexAngle() {
        if (!this.isConnectedToBlackHole) {
            return 0.0;
        }
        double f = (double)(this.stargate.getTime() - this.isConnectedToBlackHoleFrom) / 12000.0;
        return MathHelper.clamp(f, 0.0, 4.0) * (double)(this.stargate.getTime() - this.isConnectedToBlackHoleFrom) / 2.0;
    }

    @Override
    public float getBackVortexRed() {
        if (!this.isConnectedToBlackHole) {
            return 0.0f;
        }
        return MathHelper.clamp((Math.abs(this.getBackVortexDepth()) - 0.3f) / 0.7f, 0.0f, 1.0f);
    }

    @Override
    public float getGravitationalFieldStrength() {
        if (!this.isConnectedToBlackHole) {
            return 0.0f;
        }
        return Math.abs(this.getBackVortexDepth());
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.isConnectedToBlackHole);
        buf.writeLong(this.isConnectedToBlackHoleFrom);
        buf.writeBoolean(this.isSource);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.isConnectedToBlackHole = buf.readBoolean();
        this.isConnectedToBlackHoleFrom = buf.readLong();
        this.isSource = buf.readBoolean();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128379_("isConnectedToBlackHole", this.isConnectedToBlackHole);
        compound.m_128356_("isConnectedToBlackHoleFrom", this.isConnectedToBlackHoleFrom);
        compound.m_128379_("isIncoming", this.isSource);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        this.isConnectedToBlackHole = compound.m_128471_("isConnectedToBlackHole");
        this.isConnectedToBlackHoleFrom = compound.m_128454_("isConnectedToBlackHoleFrom");
        this.isSource = compound.m_128471_("isIncoming");
    }
}

