/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.animation;

import dev.tauri.jsg.api.state.State;
import io.netty.buffer.ByteBuf;

public class IrisAnimationState
extends State {
    public static final int IRIS_HIT_ANIMATION_LENGTH = 5;
    protected long started;
    protected boolean impact = false;
    protected boolean collapse = false;
    protected boolean collapseBlackHole = false;

    public static IrisAnimationState hit(long time) {
        IrisAnimationState state = new IrisAnimationState();
        state.started = time;
        state.impact = true;
        state.collapse = false;
        state.collapseBlackHole = false;
        return state;
    }

    public static IrisAnimationState collapse(long time, boolean blackHole) {
        IrisAnimationState state = new IrisAnimationState();
        state.started = time;
        state.impact = false;
        state.collapse = !blackHole;
        state.collapseBlackHole = blackHole;
        return state;
    }

    public float getIrisImpactOffset(long tick, float partialTicks) {
        if (!this.impact) {
            return 0.0f;
        }
        float coef = (float)(tick - this.started) / 5.0f;
        if (coef < 0.0f) {
            coef = 0.0f;
        }
        if (coef > 1.0f) {
            this.impact = false;
            return 0.0f;
        }
        return (float)Math.sin((double)coef * Math.PI);
    }

    public float getIrisCollapseCoef(long tick, float partialTicks) {
        return 0.0f;
    }

    public float getIrisCollapseBlackHoleCoef(long tick, float partialTicks) {
        return 0.0f;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.started);
        buf.writeBoolean(this.impact);
        buf.writeBoolean(this.collapse);
        buf.writeBoolean(this.collapseBlackHole);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.started = buf.readLong();
        this.impact = buf.readBoolean();
        this.collapse = buf.readBoolean();
        this.collapseBlackHole = buf.readBoolean();
    }
}

