/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.animation.chevron;

import dev.tauri.jsg.api.registry.ScheduledTaskType;
import dev.tauri.jsg.api.sound.StargateSoundEventEnum;
import dev.tauri.jsg.api.stargate.ChevronEnum;
import dev.tauri.jsg.api.stargate.EnumStargateState;
import dev.tauri.jsg.api.stargate.manager.IStargateDialingManager;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolInterface;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolTypeRegistry;
import dev.tauri.jsg.api.stargate.result.StargateChevronEngageResult;
import dev.tauri.jsg.api.stargate.result.StargateOpenResult;
import dev.tauri.jsg.api.util.NBTUtils;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.stargate.animation.chevron.StargateChevronsState;
import dev.tauri.jsg.stargate.manager.dialing.StargateAbstractDialingManager;
import dev.tauri.jsg.stargate.manager.state.StargateAbstractStateManager;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@FieldsAreNonnullByDefault
public abstract class StargatePegasusChevronsState
extends StargateChevronsState {
    protected final Map<Integer, SymbolInterface> activatedSymbols = new HashMap<Integer, SymbolInterface>();

    public StargatePegasusChevronsState(StargateAbstractStateManager<?, ?> stateManager) {
        super(stateManager);
    }

    public static int getCorrectedSlot(int slot) {
        return (36 - (slot - 8)) % 36;
    }

    public static int slotFromChevron(ChevronEnum chevron) {
        int slot = chevron.rotationIndex * 4 - 1;
        if (slot < 0) {
            slot += 36;
        }
        return slot;
    }

    public static Optional<ChevronEnum> chevronFromSlot(int slot) {
        if ((slot + 1) % 4 != 0) {
            return Optional.empty();
        }
        ChevronEnum chevron = ChevronEnum.fromRotationIndex((slot + 1) % 36 / 4);
        return Optional.ofNullable(chevron);
    }

    public void activateSlot(int slot, @Nullable SymbolInterface symbol) {
        if (symbol == null) {
            return;
        }
        this.activatedSymbols.put(slot, symbol);
        this.send();
    }

    public void deactivateSlot(int slot) {
        this.activatedSymbols.remove(slot);
        this.send();
    }

    public void deactivateAllSlots() {
        this.activatedSymbols.clear();
        this.send();
    }

    public boolean isAnySlotActive() {
        return !this.activatedSymbols.isEmpty();
    }

    public boolean isSlotActive(int slot) {
        return this.activatedSymbols.containsKey(slot);
    }

    public Optional<SymbolInterface> getSymbolAtSlot(int slot) {
        return Optional.ofNullable(this.activatedSymbols.get(slot));
    }

    @Override
    public void executeTask(ScheduledTaskType scheduledTask, CompoundTag customData) {
        StargateAbstractBaseBE stargate = (StargateAbstractBaseBE)this.stateManager.stargate;
        IStargateDialingManager dialingManager = stargate.getDialingManager();
        if (scheduledTask == ScheduledTaskType.STARGATE_CHEVRON_LIGHT_UP) {
            StargateChevronEngageResult result = ((StargateAbstractDialingManager)dialingManager).onChevronActivates(customData);
            if (result != null && result != StargateChevronEngageResult.OK) {
                if (result == StargateChevronEngageResult.FAILED_FAIL_GATE) {
                    this.onChevronFailedToLock(true);
                } else {
                    this.onChevronFailedToLock(customData.m_128471_("checkConnection"));
                }
            }
            if (customData.m_128471_("setIdle")) {
                ((StargateAbstractDialingManager)dialingManager).setStargateState(EnumStargateState.IDLE);
            }
            stargate.playSoundEvent(StargateSoundEventEnum.CHEVRON_OPEN);
            StargateChevronsState.ChevronState chevronState = this.get(customData.m_128451_("chevron"), customData.m_128471_("isFinal"));
            chevronState.lock();
            if (result != null && result.ok()) {
                this.activateSlot(StargatePegasusChevronsState.slotFromChevron(chevronState.getChevron()), ((StargateAbstractDialingManager)dialingManager).getDialedAddress().getLast());
            }
        } else if (scheduledTask == ScheduledTaskType.STARGATE_CHEVRON_FAIL) {
            if (customData.m_128471_("setIdle")) {
                ((StargateAbstractDialingManager)dialingManager).dialingFailed(StargateOpenResult.ADDRESS_MALFORMED);
            }
        } else if (scheduledTask == ScheduledTaskType.STARGATE_CLEAR_CHEVRONS) {
            this.deactivateAllSlots();
            super.executeTask(scheduledTask, customData);
        } else {
            super.executeTask(scheduledTask, customData);
        }
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        NBTUtils.mapToBytes(this.activatedSymbols, buf, ByteBuf::writeInt, (b, v) -> {
            if (v == null) {
                v = SymbolTypeRegistry.PEGASUS.getOrigin();
            }
            b.writeInt(v.getId());
        });
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        NBTUtils.mapFromBytes(this.activatedSymbols, buf, ByteBuf::readInt, b -> SymbolTypeRegistry.PEGASUS.valueOf(b.readInt()));
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        compound.m_128365_("activatedSymbols", (Tag)NBTUtils.serializeMap(this.activatedSymbols, (c, k) -> c.m_128405_("slot", k.intValue()), (c, v) -> c.m_128405_("symbol", v.getId())));
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        NBTUtils.deSerializeMap(this.activatedSymbols, compound.m_128469_("activatedSymbols"), c -> c.m_128451_("slot"), c -> SymbolTypeRegistry.PEGASUS.valueOf(c.m_128451_("symbol")));
    }
}

