/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.animation.incoming;

import dev.tauri.jsg.api.util.blockentity.ITickable;
import dev.tauri.jsg.stargate.manager.dialing.StargateAbstractDialingManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;

public class IncomingAnimation<D extends StargateAbstractDialingManager<?>>
implements INBTSerializable<CompoundTag>,
ITickable {
    protected final D dialer;
    protected long started;
    protected int addressLength;
    protected int duration;
    protected int lastRun = -2;
    protected boolean finished = false;

    public IncomingAnimation(D dialer, CompoundTag tag) {
        this.dialer = dialer;
        this.deserializeNBT(tag);
    }

    public IncomingAnimation(long time, D dialer, int addressLength, int duration) {
        this.dialer = dialer;
        this.duration = duration;
        this.addressLength = addressLength;
        this.started = time;
    }

    public void start() {
        this.finished = false;
        this.lastRun = -1;
        if (this.duration <= 0) {
            this.finish();
        }
    }

    public void stop() {
        this.finished = true;
    }

    public int getParts() {
        return this.addressLength;
    }

    public void runPart(int partIndex) {
    }

    public void finish() {
        int countToRun;
        if (this.finished) {
            return;
        }
        if (this.lastRun < -1) {
            this.start();
        }
        if ((countToRun = this.getParts() - this.lastRun) <= 0) {
            return;
        }
        for (int i = this.lastRun + 1; i <= this.lastRun + countToRun; ++i) {
            this.runPart(i);
        }
        this.stop();
    }

    @Override
    public void tick(@NotNull Level level) {
        double ticksPerPart;
        double shouldRunIndexNow;
        double difference;
        if (level.f_46443_) {
            return;
        }
        if (this.finished) {
            return;
        }
        long ticks = level.m_46467_();
        if (this.lastRun < -1) {
            this.start();
        }
        if ((difference = (shouldRunIndexNow = (ticksPerPart = (double)this.duration / (double)this.getParts()) > 0.0 ? Math.floor((double)(ticks - this.started) / ticksPerPart) : (double)(this.getParts() - 1)) - (double)this.lastRun) > 0.0) {
            int lastRun = this.lastRun;
            int i = ++lastRun;
            while ((double)i < (double)lastRun + difference) {
                this.runPart(i);
                this.lastRun = i;
                if (i == this.getParts() - 1) {
                    this.stop();
                }
                ++i;
            }
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128356_("started", this.started);
        compound.m_128405_("lastRun", this.lastRun);
        compound.m_128405_("duration", this.duration);
        compound.m_128379_("finished", this.finished);
        compound.m_128405_("addressLength", this.addressLength);
        return compound;
    }

    public void deserializeNBT(CompoundTag compoundTag) {
        this.started = compoundTag.m_128454_("started");
        this.lastRun = compoundTag.m_128451_("lastRun");
        this.duration = compoundTag.m_128451_("duration");
        this.finished = compoundTag.m_128471_("finished");
        this.addressLength = compoundTag.m_128451_("addressLength");
    }
}

