/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.animation.spinning;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.api.integration.StargateComputerEvents;
import dev.tauri.jsg.api.sound.StargateSoundEventEnum;
import dev.tauri.jsg.api.stargate.animation.EnumSpinDirection;
import dev.tauri.jsg.api.stargate.animation.ISpinHelper;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolInterface;
import dev.tauri.jsg.api.state.State;
import dev.tauri.jsg.api.state.StateType;
import dev.tauri.jsg.api.util.math.MathFunctionLinear;
import dev.tauri.jsg.api.util.math.MathFunctionQuadratic;
import dev.tauri.jsg.api.util.math.MathRange;
import dev.tauri.jsg.api.util.math.MathRangedFunction;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.stargate.manager.StargateSoundManager;
import dev.tauri.jsg.stargate.manager.state.StargateAbstractStateManager;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.Pair;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassicSpinHelper
extends State
implements ISpinHelper {
    public static float A_ANGLE_PER_TICK = 1.8f;
    public static final float U_SPEEDUP_TIME = 35.0f;
    public static final float S_STOP_TIME = 25.0f;
    public static final float MIN_ANGLE_TO_DIAL = 60.0f;
    protected final StargateAbstractBaseBE<?, ?> stargate;
    protected final Consumer<CompoundTag> onSpinStop;
    protected boolean isSpinning;
    protected double lastStableRingAngle;
    protected double lastRingVelocity;
    protected double ringRotationStart;
    protected double targetRingAngle;
    protected Boolean rotateFreely = null;
    protected float speedFactor = 1.0f;
    protected EnumSpinDirection direction = EnumSpinDirection.CLOCKWISE;
    protected CompoundTag stopSpinData;

    public ClassicSpinHelper(StargateAbstractBaseBE<?, ?> stargate, Consumer<CompoundTag> onSpinStop) {
        this.stargate = stargate;
        this.onSpinStop = onSpinStop;
    }

    @Override
    public SymbolInterface getCurrentTopSymbol(float bounds) {
        return this.stargate.getSymbolType().getSymbolByAngle(this.getRingAngle(), bounds);
    }

    @Override
    public float getRingAngle() {
        return (float)this.apply(this.stargate.getTime(), true);
    }

    @Override
    public double apply(double tick, boolean clampAngle) {
        double a;
        double coef = tick - this.ringRotationStart;
        if (coef <= 0.0) {
            a = this.lastStableRingAngle;
        } else {
            a = this.calculate(coef);
            a = this.lastStableRingAngle + a * (double)this.direction.mul;
        }
        if (clampAngle) {
            while (a < 0.0) {
                a += 360.0;
            }
            a %= 360.0;
        }
        return a;
    }

    private float getDurationBeforeStop(double targetAngle) {
        return (float)(targetAngle / (double)(A_ANGLE_PER_TICK * this.speedFactor) + 5.0);
    }

    protected double getAngleToTarget() {
        double angleDiff;
        for (angleDiff = (this.targetRingAngle - this.lastStableRingAngle) * (double)this.direction.mul; angleDiff < 60.0; angleDiff += 360.0) {
        }
        return angleDiff;
    }

    @Override
    public float getTickToStop() {
        double speed = Math.abs(this.lastRingVelocity);
        float stopTimeCoefficient = (float)(speed / (double)(A_ANGLE_PER_TICK * this.speedFactor));
        return stopTimeCoefficient * 25.0f;
    }

    @Override
    public float getDuration(double angleDiff) {
        return this.getDurationBeforeStop(angleDiff) + 25.0f;
    }

    protected double calculate(double tick) {
        if (!this.isSpinning) {
            return 0.0;
        }
        if (this.rotateFreely != null) {
            if (!this.rotateFreely.booleanValue()) {
                float speed = (float)Math.abs(this.lastRingVelocity);
                float ticksToStop = this.getTickToStop();
                if (ticksToStop <= 0.0f) {
                    this.lastStableRingAngle = this.targetRingAngle;
                    JSG.logger.warn("Speed of ring is 0 while trying to stop it!");
                    this.onStopped();
                    return 0.0;
                }
                MathFunctionQuadratic stopFunc = ClassicSpinHelper.getStopFunction(speed, 0.0f, ticksToStop, 0.0f);
                MathRange stopFuncRange = new MathRange(0.0f, ticksToStop);
                if (stopFuncRange.test(Float.valueOf((float)tick))) {
                    return stopFunc.apply((float)tick);
                }
                this.lastStableRingAngle += (double)(stopFunc.apply(ticksToStop) / (float)this.direction.mul);
                this.onStopped();
                return 0.0;
            }
            MathRangedFunction speedUp = ClassicSpinHelper.getSpeedupRangedFunction(A_ANGLE_PER_TICK * this.speedFactor, 35.0f);
            MathFunctionLinear spinFunc = ClassicSpinHelper.getLinearSpinFunction(A_ANGLE_PER_TICK * this.speedFactor);
            if (tick >= (double)speedUp.range.end) {
                return spinFunc.apply((float)tick);
            }
            return speedUp.function.apply((float)tick);
        }
        double angleDiff = this.getAngleToTarget();
        float durationBeforeStop = this.getDurationBeforeStop(angleDiff);
        if (durationBeforeStop < 35.0f) {
            durationBeforeStop = (durationBeforeStop + 25.0f) / 2.0f;
            float a = (float)(angleDiff / (double)durationBeforeStop);
            MathRangedFunction speedUp = ClassicSpinHelper.getSpeedupRangedFunction(a, durationBeforeStop);
            MathFunctionQuadratic stop = ClassicSpinHelper.getStopFunction(a, durationBeforeStop, durationBeforeStop, durationBeforeStop);
            if (new MathRange(durationBeforeStop, 2.0f * durationBeforeStop).test(Float.valueOf((float)tick))) {
                return stop.apply((float)tick);
            }
            if (speedUp.range.test(Float.valueOf((float)tick))) {
                return speedUp.function.apply((float)tick);
            }
            this.lastStableRingAngle = this.targetRingAngle;
            this.onStopped();
            return 0.0;
        }
        MathRangedFunction speedUp = ClassicSpinHelper.getSpeedupRangedFunction(A_ANGLE_PER_TICK * this.speedFactor, 35.0f);
        MathFunctionLinear spinFunc = ClassicSpinHelper.getLinearSpinFunction(A_ANGLE_PER_TICK * this.speedFactor);
        MathFunctionQuadratic stopFunc = ClassicSpinHelper.getStopFunction(A_ANGLE_PER_TICK * this.speedFactor, 35.0f, 25.0f, durationBeforeStop);
        MathRange spinFuncRange = new MathRange(35.0f, durationBeforeStop);
        MathRange stopFuncRange = new MathRange(durationBeforeStop, durationBeforeStop + 25.0f);
        if (stopFuncRange.test(Float.valueOf((float)tick))) {
            return stopFunc.apply((float)tick);
        }
        if (spinFuncRange.test(Float.valueOf((float)tick))) {
            return spinFunc.apply((float)tick);
        }
        if (speedUp.range.test(Float.valueOf((float)tick))) {
            return speedUp.function.apply((float)tick);
        }
        this.lastStableRingAngle = this.targetRingAngle;
        this.onStopped();
        return 0.0;
    }

    protected void onStopped() {
        this.isSpinning = false;
        this.rotateFreely = null;
        if (this.stargate.m_58904_() != null && !this.stargate.m_58904_().f_46443_) {
            ((StargateSoundManager)this.stargate.getSoundManager()).updateRingRollSound(false);
            this.stargate.playSoundEvent(StargateSoundEventEnum.RING_STOP);
            CompoundTag data = this.stopSpinData;
            this.stopSpinData = null;
            this.onSpinStop.accept(Optional.ofNullable(data).orElseGet(CompoundTag::new));
            this.stargate.m_6596_();
            ((StargateAbstractStateManager)this.stargate.getStateManager()).sendState(StateType.SPIN_STATE, this);
            this.sendSpinStop();
        }
    }

    @Override
    public boolean isSpinning() {
        return this.isSpinning;
    }

    @Override
    public float getRingVelocity() {
        return (float)(this.apply(this.stargate.getTime() + 1L, false) - this.apply(this.stargate.getTime(), false));
    }

    @Override
    public boolean stopSpinning(boolean clearStopData) {
        if (clearStopData) {
            this.stopSpinData = null;
            this.stargate.m_6596_();
        }
        if (!this.isSpinning() || this.rotateFreely != null && !this.rotateFreely.booleanValue()) {
            return false;
        }
        this.lastRingVelocity = this.getRingVelocity();
        this.lastStableRingAngle = this.apply(this.stargate.getTime(), true);
        this.ringRotationStart = this.stargate.getTime();
        this.rotateFreely = false;
        this.stargate.m_6596_();
        ((StargateAbstractStateManager)this.stargate.getStateManager()).sendState(StateType.SPIN_STATE, this);
        return true;
    }

    @Override
    public boolean rotateFreely(@NotNull EnumSpinDirection direction) {
        if (this.isSpinning()) {
            return false;
        }
        this.isSpinning = true;
        this.updateRingSpeedFromConfig();
        this.direction = direction;
        this.ringRotationStart = this.stargate.getTime();
        this.rotateFreely = true;
        this.stargate.m_6596_();
        ((StargateAbstractStateManager)this.stargate.getStateManager()).sendState(StateType.SPIN_STATE, this);
        if (this.stargate.m_58904_() != null && !this.stargate.m_58904_().f_46443_) {
            ((StargateSoundManager)this.stargate.getSoundManager()).updateRingRollSound(true);
            this.sendSpinStart();
        }
        return true;
    }

    @Override
    public Pair<Boolean, Float> moveTo(double angle, @NotNull EnumSpinDirection direction) {
        if (this.isSpinning()) {
            return Pair.of((Object)false, (Object)Float.valueOf(-1.0f));
        }
        this.isSpinning = true;
        this.rotateFreely = null;
        this.updateRingSpeedFromConfig();
        this.direction = direction;
        this.targetRingAngle = angle;
        this.ringRotationStart = this.stargate.getTime();
        this.stargate.m_6596_();
        ((StargateAbstractStateManager)this.stargate.getStateManager()).sendState(StateType.SPIN_STATE, this);
        if (this.stargate.m_58904_() != null && !this.stargate.m_58904_().f_46443_) {
            ((StargateSoundManager)this.stargate.getSoundManager()).updateRingRollSound(true);
            this.sendSpinStart();
        }
        return Pair.of((Object)true, (Object)Float.valueOf(this.getDuration(this.getAngleToTarget())));
    }

    @Override
    public Pair<Boolean, Float> moveTo(@NotNull SymbolInterface symbol, @NotNull EnumSpinDirection direction) {
        return this.moveTo(symbol.getAngle(), direction);
    }

    @Override
    public Pair<Boolean, Float> moveTo(@NotNull SymbolInterface symbol) {
        EnumSpinDirection direction = this.direction != null ? this.direction.opposite() : EnumSpinDirection.CLOCKWISE;
        return this.moveTo(symbol.getAngle(), direction);
    }

    public void setSpinStopData(@Nullable CompoundTag compound) {
        this.stopSpinData = compound;
        this.stargate.m_6596_();
    }

    @Override
    public Pair<Boolean, Float> moveToAndEngage(@NotNull SymbolInterface symbolInterface, boolean isFinal, boolean noEnergy, boolean ignoreMaxChevrons) {
        CompoundTag data = new CompoundTag();
        data.m_128405_("symbol", symbolInterface.getId());
        data.m_128379_("isFinal", isFinal);
        data.m_128379_("noEnergy", noEnergy);
        data.m_128379_("ignoreMaxChevrons", ignoreMaxChevrons);
        Pair<Boolean, Float> r = this.moveTo(symbolInterface);
        if (((Boolean)r.first()).booleanValue()) {
            this.setSpinStopData(data);
        }
        return r;
    }

    protected void updateRingSpeedFromConfig() {
        StargateAbstractBaseBE<?, ?> stargateAbstractBaseBE = this.stargate;
        if (stargateAbstractBaseBE instanceof StargateClassicBaseBE) {
            StargateClassicBaseBE configBe = (StargateClassicBaseBE)stargateAbstractBaseBE;
            this.speedFactor = configBe.getSpeedFactor();
        }
    }

    @Override
    public void tick(@NotNull Level level) {
        if (!level.f_46443_ && this.isSpinning()) {
            this.apply(level.m_46467_(), false);
        }
    }

    @Override
    public void onLoad(@NotNull Level level) {
        if (level.f_46443_) {
            this.stargate.getStateManager().requestState(StateType.SPIN_STATE);
        } else {
            ((StargateAbstractStateManager)this.stargate.getStateManager()).sendState(StateType.SPIN_STATE, this);
        }
    }

    private static MathRangedFunction getSpeedupRangedFunction(float a, float u) {
        return new MathRangedFunction(new MathRange(0.0f, u), new MathFunctionQuadratic(a / (2.0f * u), 0.0f, 0.0f));
    }

    private static MathFunctionQuadratic getStopFunction(float a, float u, float s, float x0) {
        return new MathFunctionQuadratic(-a / (2.0f * s), a + a * x0 / s, -(a * u / 2.0f + a * x0 * x0 / (2.0f * s)));
    }

    private static MathFunctionLinear getLinearSpinFunction(float a) {
        return new MathFunctionLinear(a, -a * 35.0f / 2.0f);
    }

    protected void sendSpinStart() {
        if (this.stargate.m_58904_() == null || this.stargate.m_58904_().m_5776_()) {
            return;
        }
        StargateComputerEvents.SPIN_START.apply(this.direction, Float.valueOf(this.speedFactor)).sendVia(this.stargate);
        this.stargate.getListenerHandler().gateRingSpin();
    }

    protected void sendSpinStop() {
        if (this.stargate.m_58904_() == null || this.stargate.m_58904_().m_5776_()) {
            return;
        }
        StargateComputerEvents.SPIN_STOP.apply(this.getCurrentTopSymbol()).sendVia(this.stargate);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128379_("isSpinning", this.isSpinning);
        compound.m_128347_("lastRingVelocity", this.lastRingVelocity);
        compound.m_128347_("lastStableRingAngle", this.lastStableRingAngle);
        compound.m_128347_("ringRotationStart", this.ringRotationStart);
        compound.m_128347_("targetRingAngle", this.targetRingAngle);
        if (this.rotateFreely != null) {
            compound.m_128379_("rotateFreely", this.rotateFreely.booleanValue());
        }
        compound.m_128350_("speedFactor", this.speedFactor);
        compound.m_128405_("direction", this.direction.ordinal());
        if (this.stopSpinData != null) {
            compound.m_128365_("stopSpinData", (Tag)this.stopSpinData);
        }
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        this.isSpinning = compound.m_128471_("isSpinning");
        this.lastRingVelocity = compound.m_128459_("lastRingVelocity");
        this.lastStableRingAngle = compound.m_128459_("lastStableRingAngle");
        this.ringRotationStart = compound.m_128459_("ringRotationStart");
        this.targetRingAngle = compound.m_128459_("targetRingAngle");
        this.rotateFreely = compound.m_128441_("rotateFreely") ? Boolean.valueOf(compound.m_128471_("rotateFreely")) : null;
        this.speedFactor = compound.m_128457_("speedFactor");
        this.direction = EnumSpinDirection.values()[compound.m_128451_("direction")];
        this.stopSpinData = compound.m_128441_("stopSpinData") ? compound.m_128469_("stopSpinData") : null;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.isSpinning);
        buf.writeDouble(this.lastRingVelocity);
        buf.writeDouble(this.lastStableRingAngle);
        buf.writeDouble(this.ringRotationStart);
        buf.writeDouble(this.targetRingAngle);
        if (this.rotateFreely != null) {
            buf.writeBoolean(true);
            buf.writeBoolean(this.rotateFreely.booleanValue());
        } else {
            buf.writeBoolean(false);
        }
        buf.writeFloat(this.speedFactor);
        buf.writeInt(this.direction.ordinal());
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.isSpinning = buf.readBoolean();
        this.lastRingVelocity = buf.readDouble();
        this.lastStableRingAngle = buf.readDouble();
        this.ringRotationStart = buf.readDouble();
        this.targetRingAngle = buf.readDouble();
        this.rotateFreely = buf.readBoolean() ? Boolean.valueOf(buf.readBoolean()) : null;
        this.speedFactor = buf.readFloat();
        this.direction = EnumSpinDirection.values()[buf.readInt()];
    }

    public void from(ClassicSpinHelper state) {
        this.isSpinning = state.isSpinning;
        this.lastRingVelocity = state.lastRingVelocity;
        this.lastStableRingAngle = state.lastStableRingAngle;
        this.ringRotationStart = state.ringRotationStart;
        this.targetRingAngle = state.targetRingAngle;
        this.rotateFreely = state.rotateFreely;
        this.speedFactor = state.speedFactor;
        this.direction = state.direction;
    }
}

