/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.manager;

import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.api.stargate.Stargate;
import dev.tauri.jsg.api.stargate.manager.IStargateAutoCloseManager;
import dev.tauri.jsg.api.stargate.network.StargatePos;
import dev.tauri.jsg.stargate.manager.AbstractStargateManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class StargateAutoCloseManager
extends AbstractStargateManager<Stargate<?>>
implements IStargateAutoCloseManager {
    private int secondsPassed;
    private int playersPassed;

    public StargateAutoCloseManager(Stargate<?> gateTile) {
        super(gateTile);
    }

    public void wormholeDisconnected() {
        this.secondsPassed = 0;
        this.playersPassed = 0;
    }

    public void playerPassing() {
        ++this.playersPassed;
    }

    @Override
    public boolean shouldClose(StargatePos sourceStargatePos) {
        if (this.stargate.getTime() % 20L == 0L) {
            Level sourceWorld = sourceStargatePos.getWorld();
            BlockPos sourcePos = sourceStargatePos.gatePos;
            boolean sourceLoaded = sourceWorld.m_46749_(sourcePos);
            if (this.playersPassed > 0) {
                AABB scanBox;
                int playerCount;
                this.secondsPassed = sourceLoaded ? ((playerCount = sourceWorld.m_6249_((Entity)null, scanBox = new AABB(sourcePos.m_121955_(new Vec3i(-10, -5, -10)), sourcePos.m_121955_(new Vec3i(10, 5, 10))), e -> {
                    if (e instanceof Player) {
                        Player p = (Player)e;
                        return !p.m_21224_();
                    }
                    return false;
                }).size()) == 0 ? ++this.secondsPassed : 0) : ++this.secondsPassed;
            }
            return this.secondsPassed >= JSGConfig.Stargate.secondsToAutoclose.get() + 3;
        }
        return false;
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("secondsPassed", this.secondsPassed);
        compound.m_128405_("playersPassed", this.playersPassed);
        return compound;
    }

    public void deserializeNBT(CompoundTag compound) {
        if (compound == null) {
            return;
        }
        this.secondsPassed = compound.m_128451_("secondsPassed");
        this.playersPassed = compound.m_128451_("playersPassed");
    }
}

