/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.manager;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.api.stargate.EnumStargateState;
import dev.tauri.jsg.api.stargate.Stargate;
import dev.tauri.jsg.api.stargate.StargateClosedReasonEnum;
import dev.tauri.jsg.api.stargate.manager.IStargateDialingManager;
import dev.tauri.jsg.api.stargate.network.IStargateConnection;
import dev.tauri.jsg.api.stargate.network.StargatePos;
import dev.tauri.jsg.api.stargate.result.StargateConnectionStatus;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@FieldsAreNonnullByDefault
public class StargateConnection
implements IStargateConnection {
    private StargateConnectionStatus status = StargateConnectionStatus.NONE;
    private Optional<StargatePos> targetGate = Optional.empty();
    private boolean isRIGConnection = false;
    private boolean initiating = false;
    private boolean isNox = false;
    private boolean noEnergy = false;
    private boolean wasFully = false;
    private long since = 0L;
    private final Stargate sourceGate;

    public static StargateConnection createEmpty(Stargate sourceGate) {
        return new StargateConnection(sourceGate);
    }

    public StargateConnection(Stargate sourceGate) {
        this.sourceGate = sourceGate;
    }

    @Override
    public StargateConnectionStatus getStatus() {
        return this.status;
    }

    @Override
    public Optional<StargatePos> getTarget() {
        return this.targetGate;
    }

    @Override
    public boolean isInitiating() {
        return this.initiating;
    }

    @Override
    public boolean isNox() {
        return this.isNox;
    }

    @Override
    public boolean withoutEnergy() {
        return this.noEnergy;
    }

    @Override
    public boolean isRIG() {
        return this.isRIGConnection;
    }

    public boolean wasFully() {
        return this.wasFully;
    }

    @Override
    public long getSecondsOpen() {
        if (!this.status.full()) {
            return 0L;
        }
        return (long)((double)(this.sourceGate.getTime() - this.since) / 20.0);
    }

    @Override
    public long getSince() {
        return this.since;
    }

    private void reset() {
        this.targetGate = Optional.empty();
        this.status = StargateConnectionStatus.NONE;
        this.initiating = false;
        this.since = this.sourceGate.getTime();
        this.isNox = false;
        this.noEnergy = false;
        this.isRIGConnection = false;
        this.wasFully = false;
        this.sourceGate.setStargateChanged();
    }

    public boolean establishRIG(boolean isNox, boolean noEnergy) {
        if (this.status != StargateConnectionStatus.NONE) {
            return false;
        }
        this.targetGate = Optional.empty();
        this.status = StargateConnectionStatus.PREPARED;
        this.initiating = false;
        this.isRIGConnection = true;
        this.since = this.sourceGate.getTime();
        this.isNox = isNox;
        this.noEnergy = noEnergy;
        this.sourceGate.setStargateChanged();
        return true;
    }

    public boolean establish(StargatePos targetGatePos, boolean isNox, boolean noEnergy) {
        if (this.status != StargateConnectionStatus.NONE) {
            return false;
        }
        this.targetGate = Optional.of(targetGatePos);
        this.status = StargateConnectionStatus.PREPARED;
        this.initiating = true;
        this.isRIGConnection = false;
        this.since = this.sourceGate.getTime();
        this.isNox = isNox;
        this.noEnergy = noEnergy;
        this.sourceGate.setStargateChanged();
        Boolean targetResult = this.callConnected((c, sg) -> {
            StargateConnection conn = (StargateConnection)c;
            if (conn.status != StargateConnectionStatus.NONE) {
                this.reset();
                return false;
            }
            conn.targetGate = Optional.of(this.sourceGate.getStargatePos());
            conn.status = StargateConnectionStatus.PREPARED;
            conn.initiating = false;
            conn.isRIGConnection = false;
            conn.since = this.since;
            conn.isNox = isNox;
            conn.noEnergy = noEnergy;
            conn.sourceGate.setStargateChanged();
            return true;
        }, () -> {
            this.reset();
            return false;
        });
        return targetResult;
    }

    public void updateStatus(StargateConnectionStatus status) {
        JSG.logger.info("Updating wormhole status on gate {} to {}", (Object)this.sourceGate.getStargatePos().toString(), (Object)status.name());
        long time = this.sourceGate.getTime();
        if (status == StargateConnectionStatus.NONE) {
            this.runOnConnected((c, sg) -> {
                StargateConnection conn = (StargateConnection)c;
                conn.reset();
            });
            this.reset();
            return;
        }
        this.status = status;
        this.since = time;
        if (status == StargateConnectionStatus.FULLY) {
            this.wasFully = true;
        }
        this.runOnConnected((c, sg) -> {
            StargateConnection conn = (StargateConnection)c;
            conn.wasFully = this.wasFully;
            conn.status = this.status;
            conn.since = this.since;
            JSG.logger.info("Updating wormhole status on gate {} to {}", (Object)sg.getStargatePos().toString(), (Object)this.status.name());
        });
    }

    public void setStatusSince(long time) {
        if (this.sourceGate.getStargateLevel() != null && !this.sourceGate.getStargateLevel().f_46443_) {
            return;
        }
        this.since = time;
    }

    public void setStatusUnsafe(StargateConnectionStatus status) {
        if (this.sourceGate.getStargateLevel() != null && !this.sourceGate.getStargateLevel().f_46443_) {
            return;
        }
        this.status = status;
    }

    @Override
    public void runOnConnected(BiConsumer<IStargateConnection, Stargate<?>> function) {
        this.callConnected((c, s) -> {
            function.accept((IStargateConnection)c, (Stargate<?>)s);
            return null;
        }, () -> null);
    }

    @Override
    public void runIfConnected(TriConsumer<IStargateConnection, Stargate<?>, Boolean> function) {
        Stargate<?> targetGate;
        if (!this.status.none() && this.targetGate.isPresent() && (targetGate = this.targetGate.get().getStargate()) != null) {
            function.accept((Object)this, targetGate, (Object)this.isInitiating());
        }
    }

    @Override
    public void runIfConnectedElse(TriConsumer<IStargateConnection, Stargate<?>, Boolean> function, Runnable fallback) {
        Stargate<?> targetGate;
        if (!this.status.none() && this.targetGate.isPresent() && (targetGate = this.targetGate.get().getStargate()) != null) {
            function.accept((Object)this, targetGate, (Object)this.isInitiating());
            return;
        }
        fallback.run();
    }

    @Override
    public <R> R callConnected(BiFunction<IStargateConnection, Stargate<?>, R> function, Supplier<R> fallback) {
        Stargate<?> targetGate;
        if (!this.status.none() && this.targetGate.isPresent() && (targetGate = this.targetGate.get().getStargate()) != null) {
            return function.apply(targetGate.getDialingManager().getConnection(), targetGate);
        }
        return fallback.get();
    }

    @Override
    public void runOnBothConnected(BiConsumer<IStargateConnection, Stargate<?>> function) {
        Stargate<?> targetGate;
        function.accept(this, this.sourceGate);
        if (!this.status.none() && this.targetGate.isPresent() && !this.targetGate.get().equals(this.sourceGate.getStargatePos()) && (targetGate = this.targetGate.get().getStargate()) != null) {
            function.accept(targetGate.getDialingManager().getConnection(), targetGate);
        }
    }

    @Override
    public void runIfInitializing(BiConsumer<IStargateConnection, Stargate<?>> function) {
        if (this.status.none()) {
            return;
        }
        if (!this.initiating) {
            return;
        }
        function.accept(this, this.sourceGate);
    }

    @Override
    public <R> R callIfInitiating(BiFunction<IStargateConnection, Stargate<?>, R> function, Supplier<R> fallback) {
        if (this.status.none()) {
            return fallback.get();
        }
        if (this.initiating) {
            return function.apply(this, this.sourceGate);
        }
        return fallback.get();
    }

    @Override
    public <R> R callOnInitiating(BiFunction<IStargateConnection, Stargate<?>, R> function, Supplier<R> fallback) {
        Stargate<?> targetGate;
        if (this.status.none()) {
            return fallback.get();
        }
        if (this.initiating) {
            return function.apply(this, this.sourceGate);
        }
        if (this.targetGate.isPresent() && !this.targetGate.get().equals(this.sourceGate.getStargatePos()) && (targetGate = this.targetGate.get().getStargate()) != null) {
            return function.apply(targetGate.getDialingManager().getConnection(), targetGate);
        }
        return fallback.get();
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("status", this.status.ordinal());
        compound.m_128356_("since", this.since);
        compound.m_128379_("initiating", this.initiating);
        compound.m_128379_("isNox", this.isNox);
        compound.m_128379_("noEnergy", this.noEnergy);
        compound.m_128379_("isRIGConnection", this.isRIGConnection);
        compound.m_128379_("wasFully", this.wasFully);
        this.targetGate.ifPresent(stargatePos -> compound.m_128365_("target", (Tag)stargatePos.serializeNBT()));
        return compound;
    }

    public void deserializeNBT(CompoundTag compound) {
        this.targetGate = Optional.empty();
        this.status = StargateConnectionStatus.values()[compound.m_128451_("status")];
        this.since = compound.m_128454_("since");
        this.initiating = compound.m_128471_("initiating");
        this.isNox = compound.m_128471_("isNox");
        this.noEnergy = compound.m_128471_("noEnergy");
        this.isRIGConnection = compound.m_128471_("isRIGConnection");
        this.wasFully = compound.m_128471_("wasFully");
        if (compound.m_128441_("target")) {
            this.targetGate = Optional.of(new StargatePos(compound.m_128469_("target")));
        }
        if (!this.isRIGConnection && this.targetGate.isEmpty() && this.status != StargateConnectionStatus.NONE && this.status != StargateConnectionStatus.CLOSING) {
            JSG.logger.error("Target gate is null while connection is not NONE, this is a bug! Correcting...");
            this.status = StargateConnectionStatus.NONE;
        }
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeLong(this.since);
        buf.writeInt(this.status.ordinal());
        buf.writeBoolean(this.initiating);
        buf.writeBoolean(this.isNox);
        buf.writeBoolean(this.noEnergy);
        buf.writeBoolean(this.isRIGConnection);
        buf.writeBoolean(this.wasFully);
        if (this.targetGate.isPresent()) {
            buf.writeBoolean(true);
            this.targetGate.get().toBytes(buf);
        } else {
            buf.writeBoolean(false);
        }
    }

    public void fromBytes(FriendlyByteBuf buf) {
        this.since = buf.readLong();
        this.status = StargateConnectionStatus.values()[buf.readInt()];
        this.initiating = buf.readBoolean();
        this.isNox = buf.readBoolean();
        this.noEnergy = buf.readBoolean();
        this.isRIGConnection = buf.readBoolean();
        this.wasFully = buf.readBoolean();
        if (buf.readBoolean()) {
            this.targetGate = Optional.of(new StargatePos((ByteBuf)buf));
        }
    }

    @Override
    public void tick(@NotNull Level level) {
        if (level.f_46443_) {
            return;
        }
        this.runWatchDog((ServerLevel)level);
    }

    protected void runWatchDog(@NotNull ServerLevel level) {
        int watchDogTime;
        IStargateDialingManager dm = this.sourceGate.getDialingManager();
        EnumStargateState state = dm.getStargateState();
        if (this.status.full() != state.engaged()) {
            JSG.logger.warn("Closing stargate {} because wormhole status != mechanical status! (engaged: {}, wormhole open: {})", this.sourceGate.getStargatePos().toString(), state.engaged() ? "true" : "false", this.status.full() ? "true" : "false");
            dm.disconnectSafe(StargateClosedReasonEnum.CONNECTION_LOST);
            return;
        }
        if (this.isRIGConnection != this.sourceGate.getRIGManager().isGateActive()) {
            JSG.logger.warn("Closing stargate {} because rig status mismatch (conn: {}, rigManager: {})", this.sourceGate.getStargatePos().toString(), this.isRIGConnection ? "true" : "false", this.sourceGate.getRIGManager().isGateActive() ? "true" : "false");
            if (this.sourceGate.getRIGManager().isActive()) {
                this.sourceGate.getRIGManager().end();
            } else {
                dm.disconnectSafe(StargateClosedReasonEnum.CONNECTION_LOST);
            }
            return;
        }
        if (this.status.full()) {
            return;
        }
        if (this.status.none()) {
            if (state.idle()) {
                return;
            }
            if (state.dialing()) {
                return;
            }
            if (state.failing()) {
                return;
            }
            if (state.resetting()) {
                return;
            }
            if (state.incoming()) {
                JSG.logger.warn("Closing stargate {} because it's incoming while should be idle", (Object)this.sourceGate.getStargatePos().toString());
                this.updateStatus(StargateConnectionStatus.PREPARED);
            } else if (state == EnumStargateState.UNSTABLE_CLOSING) {
                JSG.logger.warn("Closing stargate {} because it's closing while should be idle", (Object)this.sourceGate.getStargatePos().toString());
                this.updateStatus(StargateConnectionStatus.CLOSING);
            } else {
                JSG.logger.warn("Closing stargate {} because it's not idle while should be", (Object)this.sourceGate.getStargatePos().toString());
                this.updateStatus(StargateConnectionStatus.WAITING_FOR_WORMHOLE);
            }
            dm.disconnectSafe(StargateClosedReasonEnum.CONNECTION_LOST);
            return;
        }
        int n = watchDogTime = (this.status.waiting() || this.status.prepared()) && this.initiating || state.incoming() ? 6000 : 600;
        if (level.m_46467_() - this.since >= (long)watchDogTime) {
            JSG.logger.warn("Closing stargate at {} because it's status ({}/{}) exceeded time limit of {} ticks (was {} ticks)", this.sourceGate.blockPosition().toString(), this.status.name(), state.name(), watchDogTime, level.m_46467_() - this.since);
            dm.disconnectSafe(StargateClosedReasonEnum.CONNECTION_LOST);
            return;
        }
    }
}

