/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.manager;

import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.api.config.ingame.option.StargateConfigOptions;
import dev.tauri.jsg.api.config.util.StargateTimeLimitModeEnum;
import dev.tauri.jsg.api.power.JSGEnergyStorage;
import dev.tauri.jsg.api.power.general.EnergyRequiredToOperate;
import dev.tauri.jsg.api.stargate.Stargate;
import dev.tauri.jsg.api.stargate.StargateClosedReasonEnum;
import dev.tauri.jsg.api.stargate.manager.IStargateEnergyManager;
import dev.tauri.jsg.api.stargate.network.StargatePos;
import dev.tauri.jsg.api.stargate.network.address.StargateAddressDynamic;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.config.stargate.StargateDimensionConfig;
import dev.tauri.jsg.helpers.BlockPosHelper;
import dev.tauri.jsg.stargate.manager.AbstractStargateManager;
import dev.tauri.jsg.stargate.manager.dialing.StargateAbstractDialingManager;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;

@ParametersAreNonnullByDefault
public abstract class StargateEnergyManager<SG extends StargateAbstractBaseBE<?, ?>, E extends JSGEnergyStorage>
extends AbstractStargateManager<SG>
implements IStargateEnergyManager<E> {
    protected final EnergyRequiredToOperate currentEnergyRequirements = EnergyRequiredToOperate.free();
    protected int energyStoredLastTick = -1;
    protected int energyTransferredLastTick;
    protected double energySecondsToClose = -1.0;

    public StargateEnergyManager(SG stargate) {
        super(stargate);
    }

    @Override
    public double getSecondsToClose() {
        return this.energySecondsToClose;
    }

    @Override
    public int getTransferredLastTick() {
        return this.energyTransferredLastTick;
    }

    public void setSecondsToClose(long seconds) {
        this.energySecondsToClose = seconds;
    }

    public void setTransferredLastTick(int energy) {
        this.energyTransferredLastTick = energy;
    }

    public void onGateOpen() {
        Optional<StargatePos> targetGate = ((StargateAbstractDialingManager)((StargateAbstractBaseBE)this.stargate).getDialingManager()).getConnection().getTarget();
        if (targetGate.isPresent()) {
            this.currentEnergyRequirements.update(this.getEnergyRequiredToDial(targetGate.get(), ((StargateAbstractDialingManager)((StargateAbstractBaseBE)this.stargate).getDialingManager()).getDialedAddress()));
        } else {
            this.currentEnergyRequirements.update(EnergyRequiredToOperate.free());
        }
        this.getStorage().extractEnergy(this.currentEnergyRequirements.energyToOpen, false);
    }

    @Override
    public void tick(Level level) {
        if (level.f_46443_) {
            return;
        }
        if (!((StargateAbstractDialingManager)((StargateAbstractBaseBE)this.stargate).getDialingManager()).getConnection().getStatus().full()) {
            this.energySecondsToClose = -1.0;
        }
        this.checkMaximumTimeLimitOpen();
        this.energyTransferredLastTick = this.getStorage().getEnergyStored() - this.energyStoredLastTick;
        if (this.energyStoredLastTick == -1) {
            this.energyTransferredLastTick = 0;
        }
        this.energyStoredLastTick = this.getStorage().getEnergyStored();
        ((StargateAbstractBaseBE)this.stargate).m_6596_();
        ((StargateAbstractDialingManager)((StargateAbstractBaseBE)this.stargate).getDialingManager()).getConnection().runIfInitializing((connOutgoing, sgOutgoing) -> {
            if (!connOutgoing.getStatus().full()) {
                return;
            }
            StargateEnergyManager outgoingEnergyManager = (StargateEnergyManager)sgOutgoing.getEnergyManager();
            outgoingEnergyManager.consumeByWormhole();
            outgoingEnergyManager.energySecondsToClose = outgoingEnergyManager.energyTransferredLastTick < 0 ? Math.max(0.0, (double)outgoingEnergyManager.energyStoredLastTick / (double)(-outgoingEnergyManager.energyTransferredLastTick) / 20.0) : 2.147483647E9;
            sgOutgoing.setStargateChanged();
            connOutgoing.runOnConnected((connIncoming, sgIncoming) -> {
                StargateEnergyManager incomingEnergyManager = (StargateEnergyManager)sgOutgoing.getEnergyManager();
                incomingEnergyManager.energySecondsToClose = outgoingEnergyManager.energySecondsToClose;
                sgIncoming.setStargateChanged();
            });
        });
    }

    protected void checkMaximumTimeLimitOpen() {
        boolean enabled;
        if (!((StargateAbstractDialingManager)((StargateAbstractBaseBE)this.stargate).getDialingManager()).getConnection().getStatus().full()) {
            return;
        }
        int configPower = JSGConfig.Stargate.maxOpenedPowerDrawAfterLimit.get();
        int maxSeconds = JSGConfig.Stargate.maxOpenedSeconds.get();
        StargateTimeLimitModeEnum limitMode = JSGConfig.Stargate.maxOpenedWhat.get();
        Stargate stargate = this.stargate;
        if (stargate instanceof StargateClassicBaseBE) {
            StargateClassicBaseBE casted = (StargateClassicBaseBE)stargate;
            limitMode = casted.getConfig().getValueOrDefault(StargateConfigOptions.Common.TIME_LIMIT_MODE);
            maxSeconds = casted.getConfig().getValueOrDefault(StargateConfigOptions.Common.TIME_LIMIT_TIME);
            configPower = casted.getConfig().getValueOrDefault(StargateConfigOptions.Common.TIME_LIMIT_POWER);
        }
        boolean bl = enabled = limitMode != StargateTimeLimitModeEnum.DISABLED;
        if (!enabled) {
            return;
        }
        long secondsOpen = ((StargateAbstractDialingManager)((StargateAbstractBaseBE)this.stargate).getDialingManager()).getConnection().getSecondsOpen();
        if (secondsOpen < (long)maxSeconds) {
            return;
        }
        if (limitMode == StargateTimeLimitModeEnum.CLOSE_GATE) {
            ((StargateAbstractDialingManager)((StargateAbstractBaseBE)this.stargate).getDialingManager()).attemptClose(StargateClosedReasonEnum.TIME_LIMIT);
            return;
        }
        int power = (int)((double)secondsOpen / (double)maxSeconds * (double)configPower);
        this.getStorage().extractEnergy(power, false);
    }

    protected void consumeByWormhole() {
        if (this.energySecondsToClose < 0.0) {
            return;
        }
        ((StargateAbstractBaseBE)this.stargate).getEventHorizonManager().updateUnstability(this.energySecondsToClose, this.energyTransferredLastTick);
        if (((StargateAbstractDialingManager)((StargateAbstractBaseBE)this.stargate).getDialingManager()).getConnection().withoutEnergy()) {
            return;
        }
        if (this.energySecondsToClose <= 1.0) {
            ((StargateAbstractDialingManager)((StargateAbstractBaseBE)this.stargate).getDialingManager()).attemptClose(StargateClosedReasonEnum.OUT_OF_POWER);
            return;
        }
        this.getStorage().extractEnergy(this.currentEnergyRequirements.keepAlive, false);
    }

    @Override
    public EnergyRequiredToOperate getEnergyRequiredToDial(@Nullable StargatePos targetGatePos, StargateAddressDynamic address) {
        Level level = this.getLevel();
        if (level == null || targetGatePos == null) {
            return EnergyRequiredToOperate.stargate();
        }
        BlockPos sPos = this.getBlockPos();
        BlockPos tPos = targetGatePos.gatePos;
        ResourceKey sourceDim = level.m_46472_();
        ResourceKey targetDim = targetGatePos.getWorld().m_46472_();
        double coordsScale = DimensionType.m_63908_((DimensionType)level.m_6042_(), (DimensionType)targetGatePos.getWorld().m_6042_());
        double distance = (int)BlockPosHelper.dist((Vec3i)tPos, (int)((double)sPos.m_123341_() * coordsScale), sPos.m_123342_(), (int)((double)sPos.m_123343_() * coordsScale));
        distance = distance < 5000.0 ? (distance *= 0.8) : 5000.0 * Math.log10(distance) / Math.log10(5000.0);
        EnergyRequiredToOperate energyRequired = EnergyRequiredToOperate.stargate();
        energyRequired = energyRequired.mul(distance).add(StargateDimensionConfig.INSTANCE.getCost((ResourceKey<Level>)sourceDim, (ResourceKey<Level>)targetDim));
        if (address.size() == 9) {
            energyRequired = energyRequired.mul(JSGConfig.Stargate.nineSymbolAddressMul.get());
        }
        if (address.size() == 8) {
            energyRequired = energyRequired.mul(JSGConfig.Stargate.eightSymbolAddressMul.get());
        }
        return energyRequired;
    }

    protected Level getLevel() {
        return ((StargateAbstractBaseBE)this.stargate).m_58904_();
    }

    protected BlockPos getBlockPos() {
        return ((StargateAbstractBaseBE)this.stargate).m_58899_();
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_("energyStorage", this.getStorage().serializeNBT());
        compound.m_128405_("energyStoredLastTick", this.energyStoredLastTick);
        compound.m_128365_("currentEnergyRequirements", (Tag)this.currentEnergyRequirements.serializeNBT());
        return compound;
    }

    public void deserializeNBT(CompoundTag compound) {
        this.getStorage().deserializeNBT((Tag)compound.m_128469_("energyStorage"));
        this.energyStoredLastTick = compound.m_128451_("energyStoredLastTick");
        this.currentEnergyRequirements.deserializeNBT(compound.m_128469_("currentEnergyRequirements"));
    }
}

