/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.manager;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.api.event.StargateReceiveTravelerEvent;
import dev.tauri.jsg.api.event.StargateSendTravelerEvent;
import dev.tauri.jsg.api.integration.StargateComputerEvents;
import dev.tauri.jsg.api.registry.ScheduledTaskType;
import dev.tauri.jsg.api.stargate.Stargate;
import dev.tauri.jsg.api.stargate.StargateWithIris;
import dev.tauri.jsg.api.stargate.manager.IStargateEventHorizonManager;
import dev.tauri.jsg.api.stargate.network.IStargateConnection;
import dev.tauri.jsg.api.stargate.traveler.IStargateTeleporter;
import dev.tauri.jsg.api.stargate.traveler.IStargateTraveler;
import dev.tauri.jsg.api.stargate.traveler.TravelerSendResult;
import dev.tauri.jsg.api.state.StateType;
import dev.tauri.jsg.api.util.JSGAxisAlignedBB;
import dev.tauri.jsg.api.util.RotationUtil;
import dev.tauri.jsg.api.util.ScheduledTask;
import dev.tauri.jsg.api.util.blockentity.ScheduledTaskExecutorInterface;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateOrlinBaseBE;
import dev.tauri.jsg.config.JSGConfigUtil;
import dev.tauri.jsg.packet.JSGPacketHandler;
import dev.tauri.jsg.packet.packets.StateUpdatePacketToClient;
import dev.tauri.jsg.sound.JSGSoundHelper;
import dev.tauri.jsg.sound.SoundEvent;
import dev.tauri.jsg.stargate.manager.AbstractStargateManager;
import dev.tauri.jsg.stargate.manager.StargateAutoCloseManager;
import dev.tauri.jsg.stargate.manager.state.StargateAbstractStateManager;
import dev.tauri.jsg.stargate.teleportation.StargateKillingHelper;
import dev.tauri.jsg.stargate.teleportation.StargateTeleporter;
import dev.tauri.jsg.stargate.teleportation.traveler.EntityTraveler;
import dev.tauri.jsg.stargate.teleportation.traveler.FireballTraveler;
import dev.tauri.jsg.stargate.teleportation.traveler.LivingTraveler;
import dev.tauri.jsg.stargate.teleportation.traveler.MinecartTraveler;
import dev.tauri.jsg.stargate.teleportation.traveler.PlayerTraveler;
import dev.tauri.jsg.state.stargate.StargateFlashState;
import dev.tauri.jsg.state.stargate.StargateRendererActionState;
import dev.tauri.jsg.state.stargate.StargateVaporizeBlockParticlesRequest;
import dev.tauri.jsg.util.JSGAdvancementsUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.BlockCollisions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class StargateEventHorizonManager
extends AbstractStargateManager<Stargate<?>>
implements IStargateEventHorizonManager,
ScheduledTaskExecutorInterface {
    protected JSGAxisAlignedBB serverBoundingBoxTeleport;
    protected JSGAxisAlignedBB serverBoundingBoxFront;
    protected JSGAxisAlignedBB serverBoundingBoxBack;
    protected final List<Entity> entitiesInFrontBoxLastTick = new ArrayList<Entity>();
    protected final List<Entity> entitiesRecentlyGoThrough = new ArrayList<Entity>();
    protected List<JSGAxisAlignedBB> localInnerEntityBoxes;
    protected List<JSGAxisAlignedBB> localInnerBlockBoxes;
    protected List<JSGAxisAlignedBB> localKillingBoxes;
    protected boolean horizonKilling = false;
    protected int horizonSegments = 0;
    protected final Map<IStargateTraveler<?>, Boolean> entitiesWaitingToTeleport = new HashMap();
    protected ScheduledTask horizonFlashTask;
    protected int flashIndex = 0;
    public boolean isCurrentlyUnstable = false;
    public boolean shouldBeUnstable = false;
    protected List<ScheduledTask> scheduledTasks = new ArrayList<ScheduledTask>();

    public StargateEventHorizonManager(Stargate<?> stargate) {
        super(stargate);
    }

    @Override
    public void onLoad(Level level) {
        this.initBoxes();
    }

    protected void initBoxes() {
        this.serverBoundingBoxTeleport = this.getTeleportBox().offset(0.5, -0.25, 0.5);
        this.serverBoundingBoxFront = this.serverBoundingBoxTeleport.offset(0.0, 0.0, this.serverBoundingBoxTeleport.f_82293_).setMaxZ(this.serverBoundingBoxTeleport.f_82293_ * 5.0);
        this.serverBoundingBoxBack = this.serverBoundingBoxTeleport.offset(0.0, 0.0, this.serverBoundingBoxTeleport.f_82290_ - this.serverBoundingBoxTeleport.f_82293_ * 5.0).setMaxZ(this.serverBoundingBoxTeleport.f_82290_);
        this.serverBoundingBoxTeleport = this.stargate.relative(this.serverBoundingBoxTeleport, new Vec3(0.5, 0.5, 0.5));
        this.serverBoundingBoxFront = this.stargate.relative(this.serverBoundingBoxFront, new Vec3(0.5, 0.5, 0.5));
        this.serverBoundingBoxBack = this.stargate.relative(this.serverBoundingBoxBack, new Vec3(0.5, 0.5, 0.5));
        JSGAxisAlignedBB kBox = this.getHorizonKillingBox();
        double width = kBox.f_82293_ - kBox.f_82290_;
        width /= (double)this.getKawooshSegmentsCount();
        Vec3 offset = new Vec3(0.5, 0.0, 0.5);
        this.localKillingBoxes = new ArrayList<JSGAxisAlignedBB>();
        for (int i = 0; i < this.getKawooshSegmentsCount(); ++i) {
            JSGAxisAlignedBB box = new JSGAxisAlignedBB(kBox.f_82288_, kBox.f_82289_, kBox.f_82290_ + width * (double)i, kBox.f_82291_, kBox.f_82292_, kBox.f_82290_ + width * (double)(i + 1));
            this.localKillingBoxes.add(this.stargate.rotated(box.offset(offset), new Vec3(0.5, 0.5, 0.5)));
        }
        this.localInnerBlockBoxes = new ArrayList<JSGAxisAlignedBB>();
        this.localInnerEntityBoxes = new ArrayList<JSGAxisAlignedBB>();
        for (JSGAxisAlignedBB lBox : this.getGateVaporizingBoxes()) {
            this.localInnerBlockBoxes.add(this.stargate.rotated(lBox.offset(offset), new Vec3(0.5, 0.5, 0.5)));
            this.localInnerEntityBoxes.add(this.stargate.rotated(lBox.grow(0.0, 0.0, -0.25).offset(offset), new Vec3(0.5, 0.5, 0.5)));
        }
    }

    public void onFacingUpdated() {
        this.initBoxes();
    }

    public abstract JSGAxisAlignedBB getTeleportBox();

    public abstract boolean getForceUnstable();

    public List<JSGAxisAlignedBB> getLocalKillingBoxes() {
        return this.localKillingBoxes;
    }

    public List<JSGAxisAlignedBB> getLocalInnerBlockBoxes() {
        return this.localInnerBlockBoxes;
    }

    public JSGAxisAlignedBB getLocalTeleportBox() {
        return this.serverBoundingBoxTeleport.offset(this.stargate.blockPosition().m_142393_(-1));
    }

    public JSGAxisAlignedBB getLocalTeleportBoxBack() {
        return this.serverBoundingBoxBack.offset(this.stargate.blockPosition().m_142393_(-1));
    }

    public JSGAxisAlignedBB getLocalTeleportBoxFront() {
        return this.serverBoundingBoxFront.offset(this.stargate.blockPosition().m_142393_(-1));
    }

    public abstract int getKawooshSegmentsCount();

    public abstract List<JSGAxisAlignedBB> getGateVaporizingBoxes();

    protected abstract JSGAxisAlignedBB getHorizonKillingBox();

    public int getTicksPerKawooshSegment() {
        return 12 / this.getKawooshSegmentsCount();
    }

    @Override
    public TravelerSendResult send(IStargateTraveler<?> traveler) {
        EntityType entityType;
        if (traveler.isStatic()) {
            traveler.send();
            return TravelerSendResult.OK;
        }
        if (!traveler.canBeSendToTarget()) {
            return TravelerSendResult.BLOCKED_BY_EVENT;
        }
        if (new StargateSendTravelerEvent(traveler.getTransmitter(), traveler.getReceiver(), traveler).post()) {
            return TravelerSendResult.BLOCKED_BY_EVENT;
        }
        traveler.send();
        Boolean bl = false;
        Object obj = traveler.get();
        if (obj instanceof Entity) {
            Entity e = (Entity)obj;
            entityType = e.m_6095_();
        } else {
            entityType = null;
        }
        StargateComputerEvents.EH_TRAVELER.apply(bl, entityType).sendVia(this.stargate);
        return TravelerSendResult.OK;
    }

    @Override
    public void receive(IStargateTraveler<?> traveler) {
        StargateWithIris irisGate;
        EntityType entityType;
        Entity e;
        traveler.place();
        if (traveler.isStatic()) {
            return;
        }
        new StargateReceiveTravelerEvent(traveler.getTransmitter(), traveler.getReceiver(), traveler).post();
        if (traveler.getTransmitter() != null) {
            ((StargateEventHorizonManager)traveler.getTransmitter().getEventHorizonManager()).remove(traveler);
        }
        this.stargate.playSoundEvent(SoundEvent.WORMHOLE_GO);
        Boolean bl = true;
        Object object = traveler.get();
        if (object instanceof Entity) {
            e = (Entity)object;
            entityType = e.m_6095_();
        } else {
            entityType = null;
        }
        StargateComputerEvents.EH_TRAVELER.apply(bl, entityType).sendVia(this.stargate);
        object = this.stargate;
        if (object instanceof StargateWithIris && (irisGate = (StargateWithIris)object).getIrisManager().isIrisClosed()) {
            traveler.killIris();
            irisGate.getIrisManager().hitIris();
            return;
        }
        object = traveler.get();
        if (object instanceof Entity) {
            e = (Entity)object;
            this.entitiesRecentlyGoThrough.add(e);
        }
    }

    public Vec3 processMotionVector(Vec3 vector, boolean transmittingEnd) {
        if (!transmittingEnd) {
            return vector;
        }
        if (this.stargate.getDialingManager().getDialedAddressSize() >= 9) {
            return vector.m_82542_(1.0, 1.0, 2.0).m_82520_(0.0, 0.0, 0.5);
        }
        return vector;
    }

    public Vec3 processPositionVector(Vec3 vector, boolean transmittingEnd) {
        if (transmittingEnd) {
            if (this.stargate instanceof StargateOrlinBaseBE) {
                return new Vec3(vector.f_82479_, 2.3, vector.f_82481_);
            }
            return vector;
        }
        if (this.stargate instanceof StargateOrlinBaseBE) {
            return new Vec3(0.5, 2.3, 0.5);
        }
        return vector;
    }

    public Vec3 getPositionVectorRotationPivot() {
        if (this.stargate instanceof StargateOrlinBaseBE) {
            return new Vec3(0.5, 0.5, 0.5);
        }
        return new Vec3(0.0, 0.0, 0.0);
    }

    @Override
    @Nullable
    public IStargateTraveler<?> getTraveler(Entity entity) {
        return this.getTraveler(entity, entity.m_20184_());
    }

    @Override
    @Nullable
    public IStargateTraveler<?> getRIGTraveler(ServerLevel level, Entity entity, Vec3 originalMotion) {
        IStargateConnection connection = this.stargate.getDialingManager().getConnection();
        if (connection.getStatus().none()) {
            return null;
        }
        Vec3 newPos = new Vec3((double)((float)(this.stargate.getGateCenterPos().m_123341_() - this.stargate.blockPosition().m_123341_()) + (entity.m_9236_().f_46441_.m_188501_() * 2.0f - 1.0f) + 0.5f), (double)(2.0f + entity.m_9236_().f_46441_.m_188501_()), 0.5);
        newPos = this.processPositionVector(newPos, connection.isInitiating());
        newPos = this.stargate.relative(newPos);
        Vec3 newMotionVector = originalMotion;
        newMotionVector = this.processMotionVector(newMotionVector, connection.isInitiating());
        newMotionVector = this.stargate.rotated(newMotionVector);
        float newYaw = this.stargate.getFacing().m_122435_();
        entity.m_146884_(newPos);
        entity.m_146922_(newYaw);
        if (!level.m_8860_(entity)) {
            return null;
        }
        return this.getTraveler(entity, newPos, originalMotion, newMotionVector, newYaw, null, this.stargate);
    }

    @Override
    @Nullable
    public IStargateTraveler<?> getTraveler(Entity entity, Vec3 originalMotion) {
        IStargateConnection connection = this.stargate.getDialingManager().getConnection();
        if (connection.getStatus().none()) {
            return null;
        }
        return connection.callConnected((c, targetGate) -> {
            Vec3 newPos = this.stargate.getRelative(entity.m_20182_()).m_82520_(0.0, 0.0, 1.0);
            StargateEventHorizonManager targetManager = (StargateEventHorizonManager)targetGate.getEventHorizonManager();
            newPos = targetManager.processPositionVector(this.processPositionVector(newPos, !c.isInitiating()), c.isInitiating());
            newPos = targetGate.relative(newPos, targetManager.getPositionVectorRotationPivot());
            Vec3 newMotionVector = this.stargate.getRelativeRotated(originalMotion);
            newMotionVector = ((StargateEventHorizonManager)targetGate.getEventHorizonManager()).processMotionVector(this.processMotionVector(newMotionVector, connection.isInitiating()), c.isInitiating());
            newMotionVector = targetGate.rotated(newMotionVector);
            float yaw = entity.m_146908_();
            Vec3 yawVec = RotationUtil.yawToVector(yaw);
            yawVec = this.stargate.getRelativeRotated(yawVec);
            yawVec = targetGate.rotated(yawVec);
            float newYaw = RotationUtil.vectorToYaw(yawVec);
            return this.stargate.getEventHorizonManager().getTraveler(entity, newPos, originalMotion, newMotionVector, newYaw, this.stargate, (Stargate<?>)targetGate);
        }, () -> null);
    }

    @Override
    public IStargateTraveler<?> getStaticTraveler(Stargate<?> targetGate, Entity entity) {
        Vec3 newPos = new Vec3(0.5, 2.5, 0.5);
        newPos = ((StargateEventHorizonManager)targetGate.getEventHorizonManager()).processPositionVector(this.processPositionVector(newPos, true), false);
        newPos = targetGate.relative(newPos);
        float yaw = entity.m_146908_();
        return this.getTraveler(entity, newPos, new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0), yaw, this.stargate, targetGate, true);
    }

    @Override
    public IStargateTraveler<?> getTraveler(Entity entity, IStargateTraveler<?> traveler) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)entity;
            return new PlayerTraveler(sp, traveler.getDestinationPos(), traveler.getOriginalMotion(), traveler.getDestinationMotion(), traveler.getDestinationYaw(), traveler.getTransmitter(), traveler.getReceiver(), traveler.isStatic());
        }
        if (entity instanceof AbstractHurtingProjectile) {
            AbstractHurtingProjectile fireball = (AbstractHurtingProjectile)entity;
            return new FireballTraveler(fireball, traveler.getDestinationPos(), traveler.getOriginalMotion(), traveler.getDestinationMotion(), traveler.getDestinationYaw(), traveler.getTransmitter(), traveler.getReceiver(), traveler.isStatic());
        }
        if (entity instanceof AbstractMinecart) {
            AbstractMinecart minecart = (AbstractMinecart)entity;
            return new MinecartTraveler(minecart, traveler.getDestinationPos(), traveler.getOriginalMotion(), traveler.getDestinationMotion(), traveler.getDestinationYaw(), traveler.getTransmitter(), traveler.getReceiver(), traveler.isStatic());
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return new LivingTraveler<LivingEntity>(livingEntity, traveler.getDestinationPos(), traveler.getOriginalMotion(), traveler.getDestinationMotion(), traveler.getDestinationYaw(), traveler.getTransmitter(), traveler.getReceiver(), traveler.isStatic());
        }
        return new EntityTraveler<Entity>(entity, traveler.getDestinationPos(), traveler.getOriginalMotion(), traveler.getDestinationMotion(), traveler.getDestinationYaw(), traveler.getTransmitter(), traveler.getReceiver(), traveler.isStatic());
    }

    @Override
    public IStargateTraveler<?> getTraveler(Entity entity, Vec3 destinationPos, Vec3 originalMotion, Vec3 destinationMotion, float destinationYaw, Stargate<?> sourceGate, Stargate<?> targetGate, boolean isStatic) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)entity;
            return new PlayerTraveler(sp, destinationPos, originalMotion, destinationMotion, destinationYaw, sourceGate, targetGate, isStatic);
        }
        if (entity instanceof AbstractHurtingProjectile) {
            AbstractHurtingProjectile fireball = (AbstractHurtingProjectile)entity;
            return new FireballTraveler(fireball, destinationPos, originalMotion, destinationMotion, destinationYaw, sourceGate, targetGate, isStatic);
        }
        if (entity instanceof AbstractMinecart) {
            AbstractMinecart minecart = (AbstractMinecart)entity;
            return new MinecartTraveler(minecart, destinationPos, originalMotion, destinationMotion, destinationYaw, sourceGate, targetGate, isStatic);
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return new LivingTraveler<LivingEntity>(livingEntity, destinationPos, originalMotion, destinationMotion, destinationYaw, sourceGate, targetGate, isStatic);
        }
        return new EntityTraveler<Entity>(entity, destinationPos, originalMotion, destinationMotion, destinationYaw, sourceGate, targetGate, isStatic);
    }

    @Override
    public IStargateTeleporter getTeleporter(IStargateTraveler<?> traveler, Consumer<IStargateTraveler<?>> afterPlace) {
        return new StargateTeleporter(traveler, afterPlace);
    }

    @Override
    public boolean canBeSend(IStargateTraveler<?> traveler) {
        StargateClassicBaseBE classicGate;
        Stargate<?> stargate;
        boolean irisKillAtDestination;
        if (!this.isMovingTowardsGate(traveler.getOriginalMotion())) {
            this.remove(traveler);
            return false;
        }
        traveler.getTransmitter().playSoundEvent(SoundEvent.WORMHOLE_GO);
        if (traveler.isPlayer() || traveler.get() instanceof Villager) {
            ((StargateAutoCloseManager)traveler.getTransmitter().getAutoCloseManager()).playerPassing();
        }
        if (!(irisKillAtDestination = JSGConfig.Stargate.killAtDestination.get()) && (stargate = traveler.getReceiver()) instanceof StargateClassicBaseBE && (classicGate = (StargateClassicBaseBE)stargate).getIrisManager().isIrisClosed()) {
            classicGate.playSoundEvent(SoundEvent.WORMHOLE_GO);
            classicGate.getIrisManager().hitIris();
            traveler.killIris();
            return false;
        }
        return true;
    }

    protected void scanForEntities(boolean teleport) {
        IStargateTraveler<?> packet;
        Level level = this.stargate.getStargateLevel();
        if (level == null) {
            return;
        }
        if (!teleport && !JSGConfig.Stargate.wrongSideKilling.get()) {
            return;
        }
        List entitiesTPBox = level.m_45933_(null, (AABB)this.serverBoundingBoxTeleport);
        List entitiesFrontBox = level.m_45933_(null, (AABB)this.serverBoundingBoxFront);
        List entitiesBackBox = level.m_45933_(null, (AABB)this.serverBoundingBoxBack);
        ArrayList<Entity> entitiesInAnyBox = new ArrayList<Entity>();
        for (Entity entity : entitiesTPBox) {
            entitiesInAnyBox.add(entity);
            if (this.entitiesRecentlyGoThrough.contains(entity) || this.entitiesWaitingToTeleport.containsKey(packet = this.getTraveler(entity)) || packet == null) continue;
            this.entitiesWaitingToTeleport.put(packet, false);
        }
        for (Entity entity : entitiesBackBox) {
            entitiesInAnyBox.add(entity);
            if (this.entitiesRecentlyGoThrough.contains(entity) || !this.entitiesInFrontBoxLastTick.contains(entity) || this.entitiesWaitingToTeleport.containsKey(packet = this.getTraveler(entity))) continue;
            this.entitiesInFrontBoxLastTick.remove(entity);
            if (packet == null) continue;
            this.entitiesWaitingToTeleport.put(packet, false);
        }
        this.entitiesInFrontBoxLastTick.clear();
        for (Entity entity : entitiesFrontBox) {
            entitiesInAnyBox.add(entity);
            if (this.entitiesInFrontBoxLastTick.contains(entity) || this.entitiesRecentlyGoThrough.contains(entity)) continue;
            this.entitiesInFrontBoxLastTick.add(entity);
        }
        for (Entity entity : new ArrayList<Entity>(this.entitiesRecentlyGoThrough)) {
            if (entitiesInAnyBox.contains(entity)) continue;
            if (entity instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)entity;
                if (sp.f_19794_) continue;
            }
            this.entitiesRecentlyGoThrough.remove(entity);
        }
        for (Map.Entry entry : new ArrayList(this.entitiesWaitingToTeleport.entrySet())) {
            Entity e;
            Object e2;
            IStargateTraveler traveler = (IStargateTraveler)entry.getKey();
            if (((Boolean)entry.getValue()).booleanValue() || (e2 = traveler.get()) instanceof Entity && this.entitiesRecentlyGoThrough.contains(e = (Entity)e2)) continue;
            this.entitiesWaitingToTeleport.put(traveler, true);
            if (traveler.canBeSendThisWay(teleport)) {
                if (this.isCurrentlyUnstable && (double)level.f_46441_.m_188501_() < JSGConfig.Stargate.ehDeathChance.get()) {
                    traveler.killUnstable();
                    this.remove(traveler);
                    continue;
                }
                this.send(traveler);
                continue;
            }
            traveler.killWrongTravel();
        }
    }

    @Override
    public boolean isMovingTowardsGate(Vec3 motionVec) {
        if (Math.abs(motionVec.f_82479_) + Math.abs(motionVec.f_82481_) + Math.abs(motionVec.f_82480_) < 0.01) {
            return true;
        }
        Direction sourceFacing = this.stargate.getFacingVertical() == Direction.SOUTH ? this.stargate.getFacing() : this.stargate.getFacingVertical();
        Vec3 axisMotion = motionVec.m_82559_(Vec3.m_82528_((Vec3i)sourceFacing.m_122436_()));
        return axisMotion.f_82480_ + axisMotion.f_82481_ + axisMotion.f_82479_ <= 0.0;
    }

    public void remove(IStargateTraveler<?> traveler) {
        this.entitiesWaitingToTeleport.remove(traveler);
    }

    protected void reset() {
        this.entitiesWaitingToTeleport.clear();
        this.entitiesInFrontBoxLastTick.clear();
        this.resetFlashingSequence();
    }

    public void onGateOpen(boolean isNox) {
        this.addTask(new ScheduledTask(ScheduledTaskType.STARGATE_HORIZON_LIGHT_BLOCK, this.stargate.getOpenSoundDelay() + 19 + this.getTicksPerKawooshSegment()));
        if (!isNox) {
            this.addTask(new ScheduledTask(ScheduledTaskType.STARGATE_HORIZON_WIDEN, this.stargate.getOpenSoundDelay() + 23 + this.getTicksPerKawooshSegment()));
        }
        this.reset();
    }

    public void onGateClose() {
        this.reset();
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128379_("horizonKilling", this.horizonKilling);
        compound.m_128405_("horizonSegments", this.horizonSegments);
        compound.m_128365_("scheduledTasks", (Tag)ScheduledTask.serializeList(this.scheduledTasks));
        return compound;
    }

    public void deserializeNBT(CompoundTag compound) {
        this.horizonKilling = compound.m_128471_("horizonKilling");
        this.horizonSegments = compound.m_128451_("horizonSegments");
        try {
            ScheduledTask.deserializeList(compound.m_128469_("scheduledTasks"), this.scheduledTasks, this);
        }
        catch (ClassCastException | IndexOutOfBoundsException | NullPointerException e) {
            JSG.logger.warn("Exception at reading NBT");
            JSG.logger.warn("If loading world used with previous version and nothing game-breaking doesn't happen, please ignore it", e);
        }
    }

    @Override
    public void tick(Level level) {
        StargateClassicBaseBE classicBase;
        Stargate stargate;
        ScheduledTask.iterate(this.scheduledTasks, this.stargate.getTime());
        if (level.m_5776_()) {
            return;
        }
        IStargateConnection connection = this.stargate.getDialingManager().getConnection();
        if (!(!connection.getStatus().full() || (stargate = this.stargate) instanceof StargateClassicBaseBE && (classicBase = (StargateClassicBaseBE)stargate).getIrisManager().isIrisClosed())) {
            this.scanForEntities(connection.isInitiating());
        }
        this.kawooshDestruction();
        if (this.horizonFlashTask != null && this.horizonFlashTask.isActive()) {
            this.horizonFlashTask.update(this.stargate.getTime());
        }
    }

    protected void kawooshDestruction() {
        if (!this.horizonKilling) {
            return;
        }
        Level level = this.stargate.getStargateLevel();
        if (level == null) {
            return;
        }
        BlockPos pos = this.stargate.blockPosition();
        ArrayList entities = new ArrayList();
        ArrayList blocks = new ArrayList();
        ArrayList<JSGAxisAlignedBB> blockDestroyBoxes = new ArrayList<JSGAxisAlignedBB>(this.localInnerBlockBoxes);
        for (int i = 0; i < this.horizonSegments; ++i) {
            if (this.localKillingBoxes.size() <= i) continue;
            JSGAxisAlignedBB gBox = this.localKillingBoxes.get(i).offset(pos);
            entities.addAll(level.m_45933_(null, (AABB)gBox));
            blockDestroyBoxes.add(new JSGAxisAlignedBB(gBox.offset(pos.m_142393_(-1))));
        }
        for (JSGAxisAlignedBB lBox : this.localInnerEntityBoxes) {
            entities.addAll(level.m_45933_(null, (AABB)lBox.offset(pos)));
        }
        for (Entity entity : entities) {
            StargateKillingHelper.kawooshKill(entity);
            JSGPacketHandler.sendToClient(new StateUpdatePacketToClient(pos, StateType.STARGATE_VAPORIZE_BLOCK_PARTICLES, new StargateVaporizeBlockParticlesRequest(entity.m_20183_(), false)), ((StargateAbstractStateManager)this.stargate.getStateManager()).getTargetPoint());
        }
        for (JSGAxisAlignedBB lBox : blockDestroyBoxes) {
            JSGAxisAlignedBB gBox = lBox.offset(pos);
            new BlockCollisions((CollisionGetter)level, null, (AABB)gBox, false, (p, s) -> p).forEachRemaining(dPos -> {
                BlockState state = level.m_8055_((BlockPos)dPos);
                if (dPos.equals((Object)this.stargate.getGateCenterPos()) && state.m_60713_(Blocks.f_152480_)) {
                    return;
                }
                if (!level.m_8055_((BlockPos)dPos).m_60795_() && state.m_60800_((BlockGetter)level, (BlockPos)dPos) >= 0.0f && JSGConfigUtil.canKawooshDestroyBlock(state)) {
                    if (state.m_60713_(Blocks.f_49990_)) {
                        int waterCount = 0;
                        for (Direction dir : Direction.values()) {
                            if (dir == Direction.DOWN || !level.m_8055_(dPos.m_121945_(dir)).m_60713_(Blocks.f_49990_) || !level.m_6425_(dPos.m_121945_(dir)).m_76170_()) continue;
                            ++waterCount;
                        }
                        if (waterCount <= 2) {
                            level.m_46597_((BlockPos)dPos, Blocks.f_50016_.m_49966_());
                        }
                    } else {
                        level.m_46597_((BlockPos)dPos, Blocks.f_50016_.m_49966_());
                    }
                    JSGPacketHandler.sendToClient(new StateUpdatePacketToClient(pos, StateType.STARGATE_VAPORIZE_BLOCK_PARTICLES, new StargateVaporizeBlockParticlesRequest((BlockPos)dPos, state.m_60713_(Blocks.f_49990_))), ((StargateAbstractStateManager)this.stargate.getStateManager()).getTargetPoint());
                }
            });
        }
    }

    protected void setHorizonFlashTask(ScheduledTask horizonFlashTask) {
        horizonFlashTask.setExecutor(this);
        horizonFlashTask.setTaskCreated(this.stargate.getTime());
        this.horizonFlashTask = horizonFlashTask;
        this.stargate.setStargateChanged();
    }

    protected void resetFlashingSequence() {
        this.flashIndex = 0;
        this.isCurrentlyUnstable = false;
        this.shouldBeUnstable = false;
        this.horizonFlashTask = null;
    }

    protected void updateFlashState() {
        this.stargate.getDialingManager().getConnection().runOnBothConnected((conn, sg) -> {
            JSGPacketHandler.sendToClient(new StateUpdatePacketToClient(sg.blockPosition(), StateType.FLASH_STATE, new StargateFlashState(this.isCurrentlyUnstable)), ((StargateAbstractStateManager)sg.getStateManager()).getTargetPoint());
            if (this.isCurrentlyUnstable && this.flashIndex == 1) {
                JSGAdvancementsUtil.tryTriggerRangedAdvancement(sg, JSGAdvancementsUtil.EnumAdvancementType.GATE_FLICKER);
                JSGSoundHelper.playSoundEvent(sg.getStargateLevel(), sg.getGateCenterPos(), SoundEvent.WORMHOLE_FLICKER, 0.9f + sg.getRandom().m_188501_() * 0.2f);
            }
        });
    }

    public void updateUnstability(double energySecondsToClose, int energyTransferredLastTick) {
        if (!this.stargate.getDialingManager().getStargateState().engaged()) {
            this.resetFlashingSequence();
            return;
        }
        boolean forceUnstable = this.getForceUnstable();
        if (this.horizonFlashTask == null && (forceUnstable || energySecondsToClose < (double)JSGConfig.Stargate.instabilitySeconds.get() && energyTransferredLastTick < 0)) {
            this.resetFlashingSequence();
            this.shouldBeUnstable = true;
            double mul = this.stargate.getEnergyManager().getSecondsToClose() / (double)JSGConfig.Stargate.instabilitySeconds.get();
            if (this.getForceUnstable()) {
                mul = 0.01;
            }
            double min = 15.0 * (mul * mul) * 2.0;
            double off = 20.0 * (mul * mul) * 2.0;
            min = Math.max(5.0, min);
            this.setHorizonFlashTask(new ScheduledTask(ScheduledTaskType.HORIZON_FLASH, (int)(min + this.stargate.getRandom().m_188500_() * off)));
            StargateComputerEvents.EH_UNSTABLE.apply(this.stargate.getDialingManager().getConnection().isInitiating()).sendVia(this.stargate);
        }
        if (this.horizonFlashTask != null && !forceUnstable && (energySecondsToClose > (double)JSGConfig.Stargate.instabilitySeconds.get() || energyTransferredLastTick >= 0)) {
            this.horizonFlashTask = null;
            this.isCurrentlyUnstable = false;
            this.shouldBeUnstable = false;
            StargateComputerEvents.EH_STABILIZED.apply(this.stargate.getDialingManager().getConnection().isInitiating()).sendVia(this.stargate);
            this.updateFlashState();
        }
    }

    @Override
    public void addTask(ScheduledTask scheduledTask) {
        scheduledTask.setExecutor(this);
        scheduledTask.setTaskCreated(this.stargate.getTime());
        if (scheduledTask.getWaitTime() <= 0) {
            scheduledTask.execute();
            return;
        }
        this.scheduledTasks.add(scheduledTask);
        this.stargate.setStargateChanged();
    }

    @Override
    public void executeTask(ScheduledTaskType scheduledTask, CompoundTag customData) {
        if (scheduledTask == ScheduledTaskType.STARGATE_HORIZON_WIDEN) {
            if (!this.horizonKilling) {
                this.horizonKilling = true;
            }
            ++this.horizonSegments;
            JSGPacketHandler.sendToClient(new StateUpdatePacketToClient(this.stargate.blockPosition(), StateType.RENDERER_UPDATE, StargateRendererActionState.STARGATE_HORIZON_WIDEN_ACTION), ((StargateAbstractStateManager)this.stargate.getStateManager()).getTargetPoint());
            if (this.horizonSegments < this.getKawooshSegmentsCount()) {
                this.addTask(new ScheduledTask(ScheduledTaskType.STARGATE_HORIZON_WIDEN, this.getTicksPerKawooshSegment()));
            } else {
                this.addTask(new ScheduledTask(ScheduledTaskType.STARGATE_HORIZON_SHRINK, this.getTicksPerKawooshSegment() + 12));
            }
        } else if (scheduledTask == ScheduledTaskType.STARGATE_HORIZON_SHRINK) {
            --this.horizonSegments;
            JSGPacketHandler.sendToClient(new StateUpdatePacketToClient(this.stargate.blockPosition(), StateType.RENDERER_UPDATE, StargateRendererActionState.STARGATE_HORIZON_SHRINK_ACTION), ((StargateAbstractStateManager)this.stargate.getStateManager()).getTargetPoint());
            if (this.horizonSegments > 0) {
                this.addTask(new ScheduledTask(ScheduledTaskType.STARGATE_HORIZON_SHRINK, this.getTicksPerKawooshSegment() + 1));
            } else {
                this.horizonKilling = false;
            }
            this.stargate.setStargateChanged();
        } else if (scheduledTask == ScheduledTaskType.HORIZON_FLASH) {
            this.isCurrentlyUnstable ^= true;
            if (this.isCurrentlyUnstable) {
                ++this.flashIndex;
                if (this.flashIndex >= 2) {
                    this.setHorizonFlashTask(new ScheduledTask(ScheduledTaskType.HORIZON_FLASH, 2));
                } else {
                    this.setHorizonFlashTask(new ScheduledTask(ScheduledTaskType.HORIZON_FLASH, (int)(this.stargate.getRandom().m_188500_() * 3.0) + 3));
                }
            } else if (this.flashIndex == 1) {
                this.setHorizonFlashTask(new ScheduledTask(ScheduledTaskType.HORIZON_FLASH, (int)(this.stargate.getRandom().m_188500_() * 4.0) + 1));
            } else if (this.shouldBeUnstable && this.stargate.getRandom().m_188501_() < 0.5f) {
                this.flashIndex = 0;
                this.setHorizonFlashTask(new ScheduledTask(ScheduledTaskType.HORIZON_FLASH, (int)(this.stargate.getRandom().m_188500_() * 4.0) + 1));
            } else {
                this.resetFlashingSequence();
            }
            this.updateFlashState();
            this.stargate.setStargateChanged();
        }
    }
}

