/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.manager;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.api.blockstates.JSGProperties;
import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.api.integration.StargateComputerEvents;
import dev.tauri.jsg.api.power.general.LargeEnergyStorage;
import dev.tauri.jsg.api.registry.ScheduledTaskType;
import dev.tauri.jsg.api.stargate.EnumStargateState;
import dev.tauri.jsg.api.stargate.StargateSizeEnum;
import dev.tauri.jsg.api.stargate.iris.EnumIrisMode;
import dev.tauri.jsg.api.stargate.iris.EnumIrisState;
import dev.tauri.jsg.api.stargate.iris.EnumIrisType;
import dev.tauri.jsg.api.stargate.iris.codesender.CodeSender;
import dev.tauri.jsg.api.stargate.manager.IStargateIrisManager;
import dev.tauri.jsg.api.state.StateType;
import dev.tauri.jsg.api.util.EnumKeyInterface;
import dev.tauri.jsg.api.util.EnumKeyMap;
import dev.tauri.jsg.api.util.ScheduledTask;
import dev.tauri.jsg.api.util.blockentity.ScheduledTaskExecutorInterface;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.item.linkable.gdo.GDOMessages;
import dev.tauri.jsg.item.stargate.IrisItem;
import dev.tauri.jsg.registry.BlockRegistry;
import dev.tauri.jsg.registry.ItemRegistry;
import dev.tauri.jsg.renderer.stargate.StargateClassicRendererState;
import dev.tauri.jsg.sound.SoundEvent;
import dev.tauri.jsg.stargate.animation.IrisAnimationState;
import dev.tauri.jsg.stargate.manager.AbstractStargateManager;
import dev.tauri.jsg.stargate.manager.StargateSoundManager;
import dev.tauri.jsg.stargate.manager.dialing.StargateAbstractDialingManager;
import dev.tauri.jsg.stargate.manager.state.StargateAbstractStateManager;
import dev.tauri.jsg.state.stargate.StargateRendererActionState;
import dev.tauri.jsg.util.JSGAdvancementsUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StargateIrisManager
extends AbstractStargateManager<StargateClassicBaseBE<?>>
implements IStargateIrisManager,
ScheduledTaskExecutorInterface {
    protected EnumIrisState state = EnumIrisState.OPENED;
    protected EnumIrisType type = EnumIrisType.NULL;
    protected EnumIrisMode mode = EnumIrisMode.OPENED;
    @NotNull
    protected String code = "";
    protected CodeSender codeSender;
    protected Runnable afterIrisDone;
    protected long irisAnimationStart;
    protected IrisAnimationState irisAnimationState = new IrisAnimationState();
    protected final List<ScheduledTask> scheduledTasks = new ArrayList<ScheduledTask>();

    public StargateIrisManager(StargateClassicBaseBE<?> stargate) {
        super(stargate);
    }

    public StargateClassicRendererState.StargateClassicRendererStateBuilder processRenderState(StargateClassicRendererState.StargateClassicRendererStateBuilder builder) {
        return builder.setIrisState(this.state).setIrisType(this.type).setIrisMode(this.mode).setIrisCode(this.code).setIrisAnimation(this.irisAnimationStart);
    }

    public void setIrisAnimationState(IrisAnimationState irisAnimationState) {
        this.irisAnimationState = irisAnimationState;
    }

    @NotNull
    public IrisAnimationState getIrisAnimationState() {
        return this.irisAnimationState;
    }

    @Override
    @Nullable
    public CodeSender getCodeSender() {
        return this.codeSender;
    }

    @Override
    @NotNull
    public EnumIrisType getIrisType() {
        return this.type;
    }

    @Override
    @NotNull
    public EnumIrisMode getIrisMode() {
        return this.mode;
    }

    @Override
    @NotNull
    public String getIrisCode() {
        return this.code;
    }

    @Override
    @NotNull
    public EnumIrisState getIrisState() {
        return this.state;
    }

    @Override
    @NotNull
    public ItemStack getIrisItem() {
        return ((StargateClassicBaseBE)this.stargate).getItemHandler().getStackInSlot(11);
    }

    @Override
    public boolean canInsertItemAsIris(Item item) {
        return StargateIrisUpgradeEnum.contains(item);
    }

    public void onGateDisconnected() {
        this.codeSender = null;
        if (this.mode == EnumIrisMode.AUTO && this.isIrisClosed()) {
            this.toggleIris();
        }
        ((StargateClassicBaseBE)this.stargate).m_6596_();
    }

    public void onIncomingWormhole() {
        if (this.hasIris() && this.mode == EnumIrisMode.AUTO && this.isIrisOpened()) {
            this.toggleIris();
        }
    }

    @Override
    public boolean receiveIrisCode(@NotNull CodeSender sender, @NotNull String code) {
        StargateComputerEvents.IRIS_CODE_RECEIVED.apply(code).sendVia(this.stargate);
        if (this.mode != EnumIrisMode.AUTO) {
            if (((StargateClassicBaseBE)this.stargate).getListenerHandler().receiveIDC(sender, code)) {
                return true;
            }
            sender.sendMessage(GDOMessages.SEND_TO_COMPUTER.textComponent);
            this.codeSender = sender;
            return false;
        }
        if (Objects.equals(code, this.code)) {
            switch (this.state) {
                case OPENED: {
                    sender.sendMessage(GDOMessages.OPENED.textComponent);
                    break;
                }
                case CLOSED: {
                    sender.sendMessage(GDOMessages.CODE_ACCEPTED.textComponent);
                    this.codeSender = sender;
                    this.toggleIris();
                    break;
                }
                case OPENING: 
                case CLOSING: {
                    sender.sendMessage(GDOMessages.BUSY.textComponent);
                    break;
                }
            }
        } else {
            if (((StargateClassicBaseBE)this.stargate).getListenerHandler().receiveIDC(sender, code)) {
                return true;
            }
            sender.sendMessage(GDOMessages.CODE_REJECTED.textComponent);
            return false;
        }
        ((StargateClassicBaseBE)this.stargate).m_6596_();
        return true;
    }

    @Override
    public void setIrisCode(String code) {
        if (code == null) {
            code = "";
        }
        this.code = code;
        ((StargateClassicBaseBE)this.stargate).m_6596_();
    }

    @Override
    public void setIrisMode(@NotNull EnumIrisMode irisMode) {
        if (((StargateClassicBaseBE)this.stargate).m_58904_() == null || ((StargateClassicBaseBE)this.stargate).m_58904_().f_46443_) {
            this.mode = irisMode;
            return;
        }
        if (this.mode != irisMode && this.hasIris()) {
            switch (irisMode) {
                case OPENED: 
                case CLOSED: {
                    this.irisModeAction(irisMode);
                    break;
                }
                case AUTO: {
                    EnumStargateState sgState = ((StargateAbstractDialingManager)((StargateClassicBaseBE)this.stargate).getDialingManager()).getStargateState();
                    if (sgState.notInitiating() || sgState.incoming()) {
                        if (this.state != EnumIrisState.OPENED) break;
                        this.toggleIris();
                        break;
                    }
                    if (!this.isIrisClosed()) break;
                    this.toggleIris();
                    break;
                }
            }
        }
        this.mode = irisMode;
        ((StargateClassicBaseBE)this.stargate).m_6596_();
    }

    public void onUnmerged() {
        if (this.type != EnumIrisType.NULL && this.state == EnumIrisState.CLOSED) {
            this.setIrisBlocks(false);
        }
        this.state = EnumIrisState.OPENED;
        this.type = EnumIrisType.NULL;
    }

    public void onLoad() {
        boolean set;
        this.updateIrisType();
        boolean bl = set = this.type != EnumIrisType.NULL;
        if (((StargateClassicBaseBE)this.stargate).isMerged()) {
            this.setIrisBlocks(set && this.state == EnumIrisState.CLOSED);
        }
    }

    private void irisModeAction(EnumIrisMode mode) {
        EnumIrisState p2;
        EnumIrisState p;
        if (mode == EnumIrisMode.OPENED) {
            p = EnumIrisState.CLOSED;
            p2 = EnumIrisState.CLOSING;
        } else if (mode == EnumIrisMode.CLOSED) {
            p = EnumIrisState.OPENED;
            p2 = EnumIrisState.OPENING;
        } else {
            return;
        }
        if (this.state == p) {
            this.toggleIris();
        } else if (this.state == p2) {
            this.afterIrisDone = this::toggleIris;
        }
    }

    @Override
    public boolean toggleIris() {
        SoundEvent closeSound;
        SoundEvent openSound;
        this.updateIrisType();
        if (this.type == EnumIrisType.NULL) {
            return false;
        }
        if (this.isIrisClosed() || this.isIrisOpened()) {
            this.irisAnimationStart = ((StargateClassicBaseBE)this.stargate).getTime();
        }
        if (this.hasPhysicalIris()) {
            openSound = SoundEvent.IRIS_OPENING;
            closeSound = SoundEvent.IRIS_CLOSING;
        } else {
            openSound = SoundEvent.SHIELD_OPENING;
            closeSound = SoundEvent.SHIELD_CLOSING;
        }
        switch (this.state) {
            case OPENED: 
            case OPENING: {
                if (this.hasShield() && ((LargeEnergyStorage)((Object)((StargateClassicBaseBE)this.stargate).getEnergyManager().getStorage())).getEnergyStored() < JSGConfig.Stargate.irisShieldPowerDraw.get() * 3) {
                    return false;
                }
                StargateComputerEvents.IRIS_TOGGLED.apply(true).sendVia(this.stargate);
                StargateComputerEvents.IRIS_STATE_CHANGED.apply(this.state, EnumIrisState.CLOSING).sendVia(this.stargate);
                this.state = EnumIrisState.CLOSING;
                if (this.mode == EnumIrisMode.OPENED) {
                    StargateComputerEvents.IRIS_MODE_CHANGED.apply(this.mode, EnumIrisMode.CLOSED).sendVia(this.stargate);
                    this.mode = EnumIrisMode.CLOSED;
                }
                ((StargateAbstractStateManager)((StargateClassicBaseBE)this.stargate).getStateManager()).sendRenderingUpdate(StargateRendererActionState.EnumGateAction.IRIS_UPDATE, 0, true, this.type, this.state, this.irisAnimationStart);
                ((StargateClassicBaseBE)this.stargate).playSoundEvent(closeSound);
                if (this.hasShield()) {
                    ((StargateSoundManager)((StargateClassicBaseBE)this.stargate).getSoundManager()).updateShieldHummingSound(true);
                }
                if (((StargateAbstractDialingManager)((StargateClassicBaseBE)this.stargate).getDialingManager()).getConnection().getStatus().full()) {
                    ((StargateClassicBaseBE)this.stargate).executeTask(ScheduledTaskType.STARGATE_HORIZON_LIGHT_BLOCK, new CompoundTag());
                }
                ((StargateClassicBaseBE)this.stargate).getListenerHandler().irisCloses();
                break;
            }
            case CLOSED: 
            case CLOSING: {
                StargateComputerEvents.IRIS_TOGGLED.apply(false).sendVia(this.stargate);
                StargateComputerEvents.IRIS_STATE_CHANGED.apply(this.state, EnumIrisState.OPENING).sendVia(this.stargate);
                this.state = EnumIrisState.OPENING;
                if (this.mode == EnumIrisMode.CLOSED) {
                    StargateComputerEvents.IRIS_MODE_CHANGED.apply(this.mode, EnumIrisMode.OPENED).sendVia(this.stargate);
                    this.mode = EnumIrisMode.OPENED;
                }
                this.setIrisBlocks(false);
                ((StargateAbstractStateManager)((StargateClassicBaseBE)this.stargate).getStateManager()).sendRenderingUpdate(StargateRendererActionState.EnumGateAction.IRIS_UPDATE, 0, true, this.type, this.state, this.irisAnimationStart);
                ((StargateClassicBaseBE)this.stargate).playSoundEvent(openSound);
                ((StargateSoundManager)((StargateClassicBaseBE)this.stargate).getSoundManager()).updateShieldHummingSound(false);
                if (((StargateAbstractDialingManager)((StargateClassicBaseBE)this.stargate).getDialingManager()).getConnection().getStatus().full()) {
                    ((StargateClassicBaseBE)this.stargate).executeTask(ScheduledTaskType.STARGATE_HORIZON_LIGHT_BLOCK, new CompoundTag());
                }
                ((StargateClassicBaseBE)this.stargate).getListenerHandler().irisOpens();
                break;
            }
            default: {
                return false;
            }
        }
        ((StargateClassicBaseBE)this.stargate).m_6596_();
        return true;
    }

    @Override
    public void hitIris() {
        if (!this.hasIris()) {
            return;
        }
        JSGAdvancementsUtil.tryTriggerRangedAdvancement(this.stargate, JSGAdvancementsUtil.EnumAdvancementType.IRIS_IMPACT);
        ((StargateClassicBaseBE)this.stargate).getListenerHandler().irisHit();
        ItemStack irisItem = this.getIrisItem();
        ((StargateAbstractStateManager)((StargateClassicBaseBE)this.stargate).getStateManager()).sendState(StateType.IRIS_ANIMATION, IrisAnimationState.hit(((StargateClassicBaseBE)this.stargate).getTime()));
        if (!this.hasCreativeIris() && irisItem.m_41720_() instanceof IrisItem && irisItem.m_41763_()) {
            int chance = EnchantmentHelper.m_44831_((ItemStack)irisItem).containsKey(Enchantments.f_44986_) ? JSGConfig.Stargate.irisUnbreakingChance.get() * irisItem.getEnchantmentLevel(Enchantments.f_44986_) : 0;
            int random = new Random().nextInt(100);
            if (random > chance) {
                irisItem.m_41720_().setDamage(irisItem, irisItem.m_41720_().getDamage(irisItem) + 1);
            }
            if (irisItem.m_41613_() == 0) {
                this.updateIrisType();
            }
            ((StargateClassicBaseBE)this.stargate).tryHeatUp(true, 2.0);
        } else if (!this.hasCreativeIris()) {
            ((LargeEnergyStorage)((Object)((StargateClassicBaseBE)this.stargate).getEnergyManager().getStorage())).extractEnergy(500, false);
        }
        if (this.hasPhysicalIris()) {
            ((StargateClassicBaseBE)this.stargate).playSoundEvent(SoundEvent.IRIS_HIT);
        } else if (this.hasShield()) {
            ((StargateClassicBaseBE)this.stargate).playSoundEvent(SoundEvent.SHIELD_HIT);
        }
        StargateComputerEvents.IRIS_HIT.get().sendVia(this.stargate);
    }

    public void updateIrisType() {
        EnumIrisType newType = EnumIrisType.byItem(this.getIrisItem().m_41720_());
        if (((StargateClassicBaseBE)this.stargate).m_58904_() == null || ((StargateClassicBaseBE)this.stargate).m_58904_().f_46443_) {
            this.type = newType;
            return;
        }
        if (newType != this.type) {
            StargateComputerEvents.IRIS_TYPE_CHANGED.apply(this.type, newType).sendVia(this.stargate);
        }
        this.type = newType;
        if (this.type == EnumIrisType.NULL) {
            StargateComputerEvents.IRIS_STATE_CHANGED.apply(this.state, EnumIrisState.OPENED).sendVia(this.stargate);
            this.state = EnumIrisState.OPENED;
        }
        ((StargateAbstractStateManager)((StargateClassicBaseBE)this.stargate).getStateManager()).sendRenderingUpdate(StargateRendererActionState.EnumGateAction.IRIS_UPDATE, 0, false, this.type, this.state, this.irisAnimationStart);
        ((StargateClassicBaseBE)this.stargate).m_6596_();
        if (this.isIrisOpened()) {
            ((StargateSoundManager)((StargateClassicBaseBE)this.stargate).getSoundManager()).updateShieldHummingSound(false);
            this.setIrisBlocks(false);
        }
    }

    private void setIrisBlocks(boolean set) {
        Level world = ((StargateClassicBaseBE)this.stargate).m_58904_();
        if (world == null) {
            return;
        }
        BlockState invBlockState = (BlockState)((BlockState)((Block)BlockRegistry.IRIS_BLOCK.get()).m_49966_().m_61124_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY, (Comparable)((StargateClassicBaseBE)this.stargate).getFacing())).m_61124_((Property)JSGProperties.FACING_VERTICAL_PROPERTY, (Comparable)Integer.valueOf(JSGProperties.getVerticalFacingByDirection(((StargateClassicBaseBE)this.stargate).getFacingVertical())));
        for (BlockPos invPos : Objects.requireNonNull(StargateSizeEnum.getIrisBlocksPattern(((StargateClassicBaseBE)this.stargate).getStargateSize()))) {
            BlockPos newPos = ((StargateClassicBaseBE)this.stargate).relative(invPos);
            if (set) {
                if (world.m_8055_(newPos).m_60734_() != Blocks.f_50016_) {
                    if (!JSGConfig.Stargate.irisDestroysBlocks.get() || world.m_8055_(newPos).m_60734_() == Blocks.f_152480_ && newPos == ((StargateClassicBaseBE)this.stargate).getGateCenterPos()) continue;
                    world.m_46961_(newPos, true);
                }
                world.m_7731_(newPos, invBlockState, 3);
                continue;
            }
            if (newPos == ((StargateClassicBaseBE)this.stargate).getGateCenterPos() && ((StargateAbstractDialingManager)((StargateClassicBaseBE)this.stargate).getDialingManager()).getConnection().getStatus().full()) {
                ((StargateClassicBaseBE)this.stargate).executeTask(ScheduledTaskType.STARGATE_HORIZON_LIGHT_BLOCK, new CompoundTag());
            }
            if (world.m_8055_(newPos).m_60734_() != BlockRegistry.IRIS_BLOCK.get()) continue;
            world.m_7731_(newPos, Blocks.f_50016_.m_49966_(), 3);
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        if (this.state == null) {
            if (this.codeSender != null) {
                this.codeSender.sendMessage(GDOMessages.OPENED.textComponent);
                this.codeSender = null;
            }
            this.state = EnumIrisState.OPENED;
        }
        compound.m_128344_("irisState", this.state.id);
        compound.m_128359_("irisCode", this.code);
        compound.m_128344_("irisMode", this.mode.id);
        compound.m_128344_("irisType", this.type.id);
        compound.m_128356_("irisAnimationStart", this.irisAnimationStart);
        compound.m_128365_("scheduledTasks", (Tag)ScheduledTask.serializeList(this.scheduledTasks));
        Level level = ((StargateClassicBaseBE)this.stargate).m_58904_();
        if (this.codeSender != null && level != null && !level.f_46443_) {
            compound.m_128365_("codeSender", (Tag)this.codeSender.serializeNBT());
        }
        return compound;
    }

    public void deserializeNBT(CompoundTag compound) {
        this.state = EnumIrisState.getValue(compound.m_128445_("irisState"));
        this.code = !compound.m_128461_("irisCode").isEmpty() ? compound.m_128461_("irisCode") : "";
        this.mode = EnumIrisMode.getValue(compound.m_128445_("irisMode"));
        this.type = EnumIrisType.byId(compound.m_128445_("irisType"));
        this.irisAnimationStart = compound.m_128454_("irisAnimationStart");
        Level level = ((StargateClassicBaseBE)this.stargate).m_58904_();
        if (level != null && compound.m_128441_("codeSender") && !level.f_46443_) {
            CompoundTag nbt = compound.m_128469_("codeSender");
            this.codeSender = CodeSender.fromNBT(nbt, level);
        }
        try {
            ScheduledTask.deserializeList(compound.m_128469_("scheduledTasks"), this.scheduledTasks, this);
        }
        catch (ClassCastException | IndexOutOfBoundsException | NullPointerException e) {
            JSG.logger.warn("Exception at reading NBT");
            JSG.logger.warn("If loading world used with previous version and nothing game-breaking doesn't happen, please ignore it", e);
        }
    }

    @Override
    public void tick(@NotNull Level level) {
        if (!level.f_46443_) {
            if (this.hasShield()) {
                int shieldKeepAlive = JSGConfig.Stargate.irisShieldPowerDraw.get();
                shieldKeepAlive += (int)(((StargateClassicBaseBE)this.stargate).irisHeat * (((StargateClassicBaseBE)this.stargate).irisHeat / StargateClassicBaseBE.IRIS_MAX_HEAT_TRINIUM));
                if (this.isIrisClosed()) {
                    ((LargeEnergyStorage)((Object)((StargateClassicBaseBE)this.stargate).getEnergyManager().getStorage())).extractEnergy(shieldKeepAlive, false);
                }
                if (((LargeEnergyStorage)((Object)((StargateClassicBaseBE)this.stargate).getEnergyManager().getStorage())).getEnergyStored() < shieldKeepAlive) {
                    StargateComputerEvents.IRIS_OUT_OF_POWER.get().sendVia(this.stargate);
                    this.toggleIris();
                } else if (this.mode == EnumIrisMode.CLOSED && this.state != EnumIrisState.CLOSING && this.state != EnumIrisState.CLOSED) {
                    this.toggleIris();
                }
            }
            if (!this.isIrisClosed() && !this.isIrisOpened() && ((StargateClassicBaseBE)this.stargate).getTime() - this.irisAnimationStart > (long)(this.hasPhysicalIris() ? 65 : 10)) {
                switch (this.state) {
                    case OPENING: {
                        StargateComputerEvents.IRIS_STATE_CHANGED.apply(this.state, EnumIrisState.OPENED).sendVia(this.stargate);
                        this.state = EnumIrisState.OPENED;
                        ((StargateAbstractStateManager)((StargateClassicBaseBE)this.stargate).getStateManager()).sendRenderingUpdate(StargateRendererActionState.EnumGateAction.IRIS_UPDATE, 0, false, this.type, this.state, this.irisAnimationStart);
                        if (this.afterIrisDone != null) {
                            this.afterIrisDone.run();
                        }
                        this.afterIrisDone = null;
                        break;
                    }
                    case CLOSING: {
                        StargateComputerEvents.IRIS_STATE_CHANGED.apply(this.state, EnumIrisState.CLOSED).sendVia(this.stargate);
                        this.state = EnumIrisState.CLOSED;
                        this.setIrisBlocks(true);
                        ((StargateAbstractStateManager)((StargateClassicBaseBE)this.stargate).getStateManager()).sendRenderingUpdate(StargateRendererActionState.EnumGateAction.IRIS_UPDATE, 0, false, this.type, this.state, this.irisAnimationStart);
                        if (this.afterIrisDone != null) {
                            this.afterIrisDone.run();
                        }
                        this.afterIrisDone = null;
                        break;
                    }
                }
                ((StargateClassicBaseBE)this.stargate).m_6596_();
            }
        }
    }

    @Override
    public void addTask(ScheduledTask scheduledTask) {
        scheduledTask.setExecutor(this);
        scheduledTask.setTaskCreated(((StargateClassicBaseBE)this.stargate).getTime());
        this.scheduledTasks.add(scheduledTask);
        ((StargateClassicBaseBE)this.stargate).m_6596_();
    }

    @Override
    public void executeTask(ScheduledTaskType scheduledTask, @NotNull CompoundTag customData) {
    }

    public static enum StargateIrisUpgradeEnum implements EnumKeyInterface<Item>
    {
        IRIS_UPGRADE_CLASSIC((Item)ItemRegistry.UPGRADE_IRIS.get()),
        IRIS_UPGRADE_TRINIUM((Item)ItemRegistry.UPGRADE_IRIS_TRINIUM.get()),
        IRIS_UPGRADE_CREATIVE((Item)ItemRegistry.UPGRADE_IRIS_CREATIVE.get()),
        IRIS_UPGRADE_SHIELD((Item)ItemRegistry.UPGRADE_SHIELD.get());

        public final Item item;
        private static final EnumKeyMap<Item, StargateIrisUpgradeEnum> idMap;

        private StargateIrisUpgradeEnum(Item item) {
            this.item = item;
        }

        @Override
        public Item getKey() {
            return this.item;
        }

        public static StargateIrisUpgradeEnum valueOf(Item item) {
            return idMap.valueOf(item);
        }

        public static boolean contains(Item item) {
            return idMap.contains(item);
        }

        static {
            idMap = new EnumKeyMap((EnumKeyInterface[])StargateIrisUpgradeEnum.values());
        }
    }
}

