/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.manager;

import dev.tauri.jsg.api.registry.ScheduledTaskType;
import dev.tauri.jsg.api.sound.StargateSoundPositionedEnum;
import dev.tauri.jsg.api.stargate.Stargate;
import dev.tauri.jsg.api.stargate.manager.IStargateSoundManager;
import dev.tauri.jsg.api.state.StateType;
import dev.tauri.jsg.api.util.ScheduledTask;
import dev.tauri.jsg.api.util.blockentity.ScheduledTaskExecutorInterface;
import dev.tauri.jsg.sound.JSGSoundHelper;
import dev.tauri.jsg.sound.PositionedSound;
import dev.tauri.jsg.stargate.manager.AbstractStargateManager;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class StargateSoundManager<BE extends Stargate<?>>
extends AbstractStargateManager<BE>
implements IStargateSoundManager,
ScheduledTaskExecutorInterface {
    protected boolean wormholeSound;
    protected boolean ringRollSound;
    protected boolean shieldHummingSound;
    protected ScheduledTask ringRollStartTask;

    public StargateSoundManager(BE stargate) {
        super(stargate);
    }

    @Override
    public void updateWormholeSound(boolean play) {
        this.wormholeSound = play;
        JSGSoundHelper.playPositionedSound(this.stargate.getStargateLevel(), this.stargate.getGateCenterPos(), PositionedSound.WORMHOLE_LOOP, play);
        this.stargate.setStargateChanged();
    }

    @Override
    public void updateShieldHummingSound(boolean play) {
        this.shieldHummingSound = play;
        JSGSoundHelper.playPositionedSound(this.stargate.getStargateLevel(), this.stargate.getGateCenterPos(), PositionedSound.SHIELD_HUMMING, play);
        this.stargate.setStargateChanged();
    }

    @Override
    public void updateRingRollSound(boolean play) {
        this.ringRollSound = play;
        this.stargate.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL_START, play);
        this.updateRingRollLoopSound(play);
        this.stargate.setStargateChanged();
    }

    private void updateRingRollLoopSound(boolean play) {
        if (play && this.stargate.getStargateLevel() != null && !this.stargate.getStargateLevel().m_5776_()) {
            this.ringRollStartTask = new ScheduledTask(ScheduledTaskType.STARGATE_RING_ROLL_LOOP_SOUND);
            this.ringRollStartTask.setExecutor(this);
            this.ringRollStartTask.setTaskCreated(this.stargate.getStargateLevel().m_46467_());
        } else {
            if (!play) {
                this.ringRollStartTask = null;
            }
            this.stargate.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL, play);
        }
        this.stargate.setStargateChanged();
    }

    @Override
    public boolean isRingRollPlaying() {
        return this.ringRollSound;
    }

    @Override
    public void onLoad(@NotNull Level level) {
        if (level.m_5776_()) {
            this.stargate.getStateManager().requestState(StateType.SOUND_UPDATE);
        } else {
            this.stargate.getStateManager().getAndSendState(StateType.SOUND_UPDATE);
        }
    }

    public void updateClient() {
        this.updateRingRollSound(this.ringRollSound);
        this.updateWormholeSound(this.wormholeSound);
        this.updateShieldHummingSound(this.shieldHummingSound);
    }

    @Override
    public void tick(@NotNull Level level) {
        if (this.ringRollStartTask != null) {
            this.ringRollStartTask.update(level.m_46467_());
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128379_("wormholeSound", this.wormholeSound);
        compound.m_128379_("ringRollSound", this.ringRollSound);
        compound.m_128379_("shieldHummingSound", this.shieldHummingSound);
        if (this.ringRollStartTask != null) {
            compound.m_128365_("ringRollStartTask", (Tag)this.ringRollStartTask.serializeNBT());
        }
        return compound;
    }

    public void deserializeNBT(CompoundTag compound) {
        this.wormholeSound = compound.m_128471_("wormholeSound");
        this.ringRollSound = compound.m_128471_("ringRollSound");
        this.shieldHummingSound = compound.m_128471_("shieldHummingSound");
        if (compound.m_128441_("ringRollStartTask")) {
            this.ringRollStartTask = new ScheduledTask(compound.m_128469_("ringRollStartTask"));
            this.ringRollStartTask.setExecutor(this);
        } else {
            this.ringRollStartTask = null;
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.wormholeSound);
        buf.writeBoolean(this.ringRollSound);
        buf.writeBoolean(this.shieldHummingSound);
    }

    public void fromBytes(ByteBuf buf) {
        this.wormholeSound = buf.readBoolean();
        this.ringRollSound = buf.readBoolean();
        this.shieldHummingSound = buf.readBoolean();
    }

    @Override
    public void addTask(ScheduledTask scheduledTask) {
    }

    @Override
    public void executeTask(ScheduledTaskType scheduledTask, @NotNull CompoundTag customData) {
        if (scheduledTask == ScheduledTaskType.STARGATE_RING_ROLL_LOOP_SOUND) {
            this.ringRollStartTask = null;
            this.stargate.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL, this.ringRollSound);
        }
    }
}

