/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.manager.dialing;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.api.chunkloader.ChunkManager;
import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.api.config.ingame.IConfigurable;
import dev.tauri.jsg.api.config.ingame.option.StargateConfigOptions;
import dev.tauri.jsg.api.event.StargateChevronEngagedEvent;
import dev.tauri.jsg.api.event.StargateClosedEvent;
import dev.tauri.jsg.api.event.StargateClosingEvent;
import dev.tauri.jsg.api.event.StargateDialFailEvent;
import dev.tauri.jsg.api.event.StargateOpenedEvent;
import dev.tauri.jsg.api.integration.ComputerDeviceProvider;
import dev.tauri.jsg.api.integration.SignalHolder;
import dev.tauri.jsg.api.integration.StargateComputerEvents;
import dev.tauri.jsg.api.power.general.EnergyRequiredToOperate;
import dev.tauri.jsg.api.registry.ScheduledTaskType;
import dev.tauri.jsg.api.sound.StargateSoundEventEnum;
import dev.tauri.jsg.api.stargate.ChevronEnum;
import dev.tauri.jsg.api.stargate.EnumStargateState;
import dev.tauri.jsg.api.stargate.Stargate;
import dev.tauri.jsg.api.stargate.StargateClosedReasonEnum;
import dev.tauri.jsg.api.stargate.animation.EnumDialingType;
import dev.tauri.jsg.api.stargate.animation.IAddressDialSequence;
import dev.tauri.jsg.api.stargate.exception.BiStargateException;
import dev.tauri.jsg.api.stargate.exception.StargateException;
import dev.tauri.jsg.api.stargate.manager.IStargateDialingManager;
import dev.tauri.jsg.api.stargate.network.IStargateNetwork;
import dev.tauri.jsg.api.stargate.network.StargatePos;
import dev.tauri.jsg.api.stargate.network.address.StargateAddressDynamic;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolInterface;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.AbstractSymbolType;
import dev.tauri.jsg.api.stargate.result.StargateAddressCheckResult;
import dev.tauri.jsg.api.stargate.result.StargateChevronEngageResult;
import dev.tauri.jsg.api.stargate.result.StargateCloseResult;
import dev.tauri.jsg.api.stargate.result.StargateConnectResult;
import dev.tauri.jsg.api.stargate.result.StargateConnectionStatus;
import dev.tauri.jsg.api.stargate.result.StargateOpenResult;
import dev.tauri.jsg.api.util.ScheduledTask;
import dev.tauri.jsg.api.util.blockentity.ITickable;
import dev.tauri.jsg.api.util.blockentity.ScheduledTaskExecutorInterface;
import dev.tauri.jsg.config.stargate.StargateDimensionConfig;
import dev.tauri.jsg.renderer.stargate.StargateClassicRendererState;
import dev.tauri.jsg.stargate.StargateAddressDialSequence;
import dev.tauri.jsg.stargate.animation.incoming.IncomingAnimation;
import dev.tauri.jsg.stargate.animation.incoming.StaticIncomingAnimation;
import dev.tauri.jsg.stargate.animation.spinning.ClassicSpinHelper;
import dev.tauri.jsg.stargate.manager.AbstractStargateManager;
import dev.tauri.jsg.stargate.manager.StargateAutoCloseManager;
import dev.tauri.jsg.stargate.manager.StargateConnection;
import dev.tauri.jsg.stargate.manager.StargateEnergyManager;
import dev.tauri.jsg.stargate.manager.StargateEventHorizonManager;
import dev.tauri.jsg.stargate.manager.state.StargateAbstractStateManager;
import dev.tauri.jsg.stargate.network.StargateNetwork;
import dev.tauri.jsg.state.stargate.StargateRendererActionState;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@FieldsAreNonnullByDefault
public abstract class StargateAbstractDialingManager<SG extends Stargate<?>>
extends AbstractStargateManager<SG>
implements ITickable,
ScheduledTaskExecutorInterface,
INBTSerializable<CompoundTag>,
IStargateDialingManager {
    public static final Supplier<IStargateNetwork> network = () -> StargateNetwork.INSTANCE;
    protected final StargateConnection activeConnection;
    protected final Consumer<StargateConnection> tickConnection;
    protected final StargateAddressDynamic dialedAddress;
    protected boolean isFinalActive;
    @Nullable
    protected IncomingAnimation<?> incomingAnimation = null;
    @Nullable
    protected StargateAddressDialSequence addressDialSequence = null;
    private EnumStargateState stargateState = EnumStargateState.IDLE;
    protected final List<ScheduledTask> scheduledTasks = new ArrayList<ScheduledTask>();

    public StargateAbstractDialingManager(SG stargate) {
        this(stargate, connection -> {});
    }

    public StargateAbstractDialingManager(SG stargate, Consumer<StargateConnection> tickConnection) {
        super(stargate);
        this.activeConnection = StargateConnection.createEmpty(stargate);
        this.tickConnection = tickConnection;
        this.dialedAddress = new StargateAddressDynamic(stargate.getSymbolType());
    }

    public abstract ClassicSpinHelper generateSpinHelper();

    @Override
    public EnumStargateState getStargateState() {
        return this.stargateState;
    }

    public void setStargateState(EnumStargateState newState) {
        if (this.stargateState == newState) {
            return;
        }
        this.stargate.getListenerHandler().gateStateChanged(this.getStargateState(), newState);
        this.stargateState = newState;
        this.stargate.setStargateChanged();
    }

    @Override
    public abstract ClassicSpinHelper getSpinHelper();

    @Override
    public StargateConnection getConnection() {
        return this.activeConnection;
    }

    @Override
    public int getDialedAddressSize() {
        return this.dialedAddress.size();
    }

    @Override
    public StargateAddressDynamic getDialedAddress() {
        return new StargateAddressDynamic(this.dialedAddress);
    }

    @Override
    public boolean isFinalActive() {
        return this.isFinalActive;
    }

    @Override
    public Optional<IAddressDialSequence> getDialingSequence() {
        return Optional.ofNullable(this.addressDialSequence);
    }

    public StargateClassicRendererState.StargateClassicRendererStateBuilder processRenderState(StargateClassicRendererState.StargateClassicRendererStateBuilder builder) {
        return builder;
    }

    @Override
    public ChevronEnum getNextChevron(@Nullable SymbolInterface symbolToLock, boolean alreadyInAddress, boolean ignoreMaxChevrons) {
        ChevronEnum nextChevron = ChevronEnum.valueOf(this.dialedAddress.size() - (alreadyInAddress ? 1 : 0));
        if (this.isLockChevron(symbolToLock, !alreadyInAddress, ignoreMaxChevrons)) {
            nextChevron = ChevronEnum.getFinal();
        }
        return nextChevron;
    }

    protected void onRingStopSpinning(CompoundTag stopSpinData) {
        if (this.stargate.getStargateLevel() == null || this.stargate.getStargateLevel().m_5776_()) {
            return;
        }
        if (stopSpinData.m_128441_("symbol")) {
            Object symbol = this.stargate.getSymbolType().valueOf(stopSpinData.m_128451_("symbol"));
            this.stargate.getStateManager().getChevronsState().scheduleChevronOpen(10, ChevronEnum.getFinal(), false);
            this.stargate.getStateManager().getChevronsState().scheduleChevronActivate(17, this.getNextChevron((SymbolInterface)symbol, false, stopSpinData.m_128471_("ignoreMaxChevrons")), (SymbolInterface)symbol, false, true, true, stopSpinData.m_128471_("noEnergy"), stopSpinData.m_128471_("ignoreMaxChevrons"));
        } else if (this.getStargateState().dialingComputer()) {
            this.setStargateState(EnumStargateState.IDLE);
        }
    }

    @Override
    public StargateOpenResult attemptOpenDialed() {
        if (this.getConnection().isRIG()) {
            if (this.openGate()) {
                return StargateOpenResult.OK;
            }
            this.dialingFailed(StargateOpenResult.CALLER_HUNG_UP);
            return StargateOpenResult.CALLER_HUNG_UP;
        }
        StargateOpenResult result = this.getCanOpenDialed();
        if (result.ok()) {
            if (this.openGate()) {
                return StargateOpenResult.OK;
            }
            result = StargateOpenResult.ADDRESS_MALFORMED;
        }
        this.dialingFailed(result);
        return result;
    }

    protected StargateOpenResult getCanOpenDialed() {
        if (!this.getDialedAddress().validate()) {
            return StargateOpenResult.ADDRESS_MALFORMED;
        }
        return this.checkEnergyRequirementsOnDialed().toOpenResult();
    }

    @Override
    public StargateChevronEngageResult engageCurrentSymbol() {
        SymbolInterface symbol = this.getSpinHelper().getCurrentTopSymbol();
        if (symbol == null) {
            return StargateChevronEngageResult.BLOCKED_BY_EVENT;
        }
        this.stargate.getStateManager().getChevronsState().scheduleChevronOpen(10, ChevronEnum.getFinal(), false);
        this.stargate.getStateManager().getChevronsState().scheduleChevronActivate(17, this.getNextChevron(symbol, false, false), symbol, false, true, true);
        return StargateChevronEngageResult.OK;
    }

    @Override
    public boolean engageSymbolBySpin(SymbolInterface symbol, boolean noEnergy, boolean ignoreMaxChevrons) {
        if (!this.getStargateState().idle() && !this.getStargateState().dialing()) {
            return false;
        }
        if (this.getSpinHelper().isSpinning()) {
            return false;
        }
        Pair<Boolean, Float> r = this.getSpinHelper().moveToAndEngage(symbol, this.isLockChevron(symbol, true, ignoreMaxChevrons), noEnergy, ignoreMaxChevrons);
        if (((Boolean)r.first()).booleanValue()) {
            this.setStargateState(EnumStargateState.DIALING_COMPUTER);
            if (this.isLockChevron(symbol, true, ignoreMaxChevrons)) {
                this.getConnection().runOnConnected((conn, sg) -> ((StargateAbstractDialingManager)sg.getDialingManager()).runIncomingWormhole(this.dialedAddress.addOriginIfMissingAndImmutable().size(), ((Float)r.second()).intValue()));
            }
        }
        return (Boolean)r.first();
    }

    @Override
    public StargateChevronEngageResult dialAddress(StargateAddressDynamic address, boolean noEnergy, boolean ignoreMaxChevrons, EnumDialingType dialingType) {
        if (!this.getStargateState().idle() || this.addressDialSequence != null) {
            return StargateChevronEngageResult.BUSY;
        }
        if (this.getDialedAddressSize() > 0) {
            return StargateChevronEngageResult.ALREADY_ENGAGED;
        }
        if (dialingType == EnumDialingType.NOX) {
            StargateAddressCheckResult r = this.checkAddressAndEnergyRequirements(address, noEnergy);
            if (r != StargateAddressCheckResult.OK) {
                this.dialingFailed(r.toOpenResult());
                return StargateChevronEngageResult.BLOCKED_BY_EVENT;
            }
            StargateChevronEngageResult result = this.engageAddressByNox(address, noEnergy, ignoreMaxChevrons);
            if (result != StargateChevronEngageResult.OK) {
                this.dialingFailed(StargateOpenResult.ADDRESS_MALFORMED);
            }
            this.stargate.getListenerHandler().gateBeginDial();
            return result;
        }
        this.addressDialSequence = this.getAddressDialSequence(address, noEnergy, ignoreMaxChevrons, dialingType);
        this.stargate.setStargateChanged();
        this.addressDialSequence.dialNext();
        this.stargate.getListenerHandler().gateBeginDial();
        return StargateChevronEngageResult.OK;
    }

    protected IAddressDialSequence.DialNextConsumer getAddressDialSequenceSymbolConsumer() {
        return (symbol, noEnergy, ignoreMaxChevrons, dialingType) -> {
            if (symbol == null) {
                this.attemptOpenDialed();
                this.addressDialSequence = null;
                this.stargate.setStargateChanged();
                return;
            }
            if (dialingType == EnumDialingType.NORMAL) {
                this.engageSymbolBySpin(symbol, noEnergy, ignoreMaxChevrons);
                return;
            }
            this.engageSymbolDHD(symbol, noEnergy, ignoreMaxChevrons);
        };
    }

    protected StargateAddressDialSequence getAddressDialSequence(StargateAddressDynamic address, boolean noEnergy, boolean ignoreMaxChevrons, EnumDialingType dialingType) {
        return new StargateAddressDialSequence(this.getAddressDialSequenceSymbolConsumer(), address, noEnergy, ignoreMaxChevrons, dialingType);
    }

    protected StargateAddressDialSequence getAddressDialSequence(CompoundTag tag) {
        return new StargateAddressDialSequence(this.getAddressDialSequenceSymbolConsumer(), tag);
    }

    @Override
    public StargateChevronEngageResult engageSymbolDHD(SymbolInterface symbol, boolean noEnergy, boolean ignoreMaxChevrons) {
        return this.engageSymbolInternal(symbol, false, noEnergy, ignoreMaxChevrons);
    }

    @Override
    public StargateChevronEngageResult engageAddressByNox(StargateAddressDynamic address, boolean noEnergy, boolean ignoreMaxChevrons) {
        if (!this.getStargateState().idle()) {
            return StargateChevronEngageResult.BUSY;
        }
        for (SymbolInterface s : address.subList(0, address.size())) {
            StargateChevronEngageResult r = this.engageSymbolInternal(s, true, noEnergy, ignoreMaxChevrons);
            if (!r.ok()) {
                return r;
            }
            if (r != StargateChevronEngageResult.OK_CONNECTED) continue;
            this.getConnection().runOnConnected((conn, sg) -> ((StargateAbstractDialingManager)sg.getDialingManager()).runIncomingWormhole(this.dialedAddress.addOriginIfMissingAndImmutable().size(), 0));
        }
        ArrayList<ChevronEnum> chevrons = new ArrayList<ChevronEnum>();
        for (int i = 0; i < address.size(); ++i) {
            if (i == address.size() - 1) {
                chevrons.add(ChevronEnum.getFinal());
                continue;
            }
            chevrons.add(ChevronEnum.valueOf(i));
        }
        this.stargate.getStateManager().getChevronsState().scheduleChevronsActivateMultiple(0, false, false, chevrons);
        this.attemptOpenDialed();
        return StargateChevronEngageResult.OK;
    }

    protected StargateChevronEngageResult engageSymbolInternal(SymbolInterface symbol, boolean isNox, boolean noEnergy, boolean ignoreMaxChevrons) {
        if (!this.getStargateState().idle() && !this.getStargateState().dialing()) {
            return StargateChevronEngageResult.BUSY;
        }
        StargateChevronEngageResult r = this.canAddSymbol(symbol, ignoreMaxChevrons);
        if (r != StargateChevronEngageResult.OK) {
            return r;
        }
        this.dialedAddress.addSymbol(symbol);
        if (this.isLockChevron(symbol, ignoreMaxChevrons)) {
            this.isFinalActive = true;
            this.stargate.setStargateChanged();
        }
        Optional<StargatePos> lastGate = this.getConnection().getTarget();
        StargateConnectResult connResult = this.findAndConnect(this.dialedAddress.addOriginIfMissingAndImmutable(), isNox, noEnergy);
        if (this.getConnection().getStatus().prepared() && this.isFinalActive) {
            this.getConnection().updateStatus(StargateConnectionStatus.WAITING_FOR_WORMHOLE);
        }
        this.stargate.getListenerHandler().gateSymbolEngage(symbol);
        if (!connResult.ok()) {
            return StargateChevronEngageResult.OK;
        }
        if (lastGate.isEmpty() || !this.getConnection().getTarget().map(target -> target.equals(lastGate.get())).orElse(false).booleanValue()) {
            return StargateChevronEngageResult.OK_CONNECTED;
        }
        return StargateChevronEngageResult.OK;
    }

    @Override
    public StargateCloseResult disconnectSafe(StargateClosedReasonEnum reason) {
        StargateConnectionStatus connState = this.getConnection().getStatus();
        if (connState.full()) {
            return this.attemptClose(reason);
        }
        if (connState.closing()) {
            return this.disconnectWormhole(reason) ? StargateCloseResult.OK : StargateCloseResult.NOT_OPEN;
        }
        if (connState.prepared() || connState.waiting()) {
            this.getConnection().updateStatus(StargateConnectionStatus.CLOSING);
            this.clearIncomingWormholeOnIncoming();
            return this.disconnect() ? StargateCloseResult.OK : StargateCloseResult.NOT_OPEN;
        }
        return StargateCloseResult.NOT_OPEN;
    }

    @Override
    public boolean abortDialingSequence() {
        if (!this.canAbortDialing()) {
            return false;
        }
        this.getSpinHelper().stopSpinning(true);
        this.disconnectSafe(StargateClosedReasonEnum.REQUESTED);
        this.dialingFailed(StargateOpenResult.ABORTED);
        this.stargate.getListenerHandler().gateDialAbort();
        return true;
    }

    @Override
    public boolean canAbortDialing() {
        return !this.getStargateState().notInitiating() && (this.addressDialSequence != null || this.getStargateState().dialing() || this.dialedAddress.size() > 0);
    }

    @Override
    public StargateCloseResult attemptClose(StargateClosedReasonEnum reason) {
        Boolean eventResult;
        if (this.activeConnection.getStatus() != StargateConnectionStatus.FULLY) {
            ((SignalHolder)StargateComputerEvents.ATTEMPT_CLOSE_FAILED.apply((Object)StargateCloseResult.NOT_OPEN, (Object)this.getDialedAddress(), (Object)false)).sendVia(this.stargate);
            return StargateCloseResult.NOT_OPEN;
        }
        if (reason == StargateClosedReasonEnum.REQUESTED && (eventResult = this.activeConnection.callConnected((c, sg) -> {
            if (new StargateClosingEvent(this.stargate, (Stargate<?>)sg, this.activeConnection.isInitiating(), reason).post()) {
                return true;
            }
            return new StargateClosingEvent((Stargate<?>)sg, this.stargate, c.isInitiating(), reason).post();
        }, () -> false)).booleanValue()) {
            ((SignalHolder)StargateComputerEvents.ATTEMPT_CLOSE_FAILED.apply((Object)StargateCloseResult.BLOCKED_BY_EVENT, (Object)this.getDialedAddress(), (Object)this.activeConnection.isInitiating())).sendVia(this.stargate);
            return StargateCloseResult.BLOCKED_BY_EVENT;
        }
        if (!this.closeGate(reason)) {
            ((SignalHolder)StargateComputerEvents.ATTEMPT_CLOSE_FAILED.apply((Object)StargateCloseResult.NOT_OPEN, (Object)this.getDialedAddress(), (Object)this.activeConnection.isInitiating())).sendVia(this.stargate);
            return StargateCloseResult.NOT_OPEN;
        }
        return StargateCloseResult.OK;
    }

    @ApiStatus.Internal
    protected StargateConnectResult findAndConnect(StargateAddressDynamic address, boolean isNox, boolean noEnergy) {
        StargatePos gate = network.get().getStargate(address);
        if (gate == null) {
            if (!this.activeConnection.getStatus().none()) {
                JSG.logger.debug("Connected - disconnecting - target gate null");
                this.disconnectSafe(StargateClosedReasonEnum.CONNECTION_LOST);
            }
            return StargateConnectResult.ADDRESS_MALFORMED;
        }
        if (!this.activeConnection.getStatus().none()) {
            if (this.activeConnection.getTarget().map(target -> target.equals(gate)).orElse(false).booleanValue()) {
                JSG.logger.debug("Connected, but to the same gate - updating");
                return StargateConnectResult.ALREADY_CONNECTED;
            }
            JSG.logger.debug("Connected - disconnecting - active connection present");
            this.disconnectSafe(StargateClosedReasonEnum.CONNECTION_LOST);
        }
        JSG.logger.debug("Connecting");
        StargateConnectResult result = this.connect(address, gate, isNox, noEnergy);
        JSG.logger.debug("Connect result: " + result.name());
        return result;
    }

    protected boolean openGate() {
        if (this.activeConnection.getStatus() != StargateConnectionStatus.WAITING_FOR_WORMHOLE) {
            JSG.logger.warn("", new StargateException("Tried to open gate while not prepared for that!", this.stargate));
            return false;
        }
        this.activeConnection.runOnBothConnected((conn, stargate) -> {
            StargateAbstractDialingManager dm = (StargateAbstractDialingManager)stargate.getDialingManager();
            if (dm.incomingAnimation != null) {
                dm.incomingAnimation.finish();
            }
            dm.addressDialSequence = null;
            dm.incomingAnimation = null;
            dm.scheduledTasks.clear();
            dm.isFinalActive = true;
            stargate.getListenerHandler().gateOpen();
            dm.setStargateState(EnumStargateState.UNSTABLE_OPENING);
            StargateComputerEvents.WORMHOLE_OPEN_UNSTABLE.apply(conn.isInitiating() ? stargate.getDialingManager().getDialedAddress() : new StargateAddressDynamic(stargate.getSymbolType()), conn.isInitiating()).sendVia((ComputerDeviceProvider)stargate);
            ((StargateAbstractStateManager)stargate.getStateManager()).sendRenderingUpdate(StargateRendererActionState.EnumGateAction.OPEN_GATE, 0, conn.isNox());
            dm.addTask(new ScheduledTask(ScheduledTaskType.STARGATE_OPEN_SOUND, stargate.getOpenSoundDelay()));
            dm.addTask(new ScheduledTask(ScheduledTaskType.STARGATE_ENGAGE));
            ((StargateEventHorizonManager)stargate.getEventHorizonManager()).onGateOpen(conn.isNox());
            if (conn.isInitiating()) {
                ((StargateEnergyManager)stargate.getEnergyManager()).onGateOpen();
            }
            dm.onGateOpen(conn.isInitiating());
            stargate.setStargateChanged();
            JSG.logger.info("Gate {} opened!", (Object)stargate.getStargatePos().toString());
        });
        return true;
    }

    protected void onGateOpen(boolean initiating) {
    }

    @ApiStatus.Internal
    protected boolean connectWormhole() {
        if (this.activeConnection.getStatus() != StargateConnectionStatus.WAITING_FOR_WORMHOLE) {
            JSG.logger.warn("", new StargateException("Tried to connect wormhole while not waiting for that!", this.stargate));
            return false;
        }
        this.activeConnection.runOnBothConnected((conn, stargate) -> {
            StargateAbstractDialingManager dm = (StargateAbstractDialingManager)stargate.getDialingManager();
            dm.scheduledTasks.clear();
            dm.setStargateState(conn.isInitiating() ? EnumStargateState.ENGAGED_INITIATING : EnumStargateState.ENGAGED);
            stargate.getSoundManager().updateWormholeSound(true);
            stargate.getStateManager().getBlackHoleAnimationState().setConnectedToBlackHole(stargate.isBlackHoleEffected() || conn.callConnected((conn1, stargate1) -> stargate1.isBlackHoleEffected(), () -> false) != false, stargate.isBlackHoleEffected());
            conn.runOnConnected((c, sg) -> new StargateOpenedEvent((Stargate<?>)stargate, (Stargate<?>)sg, conn.isInitiating()).post());
            StargateComputerEvents.WORMHOLE_OPEN_FULLY.apply(conn.isInitiating() ? stargate.getDialingManager().getDialedAddress() : new StargateAddressDynamic(stargate.getSymbolType()), conn.isInitiating()).sendVia((ComputerDeviceProvider)stargate);
        });
        this.activeConnection.updateStatus(StargateConnectionStatus.FULLY);
        return true;
    }

    @ApiStatus.Internal
    protected boolean closeGate(StargateClosedReasonEnum reason) {
        if (this.activeConnection.getStatus() != StargateConnectionStatus.FULLY) {
            JSG.logger.warn("", new StargateException("Tried to close gate while not fully opened!", this.stargate));
            return false;
        }
        this.activeConnection.runOnBothConnected((conn, stargate) -> {
            StargateAbstractDialingManager dm = (StargateAbstractDialingManager)stargate.getDialingManager();
            dm.scheduledTasks.clear();
            stargate.getListenerHandler().gateClose(reason);
            dm.setStargateState(EnumStargateState.UNSTABLE_CLOSING);
            dm.addTask(new ScheduledTask(ScheduledTaskType.STARGATE_CLOSE, 62, (CompoundTag)Util.m_137469_((Object)new CompoundTag(), tag -> tag.m_128405_("reason", reason.ordinal()))));
            dm.addTask(new ScheduledTask(ScheduledTaskType.STARGATE_CLOSE_SOUND, stargate.getCloseSoundDelay()));
            ((StargateAbstractStateManager)stargate.getStateManager()).sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CLOSE_GATE, 0, false);
            stargate.getSoundManager().updateWormholeSound(false);
            ((SignalHolder)StargateComputerEvents.WORMHOLE_CLOSE_UNSTABLE.apply((Object)(conn.isInitiating() ? stargate.getDialingManager().getDialedAddress() : new StargateAddressDynamic(stargate.getSymbolType())), (Object)reason, (Object)conn.isInitiating())).sendVia((ComputerDeviceProvider)stargate);
            JSG.logger.debug("Gate at {} closed!", (Object)stargate.blockPosition().toString());
        });
        this.activeConnection.updateStatus(StargateConnectionStatus.CLOSING);
        return true;
    }

    @ApiStatus.Internal
    protected boolean disconnectWormhole(StargateClosedReasonEnum reason) {
        if (this.activeConnection.getStatus() != StargateConnectionStatus.CLOSING) {
            JSG.logger.warn("", new StargateException("Tried to disconnect wormhole while not closing!", this.stargate));
            return false;
        }
        this.activeConnection.runOnBothConnected((conn, stargate) -> {
            Level level = stargate.getStargateLevel();
            if (level != null && level.m_8055_(stargate.getGateCenterPos()).m_60734_() == Blocks.f_152480_) {
                level.m_46597_(stargate.getGateCenterPos(), Blocks.f_50016_.m_49966_());
            }
            StargateAbstractDialingManager dm = (StargateAbstractDialingManager)stargate.getDialingManager();
            if (dm.incomingAnimation != null) {
                dm.incomingAnimation.stop();
            }
            ((SignalHolder)StargateComputerEvents.WORMHOLE_CLOSE_FULLY.apply((Object)(conn.isInitiating() ? dm.getDialedAddress() : new StargateAddressDynamic(stargate.getSymbolType())), (Object)reason, (Object)conn.isInitiating())).sendVia((ComputerDeviceProvider)stargate);
            dm.addressDialSequence = null;
            dm.incomingAnimation = null;
            dm.scheduledTasks.clear();
            stargate.getListenerHandler().gateDisconnect();
            ((StargateAutoCloseManager)stargate.getAutoCloseManager()).wormholeDisconnected();
            dm.isFinalActive = false;
            stargate.getStateManager().getChevronsState().scheduleChevronsDimAll(0, true);
            dm.onWormholeDisconnected();
            dm.dialedAddress.clear();
            ((StargateEventHorizonManager)stargate.getEventHorizonManager()).onGateClose();
            stargate.setStargateChanged();
            new StargateClosedEvent((Stargate<?>)stargate).post();
        });
        this.disconnect();
        return true;
    }

    protected void onWormholeDisconnected() {
    }

    public void dialingFailed(StargateOpenResult reason) {
        this.scheduledTasks.clear();
        this.getConnection().updateStatus(StargateConnectionStatus.CLOSING);
        this.addressDialSequence = null;
        this.stargate.getListenerHandler().gateFail(reason);
        new StargateDialFailEvent(this.stargate, reason).post();
        this.addFailedTaskAndPlaySound();
        this.getSpinHelper().stopSpinning(true);
        this.setStargateState(EnumStargateState.FAILING);
        JSG.logger.info("Gate {} failed! Cause: {}", (Object)this.stargate.getStargatePos().toString(), (Object)reason.name());
        StargateComputerEvents.ATTEMPT_OPEN_FAILED.apply(reason, this.getDialedAddress()).sendVia(this.stargate);
        this.stargate.setStargateChanged();
    }

    protected void addFailedTaskAndPlaySound() {
        this.addTask(new ScheduledTask(ScheduledTaskType.STARGATE_FAIL, 53));
        this.stargate.playSoundEvent(StargateSoundEventEnum.DIAL_FAILED);
    }

    @ApiStatus.Internal
    protected void failGate() {
        this.getConnection().updateStatus(StargateConnectionStatus.CLOSING);
        this.disconnectSafe(StargateClosedReasonEnum.CONNECTION_LOST);
        this.dialedAddress.clear();
        this.isFinalActive = false;
        this.stargate.getStateManager().getChevronsState().scheduleChevronsDimAll(0, true);
        this.stargate.setStargateChanged();
    }

    @ApiStatus.Internal
    protected StargateConnectResult connect(StargateAddressDynamic address, StargatePos targetGatePos, boolean isNox, boolean noEnergy) {
        if (!this.activeConnection.getStatus().none()) {
            JSG.logger.error("", new StargateException("Tried to connect to a gate when already connected to a gate", this.stargate));
            return StargateConnectResult.ALREADY_CONNECTED;
        }
        if (this.stargate.isGateBurried()) {
            return StargateConnectResult.GATE_BURRIED;
        }
        Stargate<?> targetStargate = targetGatePos.getStargate();
        if (targetStargate == null) {
            return StargateConnectResult.ADDRESS_MALFORMED_SGN_OK;
        }
        StargateAddressCheckResult result = this.checkAddressAndEnergyRequirements(address, true);
        if (result != StargateAddressCheckResult.OK) {
            return result.toConnectResult();
        }
        if (targetStargate.isGateBurried()) {
            return StargateConnectResult.TARGET_GATE_BURRIED;
        }
        StargateAbstractDialingManager targetDm = (StargateAbstractDialingManager)targetStargate.getDialingManager();
        StargateConnection targetConnection = targetDm.activeConnection;
        if (!targetConnection.getStatus().none() && targetConnection.getTarget().map(p -> !this.stargate.is((StargatePos)p)).orElse(false).booleanValue()) {
            return StargateConnectResult.TARGET_BUSY;
        }
        if (!this.activeConnection.establish(targetGatePos, isNox, noEnergy)) {
            JSG.logger.error("", new BiStargateException("Cannot establish connection between specified gates", this.stargate, targetStargate));
            return StargateConnectResult.ADDRESS_MALFORMED;
        }
        this.activeConnection.runOnBothConnected((conn, stargate) -> {
            ChunkManager.forceChunk(stargate);
            StargateComputerEvents.WORMHOLE_SUBSPACE_CONNECTED.apply(conn.isInitiating() ? address : new StargateAddressDynamic(stargate.getSymbolType()), conn.isInitiating()).sendVia((ComputerDeviceProvider)stargate);
        });
        return StargateConnectResult.OK;
    }

    @ApiStatus.Internal
    protected boolean disconnect() {
        this.activeConnection.runOnBothConnected((conn, stargate) -> {
            StargateComputerEvents.WORMHOLE_SUBSPACE_DISCONNECTED.get().sendVia((ComputerDeviceProvider)stargate);
            stargate.getStateManager().getBlackHoleAnimationState().setConnectedToBlackHole(false, false);
            if (((StargateAbstractDialingManager)stargate.getDialingManager()).canUnforceChunk()) {
                ChunkManager.unforceChunk(stargate);
            }
        });
        this.activeConnection.updateStatus(StargateConnectionStatus.NONE);
        return true;
    }

    protected boolean canUnforceChunk() {
        return true;
    }

    public void onGateUnmerged() {
        this.getSpinHelper().stopSpinning(true);
        this.disconnectSafe(StargateClosedReasonEnum.CONNECTION_LOST);
        this.dialedAddress.clear();
        this.setStargateState(EnumStargateState.IDLE);
    }

    protected IncomingAnimation<?> getIncomingAnimationByConfig(CompoundTag tag) {
        boolean animate = JSGConfig.Stargate.allowIncomingAnimations.get();
        Stargate stargate = this.stargate;
        if (stargate instanceof IConfigurable) {
            IConfigurable configurable = (IConfigurable)((Object)stargate);
            animate = configurable.getConfig().getValueOrDefault(StargateConfigOptions.Classic.INCOMING_ANIMATION);
        }
        if (animate) {
            return this.getIncomingAnimation(tag);
        }
        return this.getIncomingAnimationStatic(tag);
    }

    protected IncomingAnimation<?> getIncomingAnimationByConfig(int addressSize, int duration) {
        boolean animate = JSGConfig.Stargate.allowIncomingAnimations.get();
        Stargate stargate = this.stargate;
        if (stargate instanceof IConfigurable) {
            IConfigurable configurable = (IConfigurable)((Object)stargate);
            animate = configurable.getConfig().getValueOrDefault(StargateConfigOptions.Classic.INCOMING_ANIMATION);
        }
        if (animate) {
            return this.getIncomingAnimation(addressSize, duration);
        }
        return this.getIncomingAnimationStatic(addressSize, duration);
    }

    protected IncomingAnimation<?> getIncomingAnimation(CompoundTag tag) {
        return new IncomingAnimation<StargateAbstractDialingManager>(this, tag);
    }

    protected IncomingAnimation<?> getIncomingAnimation(int addressSize, int duration) {
        return new IncomingAnimation<StargateAbstractDialingManager>(this.stargate.getTime(), this, addressSize, duration);
    }

    protected IncomingAnimation<?> getIncomingAnimationStatic(CompoundTag tag) {
        return new StaticIncomingAnimation(this, tag);
    }

    protected IncomingAnimation<?> getIncomingAnimationStatic(int addressSize, int duration) {
        return new StaticIncomingAnimation(this.stargate.getTime(), this, addressSize, duration);
    }

    protected void onIncoming(int addressSize, int duration) {
    }

    public void runIncomingWormhole(int addressSize, int duration) {
        if (!this.getConnection().getStatus().prepared() && !this.getConnection().getStatus().waiting()) {
            JSG.logger.error("", new StargateException("Gate must be prepared to accept incoming", this.stargate));
            return;
        }
        if (this.incomingAnimation != null) {
            JSG.logger.error("", new StargateException("incomingAnimation != null!", this.stargate));
            return;
        }
        this.scheduledTasks.clear();
        this.stargate.getStateManager().getChevronsState().scheduleChevronsDimAll(0, false);
        this.getSpinHelper().stopSpinning(true);
        this.dialedAddress.clear();
        this.addressDialSequence = null;
        this.incomingAnimation = this.getIncomingAnimationByConfig(addressSize, duration);
        this.incomingAnimation.start();
        this.setStargateState(EnumStargateState.INCOMING);
        this.stargate.getListenerHandler().gateIncoming(addressSize);
        this.onIncoming(addressSize, duration);
        this.stargate.setStargateChanged();
        StargateComputerEvents.WORMHOLE_INCOMING.apply(addressSize).sendVia(this.stargate);
    }

    protected void clearIncomingWormholeOnSelf() {
        this.setStargateState(EnumStargateState.IDLE);
    }

    protected void clearIncomingWormholeOnIncoming() {
        if (this.activeConnection.getStatus() != StargateConnectionStatus.CLOSING) {
            return;
        }
        this.getConnection().runOnBothConnected((conn, sg) -> {
            if (conn.isInitiating()) {
                return;
            }
            StargateAbstractDialingManager dm = (StargateAbstractDialingManager)sg.getDialingManager();
            dm.incomingAnimation = null;
            dm.scheduledTasks.clear();
            dm.clearIncomingWormholeOnSelf();
            dm.isFinalActive = false;
            dm.setStargateState(EnumStargateState.IDLE);
            sg.setStargateChanged();
        });
        this.disconnect();
    }

    @Override
    public StargateAddressCheckResult checkEnergyRequirementsOnDialed() {
        if (this.getConnection().isRIG()) {
            return StargateAddressCheckResult.OK;
        }
        return this.getConnection().callConnected((conn, sg) -> {
            if (!conn.getStatus().waiting()) {
                return StargateAddressCheckResult.MALFORMED;
            }
            if (conn.withoutEnergy()) {
                return StargateAddressCheckResult.OK;
            }
            EnergyRequiredToOperate energyRequired = this.stargate.getEnergyManager().getEnergyRequiredToDial((Stargate<?>)sg, this.dialedAddress);
            if (this.stargate.getEnergyManager().getStorage().getEnergyStored() < energyRequired.energyToOpen) {
                return StargateAddressCheckResult.NOT_ENOUGH_POWER;
            }
            return StargateAddressCheckResult.OK;
        }, () -> StargateAddressCheckResult.MALFORMED);
    }

    @Override
    public StargateAddressCheckResult checkAddressAndEnergyRequirements(StargateAddressDynamic address, boolean noEnergy) {
        Pair<StargateAddressCheckResult, Stargate<?>> result = this.getTargetByAddress(address);
        if (result.first() != StargateAddressCheckResult.OK) {
            return (StargateAddressCheckResult)((Object)result.first());
        }
        if (noEnergy) {
            return StargateAddressCheckResult.OK;
        }
        EnergyRequiredToOperate energyRequired = this.stargate.getEnergyManager().getEnergyRequiredToDial((Stargate)result.second(), address);
        if (this.stargate.getEnergyManager().getStorage().getEnergyStored() < energyRequired.energyToOpen) {
            return StargateAddressCheckResult.NOT_ENOUGH_POWER;
        }
        return StargateAddressCheckResult.OK;
    }

    @Override
    public boolean canDialAddress(StargateAddressDynamic address) {
        return this.getTargetByAddress(address).first() == StargateAddressCheckResult.OK;
    }

    @Override
    public Pair<StargateAddressCheckResult, Stargate<?>> getTargetByAddress(StargateAddressDynamic address) {
        if (!address.validate()) {
            return Pair.of((Object)((Object)StargateAddressCheckResult.MALFORMED), null);
        }
        Optional<StargatePos> targetPosOptional = this.getDialableStargatePos(address);
        if (targetPosOptional.isEmpty()) {
            return Pair.of((Object)((Object)StargateAddressCheckResult.MALFORMED), null);
        }
        Stargate<?> targetTile = targetPosOptional.get().getStargate();
        if (targetTile == null) {
            return Pair.of((Object)((Object)StargateAddressCheckResult.MALFORMED), null);
        }
        if (!targetTile.getDialingManager().canAcceptConnectionFrom(this.stargate.getStargatePos())) {
            return Pair.of((Object)((Object)StargateAddressCheckResult.TARGET_BUSY), targetTile);
        }
        return Pair.of((Object)((Object)StargateAddressCheckResult.OK), targetTile);
    }

    @Override
    public Optional<StargatePos> getDialableStargatePos(StargateAddressDynamic address) {
        StargatePos targetGatePos = network.get().getStargate(address);
        if (targetGatePos == null || this.stargate.is(targetGatePos)) {
            return Optional.empty();
        }
        if (this.isAddressLengthOk(address, targetGatePos)) {
            return Optional.of(targetGatePos);
        }
        return Optional.empty();
    }

    @Override
    public boolean isAddressLengthOk(StargateAddressDynamic address, StargatePos targetGatePosition) {
        boolean localDial = StargateDimensionConfig.INSTANCE.isGroupEqual(this.stargate.getStargatePos().dimension, targetGatePosition.dimension);
        return address.size() >= this.stargate.getSymbolType().getMinimalSymbolCountTo(targetGatePosition.getGateSymbolType(), localDial);
    }

    @Override
    public boolean canAcceptConnectionFrom(@Nullable StargatePos targetGatePos) {
        if (!this.stargate.isMerged()) {
            return false;
        }
        if (targetGatePos != null && this.stargate.is(targetGatePos)) {
            return false;
        }
        boolean allowConnectToDialing = JSGConfig.Stargate.allowConnectToDialing.get();
        EnumStargateState state = this.getStargateState();
        if (allowConnectToDialing) {
            return switch (state) {
                case EnumStargateState.IDLE, EnumStargateState.DIALING, EnumStargateState.DIALING_COMPUTER, EnumStargateState.INCOMING -> true;
                default -> false;
            };
        }
        return state.idle() || state.incoming();
    }

    public boolean isLockChevron(@Nullable SymbolInterface symbol, boolean notAddedYet, boolean ignoreMaxChevrons) {
        if (this.dialedAddress.size() + (notAddedYet ? 1 : 0) >= (ignoreMaxChevrons ? 9 : this.stargate.getMaxChevrons())) {
            return true;
        }
        if (symbol == null) {
            return false;
        }
        return this.dialedAddress.size() + (notAddedYet ? 1 : 0) >= 7 && symbol.origin();
    }

    public boolean isLockChevron(@Nullable SymbolInterface symbol, boolean ignoreMaxChevrons) {
        return this.isLockChevron(symbol, false, ignoreMaxChevrons);
    }

    @Override
    public StargateChevronEngageResult canAddSymbol(SymbolInterface symbol, boolean ignoreMaxChevrons) {
        StargateChevronEngageResult r = this.canAddSymbolInternal(symbol, ignoreMaxChevrons);
        if (r != StargateChevronEngageResult.OK) {
            return r;
        }
        if (new StargateChevronEngagedEvent(this.stargate, symbol, this.isLockChevron(symbol, ignoreMaxChevrons)).post()) {
            return StargateChevronEngageResult.BLOCKED_BY_EVENT;
        }
        return StargateChevronEngageResult.OK;
    }

    protected StargateChevronEngageResult canAddSymbolInternal(SymbolInterface symbol, boolean ignoreMaxChevrons) {
        if (this.isFinalActive) {
            return StargateChevronEngageResult.ADDRESS_FULL;
        }
        if (this.dialedAddress.contains(symbol)) {
            return StargateChevronEngageResult.ALREADY_ENGAGED;
        }
        return ignoreMaxChevrons && this.dialedAddress.size() < 9 || this.dialedAddress.size() < this.stargate.getMaxChevrons() ? StargateChevronEngageResult.OK : StargateChevronEngageResult.ADDRESS_FULL;
    }

    @Override
    public int getMinimalSymbolsToDial(AbstractSymbolType<?> symbolType, StargatePos targetGatePos) {
        Level level = this.stargate.getStargateLevel();
        if (level == null) {
            return 9;
        }
        return this.stargate.getSymbolType().getMinimalSymbolCountTo(symbolType, StargateDimensionConfig.INSTANCE.isGroupEqual(targetGatePos.dimension, (ResourceKey<Level>)level.m_46472_()));
    }

    @Nullable
    public StargateChevronEngageResult onChevronActivates(CompoundTag customData) {
        if (!customData.m_128441_("symbol")) {
            return null;
        }
        Object symbol = this.stargate.getSymbolType().valueOf(customData.m_128451_("symbol"));
        if (symbol == null) {
            return StargateChevronEngageResult.BLOCKED_BY_EVENT;
        }
        StargateChevronEngageResult result = this.engageSymbolInternal((SymbolInterface)symbol, customData.m_128471_("noxDialing"), customData.m_128471_("noEnergy"), customData.m_128471_("ignoreMaxChevrons"));
        if (!result.ok()) {
            return result;
        }
        StargateComputerEvents.CHEVRON_ENGAGED.apply(StargateComputerEvents.ChevronEvent.Source.BY_SPIN, (SymbolInterface)symbol, this.getNextChevron((SymbolInterface)symbol, true, customData.m_128471_("ignoreMaxChevrons")), this.getDialedAddressSize()).sendVia(this.stargate);
        if (customData.m_128471_("checkConnection") && customData.m_128471_("isFinal") && !this.getConnection().getStatus().waiting()) {
            return StargateChevronEngageResult.FAILED_FAIL_GATE;
        }
        if (this.addressDialSequence != null) {
            this.addTask(new ScheduledTask(ScheduledTaskType.STARGATE_DIAL_NEXT, 25));
        }
        return StargateChevronEngageResult.OK;
    }

    @Override
    public void addTask(ScheduledTask scheduledTask) {
        scheduledTask.setExecutor(this);
        scheduledTask.setTaskCreated(this.stargate.getTime());
        if (scheduledTask.getWaitTime() <= 0) {
            scheduledTask.execute();
            return;
        }
        this.scheduledTasks.add(scheduledTask);
        this.stargate.setStargateChanged();
    }

    @Override
    public void executeTask(ScheduledTaskType scheduledTask, CompoundTag customData) {
        if (scheduledTask == ScheduledTaskType.STARGATE_OPEN_SOUND) {
            if (this.activeConnection.isNox()) {
                this.stargate.playSoundEvent(StargateSoundEventEnum.OPEN_NOX);
            } else {
                this.stargate.playSoundEvent(StargateSoundEventEnum.OPEN);
            }
        } else if (scheduledTask == ScheduledTaskType.STARGATE_CLOSE_SOUND) {
            this.stargate.playSoundEvent(StargateSoundEventEnum.CLOSE);
        } else if (scheduledTask == ScheduledTaskType.STARGATE_CLOSE) {
            this.disconnectWormhole(StargateClosedReasonEnum.values()[customData.m_128451_("reason")]);
        } else if (scheduledTask == ScheduledTaskType.STARGATE_FAIL) {
            this.failGate();
        } else if (scheduledTask == ScheduledTaskType.STARGATE_ENGAGE) {
            this.connectWormhole();
        } else if (scheduledTask == ScheduledTaskType.STARGATE_DIAL_NEXT && this.addressDialSequence != null) {
            this.addressDialSequence.dialNext();
        }
    }

    @Override
    public void tick(Level level) {
        ScheduledTask.iterate(this.scheduledTasks, this.stargate.getTime());
        this.tickConnection.accept(this.activeConnection);
        this.activeConnection.tick(level);
        if (this.incomingAnimation != null) {
            this.incomingAnimation.tick(level);
        }
    }

    @Override
    public void onLoad(Level level) {
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_("activeConnection", (Tag)this.activeConnection.serializeNBT());
        compound.m_128365_("scheduledTasks", (Tag)ScheduledTask.serializeList(this.scheduledTasks));
        compound.m_128365_("dialedAddress", (Tag)this.dialedAddress.serializeNBT());
        compound.m_128379_("isFinalActive", this.isFinalActive);
        compound.m_128405_("stargateState", this.stargateState.ordinal());
        if (this.incomingAnimation != null) {
            compound.m_128365_("incomingAnimation", (Tag)this.incomingAnimation.serializeNBT());
        }
        if (this.addressDialSequence != null) {
            compound.m_128365_("addressDialSequence", (Tag)this.addressDialSequence.serializeNBT());
        }
        return compound;
    }

    public void deserializeNBT(CompoundTag compound) {
        this.activeConnection.deserializeNBT(compound.m_128469_("activeConnection"));
        this.dialedAddress.clear();
        this.dialedAddress.deserializeNBT(compound.m_128469_("dialedAddress"));
        try {
            ScheduledTask.deserializeList(compound.m_128469_("scheduledTasks"), this.scheduledTasks, this);
        }
        catch (ClassCastException | IndexOutOfBoundsException | NullPointerException e) {
            JSG.logger.warn("Exception at reading NBT");
            JSG.logger.warn("If loading world used with previous version and nothing game-breaking doesn't happen, please ignore it", e);
        }
        this.isFinalActive = compound.m_128471_("isFinalActive");
        this.stargateState = EnumStargateState.valueOf(compound.m_128451_("stargateState"));
        if (compound.m_128441_("incomingAnimation")) {
            this.incomingAnimation = this.getIncomingAnimationByConfig(compound.m_128469_("incomingAnimation"));
        }
        if (compound.m_128441_("addressDialSequence")) {
            this.addressDialSequence = this.getAddressDialSequence(compound.m_128469_("addressDialSequence"));
        }
    }
}

