/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.manager.dialing;

import dev.tauri.jsg.api.registry.ScheduledTaskType;
import dev.tauri.jsg.api.sound.StargateSoundEventEnum;
import dev.tauri.jsg.api.stargate.ChevronEnum;
import dev.tauri.jsg.api.stargate.EnumStargateState;
import dev.tauri.jsg.api.stargate.network.address.StargateAddress;
import dev.tauri.jsg.api.stargate.network.address.StargateAddressDynamic;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolInterface;
import dev.tauri.jsg.api.stargate.result.StargateChevronEngageResult;
import dev.tauri.jsg.api.stargate.result.StargateOpenResult;
import dev.tauri.jsg.api.util.ScheduledTask;
import dev.tauri.jsg.blockentity.stargate.StargateOrlinBaseBE;
import dev.tauri.jsg.sound.SoundEvent;
import dev.tauri.jsg.stargate.animation.incoming.IncomingAnimation;
import dev.tauri.jsg.stargate.animation.incoming.StaticIncomingAnimation;
import dev.tauri.jsg.stargate.animation.spinning.ClassicSpinHelper;
import dev.tauri.jsg.stargate.animation.spinning.OrlinSpinHelper;
import dev.tauri.jsg.stargate.manager.dialing.StargateAbstractDialingManager;
import dev.tauri.jsg.stargate.manager.state.StargateAbstractStateManager;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@FieldsAreNonnullByDefault
public class StargateOrlinDialingManager
extends StargateAbstractDialingManager<StargateOrlinBaseBE> {
    protected final ClassicSpinHelper spinHelper = this.generateSpinHelper();
    protected final StargateAddressDynamic addressToDial;

    public StargateOrlinDialingManager(StargateOrlinBaseBE stargate) {
        super(stargate);
        this.addressToDial = new StargateAddressDynamic(stargate.getSymbolType());
    }

    @Override
    public ClassicSpinHelper generateSpinHelper() {
        return new OrlinSpinHelper((StargateOrlinBaseBE)this.stargate);
    }

    @Override
    public ClassicSpinHelper getSpinHelper() {
        return this.spinHelper;
    }

    @Override
    protected IncomingAnimation<?> getIncomingAnimation(CompoundTag tag) {
        return new StaticIncomingAnimation(this, tag);
    }

    @Override
    protected IncomingAnimation<?> getIncomingAnimation(int addressSize, int duration) {
        return new StaticIncomingAnimation(((StargateOrlinBaseBE)this.stargate).getTime(), this, addressSize, duration);
    }

    @Override
    public void executeTask(ScheduledTaskType scheduledTask, CompoundTag customData) {
        if (scheduledTask == ScheduledTaskType.STARGATE_ORLIN_BROKE_SOUND) {
            ((StargateOrlinBaseBE)this.stargate).playSoundEvent(StargateSoundEventEnum.GATE_BROKE);
        } else if (scheduledTask == ScheduledTaskType.STARGATE_ORLIN_OPEN) {
            if (!this.getStargateState().dialing()) {
                return;
            }
            if (this.getDialedAddressSize() < 7) {
                return;
            }
            this.setStargateState(EnumStargateState.IDLE);
            this.attemptOpenDialed();
        } else {
            super.executeTask(scheduledTask, customData);
        }
    }

    public void updateDialedAddress() {
        StargateAddress addressToDial = ((StargateOrlinBaseBE)this.stargate).getAddressFromPageNBT();
        this.addressToDial.clear();
        if (addressToDial == null) {
            return;
        }
        StargateAddressDynamic address = new StargateAddressDynamic(addressToDial);
        List<SymbolInterface> addressNeeded = address.subList(0, 6);
        addressNeeded.add((SymbolInterface)((StargateOrlinBaseBE)this.stargate).getSymbolType().getOrigin());
        this.addressToDial.addAll(addressNeeded);
        ((StargateOrlinBaseBE)this.stargate).m_6596_();
    }

    @Override
    protected void onWormholeDisconnected() {
        super.onWormholeDisconnected();
        if (this.getConnection().isInitiating() && this.getConnection().wasFully()) {
            ((StargateOrlinBaseBE)this.stargate).incrementOpenCount();
            if (((StargateOrlinBaseBE)this.stargate).isBroken(false) && ((StargateOrlinBaseBE)this.stargate).m_58904_() != null) {
                this.addTask(new ScheduledTask(ScheduledTaskType.STARGATE_ORLIN_BROKE_SOUND, 10));
            }
        }
    }

    public void beginOpening() {
        if (((StargateOrlinBaseBE)this.stargate).m_58904_() == null) {
            return;
        }
        if (((StargateOrlinBaseBE)this.stargate).isBroken(false)) {
            this.failGate();
            return;
        }
        this.updateDialedAddress();
        if (this.getDialedAddressSize() > 0) {
            this.attemptOpenDialed();
            return;
        }
        int chevronIndex = 0;
        int lastChevronWait = this.getTicksToChevron(6);
        for (SymbolInterface symbol : this.addressToDial) {
            StargateChevronEngageResult r = this.engageSymbolInternal(symbol, false, false, false);
            if (!r.ok()) {
                ((StargateAbstractStateManager)((StargateOrlinBaseBE)this.stargate).getStateManager()).getChevronsState().clearTasks();
                this.dialingFailed(StargateOpenResult.ADDRESS_MALFORMED);
                return;
            }
            ((StargateAbstractStateManager)((StargateOrlinBaseBE)this.stargate).getStateManager()).getChevronsState().scheduleChevronActivate(this.getTicksToChevron(chevronIndex), ChevronEnum.valueOf(chevronIndex == 6 ? 8 : chevronIndex), null, false);
            ++chevronIndex;
            if (r != StargateChevronEngageResult.OK_CONNECTED) continue;
            this.getConnection().runOnConnected((conn, sg) -> ((StargateAbstractDialingManager)sg.getDialingManager()).runIncomingWormhole(this.dialedAddress.addOriginIfMissingAndImmutable().size(), lastChevronWait));
        }
        ((StargateOrlinBaseBE)this.stargate).playSoundEvent(SoundEvent.GATE_ORLIN_DIAL);
        this.setStargateState(EnumStargateState.DIALING);
        this.addTask(new ScheduledTask(ScheduledTaskType.STARGATE_ORLIN_OPEN, lastChevronWait + 10));
    }

    public int getTicksToChevron(int chevronIndex) {
        return (new int[]{1, 25, 56, 75, 111, 127, 153})[Math.min(6, chevronIndex)];
    }
}

