/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.manager.dialing;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.api.integration.StargateComputerEvents;
import dev.tauri.jsg.api.registry.ScheduledTaskType;
import dev.tauri.jsg.api.stargate.ChevronEnum;
import dev.tauri.jsg.api.stargate.EnumStargateState;
import dev.tauri.jsg.api.stargate.animation.EnumDialingType;
import dev.tauri.jsg.api.stargate.animation.IAddressDialSequence;
import dev.tauri.jsg.api.stargate.exception.StargateException;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolInterface;
import dev.tauri.jsg.api.stargate.result.StargateChevronEngageResult;
import dev.tauri.jsg.api.util.ScheduledTask;
import dev.tauri.jsg.blockentity.dialhomedevice.DHDAbstractBE;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargatePegasusBaseBE;
import dev.tauri.jsg.stargate.animation.chevron.StargatePegasusChevronsState;
import dev.tauri.jsg.stargate.animation.incoming.IncomingAnimation;
import dev.tauri.jsg.stargate.animation.incoming.PegasusIncomingAnimation;
import dev.tauri.jsg.stargate.animation.spinning.ClassicSpinHelper;
import dev.tauri.jsg.stargate.animation.spinning.PegasusSpinHelper;
import dev.tauri.jsg.stargate.manager.StargateSoundManager;
import dev.tauri.jsg.stargate.manager.dialing.StargateAbstractDialingManager;
import dev.tauri.jsg.stargate.manager.dialing.StargateClassicDialingManager;
import dev.tauri.jsg.stargate.manager.state.StargateAbstractStateManager;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@FieldsAreNonnullByDefault
public class StargatePegasusDialingManager
extends StargateClassicDialingManager<StargatePegasusBaseBE> {
    protected Pair<List<SymbolInterface>, Pair<Boolean, Boolean>> addressBuffer = Pair.of(new ArrayList(), (Object)Pair.of((Object)false, (Object)false));
    protected boolean canDialNextFromBuffer = true;

    public StargatePegasusDialingManager(StargatePegasusBaseBE stargate) {
        super(stargate);
    }

    @Override
    public ClassicSpinHelper generateSpinHelper() {
        return new PegasusSpinHelper((StargateAbstractBaseBE)this.stargate, this::onRingStopSpinning);
    }

    @Override
    protected IAddressDialSequence.DialNextConsumer getAddressDialSequenceSymbolConsumer() {
        return (symbol, noEnergy, ignoreMaxChevrons, dialingType) -> {
            if (symbol == null) {
                if (dialingType == EnumDialingType.FAST) {
                    this.engageSymbolDHD((SymbolInterface)((StargatePegasusBaseBE)this.stargate).getSymbolType().getBRB(), noEnergy, ignoreMaxChevrons);
                } else {
                    this.attemptOpenDialed();
                }
                this.addressDialSequence = null;
                ((StargatePegasusBaseBE)this.stargate).m_6596_();
                return;
            }
            if (dialingType == EnumDialingType.NORMAL) {
                this.engageSymbolBySpin(symbol, noEnergy, ignoreMaxChevrons);
                return;
            }
            this.engageSymbolDHD(symbol, noEnergy, ignoreMaxChevrons);
        };
    }

    @Override
    protected void onRingStopSpinning(CompoundTag stopSpinData) {
        if (((StargatePegasusBaseBE)this.stargate).getStargateLevel() == null || ((StargatePegasusBaseBE)this.stargate).getStargateLevel().m_5776_()) {
            return;
        }
        if (this.getStargateState().dialingComputer()) {
            this.setStargateState(EnumStargateState.IDLE);
        }
        if (stopSpinData.m_128441_("symbol")) {
            Object symbol = ((StargatePegasusBaseBE)this.stargate).getSymbolType().valueOf(stopSpinData.m_128451_("symbol"));
            ((StargateAbstractStateManager)((StargatePegasusBaseBE)this.stargate).getStateManager()).getChevronsState().scheduleChevronActivate(0, this.getNextChevron((SymbolInterface)symbol, false, stopSpinData.m_128471_("ignoreMaxChevrons")), (SymbolInterface)symbol, this.getStargateState().dialingComputer(), false, true, stopSpinData.m_128471_("noEnergy"), stopSpinData.m_128471_("ignoreMaxChevrons"));
        }
    }

    @Override
    @Nullable
    public StargateChevronEngageResult onChevronActivates(CompoundTag customData) {
        if (!customData.m_128441_("symbol")) {
            return null;
        }
        Object symbol = ((StargatePegasusBaseBE)this.stargate).getSymbolType().valueOf(customData.m_128451_("symbol"));
        if (symbol == null) {
            return StargateChevronEngageResult.BLOCKED_BY_EVENT;
        }
        StargateChevronEngageResult result = this.engageSymbolInternal((SymbolInterface)symbol, customData.m_128471_("noxDialing"), customData.m_128471_("noEnergy"), customData.m_128471_("ignoreMaxChevrons"));
        if (!result.ok()) {
            return result;
        }
        StargateComputerEvents.CHEVRON_ENGAGED.apply(StargateComputerEvents.ChevronEvent.Source.BY_SPIN, (SymbolInterface)symbol, this.getNextChevron((SymbolInterface)symbol, true, customData.m_128471_("ignoreMaxChevrons")), this.getDialedAddressSize()).sendVia(this.stargate);
        if (customData.m_128471_("checkConnection") && customData.m_128471_("isFinal") && !this.getConnection().getStatus().waiting()) {
            return StargateChevronEngageResult.FAILED_FAIL_GATE;
        }
        if (this.addressDialSequence != null && !this.getStargateState().dialing()) {
            this.addTask(new ScheduledTask(ScheduledTaskType.STARGATE_DIAL_NEXT, 25));
        }
        ((StargatePegasusChevronsState)((StargateAbstractStateManager)((StargatePegasusBaseBE)this.stargate).getStateManager()).getChevronsState()).activateSlot(StargatePegasusChevronsState.slotFromChevron(ChevronEnum.valueOf(customData.m_128451_("chevron"))), this.dialedAddress.getLast());
        return StargateChevronEngageResult.OK;
    }

    @Override
    public void tick(Level level) {
        super.tick(level);
        if (level.f_46443_) {
            return;
        }
        if (this.canDialNextFromBuffer && !((List)this.addressBuffer.first()).isEmpty() && level.m_46467_() % 10L == 0L) {
            SymbolInterface symbol = (SymbolInterface)((List)this.addressBuffer.first()).get(0);
            if (symbol == null) {
                ((List)this.addressBuffer.first()).remove(0);
                ((StargatePegasusBaseBE)this.stargate).m_6596_();
                return;
            }
            if (symbol.brb()) {
                ((List)this.addressBuffer.first()).clear();
                this.canDialNextFromBuffer = false;
                this.attemptOpenDialed();
                return;
            }
            if (this.engageSymbolBySpin(symbol, (Boolean)((Pair)this.addressBuffer.second()).first(), (Boolean)((Pair)this.addressBuffer.second()).second())) {
                this.canDialNextFromBuffer = false;
                ((List)this.addressBuffer.first()).remove(0);
                ((StargatePegasusBaseBE)this.stargate).m_6596_();
            } else {
                ((List)this.addressBuffer.first()).remove(0);
                ((StargatePegasusBaseBE)this.stargate).m_6596_();
            }
        }
    }

    @Override
    public StargateChevronEngageResult engageSymbolDHD(SymbolInterface symbol, boolean noEnergy, boolean ignoreMaxChevrons) {
        StargateChevronEngageResult r = this.canAddSymbolToBuffer(symbol, ignoreMaxChevrons);
        if (r != StargateChevronEngageResult.OK) {
            return r;
        }
        DHDAbstractBE dhd = ((StargatePegasusBaseBE)this.stargate).getLinkedDevice();
        if (((StargatePegasusBaseBE)this.stargate).isLinkedAndDHDOperational() && dhd != null) {
            dhd.activateSymbol(symbol);
        }
        this.setStargateState(EnumStargateState.DIALING);
        this.addressBuffer = Pair.of((Object)((List)this.addressBuffer.first()), (Object)Pair.of((Object)noEnergy, (Object)ignoreMaxChevrons));
        ((List)this.addressBuffer.first()).add(symbol);
        if (this.addressDialSequence != null) {
            this.addTask(new ScheduledTask(ScheduledTaskType.STARGATE_DIAL_NEXT, 10));
        }
        return StargateChevronEngageResult.OK;
    }

    public StargateChevronEngageResult canAddSymbolToBuffer(SymbolInterface symbol, boolean ignoreMaxChevrons) {
        if (this.isFinalActive && !symbol.brb()) {
            return StargateChevronEngageResult.ADDRESS_FULL;
        }
        if (((List)this.addressBuffer.first()).contains(symbol)) {
            return StargateChevronEngageResult.ALREADY_ENGAGED;
        }
        if (symbol.brb()) {
            return StargateChevronEngageResult.OK;
        }
        if (this.dialedAddress.size() + ((List)this.addressBuffer.first()).size() - (((List)this.addressBuffer.first()).contains(((StargatePegasusBaseBE)this.stargate).getSymbolType().getBRB()) || symbol.brb() ? 1 : 0) >= (ignoreMaxChevrons ? 9 : ((StargatePegasusBaseBE)this.stargate).getMaxChevrons())) {
            return StargateChevronEngageResult.ADDRESS_FULL;
        }
        return StargateChevronEngageResult.OK;
    }

    @Override
    public boolean engageSymbolBySpin(SymbolInterface symbol, boolean noEnergy, boolean ignoreMaxChevrons) {
        ChevronEnum currentChevron;
        if (!this.getStargateState().idle() && !this.getStargateState().dialingDHD()) {
            return false;
        }
        if (this.isFinalActive) {
            return false;
        }
        PegasusSpinHelper spinHelper = (PegasusSpinHelper)this.getSpinHelper();
        if (spinHelper.isSpinning()) {
            return false;
        }
        ChevronEnum nextChevron = this.getNextChevron(symbol, false, ignoreMaxChevrons);
        Pair<Boolean, Float> r = spinHelper.moveToAndEngage(symbol, nextChevron, currentChevron = this.dialedAddress.size() > 0 ? this.getNextChevron(this.dialedAddress.getLast(), true, ignoreMaxChevrons) : ChevronEnum.getFinal(), noEnergy, ignoreMaxChevrons, !((StargateSoundManager)((StargatePegasusBaseBE)this.stargate).getSoundManager()).isRingRollPlaying(), ((List)this.addressBuffer.first()).size() < 2 || nextChevron.isFinal());
        if (((Boolean)r.first()).booleanValue()) {
            if (!this.getStargateState().dialingDHD()) {
                this.setStargateState(EnumStargateState.DIALING_COMPUTER);
            }
            if (this.isLockChevron(symbol, true, ignoreMaxChevrons)) {
                this.getConnection().runOnConnected((conn, sg) -> ((StargateAbstractDialingManager)sg.getDialingManager()).runIncomingWormhole(this.dialedAddress.addOriginIfMissingAndImmutable().size(), ((Float)r.second()).intValue()));
            }
        }
        return (Boolean)r.first();
    }

    @Override
    public StargateChevronEngageResult engageCurrentSymbol() {
        JSG.logger.error("", new StargateException("Tried to engage current top symbol on pegasus gate. This will not work...", this.stargate));
        return StargateChevronEngageResult.BLOCKED_BY_EVENT;
    }

    @Override
    protected void clearIncomingWormholeOnSelf() {
        this.canDialNextFromBuffer = true;
        ((List)this.addressBuffer.first()).clear();
        this.getSpinHelper().stopSpinning(true);
        ((StargateAbstractStateManager)((StargatePegasusBaseBE)this.stargate).getStateManager()).getChevronsState().scheduleChevronsDimAll(0, true);
    }

    @Override
    public void runIncomingWormhole(int addressSize, int duration) {
        super.runIncomingWormhole(addressSize, duration);
        this.canDialNextFromBuffer = true;
        ((List)this.addressBuffer.first()).clear();
        ((StargatePegasusBaseBE)this.stargate).m_6596_();
        DHDAbstractBE dhd = ((StargatePegasusBaseBE)this.stargate).getLinkedDevice();
        if (((StargatePegasusBaseBE)this.stargate).isLinkedAndDHDOperational() && dhd != null) {
            dhd.clearSymbols();
        }
    }

    @Override
    protected void failGate() {
        super.failGate();
        this.canDialNextFromBuffer = true;
        ((List)this.addressBuffer.first()).clear();
        this.getSpinHelper().stopSpinning(true);
        ((StargatePegasusBaseBE)this.stargate).m_6596_();
        DHDAbstractBE dhd = ((StargatePegasusBaseBE)this.stargate).getLinkedDevice();
        if (((StargatePegasusBaseBE)this.stargate).isLinkedAndDHDOperational() && dhd != null) {
            dhd.clearSymbols();
        }
    }

    @Override
    protected void onWormholeDisconnected() {
        super.onWormholeDisconnected();
        this.canDialNextFromBuffer = true;
        ((List)this.addressBuffer.first()).clear();
        this.getSpinHelper().stopSpinning(true);
        ((StargateAbstractStateManager)((StargatePegasusBaseBE)this.stargate).getStateManager()).getChevronsState().scheduleChevronsDimAll(0, true);
        ((StargatePegasusBaseBE)this.stargate).m_6596_();
        DHDAbstractBE dhd = ((StargatePegasusBaseBE)this.stargate).getLinkedDevice();
        if (((StargatePegasusBaseBE)this.stargate).isLinkedAndDHDOperational() && dhd != null) {
            dhd.clearSymbols();
        }
    }

    @Override
    protected void onGateOpen(boolean initiating) {
        super.onGateOpen(initiating);
        this.canDialNextFromBuffer = true;
        ((List)this.addressBuffer.first()).clear();
        ((StargatePegasusBaseBE)this.stargate).m_6596_();
        DHDAbstractBE dhd = ((StargatePegasusBaseBE)this.stargate).getLinkedDevice();
        if (((StargatePegasusBaseBE)this.stargate).isLinkedAndDHDOperational() && dhd != null) {
            dhd.activateSymbol((SymbolInterface)((StargatePegasusBaseBE)this.stargate).getSymbolType().getBRB());
        }
    }

    @Override
    protected StargateChevronEngageResult engageSymbolInternal(SymbolInterface symbol, boolean isNox, boolean noEnergy, boolean ignoreMaxChevrons) {
        StargateChevronEngageResult result = super.engageSymbolInternal(symbol, isNox, noEnergy, ignoreMaxChevrons);
        if (result.ok()) {
            DHDAbstractBE dhd = ((StargatePegasusBaseBE)this.stargate).getLinkedDevice();
            if (((StargatePegasusBaseBE)this.stargate).isLinkedAndDHDOperational() && dhd != null) {
                dhd.activateSymbol(symbol);
            }
        }
        this.canDialNextFromBuffer = true;
        ((StargatePegasusBaseBE)this.stargate).m_6596_();
        return result;
    }

    @Override
    protected IncomingAnimation<?> getIncomingAnimation(CompoundTag tag) {
        return new PegasusIncomingAnimation(this, tag);
    }

    @Override
    protected IncomingAnimation<?> getIncomingAnimation(int addressSize, int duration) {
        return new PegasusIncomingAnimation(((StargatePegasusBaseBE)this.stargate).getTime(), this, addressSize, duration);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag c = super.serializeNBT();
        c.m_128408_("addressBufferAddress", ((List)this.addressBuffer.first()).stream().map(SymbolInterface::getId).toList());
        c.m_128379_("addressBufferNoEnergy", ((Boolean)((Pair)this.addressBuffer.second()).first()).booleanValue());
        c.m_128379_("addressBufferIgnoreMaxChevrons", ((Boolean)((Pair)this.addressBuffer.second()).second()).booleanValue());
        c.m_128379_("addressBufferCanDialNext", this.canDialNextFromBuffer);
        return c;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        ArrayList list = new ArrayList();
        for (int i : compound.m_128465_("addressBufferAddress")) {
            list.add(((StargatePegasusBaseBE)this.stargate).getSymbolType().valueOf(i));
        }
        this.addressBuffer = Pair.of(list, (Object)Pair.of((Object)compound.m_128471_("addressBufferNoEnergy"), (Object)compound.m_128471_("addressBufferIgnoreMaxChevrons")));
        this.canDialNextFromBuffer = compound.m_128471_("addressBufferCanDialNext");
    }
}

