/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.manager.dialing;

import dev.tauri.jsg.api.integration.StargateComputerEvents;
import dev.tauri.jsg.api.registry.ScheduledTaskType;
import dev.tauri.jsg.api.stargate.EnumStargateState;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolInterface;
import dev.tauri.jsg.api.stargate.result.StargateChevronEngageResult;
import dev.tauri.jsg.api.util.ScheduledTask;
import dev.tauri.jsg.blockentity.stargate.StargateMilkyWayBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateTollanBaseBE;
import dev.tauri.jsg.stargate.manager.dialing.StargateAbstractDialingManager;
import dev.tauri.jsg.stargate.manager.dialing.StargateMilkyWayDialingManager;
import dev.tauri.jsg.stargate.manager.state.StargateAbstractStateManager;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@FieldsAreNonnullByDefault
public class StargateTollanDialingManager
extends StargateMilkyWayDialingManager {
    public StargateTollanDialingManager(StargateTollanBaseBE stargate) {
        super(stargate);
    }

    @Override
    public StargateChevronEngageResult engageSymbolDHD(SymbolInterface symbol, boolean noEnergy, boolean ignoreMaxChevrons) {
        if (!this.getStargateState().idle()) {
            return StargateChevronEngageResult.BUSY;
        }
        StargateChevronEngageResult r = this.engageSymbolInternal(symbol, false, noEnergy, ignoreMaxChevrons);
        if (!r.ok()) {
            return r;
        }
        StargateComputerEvents.CHEVRON_ENGAGED.apply(StargateComputerEvents.ChevronEvent.Source.DHD, symbol, this.getNextChevron(symbol, true, ignoreMaxChevrons), this.getDialedAddressSize()).sendVia(this.stargate);
        this.setStargateState(EnumStargateState.DIALING);
        if (r == StargateChevronEngageResult.OK_CONNECTED) {
            this.getConnection().runOnConnected((conn, sg) -> ((StargateAbstractDialingManager)sg.getDialingManager()).runIncomingWormhole(this.dialedAddress.addOriginIfMissingAndImmutable().size(), 30));
        }
        int plusTime = new Random().nextInt(5);
        ((StargateAbstractStateManager)((StargateMilkyWayBaseBE)this.stargate).getStateManager()).getChevronsState().scheduleChevronActivate(10 + plusTime, this.getNextChevron(symbol, true, ignoreMaxChevrons), null, true);
        if (this.addressDialSequence != null) {
            this.addTask(new ScheduledTask(ScheduledTaskType.STARGATE_DIAL_NEXT, 15 + plusTime));
        }
        ((StargateMilkyWayBaseBE)this.stargate).m_6596_();
        return r;
    }

    @Override
    public boolean engageSymbolBySpin(SymbolInterface symbol, boolean noEnergy, boolean ignoreMaxChevrons) {
        if (!this.getStargateState().idle()) {
            return false;
        }
        StargateChevronEngageResult r = this.engageSymbolInternal(symbol, false, noEnergy, ignoreMaxChevrons);
        if (!r.ok()) {
            return false;
        }
        this.setStargateState(EnumStargateState.DIALING_COMPUTER);
        if (r == StargateChevronEngageResult.OK_CONNECTED) {
            this.getConnection().runOnConnected((conn, sg) -> ((StargateAbstractDialingManager)sg.getDialingManager()).runIncomingWormhole(this.dialedAddress.addOriginIfMissingAndImmutable().size(), 30));
        }
        int plusTime = new Random().nextInt(5);
        ((StargateAbstractStateManager)((StargateMilkyWayBaseBE)this.stargate).getStateManager()).getChevronsState().scheduleChevronActivate(10 + plusTime, this.getNextChevron(symbol, true, ignoreMaxChevrons), null, true);
        if (this.addressDialSequence != null) {
            this.addTask(new ScheduledTask(ScheduledTaskType.STARGATE_DIAL_NEXT, 15 + plusTime));
        }
        ((StargateMilkyWayBaseBE)this.stargate).m_6596_();
        return true;
    }
}

