/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.manager.dialing;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.api.chunkloader.ChunkManager;
import dev.tauri.jsg.api.integration.StargateComputerEvents;
import dev.tauri.jsg.api.registry.ScheduledTaskType;
import dev.tauri.jsg.api.sound.StargateSoundEventEnum;
import dev.tauri.jsg.api.stargate.ChevronEnum;
import dev.tauri.jsg.api.stargate.EnumStargateState;
import dev.tauri.jsg.api.stargate.animation.EnumDialingType;
import dev.tauri.jsg.api.stargate.animation.EnumSpinDirection;
import dev.tauri.jsg.api.stargate.animation.IAddressDialSequence;
import dev.tauri.jsg.api.stargate.exception.StargateException;
import dev.tauri.jsg.api.stargate.network.address.StargateAddressDynamic;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolInterface;
import dev.tauri.jsg.api.stargate.result.StargateChevronEngageResult;
import dev.tauri.jsg.api.util.ScheduledTask;
import dev.tauri.jsg.blockentity.dialhomedevice.DHDAbstractBE;
import dev.tauri.jsg.blockentity.stargate.StargateUniverseBaseBE;
import dev.tauri.jsg.sound.SoundEvent;
import dev.tauri.jsg.stargate.animation.chevron.StargateUniverseChevronsState;
import dev.tauri.jsg.stargate.animation.incoming.IncomingAnimation;
import dev.tauri.jsg.stargate.animation.incoming.UniverseIncomingAnimation;
import dev.tauri.jsg.stargate.manager.dialing.StargateAbstractDialingManager;
import dev.tauri.jsg.stargate.manager.dialing.StargateClassicDialingManager;
import dev.tauri.jsg.stargate.manager.state.StargateAbstractStateManager;
import it.unimi.dsi.fastutil.Pair;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@FieldsAreNonnullByDefault
public class StargateUniverseDialingManager
extends StargateClassicDialingManager<StargateUniverseBaseBE> {
    public StargateUniverseDialingManager(StargateUniverseBaseBE stargate) {
        super(stargate);
    }

    @Override
    public StargateChevronEngageResult engageSymbolDHD(SymbolInterface symbol, boolean noEnergy, boolean ignoreMaxChevrons) {
        if (!this.getStargateState().idle() && !this.getStargateState().dialingDHD()) {
            return StargateChevronEngageResult.BUSY;
        }
        StargateChevronEngageResult r = this.canAddSymbol(symbol, ignoreMaxChevrons);
        if (r != StargateChevronEngageResult.OK) {
            return r;
        }
        r = this.engageSymbolInternal(symbol, false, noEnergy, ignoreMaxChevrons);
        if (this.isFinalActive) {
            this.getSpinHelper().stopSpinning(false);
        }
        if (r == StargateChevronEngageResult.OK_CONNECTED) {
            this.getConnection().runOnConnected((conn, sg) -> ((StargateAbstractDialingManager)sg.getDialingManager()).runIncomingWormhole(this.dialedAddress.addOriginIfMissingAndImmutable().size(), 30));
        }
        if (r.ok()) {
            StargateComputerEvents.CHEVRON_ENGAGED.apply(StargateComputerEvents.ChevronEvent.Source.DHD, symbol, this.getNextChevron(symbol, true, ignoreMaxChevrons), this.getDialedAddressSize()).sendVia(this.stargate);
            this.setStargateState(EnumStargateState.DIALING);
            if (this.dialedAddress.size() == 1) {
                this.beginSpinAndLightUpFirstSymbol(symbol);
            } else {
                this.lightUpSymbol(symbol);
            }
        }
        return r;
    }

    public boolean engageSymbolByRemote(SymbolInterface symbol, boolean noEnergy, boolean ignoreMaxChevrons) {
        if (((StargateAbstractStateManager)((StargateUniverseBaseBE)this.stargate).getStateManager()).getChevronsState().get(ChevronEnum.C1).isLocked()) {
            if (!this.getStargateState().idle() && !this.getStargateState().dialingRemote()) {
                return false;
            }
            if (this.getSpinHelper().isSpinning()) {
                return false;
            }
            Pair<Boolean, Float> r = this.getSpinHelper().moveToAndEngage(symbol, this.isLockChevron(symbol, ignoreMaxChevrons), noEnergy, ignoreMaxChevrons);
            if (((Boolean)r.first()).booleanValue()) {
                this.setStargateState(EnumStargateState.DIALING_REMOTE);
                if (this.isLockChevron(symbol, true, ignoreMaxChevrons)) {
                    this.getConnection().runOnConnected((conn, sg) -> ((StargateAbstractDialingManager)sg.getDialingManager()).runIncomingWormhole(this.dialedAddress.addOriginIfMissingAndImmutable().size(), ((Float)r.second()).intValue()));
                }
            }
            return (Boolean)r.first();
        }
        if (!this.getStargateState().idle()) {
            return false;
        }
        if (this.getSpinHelper().isSpinning()) {
            return false;
        }
        this.setStargateState(EnumStargateState.DIALING_REMOTE);
        this.beginSpinAndMoveToFirstSymbol(symbol, true, noEnergy, true, ignoreMaxChevrons);
        return true;
    }

    @Override
    public boolean engageSymbolBySpin(SymbolInterface symbol, boolean noEnergy, boolean ignoreMaxChevrons) {
        if (((StargateAbstractStateManager)((StargateUniverseBaseBE)this.stargate).getStateManager()).getChevronsState().get(ChevronEnum.C1).isLocked()) {
            return super.engageSymbolBySpin(symbol, noEnergy, ignoreMaxChevrons);
        }
        if (!this.getStargateState().idle()) {
            return false;
        }
        if (this.getSpinHelper().isSpinning()) {
            return false;
        }
        this.setStargateState(EnumStargateState.DIALING_COMPUTER);
        this.beginSpinAndMoveToFirstSymbol(symbol, true, noEnergy, false, ignoreMaxChevrons);
        return true;
    }

    @Override
    public StargateChevronEngageResult engageAddressByNox(StargateAddressDynamic address, boolean noEnergy, boolean ignoreMaxChevrons) {
        if (!this.getStargateState().idle()) {
            return StargateChevronEngageResult.BUSY;
        }
        for (SymbolInterface s : address.subList(0, address.size())) {
            StargateChevronEngageResult r = this.engageSymbolInternal(s, true, noEnergy, ignoreMaxChevrons);
            if (!r.ok()) {
                return r;
            }
            if (r != StargateChevronEngageResult.OK_CONNECTED) continue;
            this.getConnection().runOnConnected((conn, sg) -> ((StargateAbstractDialingManager)sg.getDialingManager()).runIncomingWormhole(this.dialedAddress.addOriginIfMissingAndImmutable().size(), 10));
        }
        this.lightUpDialedSymbols();
        ((StargateAbstractStateManager)((StargateUniverseBaseBE)this.stargate).getStateManager()).getChevronsState().scheduleChevronsLockAll(0, false);
        this.attemptOpenDialed();
        return StargateChevronEngageResult.OK;
    }

    @Override
    protected IAddressDialSequence.DialNextConsumer getAddressDialSequenceSymbolConsumer() {
        return (symbol, noEnergy, ignoreMaxChevrons, dialingType) -> {
            if (symbol == null) {
                if (dialingType != EnumDialingType.FAST) {
                    this.attemptOpenDialed();
                }
                this.addressDialSequence = null;
                ((StargateUniverseBaseBE)this.stargate).m_6596_();
                return;
            }
            if (dialingType == EnumDialingType.NORMAL) {
                this.engageSymbolBySpin(symbol, noEnergy, ignoreMaxChevrons);
                return;
            }
            if (dialingType == EnumDialingType.REMOTE) {
                this.engageSymbolByRemote(symbol, noEnergy, ignoreMaxChevrons);
                return;
            }
            this.engageSymbolDHD(symbol, noEnergy, ignoreMaxChevrons);
        };
    }

    @Override
    protected StargateChevronEngageResult engageSymbolInternal(SymbolInterface symbol, boolean isNox, boolean noEnergy, boolean ignoreMaxChevrons) {
        StargateChevronEngageResult result = super.engageSymbolInternal(symbol, isNox, noEnergy, ignoreMaxChevrons);
        if (!result.ok()) {
            return result;
        }
        DHDAbstractBE dhd = ((StargateUniverseBaseBE)this.stargate).getLinkedDevice();
        if (((StargateUniverseBaseBE)this.stargate).isLinkedAndDHDOperational() && dhd != null) {
            dhd.activateSymbol(symbol);
        }
        return result;
    }

    protected void beginSpinAndLightUpFirstSymbol(SymbolInterface symbol) {
        ((StargateUniverseBaseBE)this.stargate).playSoundEvent(SoundEvent.GATE_UNIVERSE_DIAL_START);
        ((StargateAbstractStateManager)((StargateUniverseBaseBE)this.stargate).getStateManager()).getChevronsState().scheduleChevronsLockAll(10, false);
        CompoundTag data = new CompoundTag();
        CompoundTag stopData = new CompoundTag();
        stopData.m_128379_("openGate", true);
        data.m_128365_("stopData", (Tag)stopData);
        data.m_128405_("litAfterSpin", symbol.getId());
        this.addTask(new ScheduledTask(ScheduledTaskType.BEGIN_SPIN, data));
    }

    protected void beginSpinAndMoveToFirstSymbol(SymbolInterface symbol, boolean engage, boolean noEnergy, boolean usingRemote, boolean ignoreMaxChevrons) {
        ((StargateUniverseBaseBE)this.stargate).playSoundEvent(SoundEvent.GATE_UNIVERSE_DIAL_START);
        ((StargateAbstractStateManager)((StargateUniverseBaseBE)this.stargate).getStateManager()).getChevronsState().scheduleChevronsLockAll(10, false);
        CompoundTag data = new CompoundTag();
        data.m_128379_("engage", engage);
        data.m_128379_("noEnergy", noEnergy);
        data.m_128379_("ignoreMaxChevrons", ignoreMaxChevrons);
        data.m_128405_("symbol", symbol.getId());
        data.m_128379_("usingRemote", usingRemote);
        this.addTask(new ScheduledTask(ScheduledTaskType.BEGIN_SPIN, data));
    }

    protected void lightUpSymbol(SymbolInterface symbol) {
        ((StargateUniverseBaseBE)this.stargate).playSoundEvent(StargateSoundEventEnum.CHEVRON_SHUT);
        CompoundTag data = new CompoundTag();
        data.m_128405_("symbol", symbol.getId());
        ((StargateAbstractStateManager)((StargateUniverseBaseBE)this.stargate).getStateManager()).getChevronsState().addTask(new ScheduledTask(ScheduledTaskType.STARGATE_SYMBOL_LOCK, data));
        if (this.addressDialSequence != null) {
            this.addTask(new ScheduledTask(ScheduledTaskType.STARGATE_DIAL_NEXT, 20));
        }
    }

    protected void lightUpDialedSymbols() {
        ((StargateUniverseBaseBE)this.stargate).playSoundEvent(StargateSoundEventEnum.CHEVRON_SHUT);
        CompoundTag data = new CompoundTag();
        data.m_128379_("litAddress", true);
        ((StargateAbstractStateManager)((StargateUniverseBaseBE)this.stargate).getStateManager()).getChevronsState().addTask(new ScheduledTask(ScheduledTaskType.STARGATE_SYMBOL_LOCK, data));
    }

    @Override
    public boolean canAbortDialing() {
        return super.canAbortDialing() && this.getStargateState() != EnumStargateState.RESETTING;
    }

    @Override
    public void executeTask(ScheduledTaskType scheduledTask, CompoundTag customData) {
        if (scheduledTask == ScheduledTaskType.BEGIN_SPIN) {
            if (customData.m_128471_("freely")) {
                this.getSpinHelper().rotateFreely(EnumSpinDirection.random(new Random()));
            }
            if (customData.m_128441_("litAfterSpin")) {
                this.lightUpSymbol((SymbolInterface)((StargateUniverseBaseBE)this.stargate).getSymbolType().valueOf(customData.m_128451_("litAfterSpin")));
                this.getSpinHelper().rotateFreely(EnumSpinDirection.random(new Random()));
                if (customData.m_128441_("stopData")) {
                    this.getSpinHelper().setSpinStopData(customData.m_128469_("stopData"));
                }
            }
            if (customData.m_128441_("symbol")) {
                Object symbol = ((StargateUniverseBaseBE)this.stargate).getSymbolType().valueOf(customData.m_128451_("symbol"));
                if (customData.m_128471_("engage")) {
                    if (customData.m_128471_("usingRemote")) {
                        this.engageSymbolByRemote((SymbolInterface)symbol, customData.m_128471_("noEnergy"), customData.m_128471_("ignoreMaxChevrons"));
                    } else {
                        this.engageSymbolBySpin((SymbolInterface)symbol, customData.m_128471_("noEnergy"), customData.m_128471_("ignoreMaxChevrons"));
                    }
                } else {
                    this.getSpinHelper().moveTo((SymbolInterface)symbol);
                    if (customData.m_128441_("stopData")) {
                        this.getSpinHelper().setSpinStopData(customData.m_128469_("stopData"));
                    }
                }
            }
        } else if (scheduledTask == ScheduledTaskType.STARGATE_RESET) {
            this.resetStargate();
        } else {
            super.executeTask(scheduledTask, customData);
        }
    }

    @Override
    protected boolean canUnforceChunk() {
        return this.getStargateState() != EnumStargateState.RESETTING;
    }

    protected void scheduleResetStargate() {
        float ticksToStop;
        this.scheduledTasks.clear();
        this.addressDialSequence = null;
        ChunkManager.forceChunk(this.stargate);
        this.setStargateState(EnumStargateState.RESETTING);
        float f = ticksToStop = this.getSpinHelper().isSpinning() ? this.getSpinHelper().getTickToStop() : 0.0f;
        if (ticksToStop > 0.0f) {
            this.getSpinHelper().stopSpinning(true);
        }
        this.addTask(new ScheduledTask(ScheduledTaskType.STARGATE_RESET, (int)(ticksToStop + (float)ScheduledTaskType.STARGATE_RESET.waitTicks)));
    }

    protected void resetStargate() {
        this.scheduledTasks.clear();
        ((StargateAbstractStateManager)((StargateUniverseBaseBE)this.stargate).getStateManager()).getChevronsState().scheduleChevronsDimAll(0, false);
        DHDAbstractBE dhd = ((StargateUniverseBaseBE)this.stargate).getLinkedDevice();
        if (((StargateUniverseBaseBE)this.stargate).isLinkedAndDHDOperational() && dhd != null) {
            dhd.clearSymbols();
        }
        CompoundTag data = new CompoundTag();
        data.m_128379_("isResetting", true);
        if (this.getSpinHelper().getCurrentTopSymbol(1.0f) == ((StargateUniverseBaseBE)this.stargate).getSymbolType().getTopSymbol()) {
            this.onRingStopSpinning(data);
            return;
        }
        this.setStargateState(EnumStargateState.RESETTING);
        this.getSpinHelper().moveTo((SymbolInterface)((StargateUniverseBaseBE)this.stargate).getSymbolType().getTopSymbol());
        this.getSpinHelper().setSpinStopData(data);
    }

    @Override
    protected void onRingStopSpinning(CompoundTag stopSpinData) {
        if (((StargateUniverseBaseBE)this.stargate).getStargateLevel() == null || ((StargateUniverseBaseBE)this.stargate).getStargateLevel().m_5776_()) {
            return;
        }
        if (stopSpinData.m_128441_("symbol")) {
            Object symbol = ((StargateUniverseBaseBE)this.stargate).getSymbolType().valueOf(stopSpinData.m_128451_("symbol"));
            StargateChevronEngageResult result = this.engageSymbolInternal((SymbolInterface)symbol, false, stopSpinData.m_128471_("noEnergy"), stopSpinData.m_128471_("ignoreMaxChevrons"));
            if (result.ok()) {
                if (this.getStargateState().dialingComputer()) {
                    this.setStargateState(EnumStargateState.IDLE);
                }
                this.lightUpSymbol((SymbolInterface)symbol);
                StargateComputerEvents.CHEVRON_ENGAGED.apply(StargateComputerEvents.ChevronEvent.Source.BY_SPIN, (SymbolInterface)symbol, this.getNextChevron((SymbolInterface)symbol, true, stopSpinData.m_128471_("ignoreMaxChevrons")), this.getDialedAddressSize()).sendVia(this.stargate);
            } else {
                ((StargateAbstractStateManager)((StargateUniverseBaseBE)this.stargate).getStateManager()).getChevronsState().scheduleChevronFail(40, ChevronEnum.getFinal(), true);
            }
        } else if (this.getStargateState().dialingComputer()) {
            this.setStargateState(EnumStargateState.IDLE);
        }
        if (stopSpinData.m_128471_("isResetting")) {
            this.setStargateState(EnumStargateState.IDLE);
            this.addressDialSequence = null;
            ((StargateUniverseBaseBE)this.stargate).getListenerHandler().gateReset();
            ((StargateUniverseBaseBE)this.stargate).m_6596_();
            ChunkManager.unforceChunk(this.stargate);
        }
        if (stopSpinData.m_128471_("openGate")) {
            this.attemptOpenDialed();
        }
    }

    @Override
    protected IncomingAnimation<?> getIncomingAnimation(CompoundTag tag) {
        return new UniverseIncomingAnimation(this, tag);
    }

    @Override
    protected IncomingAnimation<?> getIncomingAnimation(int addressSize, int duration) {
        return new UniverseIncomingAnimation(((StargateUniverseBaseBE)this.stargate).getTime(), this, addressSize, duration);
    }

    @Override
    protected void clearIncomingWormholeOnSelf() {
        this.scheduleResetStargate();
    }

    @Override
    public void runIncomingWormhole(int addressSize, int duration) {
        if (!this.getConnection().getStatus().prepared() && !this.getConnection().getStatus().waiting()) {
            JSG.logger.error("", new StargateException("Gate must be prepared to accept incoming", this.stargate));
            return;
        }
        if (this.incomingAnimation != null) {
            JSG.logger.error("", new StargateException("incomingAnimation != null!", this.stargate));
            return;
        }
        this.scheduledTasks.clear();
        ((StargateUniverseChevronsState)((StargateAbstractStateManager)((StargateUniverseBaseBE)this.stargate).getStateManager()).getChevronsState()).dimAllSymbols();
        this.getSpinHelper().stopSpinning(true);
        this.dialedAddress.clear();
        this.addressDialSequence = null;
        this.incomingAnimation = this.getIncomingAnimationByConfig(addressSize, duration);
        this.setStargateState(EnumStargateState.INCOMING);
        ((StargateUniverseBaseBE)this.stargate).getListenerHandler().gateIncoming(addressSize);
        this.onIncoming(addressSize, duration);
        ((StargateUniverseBaseBE)this.stargate).setStargateChanged();
        StargateComputerEvents.WORMHOLE_INCOMING.apply(addressSize).sendVia(this.stargate);
        DHDAbstractBE dhd = ((StargateUniverseBaseBE)this.stargate).getLinkedDevice();
        if (((StargateUniverseBaseBE)this.stargate).isLinkedAndDHDOperational() && dhd != null) {
            dhd.clearSymbols();
        }
    }

    @Override
    protected void failGate() {
        super.failGate();
        this.scheduleResetStargate();
        DHDAbstractBE dhd = ((StargateUniverseBaseBE)this.stargate).getLinkedDevice();
        if (((StargateUniverseBaseBE)this.stargate).isLinkedAndDHDOperational() && dhd != null) {
            dhd.clearSymbols();
        }
    }

    @Override
    protected void onWormholeDisconnected() {
        super.onWormholeDisconnected();
        this.scheduleResetStargate();
        DHDAbstractBE dhd = ((StargateUniverseBaseBE)this.stargate).getLinkedDevice();
        if (((StargateUniverseBaseBE)this.stargate).isLinkedAndDHDOperational() && dhd != null) {
            dhd.clearSymbols();
        }
    }

    @Override
    protected void onGateOpen(boolean initiating) {
        super.onGateOpen(initiating);
        DHDAbstractBE dhd = ((StargateUniverseBaseBE)this.stargate).getLinkedDevice();
        if (((StargateUniverseBaseBE)this.stargate).isLinkedAndDHDOperational() && dhd != null) {
            dhd.activateSymbol((SymbolInterface)((StargateUniverseBaseBE)this.stargate).getSymbolType().getBRB());
        }
    }
}

