/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.network;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.api.helper.DimensionsHelper;
import dev.tauri.jsg.api.stargate.network.IStargateNetwork;
import dev.tauri.jsg.api.stargate.network.StargatePos;
import dev.tauri.jsg.api.stargate.network.address.StargateAddress;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.AbstractSymbolType;
import dev.tauri.jsg.api.stargate.type.StargateType;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class StargateNetwork
extends SavedData
implements IStargateNetwork {
    public static StargateNetwork INSTANCE = new StargateNetwork();
    public static final String DATA_NAME = "jsg_stargates";
    private final Map<StargatePos, Map<AbstractSymbolType<?>, StargateAddress>> GATES_MAP_BY_POS = new LinkedHashMap();
    private final Map<StargateAddress, StargatePos> GATES_MAP_BY_ADDRESS = new LinkedHashMap<StargateAddress, StargatePos>();
    public final List<ResourceLocation> generatedSpecialStructures = new ArrayList<ResourceLocation>();

    public void register(@Nonnull DimensionDataStorage storage) {
        INSTANCE = this;
        storage.m_164861_(INSTANCE::load, () -> INSTANCE, DATA_NAME);
    }

    public Map<StargatePos, Map<AbstractSymbolType<?>, StargateAddress>> getAll() {
        return this.GATES_MAP_BY_POS;
    }

    @Override
    @Nonnull
    public Optional<Map.Entry<StargatePos, Map<AbstractSymbolType<?>, StargateAddress>>> getStargateByDimension(ResourceKey<Level> dimension) {
        for (Map.Entry<StargatePos, Map<AbstractSymbolType<?>, StargateAddress>> e : this.GATES_MAP_BY_POS.entrySet()) {
            if (e.getKey().dimension != dimension) continue;
            return Optional.of(e);
        }
        return Optional.empty();
    }

    @Override
    @Nullable
    public StargatePos getStargate(StargateAddress address) {
        if (address == null) {
            return null;
        }
        if (address.getSize() < 7) {
            return null;
        }
        StargatePos pos = this.GATES_MAP_BY_ADDRESS.get(address);
        if (pos == null) {
            return null;
        }
        if (pos.getWorld() == null) {
            return null;
        }
        Map<AbstractSymbolType<?>, StargateAddress> gateAddress = this.GATES_MAP_BY_POS.get(pos);
        if (gateAddress == null || !Objects.equals(gateAddress.get(address.getSymbolType()), address)) {
            return null;
        }
        return pos;
    }

    @Override
    @Nullable
    public Map<AbstractSymbolType<?>, StargateAddress> getAddresses(StargatePos pos) {
        if (pos == null) {
            return null;
        }
        return new HashMap(this.GATES_MAP_BY_POS.get(pos));
    }

    @Override
    @Nullable
    public Pair<StargatePos, StargateAddress> getRandomAddress(RandomSource random, AbstractSymbolType<?> symbolTypeEnum, @Nullable StargateType stargateType, @Nullable Predicate<StargatePos> customTest) {
        int size = this.GATES_MAP_BY_POS.size();
        if (size == 0) {
            return null;
        }
        ArrayList<Pair> allowedList = new ArrayList<Pair>();
        for (Map.Entry<StargatePos, Map<AbstractSymbolType<?>, StargateAddress>> entry : this.GATES_MAP_BY_POS.entrySet()) {
            StargateAddress address;
            Map<AbstractSymbolType<?>, StargateAddress> addresses;
            if (stargateType != null && stargateType != entry.getKey().getStargateType() || !(addresses = entry.getValue()).containsKey(symbolTypeEnum) || (address = addresses.get(symbolTypeEnum)) == null || customTest != null && !customTest.test(entry.getKey())) continue;
            allowedList.add(Pair.of((Object)entry.getKey(), (Object)address));
        }
        if (allowedList.isEmpty()) {
            return null;
        }
        int rand = random.m_188503_(allowedList.size());
        return (Pair)allowedList.get(rand);
    }

    @Override
    public void putStargate(StargateAddress address, StargatePos stargatePos) {
        HashMap map = new HashMap();
        map.put(address.getSymbolType(), address);
        this.putStargate(map, stargatePos);
    }

    @Override
    public void putStargate(Map<AbstractSymbolType<?>, StargateAddress> addressMap, StargatePos stargatePos) {
        if (addressMap == null) {
            JSG.logger.warn("Tried to add NULL-address gate! Aborting...", new NullPointerException());
            return;
        }
        Map<AbstractSymbolType<?>, StargateAddress> map = this.GATES_MAP_BY_POS.get(stargatePos);
        if (map == null) {
            this.GATES_MAP_BY_POS.put(stargatePos, new HashMap(addressMap));
        } else {
            map.putAll(addressMap);
            this.GATES_MAP_BY_POS.put(stargatePos, map);
        }
        for (StargateAddress address : addressMap.values()) {
            this.GATES_MAP_BY_ADDRESS.put(address, stargatePos);
        }
        this.checkForInvalidDims();
        this.m_77762_();
    }

    @Override
    public void removeStargate(StargatePos stargatePos) {
        if (stargatePos == null) {
            return;
        }
        JSG.logger.debug("Removing stargate's addresses at {} from the network!", (Object)stargatePos);
        this.GATES_MAP_BY_POS.remove(stargatePos);
        ArrayList<StargateAddress> del = new ArrayList<StargateAddress>();
        for (Map.Entry<StargateAddress, StargatePos> e : this.GATES_MAP_BY_ADDRESS.entrySet()) {
            if (e.getValue() != stargatePos) continue;
            del.add(e.getKey());
        }
        for (StargateAddress a : del) {
            this.GATES_MAP_BY_ADDRESS.remove(a);
        }
        this.m_77762_();
    }

    private void checkForInvalidDims() {
        if (JSG.currentServer == null) {
            return;
        }
        HashMap map = new HashMap(this.GATES_MAP_BY_POS);
        for (Map.Entry<StargatePos, Map<AbstractSymbolType<?>, StargateAddress>> e : map.entrySet()) {
            StargatePos pos = e.getKey();
            if (DimensionsHelper.getLevel(pos.dimension) != null) continue;
            JSG.logger.warn("Removing stargate at {} from the network as dim is INVALID!", (Object)pos);
            this.removeStargate(pos);
        }
    }

    @Override
    public void renameStargate(StargatePos pos, String newName) {
        Map<AbstractSymbolType<?>, StargateAddress> map = this.getAddresses(pos);
        this.removeStargate(pos);
        JSG.logger.debug("Setting gate's name at {} to: {}", (Object)pos, (Object)newName);
        pos.setName(newName);
        this.putStargate(map, pos);
        this.m_77762_();
    }

    public StargateNetwork load(CompoundTag compound) {
        INSTANCE.fromNBT(compound);
        return INSTANCE;
    }

    public void fromNBT(CompoundTag compound) {
        this.GATES_MAP_BY_POS.clear();
        this.GATES_MAP_BY_ADDRESS.clear();
        ListTag stargateTagList = compound.m_128437_("stargates", 10);
        if (compound.m_128441_("version") && compound.m_128461_("version").equalsIgnoreCase("2.0")) {
            for (Iterator stargateTag : stargateTagList) {
                CompoundTag stargateCompound = (CompoundTag)stargateTag;
                StargatePos stargatePos = new StargatePos(stargateCompound.m_128469_("pos"));
                ListTag tagMap = stargateCompound.m_128437_("addressMap", 10);
                for (Tag addressTag : tagMap) {
                    this.putStargate(new StargateAddress((CompoundTag)addressTag), stargatePos);
                }
            }
        } else {
            StargatePos stargatePos = null;
            for (Tag baseTag : stargateTagList) {
                CompoundTag stargateCompound = (CompoundTag)baseTag;
                StargateAddress stargateAddress = new StargateAddress(stargateCompound.m_128469_("address"));
                if (stargatePos == null) {
                    stargatePos = new StargatePos(stargateCompound.m_128469_("pos"));
                }
                this.putStargate(stargateAddress, stargatePos);
            }
        }
        this.generatedSpecialStructures.clear();
        int structuresSize = compound.m_128451_("specialStructureGenerated_size");
        for (int i = 0; i < structuresSize; ++i) {
            this.generatedSpecialStructures.add(new ResourceLocation(compound.m_128461_("specialStructureGenerated_" + i)));
        }
    }

    @Nonnull
    public CompoundTag m_7176_(@Nonnull CompoundTag compound) {
        JSG.logger.info("Saving SGN: Started");
        compound.m_128359_("version", "2.0");
        ListTag stargateTagList = new ListTag();
        for (Map.Entry<StargatePos, Map<AbstractSymbolType<?>, StargateAddress>> stargate : this.GATES_MAP_BY_POS.entrySet()) {
            CompoundTag sgTag = new CompoundTag();
            sgTag.m_128365_("pos", (Tag)stargate.getKey().serializeNBT());
            ListTag mapList = new ListTag();
            for (Map.Entry<AbstractSymbolType<?>, StargateAddress> address : stargate.getValue().entrySet()) {
                mapList.add((Object)address.getValue().serializeNBT());
            }
            sgTag.m_128365_("addressMap", (Tag)mapList);
            stargateTagList.add((Object)sgTag);
        }
        compound.m_128365_("stargates", (Tag)stargateTagList);
        int structuresSize = this.generatedSpecialStructures.size();
        compound.m_128405_("specialStructureGenerated_size", structuresSize);
        for (int i = 0; i < structuresSize; ++i) {
            compound.m_128359_("specialStructureGenerated_" + i, this.generatedSpecialStructures.get(i).toString());
        }
        JSG.logger.info("Saving SGN: Done");
        return compound;
    }

    public void toBytes(ByteBuf buff) {
        FriendlyByteBuf buf = new FriendlyByteBuf(buff);
        buf.writeInt(this.GATES_MAP_BY_POS.size());
        for (Map.Entry<StargatePos, Map<AbstractSymbolType<?>, StargateAddress>> stargate : this.GATES_MAP_BY_POS.entrySet()) {
            stargate.getKey().toBytes(buf);
            buf.writeInt(stargate.getValue().size());
            for (StargateAddress address : stargate.getValue().values()) {
                address.toBytes((ByteBuf)buf);
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            StargatePos pos = new StargatePos(buf);
            int addSize = buf.readInt();
            for (int j = 0; j < addSize; ++j) {
                this.putStargate(new StargateAddress(buf), pos);
            }
        }
    }
}

