/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.network;

import dev.tauri.jsg.api.stargate.Stargate;
import dev.tauri.jsg.api.stargate.network.address.StargateAddress;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolInterface;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolTypeRegistry;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.AbstractSymbolType;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.SymbolMilkyWayEnum;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.SymbolPegasusEnum;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.SymbolUniverseEnum;
import dev.tauri.jsg.registry.DimensionRegistry;
import dev.tauri.jsg.stargate.network.StargateNetwork;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public class StargateReservedAddresses {
    private static final Map<ResourceKey<Level>, ReservedStargate> REGISTRY = new HashMap<ResourceKey<Level>, ReservedStargate>();
    public static ReservedStargate OVERWORLD = StargateReservedAddresses.registerStargate((ResourceKey<Level>)Level.f_46428_, new AddressesBuilder().setAddress(SymbolTypeRegistry.MILKYWAY, SymbolMilkyWayEnum.AURIGA, SymbolMilkyWayEnum.CETUS, SymbolMilkyWayEnum.CENTAURUS, SymbolMilkyWayEnum.CANCER, SymbolMilkyWayEnum.SCUTUM, SymbolMilkyWayEnum.ERIDANUS, SymbolMilkyWayEnum.CANISMINOR, SymbolMilkyWayEnum.SERPENSCAPUT).setAddress(SymbolTypeRegistry.PEGASUS, SymbolPegasusEnum.BYDO, SymbolPegasusEnum.ZEO, SymbolPegasusEnum.ONCEEL, SymbolPegasusEnum.DAWNRE, SymbolPegasusEnum.RAMNON, SymbolPegasusEnum.GILLTIN, SymbolPegasusEnum.ELENAMI, SymbolPegasusEnum.RECKTIC).setAddress(SymbolTypeRegistry.UNIVERSE, SymbolUniverseEnum.G10, SymbolUniverseEnum.G15, SymbolUniverseEnum.G20, SymbolUniverseEnum.G26, SymbolUniverseEnum.G28, SymbolUniverseEnum.G13, SymbolUniverseEnum.G18, SymbolUniverseEnum.G6).build());
    public static ReservedStargate ABYDOS_STARGATE = StargateReservedAddresses.registerStargate(DimensionRegistry.ABYDOS, new AddressesBuilder().setAddress(SymbolTypeRegistry.MILKYWAY, SymbolMilkyWayEnum.TAURUS, SymbolMilkyWayEnum.SERPENSCAPUT, SymbolMilkyWayEnum.CAPRICORNUS, SymbolMilkyWayEnum.MONOCEROS, SymbolMilkyWayEnum.SAGITTARIUS, SymbolMilkyWayEnum.ORION, SymbolMilkyWayEnum.CANISMINOR, SymbolMilkyWayEnum.AURIGA).setAddress(SymbolTypeRegistry.PEGASUS, SymbolPegasusEnum.ACJESIS, SymbolPegasusEnum.BASELAI, SymbolPegasusEnum.DANAMI, SymbolPegasusEnum.ECRUMIG, SymbolPegasusEnum.AAXEL, SymbolPegasusEnum.GILLTIN, SymbolPegasusEnum.HACEMILL, SymbolPegasusEnum.RECKTIC).setAddress(SymbolTypeRegistry.UNIVERSE, SymbolUniverseEnum.G5, SymbolUniverseEnum.G6, SymbolUniverseEnum.G18, SymbolUniverseEnum.G20, SymbolUniverseEnum.G1, SymbolUniverseEnum.G7, SymbolUniverseEnum.G22, SymbolUniverseEnum.G31).build());
    public static ReservedStargate NETHER = StargateReservedAddresses.registerStargate((ResourceKey<Level>)Level.f_46429_, new AddressesBuilder().setAddress(SymbolTypeRegistry.MILKYWAY, SymbolMilkyWayEnum.LYNX, SymbolMilkyWayEnum.VIRGO, SymbolMilkyWayEnum.CANISMINOR, SymbolMilkyWayEnum.ERIDANUS, SymbolMilkyWayEnum.CENTAURUS, SymbolMilkyWayEnum.EQUULEUS, SymbolMilkyWayEnum.SEXTANS, SymbolMilkyWayEnum.MICROSCOPIUM).setAddress(SymbolTypeRegistry.PEGASUS, SymbolPegasusEnum.BASELAI, SymbolPegasusEnum.ACJESIS, SymbolPegasusEnum.DANAMI, SymbolPegasusEnum.ECRUMIG, SymbolPegasusEnum.AAXEL, SymbolPegasusEnum.GILLTIN, SymbolPegasusEnum.HACEMILL, SymbolPegasusEnum.RECKTIC).setAddress(SymbolTypeRegistry.UNIVERSE, SymbolUniverseEnum.G6, SymbolUniverseEnum.G5, SymbolUniverseEnum.G18, SymbolUniverseEnum.G20, SymbolUniverseEnum.G1, SymbolUniverseEnum.G7, SymbolUniverseEnum.G22, SymbolUniverseEnum.G31).build());
    public static ReservedStargate END = StargateReservedAddresses.registerStargate((ResourceKey<Level>)Level.f_46430_, new AddressesBuilder().setAddress(SymbolTypeRegistry.MILKYWAY, SymbolMilkyWayEnum.MICROSCOPIUM, SymbolMilkyWayEnum.PISCES, SymbolMilkyWayEnum.PISCISAUSTRINUS, SymbolMilkyWayEnum.SCUTUM, SymbolMilkyWayEnum.ORION, SymbolMilkyWayEnum.SERPENSCAPUT, SymbolMilkyWayEnum.GEMINI, SymbolMilkyWayEnum.NORMA).setAddress(SymbolTypeRegistry.PEGASUS, SymbolPegasusEnum.OLAVII, SymbolPegasusEnum.BASELAI, SymbolPegasusEnum.CAPO, SymbolPegasusEnum.ZAMILLOZ, SymbolPegasusEnum.TAHNAN, SymbolPegasusEnum.ILLUME, SymbolPegasusEnum.ZEO, SymbolPegasusEnum.POCORE).setAddress(SymbolTypeRegistry.UNIVERSE, SymbolUniverseEnum.G3, SymbolUniverseEnum.G30, SymbolUniverseEnum.G11, SymbolUniverseEnum.G14, SymbolUniverseEnum.G31, SymbolUniverseEnum.G9, SymbolUniverseEnum.G1, SymbolUniverseEnum.G22).build());

    public static ReservedStargate registerStargate(ResourceKey<Level> dimension, Map<AbstractSymbolType<?>, StargateAddress> addresses) {
        ReservedStargate sg = new ReservedStargate(dimension, addresses);
        REGISTRY.put(dimension, sg);
        return sg;
    }

    public static Optional<ReservedStargate> getStargate(@Nonnull ServerLevel dim) {
        return StargateReservedAddresses.getStargate((ResourceKey<Level>)dim.m_46472_());
    }

    public static Optional<ReservedStargate> getStargate(@Nonnull ResourceKey<Level> dim) {
        return Optional.ofNullable(REGISTRY.get(dim));
    }

    public static void register() {
    }

    public record ReservedStargate(ResourceKey<Level> dimension, Map<AbstractSymbolType<?>, StargateAddress> addresses) {
        public void setAddresses(Stargate<?> baseTile) {
            for (Map.Entry<AbstractSymbolType<?>, StargateAddress> addressEntry : this.addresses.entrySet()) {
                baseTile.setGateAddress(addressEntry.getKey(), addressEntry.getValue());
            }
        }

        public boolean isGenerated() {
            for (Map.Entry<AbstractSymbolType<?>, StargateAddress> addressEntry : this.addresses.entrySet()) {
                if (StargateNetwork.INSTANCE.getStargate(addressEntry.getValue()) == null) continue;
                return true;
            }
            return false;
        }
    }

    public static class AddressesBuilder {
        Map<AbstractSymbolType<?>, StargateAddress> addressMap = new HashMap();

        public AddressesBuilder setAddress(AbstractSymbolType<?> type, SymbolInterface ... symbols) {
            if (symbols.length < 8) {
                return this;
            }
            StargateAddress address = new StargateAddress(type, symbols[0], symbols[1], symbols[2], symbols[3], symbols[4], symbols[5], symbols[6], symbols[7]);
            this.addressMap.put(type, address);
            return this;
        }

        public Map<AbstractSymbolType<?>, StargateAddress> build() {
            return this.addressMap;
        }
    }
}

