/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.network.symbol;

import dev.tauri.jsg.api.client.screen.ITab;
import dev.tauri.jsg.api.client.screen.ITabAddress;
import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.api.pointoforigins.IPointOfOriginType;
import dev.tauri.jsg.api.stargate.network.address.IAddress;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolTypeRegistry;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.AbstractSymbolType;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.SymbolMilkyWayEnum;
import dev.tauri.jsg.api.stargate.type.StargateTypes;
import dev.tauri.jsg.registry.BlockRegistry;
import dev.tauri.jsg.registry.ItemRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SymbolMilkyWayProvider
extends AbstractSymbolType<SymbolMilkyWayEnum> {
    private static final Map<Integer, SymbolMilkyWayEnum> ID_MAP = new HashMap<Integer, SymbolMilkyWayEnum>();
    private static final Map<String, SymbolMilkyWayEnum> ENGLISH_NAME_MAP = new HashMap<String, SymbolMilkyWayEnum>();

    @Override
    public SymbolMilkyWayEnum getFirstValidForAddress() {
        return SymbolMilkyWayEnum.SCULPTOR;
    }

    @Override
    public IPointOfOriginType getPointOfOriginType() {
        return StargateTypes.MILKYWAY;
    }

    @Override
    public SymbolMilkyWayEnum getBRB() {
        return SymbolMilkyWayEnum.BRB;
    }

    @Override
    public int[] getAncientTitlePos() {
        return new int[]{330, 0};
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ITab.ITabBuilder finalizeAddressTab(ITab.ITabBuilder builder) {
        return builder.setTexture(new ResourceLocation("jsg", "textures/gui/container_stargate.png"), 512).setBackgroundTextureLocation(176, 0).setIconRenderPos(0, 6).setIconSize(22, 22).setIconTextureLocation(304, 0);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ITabAddress.SymbolCoords getSymbolCoords(int symbol) {
        return new ITabAddress.SymbolCoords(29 + 31 * (symbol % 3), 20 + 28 * (symbol / 3));
    }

    public SymbolMilkyWayEnum[] getValues() {
        return SymbolMilkyWayEnum.values();
    }

    @Override
    public Block getBaseBlock() {
        return (Block)BlockRegistry.STARGATE_MILKYWAY_BASE_BLOCK.get();
    }

    @Override
    public Item getGlyphUpgrade() {
        return (Item)ItemRegistry.CRYSTAL_GLYPH_MILKYWAY.get();
    }

    @Override
    public Block getDHDBlock() {
        return (Block)BlockRegistry.DHD_MILKYWAY.get();
    }

    @Override
    public String getId() {
        return "milkyway";
    }

    @Override
    public int getIconWidth() {
        return 32;
    }

    @Override
    public int getIconHeight() {
        return 32;
    }

    @Override
    public SymbolMilkyWayEnum getSymbolByAngle(float angle, float bounds) {
        SymbolMilkyWayEnum closest = null;
        float closestAngle = Float.MAX_VALUE;
        while (angle < 0.0f) {
            angle += 360.0f;
        }
        angle %= 360.0f;
        for (SymbolMilkyWayEnum symbol : SymbolMilkyWayEnum.values()) {
            float diffAngle = Math.abs(symbol.angle - angle);
            if (closestAngle > diffAngle) {
                closestAngle = diffAngle;
                closest = symbol;
            }
            if (closestAngle > (diffAngle = Math.abs(symbol.angle + 360.0f - angle))) {
                closestAngle = diffAngle;
                closest = symbol;
            }
            if (!(closestAngle > (diffAngle = Math.abs(symbol.angle - (angle + 360.0f))))) continue;
            closestAngle = diffAngle;
            closest = symbol;
        }
        if (closestAngle >= bounds) {
            return null;
        }
        if (closest != null) {
            return closest;
        }
        return this.getOrigin();
    }

    @Override
    public float getAngleOfNearest(float angle) {
        int end = 38;
        int loops = 0;
        int temp = end;
        for (int current = 0; current < end; ++current) {
            temp = end - current;
            if (!(angle < this.getAngleByAngIndex(temp) && angle < this.getAngleByAngIndex(temp - 1)) && angle != this.getAngleByAngIndex(temp)) continue;
            return this.getAngleByAngIndex(temp);
        }
        return this.getAngleByAngIndex(temp);
    }

    @Override
    public float getAngleByAngIndex(int index) {
        if (index < 0) {
            index = 0;
        }
        if (index > 38) {
            index = 38;
        }
        for (SymbolMilkyWayEnum symbol : SymbolMilkyWayEnum.values()) {
            if (symbol.angleIndex != index) continue;
            return symbol.angle;
        }
        return 0.0f;
    }

    @Override
    public SymbolMilkyWayEnum getRandomSymbol(Random random) {
        int id;
        while (this.valueOf(id = random.nextInt(38)) == null || !this.valueOf(id).isValidForAddress() || id == SymbolMilkyWayEnum.ORIGIN.id) {
        }
        return this.valueOf(id);
    }

    @Override
    public boolean validateDialedAddress(IAddress stargateAddress) {
        if (stargateAddress.getSize() < 7) {
            return false;
        }
        return stargateAddress.get(stargateAddress.getSize() - 1).origin();
    }

    @Override
    public int getMinimalSymbolCountTo(AbstractSymbolType<?> symbolType, boolean localDial) {
        boolean eightChevrons = JSGConfig.Stargate.pegAndMilkUseEightChevrons.get();
        if (Objects.equals(symbolType.getId(), SymbolTypeRegistry.PEGASUS.getId())) {
            return localDial && !eightChevrons ? 7 : 8;
        }
        if (Objects.equals(symbolType.getId(), SymbolTypeRegistry.MILKYWAY.getId())) {
            return localDial ? 7 : 8;
        }
        if (Objects.equals(symbolType.getId(), SymbolTypeRegistry.UNIVERSE.getId())) {
            return 9;
        }
        return symbolType.getMinimalSymbolCountTo(SymbolTypeRegistry.MILKYWAY, localDial);
    }

    @Override
    public SymbolMilkyWayEnum getOrigin() {
        return SymbolMilkyWayEnum.ORIGIN;
    }

    @Override
    public int getMaxSymbolsDisplay(boolean hasUpgrade) {
        return hasUpgrade ? 8 : 6;
    }

    @Override
    public float getAnglePerGlyph() {
        return 9.230769f;
    }

    @Override
    public SymbolMilkyWayEnum getTopSymbol() {
        return SymbolMilkyWayEnum.ORIGIN;
    }

    @Override
    public SymbolMilkyWayEnum valueOf(int id) {
        return ID_MAP.get(id);
    }

    @Override
    public SymbolMilkyWayEnum fromEnglishName(String englishName) {
        return ENGLISH_NAME_MAP.get(englishName.toLowerCase().replace("\u00f6", "o"));
    }

    static {
        for (SymbolMilkyWayEnum symbol : SymbolMilkyWayEnum.values()) {
            ID_MAP.put(symbol.id, symbol);
            ENGLISH_NAME_MAP.put(symbol.englishName.toLowerCase(), symbol);
        }
    }
}

