/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.network.symbol;

import dev.tauri.jsg.api.client.screen.ITab;
import dev.tauri.jsg.api.client.screen.ITabAddress;
import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.api.pointoforigins.IPointOfOriginType;
import dev.tauri.jsg.api.stargate.network.address.IAddress;
import dev.tauri.jsg.api.stargate.network.address.symbol.SymbolTypeRegistry;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.AbstractSymbolType;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.SymbolPegasusEnum;
import dev.tauri.jsg.api.stargate.type.StargateTypes;
import dev.tauri.jsg.registry.BlockRegistry;
import dev.tauri.jsg.registry.ItemRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SymbolPegasusProvider
extends AbstractSymbolType<SymbolPegasusEnum> {
    private static final Map<Integer, SymbolPegasusEnum> ID_MAP = new HashMap<Integer, SymbolPegasusEnum>();
    private static final Map<String, SymbolPegasusEnum> ENGLISH_NAME_MAP = new HashMap<String, SymbolPegasusEnum>();

    @Override
    public SymbolPegasusEnum getFirstValidForAddress() {
        return SymbolPegasusEnum.ROEHI;
    }

    @Override
    public IPointOfOriginType getPointOfOriginType() {
        return StargateTypes.PEGASUS;
    }

    @Override
    public SymbolPegasusEnum getBRB() {
        return SymbolPegasusEnum.BBB;
    }

    @Override
    public int[] getAncientTitlePos() {
        return new int[]{330, 18};
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ITab.ITabBuilder finalizeAddressTab(ITab.ITabBuilder builder) {
        return builder.setTexture(new ResourceLocation("jsg", "textures/gui/container_stargate.png"), 512).setBackgroundTextureLocation(176, 0).setIconRenderPos(0, 6).setIconSize(22, 22).setIconTextureLocation(304, 22);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ITabAddress.SymbolCoords getSymbolCoords(int symbol) {
        return new ITabAddress.SymbolCoords(29 + 34 * (symbol % 3), 20 + 28 * (symbol / 3));
    }

    public SymbolPegasusEnum[] getValues() {
        return SymbolPegasusEnum.values();
    }

    @Override
    public Block getBaseBlock() {
        return (Block)BlockRegistry.STARGATE_PEGASUS_BASE_BLOCK.get();
    }

    @Override
    public Item getGlyphUpgrade() {
        return (Item)ItemRegistry.CRYSTAL_GLYPH_PEGASUS.get();
    }

    @Override
    public Block getDHDBlock() {
        return (Block)BlockRegistry.DHD_PEGASUS.get();
    }

    @Override
    public String getId() {
        return "pegasus";
    }

    @Override
    public int getIconWidth() {
        return 27;
    }

    @Override
    public int getIconHeight() {
        return 27;
    }

    @Override
    public SymbolPegasusEnum getRandomSymbol(Random random) {
        int id;
        while (this.valueOf(id = random.nextInt(38)) == null || !this.valueOf(id).isValidForAddress() || id == SymbolPegasusEnum.SUBIDO.id) {
        }
        return this.valueOf(id);
    }

    @Override
    public boolean validateDialedAddress(IAddress stargateAddress) {
        if (stargateAddress.getSize() < 7) {
            return false;
        }
        return stargateAddress.get(stargateAddress.getSize() - 1).origin();
    }

    @Override
    public int getMinimalSymbolCountTo(AbstractSymbolType<?> symbolType, boolean localDial) {
        boolean eightChevrons = JSGConfig.Stargate.pegAndMilkUseEightChevrons.get();
        if (Objects.equals(symbolType.getId(), SymbolTypeRegistry.MILKYWAY.getId())) {
            return localDial && !eightChevrons ? 7 : 8;
        }
        if (Objects.equals(symbolType.getId(), SymbolTypeRegistry.PEGASUS.getId())) {
            return localDial ? 7 : 8;
        }
        if (Objects.equals(symbolType.getId(), SymbolTypeRegistry.UNIVERSE.getId())) {
            return 9;
        }
        return symbolType.getMinimalSymbolCountTo(SymbolTypeRegistry.PEGASUS, localDial);
    }

    @Override
    public SymbolPegasusEnum getOrigin() {
        return SymbolPegasusEnum.SUBIDO;
    }

    @Override
    public int getMaxSymbolsDisplay(boolean hasUpgrade) {
        return hasUpgrade ? 8 : 6;
    }

    @Override
    public float getAnglePerGlyph() {
        return 1.0f;
    }

    @Override
    public SymbolPegasusEnum getSymbolByAngle(float angle, float bounds) {
        return this.getOrigin();
    }

    @Override
    public SymbolPegasusEnum getTopSymbol() {
        return SymbolPegasusEnum.SUBIDO;
    }

    @Override
    public SymbolPegasusEnum valueOf(int id) {
        return ID_MAP.get(id);
    }

    @Override
    public SymbolPegasusEnum fromEnglishName(String englishName) {
        return ENGLISH_NAME_MAP.get(englishName.toLowerCase());
    }

    static {
        for (SymbolPegasusEnum symbol : SymbolPegasusEnum.values()) {
            ID_MAP.put(symbol.id, symbol);
            ENGLISH_NAME_MAP.put(symbol.englishName.toLowerCase(), symbol);
        }
        ENGLISH_NAME_MAP.put("point of origin", SymbolPegasusEnum.SUBIDO);
    }
}

