/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.rig;

import dev.tauri.jsg.api.stargate.Stargate;
import dev.tauri.jsg.api.stargate.StargateClosedReasonEnum;
import dev.tauri.jsg.api.stargate.StargateWithIris;
import dev.tauri.jsg.api.stargate.iris.EnumIrisMode;
import dev.tauri.jsg.api.stargate.manager.IStargateDialingManager;
import dev.tauri.jsg.api.stargate.manager.IStargateIrisManager;
import dev.tauri.jsg.api.stargate.result.StargateConnectionStatus;
import dev.tauri.jsg.api.stargate.rig.IRIGWave;
import dev.tauri.jsg.api.stargate.traveler.IStargateTraveler;
import dev.tauri.jsg.stargate.manager.StargateConnection;
import dev.tauri.jsg.stargate.manager.dialing.StargateAbstractDialingManager;
import dev.tauri.jsg.stargate.rig.StargateRIGManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class RIGInstance {
    private final StargateRIGManager manager;
    private final int chevronCount;
    private final int animationLength;
    private final IRIGWave wave;
    private final long started;
    private boolean shouldOpenIris;
    private int state;
    private boolean isRunning;
    private long nextEntitySpawnIn;

    public RIGInstance(StargateRIGManager manager, IRIGWave wave, int chevronCount, int animationLength, boolean shouldOpenIris) {
        this.manager = manager;
        this.wave = wave;
        this.chevronCount = chevronCount;
        this.animationLength = animationLength;
        this.shouldOpenIris = shouldOpenIris;
        this.isRunning = true;
        this.started = manager.stargate.getTime();
        this.state = 0;
    }

    public void tick() {
        if (!this.isRunning) {
            return;
        }
        if (!this.manager.stargate.isMerged()) {
            this.end(false);
        }
        long tick = this.manager.stargate.getTime();
        if (this.state == 0) {
            this.doIncomingAnimation();
            this.state = 1;
        }
        if (this.state == 1 && tick - this.started >= (long)this.animationLength) {
            this.openGate();
            this.state = 2;
        }
        if (this.state == 2 && tick - this.started >= (long)(this.animationLength + 60)) {
            if (this.manager.stargate.getDialingManager().getStargateState().engaged()) {
                this.trySpawnEntity();
            } else if (this.manager.stargate.getDialingManager().getStargateState().idle()) {
                this.end(false);
            }
        }
    }

    public void end(boolean closeGate) {
        if (!this.isRunning) {
            return;
        }
        this.isRunning = false;
        this.state = 0;
        this.manager.stargate.setStargateChanged();
        if (!closeGate || this.manager.stargate.getDialingManager().getStargateState().idle()) {
            return;
        }
        this.manager.stargate.getDialingManager().attemptClose(StargateClosedReasonEnum.AUTOCLOSE);
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean isGateActive() {
        return this.isRunning && this.state > 0;
    }

    private void doIncomingAnimation() {
        Stargate gate = this.manager.stargate;
        StargateAbstractDialingManager dialingManager = (StargateAbstractDialingManager)gate.getDialingManager();
        StargateConnection connection = dialingManager.getConnection();
        if (!connection.getStatus().none() || !dialingManager.canAcceptConnectionFrom(null)) {
            this.end(false);
            return;
        }
        if (!connection.establishRIG(false, false)) {
            this.end(false);
            return;
        }
        connection.updateStatus(StargateConnectionStatus.WAITING_FOR_WORMHOLE);
        dialingManager.runIncomingWormhole(this.chevronCount, this.animationLength - 2);
    }

    private void openGate() {
        Stargate gate = this.manager.stargate;
        IStargateDialingManager dialingManager = gate.getDialingManager();
        StargateConnection connection = (StargateConnection)dialingManager.getConnection();
        if (!connection.isRIG() || !dialingManager.getStargateState().incoming() || dialingManager.getStargateState().engaged() || dialingManager.getStargateState().unstable()) {
            this.end(true);
            return;
        }
        if (!dialingManager.attemptOpenDialed().ok()) {
            this.end(true);
            return;
        }
        this.nextEntitySpawnIn = 0L;
        this.manager.stargate.setStargateChanged();
    }

    private void trySpawnEntity() {
        StargateWithIris irisGate;
        IStargateIrisManager irisManager;
        if (this.wave.hasFinished()) {
            this.end(true);
            return;
        }
        Stargate gate = this.manager.stargate;
        ServerLevel level = (ServerLevel)gate.getStargateLevel();
        if (level == null) {
            this.end(true);
            return;
        }
        long tick = level.m_46467_();
        if (this.nextEntitySpawnIn < 1L) {
            this.nextEntitySpawnIn = (long)((double)tick + (level.m_213780_().m_188500_() * 5.0 + 1.0) * 7.0);
        }
        if (tick < this.nextEntitySpawnIn) {
            return;
        }
        this.nextEntitySpawnIn = 0L;
        if (gate instanceof StargateWithIris && (irisManager = (irisGate = (StargateWithIris)gate).getIrisManager()).isIrisClosed()) {
            if (this.shouldOpenIris && (irisManager.getIrisMode() == EnumIrisMode.AUTO || irisManager.getIrisMode() == EnumIrisMode.OC)) {
                this.nextEntitySpawnIn = tick + 80L;
                irisManager.toggleIris();
                this.shouldOpenIris = false;
                return;
            }
            irisManager.hitIris();
            this.wave.getNextEntity(level);
            return;
        }
        Entity entity = this.wave.getNextEntity(level);
        IStargateTraveler<?> traveler = gate.getEventHorizonManager().getRIGTraveler(level, entity, new Vec3(0.0, 0.0, (double)-0.01f));
        if (traveler != null) {
            gate.getEventHorizonManager().receive(traveler);
        }
    }
}

