/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.rig;

import dev.tauri.jsg.api.stargate.rig.IRIGWave;
import dev.tauri.jsg.api.stargate.type.StargateType;
import dev.tauri.jsg.api.stargate.type.StargateTypes;
import dev.tauri.jsg.api.util.ParameterReplacer;
import dev.tauri.jsg.stargate.rig.MobsCount;
import dev.tauri.jsg.stargate.rig.RIGEntity;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RIGWave
implements IRIGWave {
    private final String name;
    public int weight;
    public int chevronsToDial;
    public List<String> allowedOnGates;
    @Nullable
    public List<String> allowedInDims;
    @Nullable
    public List<String> allowedBiomes;
    @Nullable
    public List<String> blacklistedBiomes;
    public List<Difficulty> allowedForDifficulties;
    public List<RIGEntity> entities;
    public boolean selectRandomMobs;
    public double shouldOpenIrisChance;
    @Nullable
    public MobsCount randomMobsCount;
    private ParameterReplacer replacer = new ParameterReplacer();
    private boolean finished = false;
    private LinkedList<RIGEntity> currentPool = new LinkedList();

    public RIGWave(String name, int weight, int chevronsToDial, List<String> allowedOnGates, @Nullable List<String> allowedInDims, @Nullable List<String> allowedBiomes, @Nullable List<String> blacklistedBiomes, List<Difficulty> allowedForDifficulties, List<RIGEntity> entities, boolean selectRandomMobs, @Nullable MobsCount randomMobsCount, double shouldOpenIrisChance) {
        this.name = name;
        this.weight = weight;
        this.chevronsToDial = chevronsToDial;
        this.allowedOnGates = allowedOnGates;
        this.allowedBiomes = allowedBiomes;
        this.blacklistedBiomes = blacklistedBiomes;
        this.allowedInDims = allowedInDims;
        this.allowedForDifficulties = allowedForDifficulties;
        this.entities = entities;
        this.selectRandomMobs = selectRandomMobs;
        this.randomMobsCount = randomMobsCount;
        this.shouldOpenIrisChance = shouldOpenIrisChance;
    }

    @Override
    public String getId() {
        return this.name;
    }

    @Override
    public boolean hasFinished() {
        return this.finished;
    }

    @Override
    public double shouldOpenIrisChance() {
        return this.shouldOpenIrisChance;
    }

    @Override
    public void setup(RandomSource random) {
        this.finished = false;
        this.currentPool = new LinkedList();
        this.replacer = new ParameterReplacer();
        this.replacer.addKey("UUID", "[I;" + random.m_188503_(2112623056) + "," + random.m_188503_(2112623056) + "," + random.m_188503_(2112623056) + "," + random.m_188503_(2112623056) + "]");
        this.replacer.addKey("chance1", String.format("%.2f", Float.valueOf(random.m_188501_())));
        this.replacer.addKey("chance2", String.format("%.2f", Float.valueOf(random.m_188501_())));
        this.replacer.addKey("chance3", String.format("%.2f", Float.valueOf(random.m_188501_())));
        this.replacer.addKey("chance4", String.format("%.2f", Float.valueOf(random.m_188501_())));
        if (!this.selectRandomMobs) {
            for (RIGEntity e : this.entities) {
                for (int i = 0; i < e.weight; ++i) {
                    this.currentPool.addLast(e);
                }
            }
        } else if (this.randomMobsCount != null) {
            LinkedList<RIGEntity> all = new LinkedList<RIGEntity>();
            for (RIGEntity e : this.entities) {
                for (int i = 0; i < e.weight; ++i) {
                    all.addLast(e);
                }
            }
            if (all.isEmpty()) {
                this.finished = true;
            } else {
                int count = this.randomMobsCount.get(random);
                for (int i = 0; i < count; ++i) {
                    int index = random.m_188503_(all.size());
                    this.currentPool.addLast((RIGEntity)all.get(index));
                }
            }
        }
        if (this.currentPool.isEmpty()) {
            this.finished = true;
        }
    }

    @Override
    @NotNull
    public Entity getNextEntity(ServerLevel level) {
        if (this.hasFinished()) {
            throw new UnsupportedOperationException("Tried to get next entity when wave has already finished!");
        }
        RIGEntity entity = this.currentPool.getFirst();
        this.currentPool.removeFirst();
        if (this.currentPool.isEmpty()) {
            this.finished = true;
        }
        return entity.get(level, this.replacer);
    }

    public static class Builder {
        private String name;
        private int weight = 1;
        private int chevronsToDial = 7;
        private List<String> allowedOnGates = new ArrayList<String>(List.of(StargateTypes.MILKYWAY.toString(), StargateTypes.PEGASUS.toString(), StargateTypes.UNIVERSE.toString(), StargateTypes.MOVIE.toString(), StargateTypes.TOLLAN.toString()));
        private List<String> allowedInDims = null;
        private List<String> allowedBiomes = null;
        private List<String> blacklistedBiomes = null;
        private List<Difficulty> allowedForDifficulties = new ArrayList<Difficulty>(List.of(Difficulty.HARD, Difficulty.NORMAL, Difficulty.EASY));
        private List<RIGEntity> entities = new ArrayList<RIGEntity>();
        private boolean selectRandomMobs = false;
        private double shouldOpenIrisChance = 0.0;
        @Nullable
        private MobsCount randomMobsCount;

        public static Builder create() {
            return new Builder();
        }

        public Builder addEntity(RIGEntity entity) {
            this.entities.add(entity);
            return this;
        }

        public Builder addDim(String dim) {
            return this.addDim(dim, false);
        }

        public Builder addDim(String dim, boolean clear) {
            if (clear) {
                this.allowedInDims.clear();
            }
            this.allowedInDims.add(dim);
            return this;
        }

        public Builder addDifficulty(Difficulty difficulty) {
            return this.addDifficulty(difficulty, false);
        }

        public Builder addDifficulty(Difficulty difficulty, boolean clear) {
            if (clear) {
                this.allowedForDifficulties.clear();
            }
            this.allowedForDifficulties.add(difficulty);
            return this;
        }

        public Builder addGate(StargateType stargateType) {
            return this.addGate(stargateType, false);
        }

        public Builder addGate(StargateType stargateType, boolean clear) {
            if (clear) {
                this.allowedOnGates.clear();
            }
            this.allowedOnGates.add(stargateType.toString());
            return this;
        }

        public Builder selectRandomMobs() {
            this.selectRandomMobs = true;
            return this;
        }

        public Builder shouldOpenIrisChance(double chance) {
            this.shouldOpenIrisChance = chance;
            return this;
        }

        public Builder randomMobsCount(int min, int max) {
            this.randomMobsCount = new MobsCount(min, max);
            return this;
        }

        public Builder entities(List<RIGEntity> entities) {
            this.entities = entities;
            return this;
        }

        public Builder allowedBiomes(List<String> allowedBiomes) {
            this.allowedBiomes = allowedBiomes;
            return this;
        }

        public Builder blacklistedBiomes(List<String> blacklistedBiomes) {
            this.blacklistedBiomes = blacklistedBiomes;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder weight(int weight) {
            this.weight = weight;
            return this;
        }

        public Builder chevronsToDial(int chevronsToDial) {
            this.chevronsToDial = chevronsToDial;
            return this;
        }

        public Builder allowedOnGates(List<String> allowedOnGates) {
            this.allowedOnGates = allowedOnGates;
            return this;
        }

        public Builder allowedInDims(List<String> allowedInDims) {
            this.allowedInDims = allowedInDims;
            return this;
        }

        public Builder allowedForDifficulties(List<Difficulty> allowedForDifficulties) {
            this.allowedForDifficulties = allowedForDifficulties;
            return this;
        }

        public RIGWave build() {
            return new RIGWave(this.name, this.weight, this.chevronsToDial, this.allowedOnGates, this.allowedInDims, this.allowedBiomes, this.blacklistedBiomes, this.allowedForDifficulties, this.entities, this.selectRandomMobs, this.randomMobsCount, this.shouldOpenIrisChance);
        }
    }
}

